/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;

public class HeaderFlushedOutputStream
extends OutputStream {
    private MultivaluedMap<String, Object> headers;
    private OutputStream stream;
    private boolean headersFlushed = false;

    public HeaderFlushedOutputStream(MultivaluedMap<String, Object> headers, OutputStream delegate) {
        this.headers = headers;
        this.stream = delegate;
    }

    protected void flushHeaders() throws IOException {
        if (this.headersFlushed) {
            return;
        }
        this.headersFlushed = true;
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        for (String key : this.headers.keySet()) {
            for (Object obj : (List)this.headers.get((Object)key)) {
                RuntimeDelegate.HeaderDelegate headerDelegate = delegate.createHeaderDelegate(obj.getClass());
                String value = headerDelegate != null ? headerDelegate.toString(obj) : obj.toString();
                this.stream.write(key.getBytes());
                this.stream.write(": ".getBytes());
                this.stream.write(value.getBytes());
                this.stream.write("\r\n".getBytes());
            }
        }
        this.stream.write("\r\n".getBytes());
    }

    @Override
    public void write(int i) throws IOException {
        this.flushHeaders();
        this.stream.write(i);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.flushHeaders();
        this.stream.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int i, int i1) throws IOException {
        this.flushHeaders();
        this.stream.write(bytes, i, i1);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

