##############################################################################
#
# Copyright (c) 2005 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Test harness for zc.selenium.

$Id: tests.py 12897 2006-07-26 20:11:41Z fred $
"""

import unittest
import zc.selenium.pytest
from zope.testing import doctest


class TestSelenium(zc.selenium.pytest.Test):

    def test_open(self):
        self.selenium.open('http://%s/' % self.selenium.server)
        self.selenium.verifyTextPresent('Login')


def test_suite():
    return unittest.TestSuite([
        doctest.DocFileSuite('pytest.txt',
                    optionflags=doctest.ELLIPSIS|doctest.REPORT_NDIFF),
        doctest.DocTestSuite('zc.selenium.pytest'),
    ])
