# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import ComputeManagementClientConfiguration
from .operations import GalleriesOperations
from .operations import GalleryImagesOperations
from .operations import GalleryImageVersionsOperations
from .operations import GalleryApplicationsOperations
from .operations import GalleryApplicationVersionsOperations
from . import models


class ComputeManagementClient(SDKClient):
    """Compute Client

    :ivar config: Configuration for client.
    :vartype config: ComputeManagementClientConfiguration

    :ivar galleries: Galleries operations
    :vartype galleries: azure.mgmt.compute.v2019_12_01.operations.GalleriesOperations
    :ivar gallery_images: GalleryImages operations
    :vartype gallery_images: azure.mgmt.compute.v2019_12_01.operations.GalleryImagesOperations
    :ivar gallery_image_versions: GalleryImageVersions operations
    :vartype gallery_image_versions: azure.mgmt.compute.v2019_12_01.operations.GalleryImageVersionsOperations
    :ivar gallery_applications: GalleryApplications operations
    :vartype gallery_applications: azure.mgmt.compute.v2019_12_01.operations.GalleryApplicationsOperations
    :ivar gallery_application_versions: GalleryApplicationVersions operations
    :vartype gallery_application_versions: azure.mgmt.compute.v2019_12_01.operations.GalleryApplicationVersionsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ComputeManagementClientConfiguration(credentials, subscription_id, base_url)
        super(ComputeManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-12-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.galleries = GalleriesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.gallery_images = GalleryImagesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.gallery_image_versions = GalleryImageVersionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.gallery_applications = GalleryApplicationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.gallery_application_versions = GalleryApplicationVersionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
