# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Lab(Model):
    """A lab.

    :param default_storage_account: The lab's default storage account.
    :type default_storage_account: str
    :param artifacts_storage_account: The artifact storage account of the lab.
    :type artifacts_storage_account: str
    :param vault_name: The name of the key vault of the lab.
    :type vault_name: str
    :param lab_storage_type: The type of the lab storage. Possible values
     include: 'Standard', 'Premium'
    :type lab_storage_type: str or :class:`LabStorageType
     <azure.mgmt.devtestlabs.models.LabStorageType>`
    :param created_date: The creation date of the lab.
    :type created_date: datetime
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    :param id: The identifier of the resource.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource.
    :type type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict
    """ 

    _attribute_map = {
        'default_storage_account': {'key': 'properties.defaultStorageAccount', 'type': 'str'},
        'artifacts_storage_account': {'key': 'properties.artifactsStorageAccount', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
        'lab_storage_type': {'key': 'properties.labStorageType', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, default_storage_account=None, artifacts_storage_account=None, vault_name=None, lab_storage_type=None, created_date=None, provisioning_state=None, unique_identifier=None, id=None, name=None, type=None, location=None, tags=None):
        self.default_storage_account = default_storage_account
        self.artifacts_storage_account = artifacts_storage_account
        self.vault_name = vault_name
        self.lab_storage_type = lab_storage_type
        self.created_date = created_date
        self.provisioning_state = provisioning_state
        self.unique_identifier = unique_identifier
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags
