# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ArtifactSource(Model):
    """Properties of an artifact source.

    :param display_name: The display name of the artifact source.
    :type display_name: str
    :param uri: The URI of the artifact source.
    :type uri: str
    :param source_type: The type of the artifact source. Possible values
     include: 'VsoGit', 'GitHub'
    :type source_type: str or :class:`SourceControlType
     <azure.mgmt.devtestlabs.models.SourceControlType>`
    :param folder_path: The folder path of the artifact source.
    :type folder_path: str
    :param branch_ref: The branch reference of the artifact source.
    :type branch_ref: str
    :param security_token: The security token of the artifact source.
    :type security_token: str
    :param status: The status of the artifact source. Possible values
     include: 'Enabled', 'Disabled'
    :type status: str or :class:`EnableStatus
     <azure.mgmt.devtestlabs.models.EnableStatus>`
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    :param id: The identifier of the resource.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource.
    :type type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict
    """ 

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'branch_ref': {'key': 'properties.branchRef', 'type': 'str'},
        'security_token': {'key': 'properties.securityToken', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, display_name=None, uri=None, source_type=None, folder_path=None, branch_ref=None, security_token=None, status=None, provisioning_state=None, unique_identifier=None, id=None, name=None, type=None, location=None, tags=None):
        self.display_name = display_name
        self.uri = uri
        self.source_type = source_type
        self.folder_path = folder_path
        self.branch_ref = branch_ref
        self.security_token = security_token
        self.status = status
        self.provisioning_state = provisioning_state
        self.unique_identifier = unique_identifier
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags
