# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-08-08 10:45
from __future__ import unicode_literals

from django.db import migrations, models


def set_static_category(apps, schema_editor):
    Category = apps.get_model('cfblog', 'Category')
    try:
        cat = Category.objects.get(id=1, title='Static Page')
    except Category.DoesNotExist:
        pass
    else:
        cat.is_static = True
        cat.save()


class Migration(migrations.Migration):

    dependencies = [
        ('cfblog', '0005_auto_20160406_1825'),
    ]

    operations = [
        migrations.AddField(
            model_name='category',
            name='is_static',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.RunPython(
            code=set_static_category,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
