# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import CustomProvidersClientConfiguration
from .operations import Operations
from .operations import CustomResourceProviderOperations
from .operations import AssociationsOperations
from . import models


class CustomProvidersClient(SDKClient):
    """Allows extension of ARM control plane with custom resource providers.

    :ivar config: Configuration for client.
    :vartype config: CustomProvidersClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.customproviders.operations.Operations
    :ivar custom_resource_provider: CustomResourceProvider operations
    :vartype custom_resource_provider: azure.mgmt.customproviders.operations.CustomResourceProviderOperations
    :ivar associations: Associations operations
    :vartype associations: azure.mgmt.customproviders.operations.AssociationsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription ID. This is a
     GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = CustomProvidersClientConfiguration(credentials, subscription_id, base_url)
        super(CustomProvidersClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-09-01-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.custom_resource_provider = CustomResourceProviderOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.associations = AssociationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
