# Generated by Django 3.2.15 on 2023-02-06 18:23

import django.db.models.deletion
from django.db import migrations, models


def forwards_func(apps, schema_editor):
    ObjectPermission = apps.get_model("course_flow", "ObjectPermission")
    ContentType = apps.get_model("contenttypes", "ContentType")
    workflow_contenttype = ContentType.objects.get_for_model(
        apps.get_model("course_flow", "Workflow")
    )
    activity_contenttype = ContentType.objects.get_for_model(
        apps.get_model("course_flow", "Activity")
    )
    course_contenttype = ContentType.objects.get_for_model(
        apps.get_model("course_flow", "Course")
    )
    program_contenttype = ContentType.objects.get_for_model(
        apps.get_model("course_flow", "Program")
    )
    db_alias = schema_editor.connection.alias
    ObjectPermission.objects.using(db_alias).filter(
        content_type=activity_contenttype
    ).update(content_type=workflow_contenttype)
    ObjectPermission.objects.using(db_alias).filter(
        content_type=course_contenttype
    ).update(content_type=workflow_contenttype)
    ObjectPermission.objects.using(db_alias).filter(
        content_type=program_contenttype
    ).update(content_type=workflow_contenttype)


def reverse_func(apps, schema_editor):
    ObjectPermission = apps.get_model("course_flow", "ObjectPermission")
    ContentType = apps.get_model("contenttypes", "ContentType")
    Activity = apps.get_model("course_flow", "Activity")
    Course = apps.get_model("course_flow", "Course")
    Program = apps.get_model("course_flow", "Program")
    workflow_contenttype = ContentType.objects.get_for_model(
        apps.get_model("course_flow", "Workflow")
    )
    activity_contenttype = ContentType.objects.get_for_model(Activity)
    course_contenttype = ContentType.objects.get_for_model(Course)
    program_contenttype = ContentType.objects.get_for_model(Program)
    db_alias = schema_editor.connection.alias

    ObjectPermission.objects.using(db_alias).exclude(activity=None).update(
        content_type=activity_contenttype
    )
    ObjectPermission.objects.using(db_alias).exclude(course=None).update(
        content_type=course_contenttype
    )
    ObjectPermission.objects.using(db_alias).exclude(program=None).update(
        content_type=program_contenttype
    )


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("course_flow", "0106_project_is_strategy"),
    ]

    operations = [
        migrations.AlterField(
            model_name="objectpermission",
            name="content_type",
            field=models.ForeignKey(
                limit_choices_to={
                    "model__in": [
                        "project",
                        "activity",
                        "course",
                        "program",
                        "workflow",
                    ]
                },
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.RunPython(forwards_func, reverse_func),
    ]
