# Generated by Django 3.2.15 on 2023-02-05 16:12

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


def forwards_func(apps, schema_editor):
    Activity = apps.get_model("course_flow", "Activity")
    Course = apps.get_model("course_flow", "Course")
    Program = apps.get_model("course_flow", "Program")
    for workflow in (
        list(Activity.objects.all())
        + list(Course.objects.all())
        + list(Program.objects.all())
    ):
        workflow.author_temp = workflow.author
        workflow.save()


def reverse_func(apps, schema_editor):
    Activity = apps.get_model("course_flow", "Activity")
    Course = apps.get_model("course_flow", "Course")
    Program = apps.get_model("course_flow", "Program")
    for workflow in (
        list(Activity.objects.all())
        + list(Course.objects.all())
        + list(Program.objects.all())
    ):
        workflow.author = workflow.author_temp
        workflow.save()


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("course_flow", "0101_auto_20230118_2202"),
    ]

    operations = [
        migrations.AddField(
            model_name="workflow",
            name="author_temp",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="authored_workflows",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.RunPython(forwards_func, reverse_func),
        migrations.AlterField(
            model_name="courseflowuser",
            name="notifications",
            field=models.BooleanField(
                default=False,
                help_text="Check this box if you would like to receive emails from us about updates to CourseFlow.",
            ),
        ),
    ]
