########################################################################
#
#                 Language configuration
#
########################################################################

# --- unique fiber offset ---
# Warning! do not touch this. It will be automatically generated by fs.py

FIBER_OFFSET = 0

# -- editable section -->

import os
import sys

from optparse import OptionParser

import fibermod.symbol as symbol
import fibermod.token as token

token.FIBER_OFFSET = FIBER_OFFSET
token.FiberToken().gen_token(token)

# modules and functions parametrized by symbol and token

from EasyExtend.cst2source import Unparser
from EasyExtend.csttools import pprint
from EasyExtend.eecommon import getoptions

from EasyExtend.fstools import FSConfig
FSConfig.fiber_table.append( {"offset":FIBER_OFFSET, "symbol": symbol, "token":token} )

opt = getoptions()
opt.add_option("-d", dest="deactivate_default", action = "store_const", const=True, help="deactivate default pattern that recognizes modules of the kind test_xxx and xxx accordingly")
opt.add_option("--pat", dest="pattern", help="pattern used to describe modules accepted by coverage importer")
opt.add_option("-o", dest="output",  help="Report output file")

unparse = Unparser(symbol, token, offset = FIBER_OFFSET)

# add Fibers dir to sys.path

sys.path.append((os.sep).join(symbol.__file__.split(os.sep)[:-3]))

# thin fiber

thin_fiber = False

# prompt

prompt = ">>> "

# extension

ext = "pycov"

########################################################################


