/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.CallbackConnection;
import py4j.Py4JException;
import py4j.Py4JNetworkException;

public class CallbackClient {
    public static final String DEFAULT_ADDRESS = "127.0.0.1";
    private final int port;
    private final InetAddress address;
    private final Deque<CallbackConnection> connections = new ArrayDeque<CallbackConnection>();
    private final Lock lock = new ReentrantLock(true);
    private final Logger logger = Logger.getLogger(CallbackClient.class.getName());
    private boolean isShutdown = false;
    public static final long DEFAULT_MIN_CONNECTION_TIME = 30L;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final long minConnectionTime;
    private final TimeUnit minConnectionTimeUnit;

    public CallbackClient(int port) {
        this.port = port;
        try {
            this.address = InetAddress.getByName(DEFAULT_ADDRESS);
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Default address could not be determined when creating communication channel.");
        }
        this.minConnectionTime = 30L;
        this.minConnectionTimeUnit = TimeUnit.SECONDS;
        this.setupCleaner();
    }

    public CallbackClient(int port, InetAddress address) {
        this.port = port;
        this.address = address;
        this.minConnectionTime = 30L;
        this.minConnectionTimeUnit = TimeUnit.SECONDS;
        this.setupCleaner();
    }

    public CallbackClient(int port, InetAddress address, long minConnectionTime, TimeUnit minConnectionTimeUnit) {
        this.port = port;
        this.address = address;
        this.minConnectionTime = minConnectionTime;
        this.minConnectionTimeUnit = minConnectionTimeUnit;
        this.setupCleaner();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    private CallbackConnection getConnection() throws IOException {
        CallbackConnection connection = null;
        connection = this.connections.pollLast();
        if (connection == null) {
            connection = new CallbackConnection(this.port, this.address);
            connection.start();
        }
        return connection;
    }

    private CallbackConnection getConnectionLock() {
        CallbackConnection cc = null;
        try {
            this.logger.log(Level.INFO, "Getting CB Connection");
            this.lock.lock();
            if (!this.isShutdown) {
                cc = this.getConnection();
                this.logger.log(Level.INFO, "Acquired CB Connection");
            } else {
                this.logger.log(Level.INFO, "Shuting down, no connection can be created.");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Critical error while sending a command", e);
            throw new Py4JException("Error while obtaining a new communication channel", e);
        }
        finally {
            this.lock.unlock();
        }
        return cc;
    }

    public int getPort() {
        return this.port;
    }

    private void giveBackConnection(CallbackConnection cc) {
        try {
            this.lock.lock();
            if (cc != null) {
                if (!this.isShutdown) {
                    this.connections.addLast(cc);
                } else {
                    cc.shutdown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void periodicCleanup() {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                int size = this.connections.size();
                for (int i = 0; i < size; ++i) {
                    CallbackConnection cc = this.connections.pollLast();
                    if (cc.wasUsed()) {
                        cc.setUsed(false);
                        this.connections.addFirst(cc);
                        continue;
                    }
                    cc.shutdown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String sendCommand(String command) {
        return this.sendCommand(command, true);
    }

    public String sendCommand(String command, boolean blocking) {
        String returnCommand = null;
        CallbackConnection cc = this.getConnectionLock();
        if (cc == null) {
            throw new Py4JException("Cannot obtain a new communication channel");
        }
        try {
            returnCommand = cc.sendCommand(command, blocking);
        }
        catch (Py4JNetworkException pe) {
            this.logger.log(Level.WARNING, "Error while sending a command", pe);
            returnCommand = this.sendCommand(command, blocking);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Critical error while sending a command", e);
            throw new Py4JException("Error while sending a command.");
        }
        this.giveBackConnection(cc);
        return returnCommand;
    }

    private void setupCleaner() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CallbackClient.this.periodicCleanup();
            }
        }, this.minConnectionTime, this.minConnectionTime, this.minConnectionTimeUnit);
    }

    public void shutdown() {
        this.logger.info("Shutting down Callback Client");
        try {
            this.lock.lock();
            this.isShutdown = true;
            for (CallbackConnection cc : this.connections) {
                cc.shutdown();
            }
            this.executor.shutdownNow();
            this.connections.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

