#! /usr/bin/env python
# -*- coding: latin1 -*-
"""acierror is part of the EntireX Broker Interface for Python Applications

It defines:

- errdict, the error dictionary mapping Broker errors
  to text

- geterror(), a function to obtain the error text from the EntireX error
  code

"""

errdict = {
  '0000': 'EntireX Broker Services Error Reason ',
  '0001': 'EntireX RPC Runtime ',
  '0002': 'EntireX ACI Error Class User does not ',
  '0003': 'EntireX ACI Error Class Conversation ',
  '0007': 'EntireX ACI Error Class Service not ',
  '0008': 'EntireX ACI Error Class Security or encryption ',
  '0010': 'EntireX ACI Error Class Commands to ',
  '0014': 'EntireX ACI Error Class Broker Stub Version ',
  '0020': 'EntireX ACI Error Class User error in the ',
  '0021': 'EntireX ACI Error Class Configuration error in the Attribute ',
  '0022': 'EntireX ACI Error Class Error in a user ',
  '0036': 'EntireX ACI Error Class Broker ',
  '0037': 'EntireX ACI Error Class Broker resource ',
  '0074': 'EntireX ACI Error Class No request or Message ',
  '0078': 'EntireX ACI Error Class Error from ',
  '0079': 'EntireX ACI Error Class Error in Broker ',
  '0196': 'EntireX ACI Error Class Disconnected due to new ',
  '0215': 'EntireX ACI Error Class Connection ',
  '0216': 'EntireX ACI Error Class SSL Return ',
  '0217': 'Transactionality Return ',
  '0250': 'EntireX ACI Error Class Location Transparency Return ',

  '00000001': 'DEALLOCATE (DEALLOC) RECEIVED FROM PARTNER',
  '00000002': '"DEALLOC" WITH "LOCAL=Y" IS ONLY VERB ALLOWED',
  '00003001': 'STATE ERROR: INCORRECT VERB IN SEQUENCE',
  '00003002': 'INVALID REQUEST: WRONG LOGICAL RECORD LENGTH',
  '00003003': 'INVALID REQUEST: NOT LOGICAL RECORD BOUNDARY',
  '00003004': 'OPERATOR CANCELLED SESSION',
  '00003100': 'SESSION TERMINATED: UNBIND RECEIVED',
  '00003101': 'SESSION TERMINATED: SESSION CLEANUP REQUEST',
  '00003102': 'SESSION TERMINATED: TERMINATE ORDERLY REQUEST',
  '00003103': 'SESSION TERMINATED: VTAM IS TERMINATING',
  '00003104': 'SESSION TERMINATED: LU FAILURE',
  '00003200': 'SESSION TERMINATED: UNRECOGNIZED VTAM REJECTION',
  '00010001': 'No Communication',
  '00010003': 'Unknown medium',
  '00010004': 'Invalid control block',
  '00010005': 'Out of memory',
  '00010006': 'No more registrations',
  '00010007': 'Already registered',
  '00010008': 'Not registered in ERX Runtime',
  '00010009': 'Parameter error. Location of wrong parameter is n.',
  '00010010': 'Control block not found',
  '00010011': 'Pending call',
  '00010018': 'Invalid memory',
  '00010019': 'Invalid Call Id',
  '00010028': 'Illegal type',
  '00010032': 'Too many indices',
  '00010034': 'No pending call',
  '00010036': 'Parameters values not ascending',
  '00010037': 'Invalid timeout',
  '00010038': 'Version not supported',
  '00010039': 'Cyclic parameter',
  '00010045': 'AT EXIT error',
  '00010046': 'Initializing trace failed',
  '00010052': 'Library missing',
  '00010053': 'User ID missing',
  '00010054': 'Password missing',
  '00010055': 'BCD o1.0.1ow',
  '00010056': 'BCD division by zero',
  '00010058': 'Invalid direction',
  '00010060': 'Response <reponse> from(Command/Info Service)',
  '00010061': 'Server not found(Command/Info Service)',
  '00010063': 'Invalid Parameter Definition Version',
  '00010064': 'Internal error',
  '00010065': 'No more VData Instances to free',
  '00010066': 'Cache item not found',
  '00010067': 'Success pending call',
  '00010068': 'Not yet implemented',
  '00010069': 'Invalid string buffer',
  '00010070': 'Parse error',
  '00010071': 'Server replied with different compression',
  '00010072': 'Return Code <return-code> from Broker Stub',
  '00010075': 'No RPC protocol version received by INQUIRE Call',
  '00010076': 'Server does not support RPC protocol version needed for the request',
  '00010077': 'Broker API Version 2 needed',
  '00010078': 'Parameter maximum length or array bounds o1.0.1ow.',
  '00010079': 'Invalid unbounded array.',
  '00010080': 'No more unbounded arrays to free.',
  '00010081': 'Indices not correct.',
  '00010082': 'Unbounded array does not match EntireX IDL file.',
  '00010083': 'Parameter not within value range.',
  '00010084': 'Unbounded array indices out of bounds.',
  '00010085': 'Invalid data for unbounded array.',
  '00010086': 'Invalid preserve flag for unbounded array.',
  '00010087': 'Invalid dimension for unbounded array.',
  '00010088': 'Unbounded array parameter error.',
  '00010089': 'Stub parameter definition error.',
  '00010090': 'SSL parameter initialization failed.',
  '00010091': 'Broker API Version 6 needed.',
  '00010092': 'No comma allowed in logical Etbid.',
  '00010093': 'No comma allowed in logical Service.',
  '00010095': 'Cannot open or read File=<file name>',
  '00020002': 'User Does Not Exist',
  '00030003': 'No Matching Conversation Found',
  '00030005': 'Partner finished the conversation',
  '00030010': 'EOC due to DEREGISTER of partner',
  '00030011': 'Partner has canceled conversation',
  '00030012': 'EOC due to LOGOFF of partner',
  '00030067': 'Partner timeout occurred',
  '00030073': 'Conversation Timeout Occurred',
  '00070007': 'Service Not Registered',
  '00080001': 'Access denied ext. security not active',
  '00080002': 'Access denied user profile not defined',
  '00080003': 'Access denied password not authorized',
  '00080004': 'Access denied password expired',
  '00080005': 'Access denied, new password invalid',
  '00080006': 'Access denied, rejected by inst. exit',
  '00080007': 'Access denied, user ID revoked',
  '00080008': 'Access denied at this time date',
  '00080009': 'Access denied resource not allowed',
  '00080010': 'Access denied resource not defined',
  '00080011': 'Access denied, IP address not allowed',
  '00080012': 'Access denied, IP address not defined',
  '00080254': 'Access denied SAF returns: xxxxxxxx',
  '00080255': 'Access denied SAF interface error xx(yy)',
  '00080350': 'Bad user ID detected, access denied.',
  '00080352': 'Access denied reconnected rejected',
  '00080353': 'Access denied incorrect STOKEN',
  '00080400': 'Unable to load library exxauthr.',
  '00080401': 'Service not defined, access denied.',
  '00080402': 'User not authorized for this service.',
  '00100022': 'Attach Service required',
  '00100050': 'Shutdown IMMED required',
  '00100051': 'Shutdown QUIESCE required',
  '00140213': 'Insufficient Memory For Stub',
  # 0020
  '00200004': 'API: No Function Possible After EOC',
  '00200006': 'API: Last Message Not Found',
  '00200031': 'API: Invalid Value For Wait',
  '00200044': 'API: errtext_length > 0 but no errbuffer',
  '00200047': 'API: QUIESCE invalid for Attach Manager',
  '00200048': 'API: Already registered with ATTACH',
  '00200052': 'API: Already registered without ATTACH',
  '00200094': 'API: MSG Truncated To Fit Receive-Buffer',
  '00200098': 'API: Function not possible if LOGON only',
  '00200134': 'LOGON required',
  '00200164': 'API: Invalid Compress option',
  '00200165': 'Error during data compression',
  '00200166': 'Error during data decompression',
  '00200167': 'Unexpected error during comp/decomp',
  '00200168': 'Decompressed data corrupt',
  '00200169': 'API: Compression is not available',
  '00200170': 'API: Invalid decompressed data length',
  '00200181': 'API: Invalid User-ID',
  '00200182': 'API: Invalid Function',
  '00200183': 'API: Invalid CLASS/NAME/SERVICE',
  '00200184': 'API: Invalid SEND-LENGTH',
  '00200185': 'API: Invalid FUNCTION/CONVID Combination',
  '00200186': 'API: Char "."or"," not allowed in ACI CB',
  '00200187': 'API: Invalid FUNCTION/OPTION Combination',
  '00200188': 'API: Invalid Option',
  '00200189': 'API: Invalid RECEIVE-LENGTH',
  '00200190': 'API: Invalid Cmd/Info Services Version',
  '00200191': 'API: Invalid OPTION/CONV-ID Combination',
  '00200192': 'API: Invalid parameter count',
  '00200193': 'API: Invalid FUNCTION/WAIT Combination',
  '00200194': 'API: Invalid OPTION/WAIT Combination',
  '00200195': 'API: Deregister Not Allowed From Clients',
  '00200199': 'API: Receive/CID=ANY Invalid For Clients',
  '00200200': 'API: RECEIVE/CID=NEW Invalid For Clients',
  '00200203': 'API: No RECEIVE -BUFFER Address',
  '00200208': 'API: TYPE/VERSION Combination Invalid',
  '00200210': 'API: No Send Buffer Address',
  '00200211': 'API: No API Control Block Address',
  '00200212': 'API: (*) In SN/SC/SV Invalid For Function',
  '00200216': 'API: Invalid BROKER-ID',
  '00200218': 'API: Send Or Receive Length Exceed Max',
  '00200226': 'API: Invalid STATUS',
  '00200228': 'API: Invalid CONV-STAT',
  '00200229': 'API: Invalid value for STORE',
  '00200252': 'CID=NONE required for this service',
  '00200267': 'API: CID=NEW required for this service',
  '00200268': 'API: REGISTER internal service rejected',
  '00200302': 'EOC error: must back out unit of work',
  '00200311': 'API: Invalid Numeric Field',
  '00200312': 'API: Out of Range',
  '00200335': 'No Mixed Message with UOW on the Same CONVID',
  '00200336': 'No Mixed UOW with MSG on the Same CONVID',
  '00200362': 'API: Broker Stub De-Initialized',
  '00200371': 'API: Cannot Specify arch w/o codepage',
  '00200372': 'API: Error converting locale to codepage',
  '00200377': 'API: Character Conversion O1.0.1ow',
  '00200379': 'API: Inconsistent Security Installation',
  '00200380': 'Some Characters Could not Be Converted',
  '00200400': 'Invalid SSL parameter specified.',
  '00200401': 'Invalid value specified for EL',
  '00200403': 'Error with transactionality module call.',
  '00200419': 'Mismatch of EL and current encryption.',
  '00200420': 'Mismatch of Client encryption and ATTR.',
  '00200421': 'Mismatch of Server encryption and ATTR.',
  '00200422': 'Server EL and ATTR not identical.',
  '00200424': 'SETSSLPARMS only valid function call when the Broker'\
               ' ID specifies SSL as transport',
  '00200449': 'API: Invalid Compress option',
  '00200450': 'Error during data compression',
  '00200451': 'Error during data decompression',
  '00200452': 'Unexpected error during comp/decomp',
  '00200453': 'Decompressed data corrupt',
  '00200454': 'API: Compression is not available',
  '00200472': 'API: No PSTORE but durable subscriber',
  '00200478': 'EOC Error: Still Unread Unit of Work',
  '00200482': 'API: CONV-ID NONE not supported',
  '00200485': 'API: User [UN]SUBSCRIBE not allowed',
  '00200494': 'Publish and Subscribe not enabled',
  '00200505': 'Illegal operation due to wrong UOW type',
  '00200532': 'API: Error code missing in REPLY-ERROR',
  '00200533': 'API: Invalid error code in REPLY-ERROR',
  '00200538': 'API: Must specify locale to do CONVERSION',
  '00200539': 'API: Sender did not specify locale info',
  '00200540': 'API: :1: value truncated',
  '00200563': 'DEREGISTER not completed due to UOWs',
  '00200566': 'API: Invalid value for COMPRESSION TYPE',
  '00200569': 'API: Extension data truncated to fit',
  '00200613': 'API: Filter already active',
  '00200614': 'API: Filter not found',
  '00200639': 'API: Protected UOWID has been specified',
  '00200801': 'Unsecure shutdown broker not allowed',
  '00200815': 'API: invalid ETBCB variable list',
  '00200901': 'User did not request SINGLE-CONV-MODE',
  '00209400': 'FUNCTION NOT SUPPORTED',
  '00209401': 'CONV-ID VALUE NOT SUPPORTED',
  '00209402': 'WAIT VALUE NOT SUPPORTED',
  '00209403': 'OPTION NOT SUPPORTED',
  '00209404': 'xxxxxxxx - ADAPTER ERROR',
  '00209405': 'INVALID BROKER API REQUEST',
  '00209406': 'CONV-ID REQUIRED FOR DEREGISTER',
  '00209407': 'INVALID REMOTE ATTACH FUNCTION',
  '00209410': 'NO ATTACH REQUESTS AVAILABLE',
  '00209413': 'CONV-ID REQUIRED FOR RECEIVE',
  '00209416': 'MODELQ REQUIRES SPECIFIC CONV-ID=',
  '00209417': 'INVALID MSGTYPE=, WAIT= COMBINATION',
  '00209418': 'SERVER CANNOT ISSUE SEND CONVID=NONE',
  '00209419': 'INVALID MESSAGE TYPE FOR SERVER SEND',
  '00209420': 'INVALID MESSAGE TYPE FOR CLIENT SEND',
  '00209421': 'OPT=SYNC INVALID WITH SEND WAIT=',
  '00209422': 'SYNCPOINT REQUIRES OPTION=COMMIT/BACKOUT',
  '00209423': 'MSGID REQUIRED WITH CONVID=ANY/NEW/NONE',
  '00209424': 'UNIT FIELD OF WORK NOT SUPPORTED',
  '00209450': 'INTERNAL ERROR - GETMAIN FAILED',
  '00209451': 'RECEIVE FAILED - tpname NOT REGISTERED',
  '00209452': 'REGISTER REJECTED - function ACTIVE',
  '00209453': 'UNKNOWN FUNCTION REQUESTED function',
  '00209454': 'ENTIREX BROKER SERVICES TERMINATED BY OPERATOR',
  '00209455': 'function REJECTED, MISSING value',
  '00209456': 'tpname NOT DEFINED VIA CONTROL OPERATOR',
  '00209457': 'servername STOPPED BY OPERATOR COMMAND',
  '00210013': 'ATTR: Value For Keyword Too Long',
  '00210014': 'ATTR:Class def missing or invalid',
  '00210015': 'ATTR: Max Possible NUM-CLIENT Reached',
  '00210018': 'ATTR: Max Possible NUM-SERVER Reached',
  '00210019': 'ATTR: TRANSLATION Not Specified',
  '00210023': 'ATTR: Unknown Keyword',
  '00210024': 'ATTR: CONV-LIMIT may not be UNLIM',
  '00210025': 'ATTR: CONV-DEFAULT not spec or UNLIM',
  '00210026': 'ATTR: Zero Value For Keyword Not Allowed',
  '00210027': 'ATTR: Value For Keyword Out Of Range',
  '00210028': 'ATTR: Invalid Value For Keyword',
  '00210029': 'ATTR: SHORT-BUFF-LIMIT may not be UNLIM',
  '00210030': 'ATTR: SHORT-BUFF-DEF not spec or UNLIM',
  '00210032': 'ATTR: LONG-BUFF-LIMIT may not be UNLIM',
  '00210033': 'ATTR: LONG-BUFF-DEF not spec or UNLIM',
  '00210034': 'ATTR: SERVICE Section missing',
  '00210036': 'ATTR: Unknown service attribute',
  '00210037': 'ATTR: Value must be YES or NO',
  '00210038': 'ATTR: Error During Open Of File',
  '00210040': 'ATTR: Error During Close Of File',
  '00210043': 'ATTR: Service Definition Not Found; Check if class/name/service parameters match with those in attribute file',
  '00210045': 'ATTR: Keyword Value Must Be Alpha-Num.',
  '00210046': 'ATTR: SERVER-LIMIT may not be UNLIM',
  '00210047': 'ATTR: SERVER-DEFAULT not spec or UNLIM',
  '00210048': 'ATTR: SERVER-LIMIT for service reached',
  '00210096': 'ATTR: Max Possible NUM-SERVICE Reached',
  '00210402': 'ATTR: SECURITY/ENCRYPTION-LEVEL mismatch.',
  '00210423': 'ATTR: AUTO/Catch-All Service mismatch.',
  '00360060': 'Failed To Get Lock For GCT',
  '00360088': 'Failed To Get Lock',
  '00360231': 'Failed To Get Lock For SCB',
  '00360363': 'Unable to Get Lock for SAT Create',
  '00360381': 'Unable to get lock for PCB Create',
  '00360476': 'Cannot generate new CONVID',
  '00360477': 'Cannot generate new UOWID',
  '00370041': 'ATTR: CONV-LIMIT for service reached',
  '00370042': 'ATTR: BUFFER-LIMIT for service reached',
  '00370057': 'ATTR: Shortage For NUM-SHORT-BUFFERS',
  '00370061': 'ATTR: Shortage For NUM-LONG-BUFFER',
  '00370197': 'Reconnect Rejected - User Busy',
  '00370230': 'ATTR: Max NUM-CONVERSATION Reached',
  '00370364': 'Participant Already Active',
  '00370365': 'Service Currently Created',
  '00370366': 'Participant Currently Created',
  '00370445': 'PSI: New UOW messages are not allowed',
  '00740009': 'Conversation Found - No Message',
  '00740074': 'Wait Timeout Occurred',
  '00740300': 'Conversation found no units of work',
  '00740301': 'Conversation found end of unit of work',
  '00740345': 'Service MAX-UOWS Reached',
  '00740346': 'Service Does Not Support UOW',
  '00740347': 'Max. Number of Messages per UOW Reached',
  '00749460': 'POSITIVE CONFIRMATION RECEIVED',
  '00749461': 'EXPIRATION REPORT RECEIVED',
  '00780008': 'No Related Text For Error Number',
  '00780016': 'MQ/OMB Entry Already Free',
  '00780017': 'Invalid argument for etblex',
  '00780055': 'TRE Entry Not Active',
  '00780093': 'MQ Store Pointer Is Null',
  '00780099': 'No Free TOQ Entry',
  '00780198': 'No Related SCBEXT Entry For PCB',
  '00780221': 'SPFX Translation Code Error',
  '00780239': 'Invalid length in format string',
  '00780241': 'No Free SCBEXT Entry',
  '00780244': 'No Free TRE Entry',
  '00780245': 'No Related SCB Entry For Client',
  '00780254': 'Invalid type in format string',
  '00780258': 'Pointer to next segment is null',
  '00780259': 'No Related TOQ Entry',
  '00780260': 'Pointer to Info structure is null',
  '00780261': 'No Free PCB Entry',
  '00780262': 'No Free PCBEXT Entry',
  '00780265': 'No Free SCB Entry',
  '00780266': 'Inconsistency at start Info/Cmd-Service',
  '00780303': 'No Free LCB Entry',
  '00780304': 'No Free UWCB Entry',
  '00780305': 'No matching UOW found',
  '00780306': 'UOWs not found for UOWID=BOTH',
  '00780307': 'UOW is not in correct status',
  '00780308': 'UOW was not created by caller',
  '00780309': 'Error updating UOW status',
  '00780310': 'Mismatched UOWs Store Type',
  '00780313': 'Broker RESTART failed',
  '00780337': 'Restart: Duplicate UOWID found',
  '00780338': 'Exit attempted to change message size',
  '00780339': 'No storage for security exit',
  '00780350': 'UOW operations not allowed',
  '00780351': 'UOWID required for COMMIT/BACKOUT/CANCEL',
  '00780356': 'Error Updating Receiver Data',
  '00780357': 'Message Queue Inconsistent',
  '00780375': 'No storage for Translation Buffer',
  '00780388': 'PSI: UOWs can NOT be persisted',
  '00780389': 'PSI: UOW status can NOT be persisted',
  '00790072': 'STUB: Missing API Terminator Char(.)',
  '00790122': 'STUB: Invalid :1: value',
  '00790124': 'STUB: Invalid :1: size',
  '00790130': 'STUB: Invalid size of REQ STRING value',
  '00790131': 'STUB: Invalid size of REQ STRING key',
  '00790202': 'STUB: Error in SPFX Length',
  '00790204': 'STUB: Version Not Supported',
  '00790205': 'STUB: Invalid SPFX Offsets',
  '00790206': 'STUB: Offset Does not Point to Data',
  '00790207': 'STUB: No Adabas VB Or Adabas RB',
  '00790209': 'STUB: Nothing Returned From Broker',
  '00790214': 'STUB: Work Space Allocation Failed',
  '00790219': 'STUB: No TWA defined',
  '00790225': 'SPFX Reply Buffer O1.0.1ow',
  '00790227': 'SPFX Unknown Binary field',
  '00790233': 'STUB: problem with SPFX total length',
  '00790234': 'Invalid binary field length',
  '00790237': 'STUB: parallel calls are not allowed',
  '00790369': 'STUB: Unable to Set Up Signal Handler',
  '01960196': 'Disconnected Due To New Location',
  '02150128': 'Work queue full or alloc XWQE failed',
  '02150129': 'Not enough space in Communication buffer.',
  '02150148': 'EntireX Broker not active',
  '02150151': 'Adabas command queue o1.0.1ow',
  '02150152': 'IUBL is too low',
  '02150254': 'NET: Connection Error',
  '02150255': 'NET: Connection Error',
  '02150278': 'User Buffer Too Small',
  '02150373': 'Transport Timeout exceeded',
  '02159408': 'various error texts',
  '02159409': 'various error texts',
  '02159411': 'NOTHING TO DEREGISTER',
  '02160050': 'XTS Semaphore Error',
  '02160051': 'XTS Memory Allocation Error',
  '02160052': 'XTS Server already registered',
  '02160053': 'XTS Incorrect URL',
  '02160054': 'XTS Failure Loading Protocol Handle',
  '02160055': 'XTS TCP/IP Init failed',
  '02160056': 'XTS Invalid protocol type',
  '02160057': 'XTS Listen Failed',
  '02160058': 'XTS Accept Failed',
  '02160059': 'XTS Connect Failed',
  '02160060': 'XTS No directory information',
  '02160061': 'XTS Failure to create a thread',
  '02160062': 'XTS Timeout error',
  '02160063': 'XTS Send Failed',
  '02160064': 'XTS Invalid reference',
  '02160065': 'XTS Send incomplete',
  '02160066': 'XTS No such server',
  '02160068': 'XTS No more cookies available',
  '02160069': 'XTS Resolve Target failed',
  '02160070': 'XTS Resolve Target Reply failed',
  '02160071': 'XTS Target cannot be resolved',
  '02160072': 'XTS Not initialized',
  '02160073': 'XTS Bind Client failed',
  '02160074': 'XTS Too many user threads',
  '02160075': 'XTS Created thread failed',
  '02160076': 'XTS Wrong IP address',
  '02160077': 'XTS Conversion failed',
  '02160078': 'XTS No Target Name',
  '02160079': 'XTS No Client Name',
  '02160080': 'XTS GetHostByName Failed',
  '02160081': 'XTS GetHostByAddr Failed.',
  '02160082': 'XTS Zero Length not accepted',
  '02160083': 'XTS Target Id Out of Range',
  '02160084': 'XTS Channel Inactive',
  '02160085': 'XTS Disconnect message',
  '02160086': 'XTS Hash table error',
  '02160087': 'XTS Thread key error',
  '02160088': 'XTS No CONNECT or LISTEN has been issued',
  '02160089': 'XTS Protocol not supported',
  '02160090': 'XTS Single Thread not supported',
  '02160091': 'XTS No Active Server',
  '02160092': 'XTS No Matching Cookie',
  '02160093': 'XTS Invalid HTTP header',
  '02160094': 'XTS Zero pointer',
  '02160095': 'XTS Hash table full',
  '02160096': 'XTS Send User Exit failed',
  '02160097': 'XTS Recv User Exit failed',
  '02160098': 'XTS Load User Exit failed',
  '02160099': 'XTS Message Rejected',
  '02160100': 'XTS Shutdown in process',
  '02160101': 'XTS Route Timeout',
  '02160102': 'XTS Route Table o1.0.1ow',
  '02160103': 'XTS Route TTL expired',
  '02160104': 'XTS Route failed',
  '02160120': 'XTS SSL init failed',
  '02160121': 'XTS SSL Verify CA locations failed',
  '02160122': 'XTS SSL Certificate file not specified',
  '02160123': 'XTS SSL Invalid Certificate',
  '02160124': 'XTS SSL Invalid Key File',
  '02160125': 'XTS SSL Invalid Key',
  '02160126': 'XTS SSL Connect failed',
  '02160127': 'XTS SSL Accept failed',
  '02160128': 'XTS SSL Read failed',
  '02160129': 'XTS SSL Write failed',
  '02160130': 'XTS SSL Null parameter',
  '02160131': 'XTS SSL Invalid parameter',
  '02160132': 'XTS SSL Invalid value',
  '02160133': 'XTS SSL Failed loading library',
  '02160134': 'XTS SSL No session',
  '02160135': 'XTS SSL Renegotiation failed',
  '02160136': 'XTS SSL No random file error',
  '02160137': 'XTS SSL Illegal host name',
  '02160200': 'DS Open File failed',
  '02160201': 'DS Incomplete Entry',
  '02160202': 'DS Wrong Parameter',
  '02160203': 'DS Service not provided',
  '02160204': 'DS Null parameter',
  '02160205': 'DS Incomplete Entry',
  '02160206': 'DS Topic Not Defined',
  '02160207': 'DS Wrong URL Parameter',
  '02160208': 'DS No Entries',
  '02160209': 'DS Delete Failed',
  '02160210': 'DS Connection Failed',
  '02160211': 'DS Bind Failed',
  '02160212': 'DS Search Failed',
  '02160213': 'DS Add Failed',
  '02160214': 'DS Already Exists',
  '02160215': 'DS Failure Loading Service Handler',
  '02160216': 'DS Wrong directory parameter',
  '02160217': 'DS Not Initialized',
  '02160218': 'DS Invalid target Name',
  '02161000': ' XTS Unknown error=%d',
  '02161001': 'TCP/IP Not owner',
  '02161002': 'TCP/IP No such file or directory',
  '02161003': 'TCP/IP No such process',
  '02161004': 'TCP/IP Interrupted system call',
  '02161005': 'TCP/IP I/O error',
  '02161006': 'TCP/IP No such device or address',
  '02161007': 'TCP/IP Arg list too long',
  '02161008': 'TCP/IP Exec format error',
  '02161009': 'TCP/IP Bad file number',
  '02161010': 'TCP/IP No children',
  '02161011': 'TCP/IP Operation would cause deadlock',
  '02161012': 'TCP/IP Not enough core',
  '02161013': 'TCP/IP Permission denied',
  '02161014': 'TCP/IP Bad address',
  '02161015': 'TCP/IP Block device required',
  '02161016': 'TCP/IP Mount device busy',
  '02161017': 'TCP/IP File exists',
  '02161018': 'TCP/IP Cross-device link',
  '02161019': 'TCP/IP No such device',
  '02161020': 'TCP/IP Not a directory',
  '02161021': 'TCP/IP Is a directory',
  '02161022': 'TCP/IP Invalid argument',
  '02161023': 'TCP/IP File table o1.0.1ow',
  '02161024': 'TCP/IP Too many open sockets',
  '02161025': 'TCP/IP Not a typewriter',
  '02161026': 'TCP/IP Text file busy',
  '02161027': 'TCP/IP File too large',
  '02161028': 'TCP/IP No space left on device',
  '02161029': 'TCP/IP Illegal seek',
  '02161030': 'TCP/IP Read-only file system',
  '02161031': 'TCP/IP Too many links',
  '02161032': 'TCP/IP Broken pipe',
  '02161033': 'TCP/IP Argument too large',
  '02161034': 'TCP/IP Result too large',
  '02161035': 'TCP/IP Resource temporarily unavailable',
  '02161036': 'TCP/IP Operation now in progress',
  '02161037': 'TCP/IP Operation already in progress',
  '02161038': 'TCP/IP Socket operation on non-socket',
  '02161039': 'TCP/IP Destination address required',
  '02161040': 'TCP/IP Message too long',
  '02161041': 'TCP/IP Protocol wrong type for socket',
  '02161042': 'TCP/IP Bad protocol option',
  '02161043': 'TCP/IP Protocol not supported',
  '02161044': 'TCP/IP Socket type not supported',
  '02161045': 'TCP/IP Operation not supported',
  '02161046': 'TCP/IP Protocol Family not supported',
  '02161047': 'TCP/IP Cannot assign requested address',
  '02161048': 'TCP/IP Address already in use',
  '02161049': 'TCP/IP Address family not supported by protocol family',
  '02161050': 'TCP/IP Network is down',
  '02161051': 'TCP/IP Network is unreachable',
  '02161052': 'TCP/IP Network dropped connection on reset',
  '02161053': 'TCP/IP Software caused connection abort',
  '02161054': 'TCP/IP Connection reset by peer',
  '02161055': 'TCP/IP No buffer space available',
  '02161056': 'TCP/IP Socket is already connected',
  '02161057': 'TCP/IP Socket is not connected',
  '02161058': 'TCP/IP Cannot send after socket shutdown',
  '02161059': 'TCP/IP Too many references',
  '02161060': 'TCP/IP Connection timed out',
  '02161061': 'TCP/IP Connection refused',
  '02161062': 'TCP/IP Too many levels of symbolic links',
  '02161063': 'TCP/IP File name too long',
  '02161064': 'TCP/IP Host is down',
  '02161065': 'TCP/IP No route to host',
  '02161066': 'TCP/IP Directory not empty',
  '02161067': 'TCP/IP Too many processes',
  '02161068': 'TCP/IP Too many users',
  '02161069': 'TCP/IP Disc quota exceeded',
  '02161070': 'TCP/IP Stale NFS file handle',
  '02161071': 'TCP/IP Too many levels of remote in path',
  '02161082': 'TCP/IP Out of STREAMS resources',
  '02161083': 'TCP/IP System call timed out',
  '02161084': 'TCP/IP Next message has wrong type',
  '02161085': 'TCP/IP No message on stream head read queue',
  '02161086': 'TCP/IP No message on stream head read queue',
  '02161087': 'TCP/IP fd not associated with a stream',
  '02161091': 'TCP/IP Network subsystem is unavailable',
  '02161092': 'TCP/IP WINSOCK.DLL version out of range',
  '02161093': 'TCP/IP Successful WSAStartup not yet performed',
  '02161095': 'TCP/IP cannot start operation',
  '02161097': 'TCP/IP operation (now) in progress',
  '02161101': 'TCP/IP Graceful shutdown in progress',
  '02161111': 'TCP/IP Host not found',
  '02161112': 'TCP/IP Non-authoritative host not found',
  '02161113': 'TCP/IP This is a non-recoverable error',
  '02161114': 'TCP/IP Valid name, no data record of requested type',
  '02161115': 'TCP/IP Resource unavailable',
  '02161116': 'TCP/IP SMARTS Reserved',
  '02161117': 'TCP/IP Resource deadlock would occur',
  '02161118': 'TCP/IP SMARTS Reserved',
  '02161119': 'TCP/IP Identifier removed',
  '02161120': 'TCP/IP Too many open files',
  '02161121': 'TCP/IP Message too large',
  '02161122': 'TCP/IP SMARTS Reserved',
  '02161123': 'TCP/IP No locks available',
  '02161124': 'TCP/IP SMARTS Reserved',
  '02161125': 'TCP/IP No message of the desired type',
  '02161126': 'Function not supported',
  '02161127': 'TCP/IP Directory not empty',
  '02161128': 'TCP/IP SMARTS Reserved',
  '02161129': 'TCP/IP Value too large to be stored in data',
  '02161130': 'TCP/IP SMARTS Reserved',
  '02179999': 'The shared library for the Transactionality Feature '\
                'could not be loaded.',
  '02500007': 'LocTrans: ECS conversion error',
  '02500020': 'LocTrans: LDAP server connection failure',
  '02500022': 'LocTrans: LDAP security error',
  '02500023': 'LocTrans: Invalid context parameter',
  '02500025': 'LocTrans: Repository not found',
  '02500026': 'LocTrans: Invalid directory service',
  '02500027': 'LocTrans: baseDN required for LDAP',
  '02500028': 'LocTrans: authPass required for LDAP',
  '02500029': 'LocTrans: LDAP initialization failed',
  '02500030': 'LocTrans: LDAP server bind failed',
  '02500060': 'LocTrans: Logical Name not in directory',
  '02500201': 'LocTrans: No Broker ID found for <logical name>',
  '02500202': 'LocTrans: No running Broker found for <logical name>',
  '02500203': 'LocTrans: Could not resolve logical Broker for <logical name>',
  '02500204': 'LocTrans: Real service not unique for <logical name>',
  '02500205': 'LocTrans: No real service found for <logical name>',
  '02500206': 'LocTrans: No logical Broker found for <logical name>',
  '02500207': 'LocTrans: Description of logical service corrupt '\
                '(<value>) for <logical name>',
  '02500208': 'LocTrans: Error in configuration: <detailed description>',
  '02501000': 'LocTrans: No logical service specified',
  '02501001': 'LocTrans: No active Broker found',
  '02501002': 'LocTrans: EXXLocTrans.dll file not found',
  '02501003': 'LocTrans: XDS.ini file not found'
}


def geterror(errorcode):
    if errorcode in errdict:
        return '%s: %s' % (errorcode, errdict[errorcode])
    else:
        # no error text found, return more general info.
        # Return first byte = blank as indicator for exception class
        #  to add error text returned from broker
        if len(errorcode) > 4:
            errorclass = errorcode[0:4]
            if errorclass in errdict:  # key exists?
                return ' %s: error class: %s' % (errorcode, errdict[errorclass])
        return ' %s : no explanation available' % errorcode


__version__ = '1.0.1'
if __version__ == '1.0.1':
    _svndate='$Date: 2018-10-10 18:37:47 +0200 (Wed, 10 Oct 2018) $'
    _svnrev='$Rev: 876 $'
    __version__ = 'Dev ' +  _svnrev.strip('$') + \
                  ' '.join(_svndate.strip('$').split()[0:3])

#  Copyright 2004-2019 Software AG
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
