
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def VmAlreadyExistsInDatacenter(vim, *args, **kwargs):
    '''Fault thrown when moving a standalone host between datacenters, and one or more
    of the virtual machines registered on the host are already registered to hosts
    in the target datacenter.'''

    obj = vim.client.factory.create('{urn:vim25}VmAlreadyExistsInDatacenter')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 8:
        raise IndexError('Expected at least 9 arguments got: %d' % len(args))

    required = [ 'host', 'hostname', 'vm', 'target', 'dynamicProperty', 'dynamicType',
        'faultCause', 'faultMessage' ]
    optional = [  ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
