/*
 * Decompiled with CFR 0.152.
 */
package com.ephox.jsrobot;

import java.applet.Applet;
import java.awt.AWTException;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.security.Permission;
import javax.imageio.ImageIO;
import javax.swing.Timer;
import netscape.javascript.JSObject;

public class JSRobot
extends Applet {
    private static final long serialVersionUID = 1L;
    private boolean started = false;
    private Robot robot;
    private File _screenshotDir;

    public void init() {
        System.err.println("Init");
        System.setSecurityManager(new SecurityManager(){

            public void checkPermission(Permission permission) {
            }
        });
        this.setFocusable(false);
    }

    public void start() {
        System.err.println("Start");
        if (!this.started) {
            this.started = true;
            Timer timer = new Timer(100, new ActionListener(){
                private int attempts = 0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!JSRobot.this.isShowing() && this.attempts < 50) {
                        ++this.attempts;
                        JSRobot.this.checkNotMinimized();
                        return;
                    }
                    ((Timer)actionEvent.getSource()).stop();
                    new Thread(new Runnable(){

                        public void run() {
                            JSRobot.this.waitForIdle();
                            JSRobot.this.performCallback();
                        }
                    }).start();
                }
            });
            timer.start();
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    protected void checkNotMinimized() {
        Container container;
        for (container = this.getParent(); !(container instanceof Frame) && container != null; container = container.getParent()) {
        }
        if (container != null) {
            Frame frame = (Frame)container;
            if (frame.getExtendedState() == 1) {
                frame.setExtendedState(6);
            }
        } else {
            System.err.println("Failed to get a containing frame.");
        }
    }

    public String setClipboard(String string) {
        System.err.println("Set clipboard");
        try {
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.getMessage();
        }
    }

    private void waitForIdle() {
        System.err.println("Wait for idle");
        try {
            this.getRobot().waitForIdle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void clickToFocusBrowser() {
        System.err.println("Click to focus browser.");
        try {
            Robot robot = this.getRobot();
            Point point = this.getLocationOnScreen();
            System.err.println(point);
            robot.mouseMove(point.x, point.y - 5);
            robot.mousePress(16);
            robot.mouseRelease(16);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized Robot getRobot() throws AWTException {
        if (this.robot == null) {
            this.robot = new Robot();
        }
        return this.robot;
    }

    private void performCallback() {
        System.err.println("Perform callback");
        JSObject jSObject = JSObject.getWindow((Applet)this);
        System.err.println("Got window");
        System.err.println(jSObject.eval("window.robot.callback()"));
        System.err.println("Finished performing callback");
    }

    public String typeKey(int n, boolean bl) {
        return this.doTypeKey(n, bl ? 16 : -1);
    }

    public String typeAsShortcut(int n) {
        return this.doTypeKey(n, this.getShortcutKey());
    }

    public String typeSymbolsAboveNumberKeys() {
        for (int i = 0; i < 10; ++i) {
            this.doTypeKey(48 + i, 16);
        }
        return null;
    }

    private String doTypeKey(int n, int n2) {
        try {
            System.err.println("Typing key:" + n + " with modifier " + n2);
            Robot robot = this.getRobot();
            if (n2 >= 0) {
                robot.keyPress(n2);
            }
            robot.keyPress(n);
            robot.keyRelease(n);
            if (n2 >= 0) {
                robot.keyRelease(n2);
            }
            System.err.println("Typed key");
            this.waitForIdle();
            System.err.println("Idle");
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.getMessage();
        }
    }

    private int getShortcutKey() {
        switch (this.getToolkit().getMenuShortcutKeyMask()) {
            case 2: {
                return 17;
            }
            case 4: {
                return 157;
            }
            case 8: {
                return 18;
            }
            case 32: {
                return 65406;
            }
        }
        throw new IllegalStateException("Menu shortcut key is unrecognised: " + this.getToolkit().getMenuShortcutKeyMask());
    }

    public void setScreenShotDirectory(String string) {
        this._screenshotDir = new File(string);
    }

    public String captureScreenShot() {
        try {
            Robot robot = this.getRobot();
            BufferedImage bufferedImage = robot.createScreenCapture(this.getGraphicsConfiguration().getBounds());
            File file = File.createTempFile("TestScreenshot", ".jpg", this._screenshotDir);
            ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
            return file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.getMessage();
        }
    }
}

