# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StorageAccountKey(Model):
    """An access key for the storage account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar key_name: Name of the key.
    :vartype key_name: str
    :ivar value: Base 64 encoded value of the key.
    :vartype value: str
    :ivar permissions: Permissions for the key. Possible values include:
     'READ', 'FULL'
    :vartype permissions: str or :class:`KeyPermission
     <azure.mgmt.storage.models.KeyPermission>`
    """ 

    _validation = {
        'key_name': {'readonly': True},
        'value': {'readonly': True},
        'permissions': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'KeyPermission'},
    }

    def __init__(self):
        self.key_name = None
        self.value = None
        self.permissions = None
