##############################################################################
#
# Copyright (c) 2008 Projekt01 GmbH and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""
$Id:$
"""
__docformat__ = "reStructuredText"

import zope.interface
import zope.schema


class IMemcacheClient(zope.interface.Interface):

    """A memcache client utility"""

    servers = zope.schema.List(
        title=u'Servers',
        description=u'Servers defined as <hostname>:<port>',
        value_type=zope.schema.BytesLine(
            title=u'Server:Port',
            description=u'Server defined as <hostname>:<port>',
            missing_value=u'',
            required=True),
        required=True,
        default=['127.0.0.1:11211']
        )

    debug = zope.schema.Int(
        title=u'Debug flag 0 or 1',
        description=u'The debug flag 0 or 1',
        required=False,
        default=0,
        )

    pickleProtocol = zope.schema.Int(
        title=u'Pickle protocol',
        description=u'The pickle protocol number 0, 1, 2 or -1 for latest',
        required=False,
        default=-1,
        )

    lifetime = zope.schema.Int(
        title=u'Default Lifetime',
        description=u'The default lifetime of entries',
        required=True,
        default=3600,
        )

    namespace = zope.schema.ASCIILine(
        title=u'Default Namespace (ASCII)',
        description=u'The default namespace (ASCII) used by this client',
        required=False,
        default=None)


    def buildKey(key):
        """Builds a (md5) memcache key based on the given key

        - if the key is a string, the plain key get used as base

        - if the key is unicode, the key get converted to UTF-8 as base

        - if the key is an int, the key get converted to string as base

        - if key is a persistent object its _p_oid is used as base

        - anything else will get pickled (including unicode)
        
        Such a base key get converted to an md5 hexdigest if a namespace is
        used, the namespace is used as key prefix.

        """

    def set(data, key, lifetime=None, raw=False):
        """Sets data with the given key in namespace. Lifetime
        defaults to defautlLifetime and ns defaults to the
        default namespace.

        This method returns the key that is generated by the utility.

        If raw is True, the key is taken as is, and is not modified by
        the utility, the key and the namespace need to be strings in
        this case, otherwise a ValueError is raised.
        """

    def query(key, raw=False, default=None):
        """query the cache for key in namespace, returns default if
        not found. ns defaults to default namespace."""

    def invalidate(key):
        """invalidates key in namespace which defaults to default
        namespace, currently we can not invalidate just a namespace.
        """

    def invalidateAll():
        """invalidates all data of the memcached servers, not that all
        namespaces are invalidated"""

    def getStatistics():
        """returns the memcached stats"""


class IInvalidateCacheEvent(zope.interface.Interface):
    """An event which invalidates cache entries."""

    cacheName = zope.schema.TextLine(
        title=u'cacheName',
        description=u"""
            Invalidate in the cache with this name.
            If no name is given all caches are invalidated.
            """,
        required=False)

    key = zope.schema.TextLine(
        title=u'key',
        required=False)

