/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    private final Lock createFileSystemLock = new ReentrantLock(true);

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", (Object)uri, (Throwable)exc);
        }
        return this.findFile(name, fileSystemOptions);
    }

    protected FileObject findFile(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(name, "/");
        FileSystem fs = this.getFileSystem(rootName, fileSystemOptions);
        return fs.resolveFile(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem getFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileSystem fs = this.findFileSystem(rootName, fileSystemOptions);
        if (fs == null) {
            this.createFileSystemLock.lock();
            try {
                fs = this.findFileSystem(rootName, fileSystemOptions);
                if (fs == null) {
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info((Object)("Create new file system [root=" + rootName + ",opts=" + fileSystemOptions + "]"));
                    }
                    fs = this.doCreateFileSystem(rootName, fileSystemOptions);
                    this.addFileSystem(rootName, fs);
                }
            }
            finally {
                this.createFileSystemLock.unlock();
            }
        }
        return fs;
    }

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;
}

