# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class AppResource(ProxyResource):
    """App resource payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the App resource
    :type properties: ~azure.mgmt.appplatform.models.AppResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AppResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(AppResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AppResourceProperties(Model):
    """App resource properties payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param public: Indicates whether the App exposes public endpoint
    :type public: bool
    :ivar url: URL of the App
    :vartype url: str
    :ivar provisioning_state: Provisioning state of the App. Possible values
     include: 'Succeeded', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.models.AppResourceProvisioningState
    :param active_deployment_name: Name of the active deployment of the App
    :type active_deployment_name: str
    :ivar created_time: Date time when the resource is created
    :vartype created_time: datetime
    :param temporary_disk: Temporary disk settings
    :type temporary_disk: ~azure.mgmt.appplatform.models.TemporaryDisk
    :param persistent_disk: Persistent disk settings
    :type persistent_disk: ~azure.mgmt.appplatform.models.PersistentDisk
    """

    _validation = {
        'url': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
    }

    _attribute_map = {
        'public': {'key': 'public', 'type': 'bool'},
        'url': {'key': 'url', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'active_deployment_name': {'key': 'activeDeploymentName', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'temporary_disk': {'key': 'temporaryDisk', 'type': 'TemporaryDisk'},
        'persistent_disk': {'key': 'persistentDisk', 'type': 'PersistentDisk'},
    }

    def __init__(self, **kwargs):
        super(AppResourceProperties, self).__init__(**kwargs)
        self.public = kwargs.get('public', None)
        self.url = None
        self.provisioning_state = None
        self.active_deployment_name = kwargs.get('active_deployment_name', None)
        self.created_time = None
        self.temporary_disk = kwargs.get('temporary_disk', None)
        self.persistent_disk = kwargs.get('persistent_disk', None)


class BindingResource(ProxyResource):
    """Binding resource payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the Binding resource
    :type properties: ~azure.mgmt.appplatform.models.BindingResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BindingResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(BindingResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BindingResourceProperties(Model):
    """Binding resource properties payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param resource_name: The name of the bound resource
    :type resource_name: str
    :param resource_type: The standard Azure resource type of the bound
     resource
    :type resource_type: str
    :param resource_id: The Azure resource id of the bound resource
    :type resource_id: str
    :param key: The key of the bound resource
    :type key: str
    :param binding_parameters: Binding parameters of the Binding resource
    :type binding_parameters: dict[str, object]
    :ivar generated_properties: The generated Spring Boot property file for
     this binding. The secret will be deducted.
    :vartype generated_properties: str
    :ivar created_at: Creation time of the Binding resource
    :vartype created_at: str
    :ivar updated_at: Update time of the Binding resource
    :vartype updated_at: str
    """

    _validation = {
        'generated_properties': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'binding_parameters': {'key': 'bindingParameters', 'type': '{object}'},
        'generated_properties': {'key': 'generatedProperties', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'str'},
        'updated_at': {'key': 'updatedAt', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BindingResourceProperties, self).__init__(**kwargs)
        self.resource_name = kwargs.get('resource_name', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.key = kwargs.get('key', None)
        self.binding_parameters = kwargs.get('binding_parameters', None)
        self.generated_properties = None
        self.created_at = None
        self.updated_at = None


class CloudError(Model):
    """An error response from the service.

    :param error:
    :type error: ~azure.mgmt.appplatform.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.appplatform.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, **kwargs):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ClusterResourceProperties(Model):
    """Service properties payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provisioning_state: Provisioning state of the Service. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Deleted',
     'Succeeded', 'Failed', 'Moving', 'Moved', 'MoveFailed'
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.models.ProvisioningState
    :param config_server_properties: Config server git properties of the
     Service
    :type config_server_properties:
     ~azure.mgmt.appplatform.models.ConfigServerProperties
    :param trace: Trace properties of the Service
    :type trace: ~azure.mgmt.appplatform.models.TraceProperties
    :ivar version: Version of the Service
    :vartype version: int
    :ivar service_id: ServiceInstanceEntity GUID which uniquely identifies a
     created resource
    :vartype service_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'version': {'readonly': True},
        'service_id': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'config_server_properties': {'key': 'configServerProperties', 'type': 'ConfigServerProperties'},
        'trace': {'key': 'trace', 'type': 'TraceProperties'},
        'version': {'key': 'version', 'type': 'int'},
        'service_id': {'key': 'serviceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterResourceProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.config_server_properties = kwargs.get('config_server_properties', None)
        self.trace = kwargs.get('trace', None)
        self.version = None
        self.service_id = None


class ConfigServerGitProperty(Model):
    """Property of git.

    All required parameters must be populated in order to send to Azure.

    :param repositories: Repositories of git.
    :type repositories:
     list[~azure.mgmt.appplatform.models.GitPatternRepository]
    :param uri: Required. URI of the repository
    :type uri: str
    :param label: Label of the repository
    :type label: str
    :param search_paths: Searching path of the repository
    :type search_paths: list[str]
    :param username: Username of git repository basic auth.
    :type username: str
    :param password: Password of git repository basic auth.
    :type password: str
    :param host_key: Public sshKey of git repository.
    :type host_key: str
    :param host_key_algorithm: SshKey algorithm of git repository.
    :type host_key_algorithm: str
    :param private_key: Private sshKey algorithm of git repository.
    :type private_key: str
    :param strict_host_key_checking: Strict host key checking or not.
    :type strict_host_key_checking: bool
    """

    _validation = {
        'uri': {'required': True},
    }

    _attribute_map = {
        'repositories': {'key': 'repositories', 'type': '[GitPatternRepository]'},
        'uri': {'key': 'uri', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'search_paths': {'key': 'searchPaths', 'type': '[str]'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'host_key': {'key': 'hostKey', 'type': 'str'},
        'host_key_algorithm': {'key': 'hostKeyAlgorithm', 'type': 'str'},
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'strict_host_key_checking': {'key': 'strictHostKeyChecking', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ConfigServerGitProperty, self).__init__(**kwargs)
        self.repositories = kwargs.get('repositories', None)
        self.uri = kwargs.get('uri', None)
        self.label = kwargs.get('label', None)
        self.search_paths = kwargs.get('search_paths', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.host_key = kwargs.get('host_key', None)
        self.host_key_algorithm = kwargs.get('host_key_algorithm', None)
        self.private_key = kwargs.get('private_key', None)
        self.strict_host_key_checking = kwargs.get('strict_host_key_checking', None)


class ConfigServerProperties(Model):
    """Config server git properties payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar state: State of the config server. Possible values include:
     'NotAvailable', 'Deleted', 'Failed', 'Succeeded', 'Updating'
    :vartype state: str or ~azure.mgmt.appplatform.models.ConfigServerState
    :param error: Error when apply config server settings.
    :type error: ~azure.mgmt.appplatform.models.Error
    :param config_server: Settings of config server.
    :type config_server: ~azure.mgmt.appplatform.models.ConfigServerSettings
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'config_server': {'key': 'configServer', 'type': 'ConfigServerSettings'},
    }

    def __init__(self, **kwargs):
        super(ConfigServerProperties, self).__init__(**kwargs)
        self.state = None
        self.error = kwargs.get('error', None)
        self.config_server = kwargs.get('config_server', None)


class ConfigServerSettings(Model):
    """The settings of config server.

    :param git_property: Property of git environment.
    :type git_property: ~azure.mgmt.appplatform.models.ConfigServerGitProperty
    """

    _attribute_map = {
        'git_property': {'key': 'gitProperty', 'type': 'ConfigServerGitProperty'},
    }

    def __init__(self, **kwargs):
        super(ConfigServerSettings, self).__init__(**kwargs)
        self.git_property = kwargs.get('git_property', None)


class DeploymentInstance(Model):
    """Deployment instance payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the deployment instance
    :vartype name: str
    :ivar status: Status of the deployment instance
    :vartype status: str
    :ivar reason: Failed reason of the deployment instance
    :vartype reason: str
    :ivar discovery_status: Discovery status of the deployment instance
    :vartype discovery_status: str
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'reason': {'readonly': True},
        'discovery_status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'discovery_status': {'key': 'discoveryStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeploymentInstance, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.reason = None
        self.discovery_status = None


class DeploymentResource(ProxyResource):
    """Deployment resource payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the Deployment resource
    :type properties:
     ~azure.mgmt.appplatform.models.DeploymentResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(DeploymentResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class DeploymentResourceProperties(Model):
    """Deployment resource properties payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param source: Uploaded source information of the deployment.
    :type source: ~azure.mgmt.appplatform.models.UserSourceInfo
    :ivar app_name: App name of the deployment
    :vartype app_name: str
    :param deployment_settings: Deployment settings of the Deployment
    :type deployment_settings:
     ~azure.mgmt.appplatform.models.DeploymentSettings
    :ivar provisioning_state: Provisioning state of the Deployment. Possible
     values include: 'Creating', 'Processing', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.models.DeploymentResourceProvisioningState
    :ivar status: Status of the Deployment. Possible values include:
     'Unknown', 'Stopped', 'Running', 'Failed', 'Processing', 'Allocating',
     'Upgrading', 'Compiling'
    :vartype status: str or
     ~azure.mgmt.appplatform.models.DeploymentResourceStatus
    :ivar active: Indicates whether the Deployment is active
    :vartype active: bool
    :ivar created_time: Date time when the resource is created
    :vartype created_time: datetime
    :ivar instances: Collection of instances belong to the Deployment
    :vartype instances:
     list[~azure.mgmt.appplatform.models.DeploymentInstance]
    """

    _validation = {
        'app_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'active': {'readonly': True},
        'created_time': {'readonly': True},
        'instances': {'readonly': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'UserSourceInfo'},
        'app_name': {'key': 'appName', 'type': 'str'},
        'deployment_settings': {'key': 'deploymentSettings', 'type': 'DeploymentSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'active': {'key': 'active', 'type': 'bool'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'instances': {'key': 'instances', 'type': '[DeploymentInstance]'},
    }

    def __init__(self, **kwargs):
        super(DeploymentResourceProperties, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.app_name = None
        self.deployment_settings = kwargs.get('deployment_settings', None)
        self.provisioning_state = None
        self.status = None
        self.active = None
        self.created_time = None
        self.instances = None


class DeploymentSettings(Model):
    """Deployment settings payload.

    :param cpu: Required CPU. Default value: 1 .
    :type cpu: int
    :param memory_in_gb: Required Memory size in GB. Default value: 1 .
    :type memory_in_gb: int
    :param jvm_options: JVM parameter
    :type jvm_options: str
    :param instance_count: Instance count. Default value: 1 .
    :type instance_count: int
    :param environment_variables: Collection of environment variables
    :type environment_variables: dict[str, str]
    :param runtime_version: Runtime version. Possible values include:
     'Java_8', 'Java_11'
    :type runtime_version: str or
     ~azure.mgmt.appplatform.models.RuntimeVersion
    """

    _validation = {
        'cpu': {'maximum': 4, 'minimum': 1},
        'memory_in_gb': {'maximum': 8, 'minimum': 1},
        'instance_count': {'maximum': 20, 'minimum': 1},
    }

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'int'},
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'int'},
        'jvm_options': {'key': 'jvmOptions', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeploymentSettings, self).__init__(**kwargs)
        self.cpu = kwargs.get('cpu', 1)
        self.memory_in_gb = kwargs.get('memory_in_gb', 1)
        self.jvm_options = kwargs.get('jvm_options', None)
        self.instance_count = kwargs.get('instance_count', 1)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.runtime_version = kwargs.get('runtime_version', None)


class Error(Model):
    """The error code compose of code and message.

    :param code: The code of error.
    :type code: str
    :param message: The message of error.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class GitPatternRepository(Model):
    """Git repository property payload.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the repository
    :type name: str
    :param pattern: Collection of pattern of the repository
    :type pattern: list[str]
    :param uri: Required. URI of the repository
    :type uri: str
    :param label: Label of the repository
    :type label: str
    :param search_paths: Searching path of the repository
    :type search_paths: list[str]
    :param username: Username of git repository basic auth.
    :type username: str
    :param password: Password of git repository basic auth.
    :type password: str
    :param host_key: Public sshKey of git repository.
    :type host_key: str
    :param host_key_algorithm: SshKey algorithm of git repository.
    :type host_key_algorithm: str
    :param private_key: Private sshKey algorithm of git repository.
    :type private_key: str
    :param strict_host_key_checking: Strict host key checking or not.
    :type strict_host_key_checking: bool
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': '[str]'},
        'uri': {'key': 'uri', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'search_paths': {'key': 'searchPaths', 'type': '[str]'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'host_key': {'key': 'hostKey', 'type': 'str'},
        'host_key_algorithm': {'key': 'hostKeyAlgorithm', 'type': 'str'},
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'strict_host_key_checking': {'key': 'strictHostKeyChecking', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(GitPatternRepository, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.pattern = kwargs.get('pattern', None)
        self.uri = kwargs.get('uri', None)
        self.label = kwargs.get('label', None)
        self.search_paths = kwargs.get('search_paths', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.host_key = kwargs.get('host_key', None)
        self.host_key_algorithm = kwargs.get('host_key_algorithm', None)
        self.private_key = kwargs.get('private_key', None)
        self.strict_host_key_checking = kwargs.get('strict_host_key_checking', None)


class LogFileUrlResponse(Model):
    """Log file URL payload.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. URL of the log file
    :type url: str
    """

    _validation = {
        'url': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LogFileUrlResponse, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)


class LogSpecification(Model):
    """Specifications of the Log for Azure Monitoring.

    :param name: Name of the log
    :type name: str
    :param display_name: Localized friendly display name of the log
    :type display_name: str
    :param blob_duration: Blob duration of the log
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class MetricDimension(Model):
    """Specifications of the Dimension of metrics.

    :param name: Name of the dimension
    :type name: str
    :param display_name: Localized friendly display name of the dimension
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetricDimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)


class MetricSpecification(Model):
    """Specifications of the Metrics for Azure Monitoring.

    :param name: Name of the metric
    :type name: str
    :param display_name: Localized friendly display name of the metric
    :type display_name: str
    :param display_description: Localized friendly description of the metric
    :type display_description: str
    :param unit: Unit that makes sense for the metric
    :type unit: str
    :param category: Name of the metric category that the metric belongs to. A
     metric can only belong to a single category.
    :type category: str
    :param aggregation_type: Only provide one value for this field. Valid
     values: Average, Minimum, Maximum, Total, Count.
    :type aggregation_type: str
    :param supported_aggregation_types: Supported aggregation types
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: Supported time grain types
    :type supported_time_grain_types: list[str]
    :param fill_gap_with_zero: Optional. If set to true, then zero will be
     returned for time duration where no metric is emitted/published.
    :type fill_gap_with_zero: bool
    :param dimensions: Dimensions of the metric
    :type dimensions: list[~azure.mgmt.appplatform.models.MetricDimension]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
    }

    def __init__(self, **kwargs):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.category = kwargs.get('category', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.dimensions = kwargs.get('dimensions', None)


class NameAvailability(Model):
    """Name availability result payload.

    :param name_available: Indicates whether the name is available
    :type name_available: bool
    :param reason: Reason why the name is not available
    :type reason: str
    :param message: Message why the name is not available
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameAvailability, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class NameAvailabilityParameters(Model):
    """Name availability parameters payload.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the resource to check name availability
    :type type: str
    :param name: Required. Name to be checked
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameAvailabilityParameters, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)


class OperationDetail(Model):
    """Operation detail payload.

    :param name: Name of the operation
    :type name: str
    :param data_action: Indicates whether the operation is a data action
    :type data_action: bool
    :param display: Display of the operation
    :type display: ~azure.mgmt.appplatform.models.OperationDisplay
    :param origin: Origin of the operation
    :type origin: str
    :param properties: Properties of the operation
    :type properties: ~azure.mgmt.appplatform.models.OperationProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_action': {'key': 'dataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(self, **kwargs):
        super(OperationDetail, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.data_action = kwargs.get('data_action', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationDisplay(Model):
    """Operation display payload.

    :param provider: Resource provider of the operation
    :type provider: str
    :param resource: Resource of the operation
    :type resource: str
    :param operation: Localized friendly name for the operation
    :type operation: str
    :param description: Localized friendly description for the operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationProperties(Model):
    """Extra Operation properties.

    :param service_specification: Service specifications of the operation
    :type service_specification:
     ~azure.mgmt.appplatform.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, **kwargs):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class PersistentDisk(Model):
    """Persistent disk payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param size_in_gb: Size of the persistent disk in GB
    :type size_in_gb: int
    :ivar used_in_gb: Size of the used persistent disk in GB
    :vartype used_in_gb: int
    :param mount_path: Mount path of the persistent disk
    :type mount_path: str
    """

    _validation = {
        'size_in_gb': {'maximum': 50, 'minimum': 0},
        'used_in_gb': {'readonly': True, 'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'used_in_gb': {'key': 'usedInGB', 'type': 'int'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PersistentDisk, self).__init__(**kwargs)
        self.size_in_gb = kwargs.get('size_in_gb', None)
        self.used_in_gb = None
        self.mount_path = kwargs.get('mount_path', None)


class RegenerateTestKeyRequestPayload(Model):
    """Regenerate test key request payload.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. Type of the test key. Possible values include:
     'Primary', 'Secondary'
    :type key_type: str or ~azure.mgmt.appplatform.models.TestKeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RegenerateTestKeyRequestPayload, self).__init__(**kwargs)
        self.key_type = kwargs.get('key_type', None)


class ResourceUploadDefinition(Model):
    """Resource upload definition payload.

    :param relative_path: Source relative path
    :type relative_path: str
    :param upload_url: Upload URL
    :type upload_url: str
    """

    _attribute_map = {
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceUploadDefinition, self).__init__(**kwargs)
        self.relative_path = kwargs.get('relative_path', None)
        self.upload_url = kwargs.get('upload_url', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The GEO location of the resource.
    :type location: str
    :param tags: Tags of the service which is a list of key value pairs that
     describe the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ServiceResource(TrackedResource):
    """Service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The GEO location of the resource.
    :type location: str
    :param tags: Tags of the service which is a list of key value pairs that
     describe the resource.
    :type tags: dict[str, str]
    :param properties: Properties of the Service resource
    :type properties: ~azure.mgmt.appplatform.models.ClusterResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ClusterResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(ServiceResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ServiceSpecification(Model):
    """Service specification payload.

    :param log_specifications: Specifications of the Log for Azure Monitoring
    :type log_specifications:
     list[~azure.mgmt.appplatform.models.LogSpecification]
    :param metric_specifications: Specifications of the Metrics for Azure
     Monitoring
    :type metric_specifications:
     list[~azure.mgmt.appplatform.models.MetricSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(self, **kwargs):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = kwargs.get('log_specifications', None)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class TemporaryDisk(Model):
    """Temporary disk payload.

    :param size_in_gb: Size of the temporary disk in GB
    :type size_in_gb: int
    :param mount_path: Mount path of the temporary disk
    :type mount_path: str
    """

    _validation = {
        'size_in_gb': {'maximum': 5, 'minimum': 0},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TemporaryDisk, self).__init__(**kwargs)
        self.size_in_gb = kwargs.get('size_in_gb', None)
        self.mount_path = kwargs.get('mount_path', None)


class TestKeys(Model):
    """Test keys payload.

    :param primary_key: Primary key
    :type primary_key: str
    :param secondary_key: Secondary key
    :type secondary_key: str
    :param primary_test_endpoint: Primary test endpoint
    :type primary_test_endpoint: str
    :param secondary_test_endpoint: Secondary test endpoint
    :type secondary_test_endpoint: str
    :param enabled: Indicates whether the test endpoint feature enabled or not
    :type enabled: bool
    """

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'primary_test_endpoint': {'key': 'primaryTestEndpoint', 'type': 'str'},
        'secondary_test_endpoint': {'key': 'secondaryTestEndpoint', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(TestKeys, self).__init__(**kwargs)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.primary_test_endpoint = kwargs.get('primary_test_endpoint', None)
        self.secondary_test_endpoint = kwargs.get('secondary_test_endpoint', None)
        self.enabled = kwargs.get('enabled', None)


class TraceProperties(Model):
    """Trace properties payload.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar state: State of the trace proxy. Possible values include:
     'NotAvailable', 'Failed', 'Succeeded', 'Updating'
    :vartype state: str or ~azure.mgmt.appplatform.models.TraceProxyState
    :param error: Error when apply trace proxy changes.
    :type error: ~azure.mgmt.appplatform.models.Error
    :param enabled: Indicates whether enable the tracing functionality
    :type enabled: bool
    :param app_insight_instrumentation_key: Target application insight
     instrumentation key
    :type app_insight_instrumentation_key: str
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'app_insight_instrumentation_key': {'key': 'appInsightInstrumentationKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TraceProperties, self).__init__(**kwargs)
        self.state = None
        self.error = kwargs.get('error', None)
        self.enabled = kwargs.get('enabled', None)
        self.app_insight_instrumentation_key = kwargs.get('app_insight_instrumentation_key', None)


class UserSourceInfo(Model):
    """Source information for a deployment.

    :param type: Type of the source uploaded. Possible values include: 'Jar',
     'Source'
    :type type: str or ~azure.mgmt.appplatform.models.UserSourceType
    :param relative_path: Relative path of the storage which stores the source
    :type relative_path: str
    :param version: Version of the source
    :type version: str
    :param artifact_selector: Selector for the artifact to be used for the
     deployment for multi-module projects. This should be
     the relative path to the target module/project.
    :type artifact_selector: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'artifact_selector': {'key': 'artifactSelector', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserSourceInfo, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.relative_path = kwargs.get('relative_path', None)
        self.version = kwargs.get('version', None)
        self.artifact_selector = kwargs.get('artifact_selector', None)
