# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WorkflowRunTrigger(Model):
    """WorkflowRunTrigger

    :param str name: Gets the name.
    :param object inputs: Gets the inputs.
    :param ContentLink inputs_link: Gets the link to inputs.
    :param object outputs: Gets the outputs.
    :param ContentLink outputs_link: Gets the link to outputs.
    :param datetime start_time: Gets the start time.
    :param datetime end_time: Gets the end time.
    :param str tracking_id: Gets the trackingId.
    :param str code: Gets the code.
    :param str status: Gets the status. Possible values include:
     'NotSpecified', 'Paused', 'Running', 'Waiting', 'Succeeded', 'Skipped',
     'Suspended', 'Cancelled', 'Failed', 'Faulted', 'TimedOut', 'Aborted'
    :param object error: Gets the error.
    """ 

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': 'object'},
        'inputs_link': {'key': 'inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'outputs_link': {'key': 'outputsLink', 'type': 'ContentLink'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'status': {'key': 'status', 'type': 'WorkflowStatus'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(self, name=None, inputs=None, inputs_link=None, outputs=None, outputs_link=None, start_time=None, end_time=None, tracking_id=None, code=None, status=None, error=None, **kwargs):
        self.name = name
        self.inputs = inputs
        self.inputs_link = inputs_link
        self.outputs = outputs
        self.outputs_link = outputs_link
        self.start_time = start_time
        self.end_time = end_time
        self.tracking_id = tracking_id
        self.code = code
        self.status = status
        self.error = error
