# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class AccessRights(str, Enum):

    manage = "Manage"
    send = "Send"
    listen = "Listen"

class DefaultAction(str, Enum):
    """Default Action for Network Rule Set
    """

    allow = "Allow"
    deny = "Deny"

class EncodingCaptureDescription(str, Enum):
    """Enumerates the possible values for the encoding format of capture description. Note:
    'AvroDeflate' will be deprecated in New API Version
    """

    avro = "Avro"
    avro_deflate = "AvroDeflate"

class EntityStatus(str, Enum):
    """Enumerates the possible values for the status of the Event Hub.
    """

    active = "Active"
    disabled = "Disabled"
    restoring = "Restoring"
    send_disabled = "SendDisabled"
    receive_disabled = "ReceiveDisabled"
    creating = "Creating"
    deleting = "Deleting"
    renaming = "Renaming"
    unknown = "Unknown"

class IPAction(str, Enum):
    """The IP Filter Action
    """

    accept = "Accept"
    reject = "Reject"

class KeyType(str, Enum):
    """The access key to regenerate.
    """

    primary_key = "PrimaryKey"
    secondary_key = "SecondaryKey"

class ProvisioningStateDR(str, Enum):
    """Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted'
    or 'Succeeded' or 'Failed'
    """

    accepted = "Accepted"
    succeeded = "Succeeded"
    failed = "Failed"

class RoleDisasterRecovery(str, Enum):
    """role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or
    'Secondary'
    """

    primary = "Primary"
    primary_not_replicating = "PrimaryNotReplicating"
    secondary = "Secondary"

class SkuName(str, Enum):
    """Name of this SKU.
    """

    basic = "Basic"
    standard = "Standard"

class SkuTier(str, Enum):
    """The billing tier of this particular SKU.
    """

    basic = "Basic"
    standard = "Standard"

class UnavailableReason(str, Enum):
    """Specifies the reason for the unavailability of the service.
    """

    none = "None"
    invalid_name = "InvalidName"
    subscription_is_disabled = "SubscriptionIsDisabled"
    name_in_use = "NameInUse"
    name_in_lockdown = "NameInLockdown"
    too_many_namespace_in_current_subscription = "TooManyNamespaceInCurrentSubscription"
