# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class AccessRights(str, Enum):

    manage = "Manage"
    send = "Send"
    listen = "Listen"

class EntityStatus(str, Enum):
    """Enumerates the possible values for the status of the Event Hub.
    """

    active = "Active"
    disabled = "Disabled"
    restoring = "Restoring"
    send_disabled = "SendDisabled"
    receive_disabled = "ReceiveDisabled"
    creating = "Creating"
    deleting = "Deleting"
    renaming = "Renaming"
    unknown = "Unknown"

class NamespaceState(str, Enum):
    """State of the Namespace.
    """

    unknown = "Unknown"
    creating = "Creating"
    created = "Created"
    activating = "Activating"
    enabling = "Enabling"
    active = "Active"
    disabling = "Disabling"
    disabled = "Disabled"
    soft_deleting = "SoftDeleting"
    soft_deleted = "SoftDeleted"
    removing = "Removing"
    removed = "Removed"
    failed = "Failed"

class Policykey(str, Enum):
    """Key that needs to be regenerated.
    """

    primary_key = "PrimaryKey"
    secondary_key = "SecondaryKey"

class SkuName(str, Enum):
    """Name of this SKU.
    """

    basic = "Basic"
    standard = "Standard"

class SkuTier(str, Enum):
    """The billing tier of this particular SKU.
    """

    basic = "Basic"
    standard = "Standard"
    premium = "Premium"

class UnavailableReason(str, Enum):
    """Specifies the reason for the unavailability of the service.
    """

    none = "None"
    invalid_name = "InvalidName"
    subscription_is_disabled = "SubscriptionIsDisabled"
    name_in_use = "NameInUse"
    name_in_lockdown = "NameInLockdown"
    too_many_namespace_in_current_subscription = "TooManyNamespaceInCurrentSubscription"
