# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VirtualMachineConfiguration(Model):
    """
    The configuration of virtual machines for a pool.

    :param image_reference: Gets or sets information about the platform or
     marketplace image to use.
    :type image_reference: :class:`ImageReference
     <azure.batch.models.ImageReference>`
    :param node_agent_sku_id: Gets or sets the SKU of Batch Node Agent that
     needs to be provisioned on the compute node. This property must match
     the ImageReference property.
    :type node_agent_sku_id: str
    :param windows_configuration: Gets or sets Windows operating system
     settings on the virtual machine. This property must not be specified if
     the ImageReference property referencs a Linux OS image.
    :type windows_configuration: :class:`WindowsConfiguration
     <azure.batch.models.WindowsConfiguration>`
    """ 

    _validation = {
        'image_reference': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'node_agent_sku_id': {'key': 'nodeAgentSKUId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
    }

    def __init__(self, image_reference, node_agent_sku_id=None, windows_configuration=None, **kwargs):
        self.image_reference = image_reference
        self.node_agent_sku_id = node_agent_sku_id
        self.windows_configuration = windows_configuration
