# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PoolResizeParameter(Model):
    """
    Parameters for a CloudPoolOperations.Resize request.

    :param target_dedicated: Sets the desired number of compute nodes in the
     pool.
    :type target_dedicated: int
    :param resize_timeout: Sets the timeout for allocation of compute nodes
     to the pool or removal of compute nodes from the pool. The default value
     is 10 minutes.
    :type resize_timeout: timedelta
    :param node_deallocation_option: Sets when nodes may be removed from the
     pool, if the pool size is decreasing. Possible values include:
     'requeue', 'terminate', 'taskcompletion', 'retaineddata'
    :type node_deallocation_option: str
    """ 

    _validation = {
        'target_dedicated': {'required': True},
    }

    _attribute_map = {
        'target_dedicated': {'key': 'targetDedicated', 'type': 'int'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
    }

    def __init__(self, target_dedicated, resize_timeout=None, node_deallocation_option=None, **kwargs):
        self.target_dedicated = target_dedicated
        self.resize_timeout = resize_timeout
        self.node_deallocation_option = node_deallocation_option
