# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MultiInstanceSettings(Model):
    """
    Information about the settings required for multi-instance task.

    :param number_of_instances: Gets or sets the number of compute node
     instances used for multi-instance task.
    :type number_of_instances: int
    :param coordination_command_line: Gets or sets the command to be run on
     the compute node instances to setup coordination among the subtasks.
    :type coordination_command_line: str
    :param common_resource_files: Gets or sets a list of files that Batch
     will download on all subtasks.
    :type common_resource_files: list of :class:`ResourceFile
     <azure.batch.models.ResourceFile>`
    """ 

    _validation = {
        'number_of_instances': {'required': True},
    }

    _attribute_map = {
        'number_of_instances': {'key': 'numberOfInstances', 'type': 'int'},
        'coordination_command_line': {'key': 'coordinationCommandLine', 'type': 'str'},
        'common_resource_files': {'key': 'commonResourceFiles', 'type': '[ResourceFile]'},
    }

    def __init__(self, number_of_instances, coordination_command_line=None, common_resource_files=None, **kwargs):
        self.number_of_instances = number_of_instances
        self.coordination_command_line = coordination_command_line
        self.common_resource_files = common_resource_files
