#!python
# -*- coding: latin1 -*- vim: ts=8 sts=4 et si sw=4 ft=python
ur"""
TODO:
- Generalisieren als scmtools:
  - ScmInfoClass(scm) gibt eine Klasse zurck, passend zum Argument
    (z. B. 'svn', 'hq', 'git', 'cvs')
  - generische Klasse, wenn nicht explizit vorgesehen
  - Plugin-Struktur (knnte ja sein, da Sonderbehandlungen ntig sind)
- Tests
- cooked_linesep (Cygwin verwendet '\n' -- unter Windows!)
- Statusinformationen (auf Anforderung) in SvnInfo-Objekt
- Property-Informationen (auf Anforderung) in SvnInfo-Objekt
"""
__version__ = '.'.join(map(str,
                           (0,
                            2,  # get_sibling_url
                            2,  # likeix.find_svn
                            'rev-%s' % '$Rev: 845 $'[6:-2],
                            )))
__all__ = ['SvnInfo',
           # exceptions:
           'SvntoolsError',
           # v0.2+:
           'SiblingDetectionError',
           'SiblingShortcircuit',
           'SiblingArgsError',
           # v0.2.2+
           'SvntoolsNoExecutable',
           # utility functions:
           'get_sibling_url',
           ]

from subprocess import Popen, PIPE, STDOUT
from os import linesep, environ
from os.path import join, sep, curdir, \
        isfile, abspath
from sys import stderr

from likeix import get_1st, find_svn, ProgramNotFound

class SvntoolsError(Exception):
    """\
    parent of all exceptions in svntools module
    """
class SvntoolsNoExecutable(SvntoolsError):
    """\
    no subversion commandline executable found
    """
class SiblingDetectionError(SvntoolsError):
    """\
    error detecting the sibling url of a resource
    """
class SiblingShortcircuit(SiblingDetectionError):
    """\
    trunk requested for resource in trunk, or branch is requested branch
    """
class SiblingArgsError(SiblingDetectionError):
    """\
    invalid args given for sibling detection
    """

class SvnInfo:
    _executable = None
    def __init__(self, path):
        self._find_svn()
        # ergibt einen String:
        output = Popen((self._executable, 'info', path),
                       stdout=PIPE,
                       stderr=PIPE
                       ).communicate()[0]
        self._data = dict()
        for line in output.split(linesep):
            if line:
                try:
                    key, val = line.split(': ', 1)
                    self._data[key] = val
                except ValueError, e:
                    if line.strip():
                        print >> stderr, '%s ("%s")' % (e, line.strip())
                        raise

    @classmethod
    def _find_svn(cls):
        if cls._executable is not None:
            return
        try:
            cls._executable = get_1st(find_svn)
        except ProgramNotFound:
            raise SvntoolsNoExecutable(_('no svn executable found'))

    def __getitem__(self, key):
        return self._data.__getitem__(key)

    @classmethod
    def get_executable(cls):
        cls._find_svn()
        return cls._executable

class MergeList:
    def __init__(self, url, suffix=''):
        self._data = list()
        self._url = url.rstrip('/')
        self._suffix = suffix

    def add(self, src, dest=None):
        if dest is None:
            dest = src or curdir
        elif dest is '':
            dest = curdir
        if src != '':
            src = '/'+src.lstrip('/')
        self._data.append((src, dest))

    def __str__(self):
        return linesep.join(['svn merge %s%s %s%s' % (self._url, s, d,
                                                      self._suffix)
                             for s, d in self._data])

def get_sibling_url(res, trunk=None, branch=None, force=None):
    """
    get the url of a sibling of the given resource.

    res -- the resource, normally given in local file system
    trunk -- default, if the resource is located in a branch, and
             if no branch is given
    branch -- the name of a branch
    force -- get a sibling url for unversioned resources as well

    Only one of trunk or branch can be given.
    """
    if trunk and branch:
        raise SiblingArgsError(
                'please specify *either* trunk *or* branch!'
                )
    in_trunk = 0
    in_branch = None
    try:
        url = SvnInfo(res)['URL']
        liz = url.split('/')
        subs = list()
    except KeyError:
        if not force:
            raise SiblingDetectionError(
                    '"%s" is not a versioned resource'
                    % (res))
        raise NotImplementedError
        res = abspath(res)
    last = None
    try:
        while liz:
            prev = last
            last = liz.pop()
            # print last
            if not last:
                raise SiblingDetectionError(
                        'no trunk nor branch found for "%s"'
                        % (url))
            elif last == 'trunk':
                in_trunk = 1
                break
            elif last == 'branches':
                if prev is None:
                    raise SiblingDetectionError(
                            'Resource "%s" (%s) is an immediate child '
                            'of the %s directory'
                            % (res, url, last))
                in_branch = prev
                break
            else:
                subs.append(last)
        subs.reverse()
        if in_trunk and trunk:
            raise SiblingShortcircuit(
                    'resource "%s" (%s) is already in trunk'
                    % (res, url))
        elif in_branch and (in_branch == branch):
            raise SiblingShortcircuit(
                    'resource "%s" (%s) is already in branch %s'
                    % (res, url, branch))
        elif branch:
            return '/'.join(liz + ['branches', branch] + subs[bool(in_branch):])
        elif trunk or in_branch:
            return '/'.join(liz + ['trunk',] + subs[1:])
        else:
            raise SiblingArgsError(
                    '"%s" (%s): in trunk; please specify a branch'
                    % (res, url))
    except IndexError:
        raise SiblingDetectionError(
                'Resource "%s" (%s) not below trunk nor any branch'
                % (res, url))


def get_sibling_file(res, trunk=None, branch=None, force=None):
    """
    get the filename of a sibling of the given resource.
    Currently no "svn export" is performed; the branch (...) structure
    is supposed to exist in the file system (as far as needed).

    res -- the resource, normally given in local file system
    trunk -- default, if the resource is located in a branch, and
             if no branch is given
    branch -- the name of a branch
    force -- get a sibling url for unversioned resources as well

    Only one of trunk or branch can be given.
    """
    if trunk and branch:
        raise SiblingArgsError(
                'please specify *either* trunk *or* branch!'
                )
    in_trunk = 0
    in_branch = None
    res = abspath(res)
    liz = res.split(sep)
    try:
        url = SvnInfo(res)['URL']
        subs = list()
    except KeyError:
        if not force:
            raise SiblingDetectionError(
                    '"%s" is not a versioned resource'
                    % (res))
        url = 'not versioned'
    last = None
    try:
        while liz:
            prev = last
            last = liz.pop()
            # print last
            if not last:
                raise SiblingDetectionError(
                        'no trunk nor branch found for "%s"'
                        % (res))
            elif last == 'trunk':
                in_trunk = 1
                break
            elif last == 'branches':
                if prev is None:
                    raise SiblingDetectionError(
                            'Resource "%s" (%s) is an immediate child '
                            'of the %s directory'
                            % (res, url, last))
                in_branch = prev
                break
            else:
                subs.append(last)
        subs.reverse()
        if in_trunk and trunk:
            raise SiblingShortcircuit(
                    'resource "%s" (%s) is already in trunk'
                    % (res, url))
        elif in_branch and (in_branch == branch):
            raise SiblingShortcircuit(
                    'resource "%s" (%s) is already in branch %s'
                    % (res, url, branch))
        elif branch:
            return sep.join(liz + ['branches', branch] + subs[bool(in_branch):])
        elif trunk or in_branch:
            return sep.join(liz + ['trunk',] + subs[1:])
        else:
            raise SiblingArgsError(
                    '"%s" (%s): in trunk; please specify a branch'
                    % (res, url))
    except IndexError:
        raise SiblingDetectionError(
                'Resource "%s" (%s) not below trunk nor any branch'
                % (res, url))


class CommandList:
    def __init__(self, mask):
        self._data = list()
        self._mask = mask

    def add(self, dings):
        self._data.append(dings)

    def __str__(self):
        return linesep.join([self._mask % s
                             for s in self._data])
'''
class Lines:
    u"""\
    fat einen Datenstrom zu Zeilen zusammen; alle Zeilenendezeichen
    (\r, \n) werden verworfen. Leere Zeilen werden ignoriert.
    """
    def __init__(self, src):
        self._src = src

    def __call__(self):
        buf = list()
        def handle_end():
            if buf:
                s = ''.join(buf).strip()
                if s:
                    yield s
                del buf[:]
        for ch in self._src:
            if ch in "\r\n":
                handle_end()
            else:
                buf.append(ch)
        handle_end()
'''


if __name__ == '__main__':
    import sys
    try:
        from enhopa import OptionParser, OptionGroup
    except ImportError:
        from optparse import OptionParser, OptionGroup
    parser = OptionParser(version='%prog '+__version__)
    group_ = OptionGroup(parser, _('Demo options'))
    group_.add_option('--self',
                      action='store_true',
                      help=_('show the svn url of this program'))
    parser.add_option_group(group_)
    try:
        import modinfo
        o, args = modinfo.main(parser=parser)
    except ImportError:
        o, args = parser.parse_args()

    def tellabout(p):
        try:
            print SvnInfo(p)['URL']
        except KeyError:
            print >> stderr, '[E] not versioned:', p

    if o.self:
        args.insert(0, sys.argv[0])
    if args:
        for a in args:
            tellabout(a)
    else:
        from os import curdir
        tellabout(curdir)
