#!/usr/bin/env python
# -*- coding: latin1 -*- vim: ts=8 sts=4 sw=4 si et tw=79
"""\
rxparse - functions to do Rexx parsing
"""

__author__ = "Tobias Herp <tobias.herp@gmx.net>"
VERSION = (0,
           1,   # initial version
           'rev-%s' % '$Rev: 877 $'[6:-2],
           )
__version__ = '.'.join(map(str, VERSION))
__all__ = ['parse_value',
           'interpret_parse',
           ]

def parse_value(source, pattern):
    """
    Rexx: PARSE VAR source expression WITH pattern
        (<pattern> containing variable names)
    Python: vars = parse_value(source, pattern)

    >>> parse_value("skipped :needle", "':' v1 0 all")
    {'v1': 'needle', 'all': 'skipped :needle'}
    >>> parse_value("skipped :needle", "':' v1 '' nothing")
    {'v1': 'needle', 'nothing': ''}
    >>> parse_value("skipped :needle", "':' +0 v1 '' nothing")
    {'v1': ':needle', 'nothing': ''}
    >>> parse_value("  one  two  three rest  ", 'first second rest')
    {'first': 'one', 'second': 'two', 'rest': ' three rest  '}
    >>> parse_value("  one  two  three rest  ", 'first second .')
    {'first': 'one', 'second': 'two'}
    >>> parse_value("  one  two  three rest  ", 'first . rest')
    {'first': 'one', 'rest': ' three rest  '}
    """
    # TODO: verify the examples
    raise NotImplemented

def interpret_parse(command):
    """
    Interpret the given PARSE command:
    PARSE VAR varname pattern
    PARSE VALUE source expression WITH pattern
    PARSE SOURCE pattern
    PARSE VERSION pattern
    PARSE ARG pattern
    PARSE PULL pattern
    PARSE INPUT pattern

    PARSE UPPER|LOWER|CASELESS ...

    ARG pattern  <--> PARSE UPPER ARG pattern
    PULL pattern <--> PARSE UPPER PULL pattern
    """
    raise NotImplemented

if __name__ == '__main__':
    import thebops.modinfo
    thebops.modinfo.main(version=__version__)

