# vim: encoding=latin1 ts=8 sts=4 et si sw=4 ft=python
__author__ = 'Tobias Herp <tobias.herp@gmx.de>'
VERSION = (0,
           1, # Reduktion auf subst-Funktionalität (gegenüber wobinich)
           'rev-%s' % '$Rev: 839 $'[6:-2],
           )
__version__ = '.'.join(map(str, VERSION))

from os import getcwd, environ
from os.path import sep, altsep, isdir, abspath, normpath, normcase
from sys import platform
from subprocess import Popen, PIPE

# exceptions:
from excp import NotOnThisOS, NotImplementedError

class SubstNotAvailable(NotOnThisOS):
    pass

def _(s): return s # Dummy für 18n

_shortopts = ['-']
defbase = dict() # defaults base
LOGICAL = 'environ subst junctions'.split()
defbase['environ'] = dict(win32=1,
                          linux=0) # Wert?
defbase['subst'] = dict(win32=1)

default = dict()
def getDefault(opt, logical=1):
    dic = defbase.get(opt, None)
    if dic is None:
        res = 0
    else:
        res = dic.get(platform, None)
    if logical:
        return bool(res)
    return res

class O(object):
    def __init__(self, trace=None):
        self.test_subst = __name__ == '__main__'
        self.subst = 1
        self.trace = (self.test_subst
                      if trace is None
                      else trace)
option = O(trace=1)
if option.test_subst:
    print 'option-Objekt:'
    for a in dir(option):
        if not a.startswith('_'):
            print '  %s:\t%r' % (a, getattr(option, a))

def unsupp(s):
    raise SubstNotAvailable(s)

RESULT_FORMATS = 9
(DICT, TUPLES, REVDICT,
 COMMANDS, COMMANDTUPS,
 TUPDICT, REVTUPDICT,
 TUPTUPLES,
 ) = range(1, RESULT_FORMATS)

def getSubstDrives(format=DICT):
    u"""
    rufe subst.exe ohne Argumente auf (Ausgabe der
    definierten Zuweisungen) und gib die definierten Zuweisungen
    in einem der folgenden Formate zurück:
    """
    if format in (DICT, REVDICT, REVTUPDICT, TUPDICT):
        res = dict()
        if format is DICT:
            # res['D:'] = r'S:\ubsti\tuted\Directory'
            def doit(tup):
                res[tup[0]] = tup[1]
        elif format is TUPDICT:
            # res['D:'] = ('S:', 'ubsti', 'tuted', 'Directory')
            def doit(tup):
                res[tup[0]] = tuple(tup[1].split(sep))
        elif format is REVTUPDICT:
            # res[('S:', 'ubsti', 'tuted', 'Directory')] = ['D:']
            def doit(tup):
                k = tuple(tup[1].split(sep))
                if not res.has_key(k):
                    res[k] = list()
                res[k].append(tup[0])
        else:
            # res[r'S:\ubsti\tuted\Directory'] = ['D:']
            def doit(tup):
                k = tup[1]
                if not res.has_key(k):
                    res[k] = list()
                res[k].append(tup[0])
    elif format in (TUPLES, TUPTUPLES, COMMANDS, COMMANDTUPS):
        res = list()
        if format is TUPLES:
            # res[0] = ('D:', r'S:\ubsti\tuted\Directory')
            def doit(tup):
                res.append(tuple(tup))
        elif format is TUPTUPLES:
            # res[0] = ('D:', r'S:\ubsti\tuted\Directory')
            def doit(tup):
                res.append((tup[0], tuple(tup[1].split(sep))))
        elif format is COMMANDTUPS:
            def doit(tup):
                res.append(('subst.exe',
                            tup[0],
                            sep.join(tup[1:])))
        else:
            def doit(tup):
                res.append('subst.exe %s "%s"' % tuple(tup))
    else:
        raise ValueError('Unknown format specification (%r)' % format)
    p = Popen(('subst.exe',), stdout=PIPE)
    for line in p.communicate()[0].split('\r\n'):
        if line:
            doit(line.split(r'\: => '))
    return res


def starts_other(s1, s2, normalize=None):
    assert isinstance(s1, (tuple, list))
    assert isinstance(s2, (tuple, list))
    l1 = len(s1)
    if l1 > len(s2) or not l1:
        return False
    if normalize is not None:
        for i1, i2 in zip(s1, s2):
            if normalize(i1) != normalize(i2):
                return False
        return True
    else:
        return tuple(s1) == tuple(s2[:len(s1)])

def normalize_dirtuple(t):
    liz = list(t)
    if len(liz) > 2:
        while liz[-1] == '':
            del liz[-1]
    if len(liz) < 2:
        liz.append('')
    return tuple(liz)

done = set()
def found(s):
    assert isinstance(s, (tuple, list))
    s = normalize_dirtuple(s)
    if s in done:
        return
    print sep.join(s)
    done.add(s)

def init(repos):
    """
    take the repository and register the drives which were found in the
    subst.exe output
    """
    # import pdb; pdb.set_trace()
    for sd, dirtup in getSubstDrives(TUPTUPLES):
        repos.getDrive(sd).substitutes(repos.getDir(dirtup))

trace = option.trace
if trace:
    import pdb
    if trace > 1:
        pdb.set_trace()

if option.subst:
    subst_drv_by = dict()
    drives = set()
    try:
        # ergibt Listen, da Mehrfachzuweisungen möglich:
        abbr_dir_as =  getSubstDrives(REVTUPDICT)
        for dirtup, driveslist in abbr_dir_as.items():
            for drv in driveslist:
                subst_drv_by[drv] = dirtup
                drives.add(drv)
    except OSError, e:
        unsupp('subst: '+ str(e))
        option.subst = None

mydir = getcwd()
spldir = tuple(mydir.split(sep))
try:
    idx = 0
    dirs = list()
    dirs.append(spldir)
    while 1:
        d = dirs[idx]
        idx += 1
        found(d)
        if option.subst:
            if d[0] in subst_drv_by.keys():
                _tmp = list(subst_drv_by[d[0]])
                if not _tmp[-1] and d[1:]:
                    _tmp.pop()
                dirs.append(tuple(_tmp)+d[1:])
        if option.subst:
            for stup in abbr_dir_as.keys():
                if starts_other(stup, d):
                    sl = len(stup)
                    for drv in abbr_dir_as[stup]:
                        dirs.append((drv,)+d[sl:])

except IndexError:
    pass

# Entwicklungsoptionen:
try:
    if option.test_subst:
        intnames = [k for k in globals().keys()
                    if isinstance(globals()[k], int)]
        for t in range(1, RESULT_FORMATS):
            print
            print 'getSubstDrives(%d) (%s):' % (
                    t, ', '.join([n for n in intnames
                                  if globals()[n] == t
                                     and n.upper() == n]))
            print getSubstDrives(t)
            if t < RESULT_FORMATS - 1:
                raw_input('Return druecken: ')
except (AttributeError, KeyboardInterrupt):
    pass
