# exceptions of the fst (file system tree) module

class FSTException(Exception):
    pass
class ValueError(FSTException, ValueError):
    pass
class InvalidDriveSpec(ValueError):
    pass
class InvalidNodeSpec(ValueError):
    pass
class NotFound(ValueError):
    pass
class NotADirectory(NotFound):
    pass
class NotImplementedError(FSTException, NotImplementedError):
    pass
class NotOnThisOS(FSTException):
    pass
class VirtualClass(FSTException):
    pass

# vim: ts=8 sts=4 si et tw=79 sw=4
