#!/usr/bin/env python
"""
File system tree (Python package)
~~~~~~~~~~~~~~~~
Cache file system queries

see:
- LIESMICH.TXT (German)
"""

__author__ = 'Tobias Herp <tobias.herp@gmx.de'
__version__ = '.'.join((map(str,
                            (0,
                             1,
                             # [[ FORK SLOT ...
                             # ]] ... FORK SLOT
                             'rev-%s' % '$Rev: 839 $'[6:-2],
                             ))
                        ))

from .excp import *
from .fs import FileSystem
from .fsn import FSNode
from .subst import init
from .mem import cache

__all__ = ['FileSystem', 'FSNode',
	   'FSTException', 'NotImplementedError',
	   # 'aspect', nicht notwendig
	   ]

init(cache)

def isfile(fn):
    cache.getNode(fn).isfile()


if __name__ == '__main__':
    import modinfo
    modinfo.main(version=VERSION)
else:
    cache.print_tree()

# vim: ts=8 sts=4 si et tw=79 sw=4
