# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class Backup(msrest.serialization.Model):
    """Backup properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param backup_retention_days: Backup retention days for the server.
    :type backup_retention_days: int
    :param geo_redundant_backup: A value indicating whether Geo-Redundant backup is enabled on the
     server. Possible values include: "Enabled", "Disabled".
    :type geo_redundant_backup: str or ~postgre_sql_management_client.models.GeoRedundantBackupEnum
    :ivar earliest_restore_date: The earliest restore point time (ISO8601 format) for server.
    :vartype earliest_restore_date: ~datetime.datetime
    """

    _validation = {
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'geo_redundant_backup': {'key': 'geoRedundantBackup', 'type': 'str'},
        'earliest_restore_date': {'key': 'earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Backup, self).__init__(**kwargs)
        self.backup_retention_days = kwargs.get('backup_retention_days', None)
        self.geo_redundant_backup = kwargs.get('geo_redundant_backup', None)
        self.earliest_restore_date = None


class CapabilitiesListResult(msrest.serialization.Model):
    """location capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of supported capabilities.
    :vartype value: list[~postgre_sql_management_client.models.CapabilityProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapabilityProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilitiesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CapabilityProperties(msrest.serialization.Model):
    """Location capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar zone: zone name.
    :vartype zone: str
    :ivar geo_backup_supported: A value indicating whether a new server in this region can have
     geo-backups to paired region.
    :vartype geo_backup_supported: bool
    :ivar zone_redundant_ha_supported: A value indicating whether a new server in this region can
     support multi zone HA.
    :vartype zone_redundant_ha_supported: bool
    :ivar zone_redundant_ha_and_geo_backup_supported: A value indicating whether a new server in
     this region can have geo-backups to paired region.
    :vartype zone_redundant_ha_and_geo_backup_supported: bool
    :ivar supported_flexible_server_editions:
    :vartype supported_flexible_server_editions:
     list[~postgre_sql_management_client.models.FlexibleServerEditionCapability]
    :ivar supported_hyperscale_node_editions:
    :vartype supported_hyperscale_node_editions:
     list[~postgre_sql_management_client.models.HyperscaleNodeEditionCapability]
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'zone': {'readonly': True},
        'geo_backup_supported': {'readonly': True},
        'zone_redundant_ha_supported': {'readonly': True},
        'zone_redundant_ha_and_geo_backup_supported': {'readonly': True},
        'supported_flexible_server_editions': {'readonly': True},
        'supported_hyperscale_node_editions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'zone': {'key': 'zone', 'type': 'str'},
        'geo_backup_supported': {'key': 'geoBackupSupported', 'type': 'bool'},
        'zone_redundant_ha_supported': {'key': 'zoneRedundantHaSupported', 'type': 'bool'},
        'zone_redundant_ha_and_geo_backup_supported': {'key': 'zoneRedundantHaAndGeoBackupSupported', 'type': 'bool'},
        'supported_flexible_server_editions': {'key': 'supportedFlexibleServerEditions', 'type': '[FlexibleServerEditionCapability]'},
        'supported_hyperscale_node_editions': {'key': 'supportedHyperscaleNodeEditions', 'type': '[HyperscaleNodeEditionCapability]'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilityProperties, self).__init__(**kwargs)
        self.zone = None
        self.geo_backup_supported = None
        self.zone_redundant_ha_supported = None
        self.zone_redundant_ha_and_geo_backup_supported = None
        self.supported_flexible_server_editions = None
        self.supported_hyperscale_node_editions = None
        self.status = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Configuration(ProxyResource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~postgre_sql_management_client.models.SystemData
    :param value: Value of the configuration.
    :type value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration. Possible values include: "Boolean", "Numeric",
     "Integer", "Enumeration".
    :vartype data_type: str or ~postgre_sql_management_client.models.ConfigurationDataType
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :param source: Source of the configuration.
    :type source: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Configuration, self).__init__(**kwargs)
        self.system_data = None
        self.value = kwargs.get('value', None)
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = kwargs.get('source', None)


class ConfigurationListResult(msrest.serialization.Model):
    """A list of server configurations.

    :param value: The list of server configurations.
    :type value: list[~postgre_sql_management_client.models.Configuration]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Database(ProxyResource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~postgre_sql_management_client.models.SystemData
    :param charset: The charset of the database.
    :type charset: str
    :param collation: The collation of the database.
    :type collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.system_data = None
        self.charset = kwargs.get('charset', None)
        self.collation = kwargs.get('collation', None)


class DatabaseListResult(msrest.serialization.Model):
    """A List of databases.

    :param value: The list of databases housed in a server.
    :type value: list[~postgre_sql_management_client.models.Database]
    :param next_link: The link used to get the next page of databases.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class DelegatedSubnetUsage(msrest.serialization.Model):
    """Delegated subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subnet_name: name of the subnet.
    :vartype subnet_name: str
    :ivar usage: Number of used delegated subnets.
    :vartype usage: long
    """

    _validation = {
        'subnet_name': {'readonly': True},
        'usage': {'readonly': True},
    }

    _attribute_map = {
        'subnet_name': {'key': 'subnetName', 'type': 'str'},
        'usage': {'key': 'usage', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelegatedSubnetUsage, self).__init__(**kwargs)
        self.subnet_name = None
        self.usage = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~postgre_sql_management_client.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~postgre_sql_management_client.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~postgre_sql_management_client.models.SystemData
    :param start_ip_address: Required. The start IP address of the server firewall rule. Must be
     IPv4 format.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
     format.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRule, self).__init__(**kwargs)
        self.system_data = None
        self.start_ip_address = kwargs['start_ip_address']
        self.end_ip_address = kwargs['end_ip_address']


class FirewallRuleListResult(msrest.serialization.Model):
    """A list of firewall rules.

    :param value: The list of firewall rules in a server.
    :type value: list[~postgre_sql_management_client.models.FirewallRule]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class FlexibleServerEditionCapability(msrest.serialization.Model):
    """Flexible server edition capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Server edition name.
    :vartype name: str
    :ivar supported_storage_editions: The list of editions supported by this server edition.
    :vartype supported_storage_editions:
     list[~postgre_sql_management_client.models.StorageEditionCapability]
    :ivar supported_server_versions: The list of server versions supported by this server edition.
    :vartype supported_server_versions:
     list[~postgre_sql_management_client.models.ServerVersionCapability]
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_storage_editions': {'readonly': True},
        'supported_server_versions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_storage_editions': {'key': 'supportedStorageEditions', 'type': '[StorageEditionCapability]'},
        'supported_server_versions': {'key': 'supportedServerVersions', 'type': '[ServerVersionCapability]'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FlexibleServerEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_storage_editions = None
        self.supported_server_versions = None
        self.status = None


class HighAvailability(msrest.serialization.Model):
    """High availability properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param mode: The HA mode for the server. Possible values include: "Disabled", "ZoneRedundant".
    :type mode: str or ~postgre_sql_management_client.models.HighAvailabilityMode
    :ivar state: A state of a HA server that is visible to user. Possible values include:
     "NotEnabled", "CreatingStandby", "ReplicatingData", "FailingOver", "Healthy",
     "RemovingStandby".
    :vartype state: str or ~postgre_sql_management_client.models.ServerHAState
    :param standby_availability_zone: availability zone information of the standby.
    :type standby_availability_zone: str
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'standby_availability_zone': {'key': 'standbyAvailabilityZone', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HighAvailability, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.state = None
        self.standby_availability_zone = kwargs.get('standby_availability_zone', None)


class HyperscaleNodeEditionCapability(msrest.serialization.Model):
    """Hyperscale node edition capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Server edition name.
    :vartype name: str
    :ivar supported_storage_editions: The list of editions supported by this server edition.
    :vartype supported_storage_editions:
     list[~postgre_sql_management_client.models.StorageEditionCapability]
    :ivar supported_server_versions: The list of server versions supported by this server edition.
    :vartype supported_server_versions:
     list[~postgre_sql_management_client.models.ServerVersionCapability]
    :ivar supported_node_types: The list of Node Types supported by this server edition.
    :vartype supported_node_types: list[~postgre_sql_management_client.models.NodeTypeCapability]
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_storage_editions': {'readonly': True},
        'supported_server_versions': {'readonly': True},
        'supported_node_types': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_storage_editions': {'key': 'supportedStorageEditions', 'type': '[StorageEditionCapability]'},
        'supported_server_versions': {'key': 'supportedServerVersions', 'type': '[ServerVersionCapability]'},
        'supported_node_types': {'key': 'supportedNodeTypes', 'type': '[NodeTypeCapability]'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HyperscaleNodeEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_storage_editions = None
        self.supported_server_versions = None
        self.supported_node_types = None
        self.status = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class MaintenanceWindow(msrest.serialization.Model):
    """Maintenance window properties of a server.

    :param custom_window: indicates whether custom window is enabled or disabled.
    :type custom_window: str
    :param start_hour: start hour for maintenance window.
    :type start_hour: int
    :param start_minute: start minute for maintenance window.
    :type start_minute: int
    :param day_of_week: day of week for maintenance window.
    :type day_of_week: int
    """

    _attribute_map = {
        'custom_window': {'key': 'customWindow', 'type': 'str'},
        'start_hour': {'key': 'startHour', 'type': 'int'},
        'start_minute': {'key': 'startMinute', 'type': 'int'},
        'day_of_week': {'key': 'dayOfWeek', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MaintenanceWindow, self).__init__(**kwargs)
        self.custom_window = kwargs.get('custom_window', None)
        self.start_hour = kwargs.get('start_hour', None)
        self.start_minute = kwargs.get('start_minute', None)
        self.day_of_week = kwargs.get('day_of_week', None)


class NameAvailability(msrest.serialization.Model):
    """Represents a resource name availability.

    :param message: Error Message.
    :type message: str
    :param name_available: Indicates whether the resource name is available.
    :type name_available: bool
    :param name: name of the PostgreSQL server.
    :type name: str
    :param type: type of the server.
    :type type: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailability, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.name_available = kwargs.get('name_available', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class NameAvailabilityRequest(msrest.serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Resource type used for verification.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs.get('type', None)


class Network(msrest.serialization.Model):
    """Network properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_network_access: public network access is enabled or not. Possible values include:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~postgre_sql_management_client.models.ServerPublicNetworkAccessState
    :param delegated_subnet_resource_id: delegated subnet arm resource id.
    :type delegated_subnet_resource_id: str
    :param private_dns_zone_arm_resource_id: private dns zone arm resource id.
    :type private_dns_zone_arm_resource_id: str
    """

    _validation = {
        'public_network_access': {'readonly': True},
    }

    _attribute_map = {
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'delegated_subnet_resource_id': {'key': 'delegatedSubnetResourceId', 'type': 'str'},
        'private_dns_zone_arm_resource_id': {'key': 'privateDnsZoneArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Network, self).__init__(**kwargs)
        self.public_network_access = None
        self.delegated_subnet_resource_id = kwargs.get('delegated_subnet_resource_id', None)
        self.private_dns_zone_arm_resource_id = kwargs.get('private_dns_zone_arm_resource_id', None)


class NodeTypeCapability(msrest.serialization.Model):
    """node type capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: note type name.
    :vartype name: str
    :ivar node_type: note type.
    :vartype node_type: str
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'name': {'readonly': True},
        'node_type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'node_type': {'key': 'nodeType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeTypeCapability, self).__init__(**kwargs)
        self.name = None
        self.node_type = None
        self.status = None


class Operation(msrest.serialization.Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~postgre_sql_management_client.models.OperationDisplay
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :ivar origin: The intended executor of the operation. Possible values include: "NotSpecified",
     "user", "system".
    :vartype origin: str or ~postgre_sql_management_client.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.is_data_action = kwargs.get('is_data_action', None)
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of resource provider operations.

    :param value: Collection of available operation details.
    :type value: list[~postgre_sql_management_client.models.Operation]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RestartParameter(msrest.serialization.Model):
    """Represents server restart parameters.

    :param restart_with_failover: Indicates whether to restart the server with failover.
    :type restart_with_failover: bool
    :param failover_mode: Failover mode.
    :type failover_mode: str
    """

    _attribute_map = {
        'restart_with_failover': {'key': 'restartWithFailover', 'type': 'bool'},
        'failover_mode': {'key': 'failoverMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestartParameter, self).__init__(**kwargs)
        self.restart_with_failover = kwargs.get('restart_with_failover', None)
        self.failover_mode = kwargs.get('failover_mode', None)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~postgre_sql_management_client.models.Identity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~postgre_sql_management_client.models.Sku
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~postgre_sql_management_client.models.SystemData
    :param administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password (required for server
     creation).
    :type administrator_login_password: str
    :param version: PostgreSQL Server version. Possible values include: "13", "12", "11".
    :type version: str or ~postgre_sql_management_client.models.ServerVersion
    :ivar minor_version: The minor version of the server.
    :vartype minor_version: str
    :ivar state: A state of a server that is visible to user. Possible values include: "Ready",
     "Dropping", "Disabled", "Starting", "Stopping", "Stopped", "Updating".
    :vartype state: str or ~postgre_sql_management_client.models.ServerState
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :param storage: Storage properties of a server.
    :type storage: ~postgre_sql_management_client.models.Storage
    :param backup: Backup properties of a server.
    :type backup: ~postgre_sql_management_client.models.Backup
    :param network: Network properties of a server.
    :type network: ~postgre_sql_management_client.models.Network
    :param high_availability: High availability properties of a server.
    :type high_availability: ~postgre_sql_management_client.models.HighAvailability
    :param maintenance_window: Maintenance window properties of a server.
    :type maintenance_window: ~postgre_sql_management_client.models.MaintenanceWindow
    :param source_server_resource_id: The source server resource ID to restore from. It's required
     when 'createMode' is 'PointInTimeRestore'.
    :type source_server_resource_id: str
    :param point_in_time_utc: Restore point creation time (ISO8601 format), specifying the time to
     restore from. It's required when 'createMode' is 'PointInTimeRestore'.
    :type point_in_time_utc: ~datetime.datetime
    :param availability_zone: availability zone information of the server.
    :type availability_zone: str
    :param create_mode: The mode to create a new PostgreSQL server. Possible values include:
     "Default", "Create", "Update", "PointInTimeRestore".
    :type create_mode: str or ~postgre_sql_management_client.models.CreateMode
    :param tags_properties_tags: Application-specific metadata in the form of key-value pairs.
    :type tags_properties_tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'minor_version': {'readonly': True},
        'state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'minor_version': {'key': 'properties.minorVersion', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'storage': {'key': 'properties.storage', 'type': 'Storage'},
        'backup': {'key': 'properties.backup', 'type': 'Backup'},
        'network': {'key': 'properties.network', 'type': 'Network'},
        'high_availability': {'key': 'properties.highAvailability', 'type': 'HighAvailability'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
        'source_server_resource_id': {'key': 'properties.sourceServerResourceId', 'type': 'str'},
        'point_in_time_utc': {'key': 'properties.pointInTimeUTC', 'type': 'iso-8601'},
        'availability_zone': {'key': 'properties.availabilityZone', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Server, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.system_data = None
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.version = kwargs.get('version', None)
        self.minor_version = None
        self.state = None
        self.fully_qualified_domain_name = None
        self.storage = kwargs.get('storage', None)
        self.backup = kwargs.get('backup', None)
        self.network = kwargs.get('network', None)
        self.high_availability = kwargs.get('high_availability', None)
        self.maintenance_window = kwargs.get('maintenance_window', None)
        self.source_server_resource_id = kwargs.get('source_server_resource_id', None)
        self.point_in_time_utc = kwargs.get('point_in_time_utc', None)
        self.availability_zone = kwargs.get('availability_zone', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)


class ServerForUpdate(msrest.serialization.Model):
    """Represents a server to be updated.

    :param location: The location the resource resides in.
    :type location: str
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~postgre_sql_management_client.models.Sku
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param administrator_login_password: The password of the administrator login.
    :type administrator_login_password: str
    :param storage: Storage properties of a server.
    :type storage: ~postgre_sql_management_client.models.Storage
    :param backup: Backup properties of a server.
    :type backup: ~postgre_sql_management_client.models.Backup
    :param high_availability: High availability properties of a server.
    :type high_availability: ~postgre_sql_management_client.models.HighAvailability
    :param maintenance_window: Maintenance window properties of a server.
    :type maintenance_window: ~postgre_sql_management_client.models.MaintenanceWindow
    :param create_mode: The mode to update a new PostgreSQL server. Possible values include:
     "Default", "Update".
    :type create_mode: str or ~postgre_sql_management_client.models.CreateModeForUpdate
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'storage': {'key': 'properties.storage', 'type': 'Storage'},
        'backup': {'key': 'properties.backup', 'type': 'Backup'},
        'high_availability': {'key': 'properties.highAvailability', 'type': 'HighAvailability'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerForUpdate, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.storage = kwargs.get('storage', None)
        self.backup = kwargs.get('backup', None)
        self.high_availability = kwargs.get('high_availability', None)
        self.maintenance_window = kwargs.get('maintenance_window', None)
        self.create_mode = kwargs.get('create_mode', None)


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    :param value: The list of flexible servers.
    :type value: list[~postgre_sql_management_client.models.Server]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ServerVersionCapability(msrest.serialization.Model):
    """Server version capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: server version.
    :vartype name: str
    :ivar supported_vcores:
    :vartype supported_vcores: list[~postgre_sql_management_client.models.VcoreCapability]
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_vcores': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_vcores': {'key': 'supportedVcores', 'type': '[VcoreCapability]'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_vcores = None
        self.status = None


class Sku(msrest.serialization.Model):
    """Sku information related properties of a server.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the sku, typically, tier + family + cores, e.g.
     Standard_D4s_v3.
    :type name: str
    :param tier: Required. The tier of the particular SKU, e.g. Burstable. Possible values include:
     "Burstable", "GeneralPurpose", "MemoryOptimized".
    :type tier: str or ~postgre_sql_management_client.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs['tier']


class Storage(msrest.serialization.Model):
    """Storage properties of a server.

    :param storage_size_gb: Max storage allowed for a server.
    :type storage_size_gb: int
    """

    _attribute_map = {
        'storage_size_gb': {'key': 'storageSizeGB', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Storage, self).__init__(**kwargs)
        self.storage_size_gb = kwargs.get('storage_size_gb', None)


class StorageEditionCapability(msrest.serialization.Model):
    """storage edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage edition name.
    :vartype name: str
    :ivar supported_storage_mb:
    :vartype supported_storage_mb: list[~postgre_sql_management_client.models.StorageMBCapability]
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_storage_mb': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_storage_mb': {'key': 'supportedStorageMB', 'type': '[StorageMBCapability]'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_storage_mb = None
        self.status = None


class StorageMBCapability(msrest.serialization.Model):
    """storage size in MB capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage MB name.
    :vartype name: str
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: long
    :ivar storage_size_mb: storage size in MB.
    :vartype storage_size_mb: long
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_iops': {'readonly': True},
        'storage_size_mb': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_iops': {'key': 'supportedIops', 'type': 'long'},
        'storage_size_mb': {'key': 'storageSizeMB', 'type': 'long'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageMBCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_iops = None
        self.storage_size_mb = None
        self.status = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~postgre_sql_management_client.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~postgre_sql_management_client.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class VcoreCapability(msrest.serialization.Model):
    """Vcores capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: vCore name.
    :vartype name: str
    :ivar v_cores: supported vCores.
    :vartype v_cores: long
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: long
    :ivar supported_memory_per_vcore_mb: supported memory per vCore in MB.
    :vartype supported_memory_per_vcore_mb: long
    :ivar status: The status.
    :vartype status: str
    """

    _validation = {
        'name': {'readonly': True},
        'v_cores': {'readonly': True},
        'supported_iops': {'readonly': True},
        'supported_memory_per_vcore_mb': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'v_cores': {'key': 'vCores', 'type': 'long'},
        'supported_iops': {'key': 'supportedIops', 'type': 'long'},
        'supported_memory_per_vcore_mb': {'key': 'supportedMemoryPerVcoreMB', 'type': 'long'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VcoreCapability, self).__init__(**kwargs)
        self.name = None
        self.v_cores = None
        self.supported_iops = None
        self.supported_memory_per_vcore_mb = None
        self.status = None


class VirtualNetworkSubnetUsageParameter(msrest.serialization.Model):
    """Virtual network subnet usage parameter.

    :param virtual_network_arm_resource_id: Virtual network resource id.
    :type virtual_network_arm_resource_id: str
    """

    _attribute_map = {
        'virtual_network_arm_resource_id': {'key': 'virtualNetworkArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageParameter, self).__init__(**kwargs)
        self.virtual_network_arm_resource_id = kwargs.get('virtual_network_arm_resource_id', None)


class VirtualNetworkSubnetUsageResult(msrest.serialization.Model):
    """Virtual network subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar delegated_subnets_usage:
    :vartype delegated_subnets_usage:
     list[~postgre_sql_management_client.models.DelegatedSubnetUsage]
    """

    _validation = {
        'delegated_subnets_usage': {'readonly': True},
    }

    _attribute_map = {
        'delegated_subnets_usage': {'key': 'delegatedSubnetsUsage', 'type': '[DelegatedSubnetUsage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageResult, self).__init__(**kwargs)
        self.delegated_subnets_usage = None
