/**
 * @fileoverview
 * (This file was autogenerated by hob)
 */

window.cls || ( window.cls = {} );

/**
  * @constructor 
  */

window.cls.ServiceBase = function()
{
  // singleton
  if(arguments.callee.instance)
  {
    return arguments.callee.instance;
  }
  arguments.callee.instance = this;

  this.on_enable_success = function(){};
  this.on_window_filter_change = function(filter){};
  this.on_quit = function(){};
  this.is_implemented = false;

  var _services = null;
  var _event_map = {};
% for service in services:
  _event_map['${dashed_name(service.name)}'] = [];
  % for command in service.itercommands():
  _event_map['${dashed_name(service.name)}'][${command.id}] = 'handle${command.name}';
  % endfor
  % for event in service.iterevents():
  _event_map['${dashed_name(service.name)}'][${event.id}] = '${event.name.replace('On', 'on')}';
  % endfor
% endfor

  var _status_map = [];
  _status_map[0] = "OK";
  _status_map[1] = "Conflict";
  _status_map[2] = "Unsupported Type";
  _status_map[3] = "Bad Request";
  _status_map[4] = "Internal Error";
  _status_map[5] = "Command Not Found";
  _status_map[6] = "Service Not Found";
  _status_map[7] = "Out Of Memory";
  _status_map[8] = "Service Not Enabled";
  _status_map[9] = "Service Already Enabled";

  var _type_map = [];
  _type_map[1] = "command"; 
  _type_map[2] = "response"; 
  _type_map[3] = "event"; 
  _type_map[4] = "error";

  var _handle_scope_message = function(service, message, command, status, tag)
  {
    if( !tagManager.handle_message(tag, status, message) )
    {
      _services[service][_event_map[service][command]](status, message);
    }
  }

  var _handle_scope_message_debug = function(service, message, command, status, tag)
  {
    window.debug.log_message(service, message, command, status, tag);
    if( !tagManager.handle_message(tag, status, message) )
    {
      _services[service][_event_map[service][command]](status, message);
    }
  }

  // static methods

  arguments.callee.get_event_map = function()
  {
    return _event_map;
  }

  arguments.callee.get_status_map = function()
  {
    return _status_map;
  }

  arguments.callee.get_type_map = function()
  {
    return _type_map;
  }

  arguments.callee.get_generic_message_handler = function()
  {
    return window.ini && window.ini.debug && _handle_scope_message_debug || _handle_scope_message;
  }

  arguments.callee.register_services = function(namespace)
  {
    _services = namespace;
  }

}