/**
 * (This file was autogenerated by hob)
 */

% for service in services:
  % if service.name == "EcmascriptDebugger" and create_test_framework:
<%
  service_name = dashed_name(service.name)
  commands = [command for command in service.itercommands()]
  events = [event for event in service.iterevents()]
  if "version" not in service.options:
      raise Exception("Option 'version' is not set on service %s" % service.name)
  version = service.options["version"].value
%>\
window.cls || (window.cls = {});
cls.${service.name} || (cls.${service.name} = {});
cls.${service.name}["${version}"] || (cls.${service.name}["${version}"] = {});

/**
  * @constructor 
  */

cls.${service.name}["${version}"].DOM = function()
{
  ## ************************************************************** ##
  ## interface
  ## ************************************************************** ##
  /* interface */

  /* scope interfaces */
  ## ************************************************************** ##
  ## commands
  ## ************************************************************** ##
    % for command in commands:
      % if command.name in ["InspectDom"]:
  this.handle${command.name} = function(status, message){};
      % endif
    % endfor
  /**
    * an event handler for a loaded top runtime
    * call this function will trigger the retrieval 
    * of the whole DOM tree of the top runtime
    */
  this.on_top_runtime_loaded = function(top_runtime_id){};

  // privat

  var self = this;

  this._on_root_id = function(status, message)
  {
    const
    /* EvalResult */
    STATUS = 0, 
    TYPE = 1, 
    EVAL_RESULT = 3, 
    /* ObjectValue */
    OBJECT_ID = 0;

    if( status == 0 && message[STATUS] == "completed" && message[TYPE] == "object" )
    {
      var root_id = message[EVAL_RESULT][OBJECT_ID];
      services["${service_name}"].requestInspectDom(0, [root_id, "subtree"])
    }
    else
    {
      // TODO
    }
  }

  this._format_processing_instruction_value = function(str)
  {
    var 
      r_attrs = str.split(' '), 
      r_attr = '', 
      i = 0, 
      attrs = '', 
      attr = null;
    
    for( ; i < r_attrs.length; i++)
    {
      if(r_attr = r_attrs[i])
      {
        attr = r_attr.split('=');
        attrs += " <key>" + 
          attr[0].toLowerCase() + 
          "</key>=<value>" + 
          attr[1] + 
          "</value>";
      }
    }
    return attrs;
  }

  this._create_view = function(data)
  {
    const 
      ID = 0, 
      TYPE = 1, 
      NAME = 2, 
      DEPTH = 3,
      NAMESPACE = 4, 
      VALUE = 7, 
      ATTRS = 5,
      ATTR_PREFIX = 0,
      ATTR_KEY = 1, 
      ATTR_VALUE = 2,
      CHILDREN_LENGTH = 6, 
      PUBLIC_ID = 4,
      SYSTEM_ID = 5,
      ELEMENT_NODE = 1,
      TEXT_NODE = 3,
      CDATA_SECTION_NODE = 4,
      ENTITY_REFERENCE_NODE = 5,
      ENTITY_NODE = 6,
      PROCESSING_INSTRUCTION_NODE = 7,
      COMMENT_NODE = 8,
      DOCUMENT_NODE = 9,
      DOCUMENT_TYPE_NODE = 10,
      DOCUMENT_FRAGMENT_NODE = 11,
      NOTATION_NODE = 12;

    var 
      tree = "<div>", 
      i = 0, 
      node = null, 
      length = data.length,
      attrs = null, 
      attr = null, 
      k = 0, 
      key = '',
      is_open = 0,
      has_only_one_child = 0,
      one_child_id = "",
      one_child_value = '',
      current_depth = 0,
      child_pointer = 0,
      child_level = 0,
      j = 0,
      children_length = 0,
      closing_tags = [],
      node_name = '',
      tag_head = '',
      class_name = '',
      re_formatted = /script|style|#comment/i,
      container = document.getElementById('dom-tree-container');

    if( data.length )
    {
      for( ; node = data[i]; i ++ )
      {
        while( current_depth > node[DEPTH] )
        {
          tree += closing_tags.pop();
          current_depth--;
        }
        current_depth = node[DEPTH];
        children_length = node[CHILDREN_LENGTH];
        child_pointer = 0;
        node_name =  
          ( ( node[NAMESPACE] ? node[NAMESPACE] + ':' : '' ) +  node[NAME] ).toLowerCase();
        switch ( node[TYPE] )
        {
          case ELEMENT_NODE:
          {
            attrs = '';
            for( k = 0; attr = node[ATTRS][k]; k++ )
            {
              attrs += " <key>" + 
                ( attr[ATTR_PREFIX] ? attr[ATTR_PREFIX] + ':' : '' ) + 
                attr[ATTR_KEY].toLowerCase() +
                "</key>=<value>\"" +  attr[ATTR_VALUE] + "\"</value>";
            }
            child_pointer = i + 1;
            is_open = ( data[child_pointer] && ( node[DEPTH] < data[child_pointer][DEPTH] ) );
            if( is_open ) 
            {
              has_only_one_child = 1;
              one_child_value = '';
              child_level = data[child_pointer][DEPTH];
              for( ; data[child_pointer] &&  
                      data[child_pointer][DEPTH] == child_level; child_pointer += 1 )
              {
                one_child_value += data[child_pointer][VALUE];
                one_child_id = data[child_pointer][ID];
                if( data[child_pointer][TYPE] != 3 )
                {
                  has_only_one_child = 0;
                  one_child_value = '';
                  break;
                }
              }
              if(one_child_value)
              {
                one_child_value = one_child_value.replace(/</g, "&lt;");
              }
            }
            if(is_open)
            {
              if(has_only_one_child)
              {
                class_name = re_formatted.test(node_name) ? " class='pre-wrap'" : '';
                tree += "<div style='margin-left:" + 16 * node[DEPTH] + 
                                                  "px;' " + class_name + ">"+
                        "<node>&lt;" + node_name +  attrs + "&gt;</node>" +
                        "<text>" + one_child_value + "</text>" +
                        "<node>&lt;/" + node_name + "&gt;</node>" +
                        " <span class='object-id'>[" + node[ID] +  "]</span>" +
                        "</div>";
                i = child_pointer - 1;
              }
              else
              {
                tree += "<div style='margin-left:" + 16 * node[DEPTH] + "px;'>"+
                        "<node>&lt;" + node_name + attrs + "&gt;</node>" +
                        " <span class='object-id'>[" + node[ID] +  "]</span>" +
                        "</div>";
                closing_tags.push(
                    "<div style='margin-left:" + 16 * node[DEPTH] + "px;'>" +
                    "<node>&lt;/" + node_name + "&gt;</node></div>"
                  );
              }
            }
            else
            {
              tree += "<div style='margin-left:" + 16 * node[DEPTH] + "px;'>"+
                      "<node>&lt;" + node_name + attrs + 
                       ( children_length ? '' : '/' ) + "&gt;</node>" +
                       " <span class='object-id'>[" + node[ID] +  "]</span>" +
                       "</div>";
            }
            break;
          }
          case PROCESSING_INSTRUCTION_NODE: 
          {
            tree += "<div style='margin-left:" + 16 * node[DEPTH] + "px;' " +      
              "class='processing-instruction'>&lt;?" + node[NAME] + ' ' + 
              this._format_processing_instruction_value(node[VALUE]) + "?&gt;</div>";
            break;
          }
          case COMMENT_NODE:  
          {
            tree += "<div style='margin-left:" + 16 * node[DEPTH] + "px;' " +      
                    "class='comment pre-wrap'>&lt;!--" + 
                        node[VALUE].replace(/</g, '&lt;') + "--&gt;</div>";
            break;
          }
          case DOCUMENT_NODE: 
          {
            break;
          }
          case DOCUMENT_TYPE_NODE: 
          {
            tree += "<div style='margin-left:" + 16 * node[ DEPTH ] + "px;' class='doctype'>"+
                    "&lt;!doctype " + this.getDoctypeName(data) +
                    ( node[PUBLIC_ID] ? 
                      ( " PUBLIC " + "\"" + node[PUBLIC_ID] + "\"" ) :"" ) +
                    ( node[SYSTEM_ID] ?  
                      ( " \"" + node[SYSTEM_ID] + "\"" ) : "" ) +
                    "&gt;</div>";
            break;
          }
          default:
          {
            tree += 
              "<div style='margin-left:" + ( 16 * node[ DEPTH ] )  + "px;'>" + 
                "<text ref-id='"+ node[ ID ] + "'>" + node[VALUE].replace(/</g, "&lt;") + "</text>" +
              "</div>";
          }
        }
      }
      while( closing_tags.length )
      {
        tree += closing_tags.pop();
      }
      tree += "</div>";
      container.innerHTML = tree;
    }
  }

  ## ************************************************************** ##
  ## implementation
  ## ************************************************************** ##
  // implementation
  ## ************************************************************** ##
  ## commands
  ## ************************************************************** ##
    % for command in commands:
      % if command.name in ["InspectDom"]:
  this.handle${command.name} = function(status, message)
  {
  ## generte all constant identifiers for the message fields
${generate_field_consts(command.response, lookup, create_test_framework, indent='    ')}\
      % if command.name == "InspectDom":
    if( status == 0 )
    {
      this._create_view(message[${const_id(command.response.fields[0])}]);
    }
    else
    {
      // TODO
    }
      % endif
  }

      % endif
    % endfor
  this.on_top_runtime_loaded = function(top_runtime_id)
  {
    var tag = tagManager.set_callback(this, this._on_root_id);
    var script = "return document.documentElement";
    services["${service_name}"].requestEval(tag, [top_runtime_id, 0, 0, script, []]);
  }

  this.bind = function()
  {
    var ecmascript_debugger = window.services['ecmascript-debugger'];
    ecmascript_debugger.handleInspectDom = function(status, message)
    {
      self.handleInspectDom(status, message);
    }

  }

  this.bind();

}
  % endif
% endfor
