angular.module('proso.user').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('static/tpl/login_modal.html',
    "<div class=\"modal-header text-center\"><button type=\"button\" class=\"close\" ng-click=\"cancel()\"><span aria-hidden=\"true\">&times;</span></button><h3 class=\"modal-title\">{{ \"Přihlásit se\" | trans }}</h3></div><div class=\"modal-body\"><a class=\"btn btn-danger btn-lg btn-block\" track-click=\"login\" href=\"/login/google-oauth2/\"><i class=\"social-google\"></i> {{ \"přes Google\" | trans }}</a><br><a class=\"btn btn-primary btn-lg btn-block\" track-click=\"login\" href=\"/login/facebook/\"><i class=\"social-facebook\"></i>{{ \"přes Facebook\" | trans }}</a><br><hr><br><form role=\"form\" ng-submit=\"login()\"><div class=\"form-group\"><input type=\"text\" class=\"form-control\" ng-model=\"credentials.username\" placeholder=\"{{ 'Uživatelské jméno' | trans }}\"></div><div class=\"form-group\"><input type=\"password\" class=\"form-control\" ng-model=\"credentials.password\" placeholder=\"{{ 'Heslo' | trans }}\"></div><alert ng-repeat=\"alert in alerts\" type=\"{{alert.type}}\" close=\"closeAlert($index)\">{{alert.msg}}</alert><button ng-disabled=\"loading\" type=\"submit\" class=\"btn btn-primary btn-block btn-lg\">{{ 'Přihlásit se' | trans }}</button></form></div><div class=\"modal-footer\"><a class=\"btn btn-link\" ng-click=\"cancel();signupModal.open()\">{{ 'Registrovat se' | trans }}</a></div>"
  );


  $templateCache.put('static/tpl/signup_modal.html',
    "<div class=\"modal-header text-center\"><button type=\"button\" class=\"close\" ng-click=\"cancel()\"><span aria-hidden=\"true\">&times;</span></button><h3 class=\"modal-title\">{{ \"Registrujte se\" | trans }}</h3><div ng-hide=\"success\">{{\" a získejte všechny výhody registrovaných uživatelů.\" | trans }} <a ng-click=\"activeExplanation=!activeExplanation\" ng-show=\"LANGUAGE_CODE=='cs'\" href=\"\">{{\"Co získám?\" | trans }}</a></div></div><div class=\"modal-body\" ng-hide=\"success\"><div ng-if=\"activeExplanation\">{{\"Možnost nastavit si osobní cíle\"}} <img ng-src=\"/static/img/goals-example-{{LANGUAGE_CODE}}.png\" alt=\"{{'Osobní cíle'}}\"><br><br><br>{{\"Přehled častých chyb\"}} <img ng-src=\"/static/img/errors-example-{{LANGUAGE_CODE}}.png\" alt=\"{{'Přehled častých chyb'}}\"><hr></div><div ng-hide=\"activateEmail\"><a class=\"btn btn-danger btn-lg btn-block\" track-click=\"login\" href=\"/login/google-oauth2/\"><i class=\"social-google\"></i> {{ \"přes Google\" | trans }}</a><br><a class=\"btn btn-primary btn-lg btn-block\" track-click=\"login\" href=\"/login/facebook/\"><i class=\"social-facebook\"></i>{{ \"přes Facebook\" | trans }}</a><br><a class=\"btn btn-info btn-lg btn-block\" ng-click=\"activateEmail=true\" href=\"\"><i class=\"glyphicon glyphicon-envelope\"></i> {{ \"přes E-mail\" | trans }}</a></div><form role=\"form\" ng-show=\"activateEmail\" ng-submit=\"signup()\"><div class=\"form-group\"><input type=\"email\" class=\"form-control\" ng-model=\"registerForm.email\" placeholder=\"{{ 'E-mail' | trans }}\" required></div><div class=\"form-group\"><input type=\"text\" class=\"form-control\" ng-model=\"registerForm.username\" placeholder=\"{{ 'Uživatelské jméno' | trans }}\" required></div><div class=\"form-group\"><input type=\"password\" class=\"form-control\" ng-model=\"registerForm.password\" placeholder=\"{{ 'Heslo' | trans }}\" required></div><div class=\"form-group\"><input type=\"password\" class=\"form-control\" ng-model=\"registerForm.password_check\" placeholder=\"{{ 'Heslo znovu' | trans }}\" required></div><alert ng-repeat=\"alert in alerts\" type=\"{{alert.type}}\" close=\"closeAlert($index)\">{{alert.msg}}</alert><button ng-disabled=\"loading\" type=\"submit\" class=\"btn btn-primary btn-block btn-lg\">{{ 'Registrovat se' | trans }}</button></form></div><div class=\"modal-body\" ng-show=\"success\"><alert type=\"success\">{{\"Registrace proběhla úspěšně. Můžete pokračovat v používání aplikace.\" | trans}}</alert></div>"
  );


  $templateCache.put('static/tpl/user_tpl.html',
    "<div class=\"overview profile\"><div class=\"col-sm-offset-2 col-sm-8\"><form editable-form name=\"editableForm\" onaftersave=\"saveUser()\"><h1>{{user.username}} <i tooltip=\"{{'Upravit profil' | trans }}\" ng-show=\"editRights && !editableForm.$visible\" tooltip-placement=\"bottom\" ng-click=\"editableForm.$show()\" class=\"pull-right glyphicon glyphicon-edit\"></i></h1><div ng-hide=\"editableForm.$visible\"><div class=\"level-progress-bar\" username=\"{{user.username}}\"></div><dl class=\"points\" ng-show=\"user.points\"><dt>{{'Body' | trans }}</dt><dd class=\"badge\" ng-bind=\"user.points\" tooltip=\"{{'přibývají za každou správnou odpověď' | trans }}\" tooltip-placement=\"bottom\"></dd></dl></div><dl><dt>{{'Jméno' | trans }}</dt><dd editable-text=\"user.first_name\" e-name=\"first_name\">{{user.first_name}}</dd></dl><dl><dt>{{'Příjmení' | trans }}</dt><dd editable-text=\"user.last_name\">{{user.last_name}}</dd></dl><dl ng-show=\"editRights\"><dt>{{'E-mail' | trans }}</dt><dd editable-text=\"user.email\">{{user.email}}</dd></dl><div class=\"buttons\"><span ng-show=\"editableForm.$visible\"><div class=\"checkbox\"><label><input type=\"checkbox\" ng-model=\"user.send_emails\"> {{'Poslat mi email při neplnění cílů' | trans}}</label></div><br><button type=\"submit\" class=\"btn btn-primary\" ng-disabled=\"editableForm.$waiting\">{{'Uložit' | trans}}</button> <button type=\"button\" class=\"btn btn-default\" ng-disabled=\"editableForm.$waiting\" ng-click=\"editableForm.$cancel()\">{{'Zrušit' | trans}}</button><br><br><br><br><br><br></span></div></form><div ng-hide=\"editableForm.$visible\"><a href=\"#/overview/{{user.username}}\">{{'Přehled znalostí uživatele' | trans}} {{ user.username}}</a><div ng-show=\"editRights\"><br><h4>{{'Sdílej svůj profil' | trans }}</h4><div my-fb-share=\"\" data-type=\"button\" data-href=\"{{profileUrl}}\"></div><!-- Place this tag where you want the share button to render. --><span class=\"g-plus-wrapper\"><div my-google-plus=\"\" data-action=\"share\" data-annotation=\"none\" data-height=\"24\"></div></span> <input type=\"text\" value=\"{{profileUrl}}\" class=\"share-input\" tooltip-placement=\"right\" tooltip=\"{{'Adresa profilu' | trans}}\"></div><div personal-goals></div></div></div><div class=\"clearfix\"></div></div>"
  );

}]);
