# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._event_grid_publisher_client_enums import *


class AcsChatEventBaseProperties(msrest.serialization.Model):
    """Schema of common properties of all chat events.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        **kwargs
    ):
        super(AcsChatEventBaseProperties, self).__init__(**kwargs)
        self.recipient_communication_identifier = recipient_communication_identifier
        self.transaction_id = transaction_id
        self.thread_id = thread_id


class AcsChatEventInThreadBaseProperties(msrest.serialization.Model):
    """Schema of common properties of all thread-level chat events.

    :param thread_id: The chat thread id.
    :type thread_id: str
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        **kwargs
    ):
        super(AcsChatEventInThreadBaseProperties, self).__init__(**kwargs)
        self.thread_id = thread_id


class AcsChatMessageEventBaseProperties(AcsChatEventBaseProperties):
    """Schema of common properties of all chat message events.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        **kwargs
    ):
        super(AcsChatMessageEventBaseProperties, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, **kwargs)
        self.message_id = message_id
        self.sender_communication_identifier = sender_communication_identifier
        self.sender_display_name = sender_display_name
        self.compose_time = compose_time
        self.type = type
        self.version = version


class AcsChatMessageDeletedEventData(AcsChatMessageEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatMessageDeleted event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    :param delete_time: The time at which the message was deleted.
    :type delete_time: ~datetime.datetime
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'delete_time': {'key': 'deleteTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        delete_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsChatMessageDeletedEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, message_id=message_id, sender_communication_identifier=sender_communication_identifier, sender_display_name=sender_display_name, compose_time=compose_time, type=type, version=version, **kwargs)
        self.delete_time = delete_time


class AcsChatMessageEventInThreadBaseProperties(AcsChatEventInThreadBaseProperties):
    """Schema of common properties of all thread-level chat message events.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        **kwargs
    ):
        super(AcsChatMessageEventInThreadBaseProperties, self).__init__(thread_id=thread_id, **kwargs)
        self.message_id = message_id
        self.sender_communication_identifier = sender_communication_identifier
        self.sender_display_name = sender_display_name
        self.compose_time = compose_time
        self.type = type
        self.version = version


class AcsChatMessageDeletedInThreadEventData(AcsChatMessageEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatMessageDeletedInThread event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    :param delete_time: The time at which the message was deleted.
    :type delete_time: ~datetime.datetime
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'delete_time': {'key': 'deleteTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        delete_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsChatMessageDeletedInThreadEventData, self).__init__(thread_id=thread_id, message_id=message_id, sender_communication_identifier=sender_communication_identifier, sender_display_name=sender_display_name, compose_time=compose_time, type=type, version=version, **kwargs)
        self.delete_time = delete_time


class AcsChatMessageEditedEventData(AcsChatMessageEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatMessageEdited event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    :param message_body: The body of the chat message.
    :type message_body: str
    :param edit_time: The time at which the message was edited.
    :type edit_time: ~datetime.datetime
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'message_body': {'key': 'messageBody', 'type': 'str'},
        'edit_time': {'key': 'editTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        message_body: Optional[str] = None,
        edit_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsChatMessageEditedEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, message_id=message_id, sender_communication_identifier=sender_communication_identifier, sender_display_name=sender_display_name, compose_time=compose_time, type=type, version=version, **kwargs)
        self.message_body = message_body
        self.edit_time = edit_time


class AcsChatMessageEditedInThreadEventData(AcsChatMessageEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatMessageEditedInThread event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    :param message_body: The body of the chat message.
    :type message_body: str
    :param edit_time: The time at which the message was edited.
    :type edit_time: ~datetime.datetime
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'message_body': {'key': 'messageBody', 'type': 'str'},
        'edit_time': {'key': 'editTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        message_body: Optional[str] = None,
        edit_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsChatMessageEditedInThreadEventData, self).__init__(thread_id=thread_id, message_id=message_id, sender_communication_identifier=sender_communication_identifier, sender_display_name=sender_display_name, compose_time=compose_time, type=type, version=version, **kwargs)
        self.message_body = message_body
        self.edit_time = edit_time


class AcsChatMessageReceivedEventData(AcsChatMessageEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatMessageReceived event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    :param message_body: The body of the chat message.
    :type message_body: str
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'message_body': {'key': 'messageBody', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        message_body: Optional[str] = None,
        **kwargs
    ):
        super(AcsChatMessageReceivedEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, message_id=message_id, sender_communication_identifier=sender_communication_identifier, sender_display_name=sender_display_name, compose_time=compose_time, type=type, version=version, **kwargs)
        self.message_body = message_body


class AcsChatMessageReceivedInThreadEventData(AcsChatMessageEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatMessageReceivedInThread event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param message_id: The chat message id.
    :type message_id: str
    :param sender_communication_identifier: The communication identifier of the sender.
    :type sender_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param sender_display_name: The display name of the sender.
    :type sender_display_name: str
    :param compose_time: The original compose time of the message.
    :type compose_time: ~datetime.datetime
    :param type: The type of the message.
    :type type: str
    :param version: The version of the message.
    :type version: long
    :param message_body: The body of the chat message.
    :type message_body: str
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_communication_identifier': {'key': 'senderCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'sender_display_name': {'key': 'senderDisplayName', 'type': 'str'},
        'compose_time': {'key': 'composeTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'message_body': {'key': 'messageBody', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        message_id: Optional[str] = None,
        sender_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        sender_display_name: Optional[str] = None,
        compose_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        version: Optional[int] = None,
        message_body: Optional[str] = None,
        **kwargs
    ):
        super(AcsChatMessageReceivedInThreadEventData, self).__init__(thread_id=thread_id, message_id=message_id, sender_communication_identifier=sender_communication_identifier, sender_display_name=sender_display_name, compose_time=compose_time, type=type, version=version, **kwargs)
        self.message_body = message_body


class AcsChatParticipantAddedToThreadEventData(AcsChatEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatParticipantAddedToThread event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param time: The time at which the user was added to the thread.
    :type time: ~datetime.datetime
    :param added_by_communication_identifier: The communication identifier of the user who added
     the user.
    :type added_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param participant_added: The details of the user who was added.
    :type participant_added: ~event_grid_publisher_client.models.AcsChatThreadParticipantProperties
    :param version: The version of the thread.
    :type version: long
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'added_by_communication_identifier': {'key': 'addedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'participant_added': {'key': 'participantAdded', 'type': 'AcsChatThreadParticipantProperties'},
        'version': {'key': 'version', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        added_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        participant_added: Optional["AcsChatThreadParticipantProperties"] = None,
        version: Optional[int] = None,
        **kwargs
    ):
        super(AcsChatParticipantAddedToThreadEventData, self).__init__(thread_id=thread_id, **kwargs)
        self.time = time
        self.added_by_communication_identifier = added_by_communication_identifier
        self.participant_added = participant_added
        self.version = version


class AcsChatThreadEventBaseProperties(AcsChatEventBaseProperties):
    """Schema of common properties of all chat thread events.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        **kwargs
    ):
        super(AcsChatThreadEventBaseProperties, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, **kwargs)
        self.create_time = create_time
        self.version = version


class AcsChatParticipantAddedToThreadWithUserEventData(AcsChatThreadEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatParticipantAddedToThreadWithUser event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param time: The time at which the user was added to the thread.
    :type time: ~datetime.datetime
    :param added_by_communication_identifier: The communication identifier of the user who added
     the user.
    :type added_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param participant_added: The details of the user who was added.
    :type participant_added: ~event_grid_publisher_client.models.AcsChatThreadParticipantProperties
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'added_by_communication_identifier': {'key': 'addedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'participant_added': {'key': 'participantAdded', 'type': 'AcsChatThreadParticipantProperties'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        time: Optional[datetime.datetime] = None,
        added_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        participant_added: Optional["AcsChatThreadParticipantProperties"] = None,
        **kwargs
    ):
        super(AcsChatParticipantAddedToThreadWithUserEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.time = time
        self.added_by_communication_identifier = added_by_communication_identifier
        self.participant_added = participant_added


class AcsChatParticipantRemovedFromThreadEventData(AcsChatEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatParticipantRemovedFromThread event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param time: The time at which the user was removed to the thread.
    :type time: ~datetime.datetime
    :param removed_by_communication_identifier: The communication identifier of the user who
     removed the user.
    :type removed_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param participant_removed: The details of the user who was removed.
    :type participant_removed:
     ~event_grid_publisher_client.models.AcsChatThreadParticipantProperties
    :param version: The version of the thread.
    :type version: long
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'removed_by_communication_identifier': {'key': 'removedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'participant_removed': {'key': 'participantRemoved', 'type': 'AcsChatThreadParticipantProperties'},
        'version': {'key': 'version', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        removed_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        participant_removed: Optional["AcsChatThreadParticipantProperties"] = None,
        version: Optional[int] = None,
        **kwargs
    ):
        super(AcsChatParticipantRemovedFromThreadEventData, self).__init__(thread_id=thread_id, **kwargs)
        self.time = time
        self.removed_by_communication_identifier = removed_by_communication_identifier
        self.participant_removed = participant_removed
        self.version = version


class AcsChatParticipantRemovedFromThreadWithUserEventData(AcsChatThreadEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatParticipantRemovedFromThreadWithUser event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param time: The time at which the user was removed to the thread.
    :type time: ~datetime.datetime
    :param removed_by_communication_identifier: The communication identifier of the user who
     removed the user.
    :type removed_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param participant_removed: The details of the user who was removed.
    :type participant_removed:
     ~event_grid_publisher_client.models.AcsChatThreadParticipantProperties
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'removed_by_communication_identifier': {'key': 'removedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'participant_removed': {'key': 'participantRemoved', 'type': 'AcsChatThreadParticipantProperties'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        time: Optional[datetime.datetime] = None,
        removed_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        participant_removed: Optional["AcsChatThreadParticipantProperties"] = None,
        **kwargs
    ):
        super(AcsChatParticipantRemovedFromThreadWithUserEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.time = time
        self.removed_by_communication_identifier = removed_by_communication_identifier
        self.participant_removed = participant_removed


class AcsChatThreadEventInThreadBaseProperties(AcsChatEventInThreadBaseProperties):
    """Schema of common properties of all chat thread events.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        **kwargs
    ):
        super(AcsChatThreadEventInThreadBaseProperties, self).__init__(thread_id=thread_id, **kwargs)
        self.create_time = create_time
        self.version = version


class AcsChatThreadCreatedEventData(AcsChatThreadEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatThreadCreatedWithUser event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param created_by_communication_identifier: The communication identifier of the user who
     created the thread.
    :type created_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param properties: The thread properties.
    :type properties: dict[str, object]
    :param participants: The list of properties of participants who are part of the thread.
    :type participants:
     list[~event_grid_publisher_client.models.AcsChatThreadParticipantProperties]
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'created_by_communication_identifier': {'key': 'createdByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'properties': {'key': 'properties', 'type': '{object}'},
        'participants': {'key': 'participants', 'type': '[AcsChatThreadParticipantProperties]'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        created_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        properties: Optional[Dict[str, object]] = None,
        participants: Optional[List["AcsChatThreadParticipantProperties"]] = None,
        **kwargs
    ):
        super(AcsChatThreadCreatedEventData, self).__init__(thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.created_by_communication_identifier = created_by_communication_identifier
        self.properties = properties
        self.participants = participants


class AcsChatThreadCreatedWithUserEventData(AcsChatThreadEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatThreadCreatedWithUser event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param created_by_communication_identifier: The communication identifier of the user who
     created the thread.
    :type created_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param properties: The thread properties.
    :type properties: dict[str, object]
    :param participants: The list of properties of participants who are part of the thread.
    :type participants:
     list[~event_grid_publisher_client.models.AcsChatThreadParticipantProperties]
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'created_by_communication_identifier': {'key': 'createdByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'properties': {'key': 'properties', 'type': '{object}'},
        'participants': {'key': 'participants', 'type': '[AcsChatThreadParticipantProperties]'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        created_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        properties: Optional[Dict[str, object]] = None,
        participants: Optional[List["AcsChatThreadParticipantProperties"]] = None,
        **kwargs
    ):
        super(AcsChatThreadCreatedWithUserEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.created_by_communication_identifier = created_by_communication_identifier
        self.properties = properties
        self.participants = participants


class AcsChatThreadDeletedEventData(AcsChatThreadEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatThreadDeleted event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param deleted_by_communication_identifier: The communication identifier of the user who
     deleted the thread.
    :type deleted_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param delete_time: The deletion time of the thread.
    :type delete_time: ~datetime.datetime
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'deleted_by_communication_identifier': {'key': 'deletedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'delete_time': {'key': 'deleteTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        deleted_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        delete_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsChatThreadDeletedEventData, self).__init__(thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.deleted_by_communication_identifier = deleted_by_communication_identifier
        self.delete_time = delete_time


class AcsChatThreadParticipantProperties(msrest.serialization.Model):
    """Schema of the chat thread participant.

    :param display_name: The name of the user.
    :type display_name: str
    :param participant_communication_identifier: The communication identifier of the user.
    :type participant_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'participant_communication_identifier': {'key': 'participantCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        participant_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        **kwargs
    ):
        super(AcsChatThreadParticipantProperties, self).__init__(**kwargs)
        self.display_name = display_name
        self.participant_communication_identifier = participant_communication_identifier


class AcsChatThreadPropertiesUpdatedEventData(AcsChatThreadEventInThreadBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatThreadPropertiesUpdated event.

    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param edited_by_communication_identifier: The communication identifier of the user who updated
     the thread properties.
    :type edited_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param edit_time: The time at which the properties of the thread were updated.
    :type edit_time: ~datetime.datetime
    :param properties: The updated thread properties.
    :type properties: dict[str, object]
    """

    _attribute_map = {
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'edited_by_communication_identifier': {'key': 'editedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'edit_time': {'key': 'editTime', 'type': 'iso-8601'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        edited_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        edit_time: Optional[datetime.datetime] = None,
        properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(AcsChatThreadPropertiesUpdatedEventData, self).__init__(thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.edited_by_communication_identifier = edited_by_communication_identifier
        self.edit_time = edit_time
        self.properties = properties


class AcsChatThreadPropertiesUpdatedPerUserEventData(AcsChatThreadEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatThreadPropertiesUpdatedPerUser event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param edited_by_communication_identifier: The communication identifier of the user who updated
     the thread properties.
    :type edited_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param edit_time: The time at which the properties of the thread were updated.
    :type edit_time: ~datetime.datetime
    :param properties: The updated thread properties.
    :type properties: dict[str, object]
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'edited_by_communication_identifier': {'key': 'editedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'edit_time': {'key': 'editTime', 'type': 'iso-8601'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        edited_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        edit_time: Optional[datetime.datetime] = None,
        properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(AcsChatThreadPropertiesUpdatedPerUserEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.edited_by_communication_identifier = edited_by_communication_identifier
        self.edit_time = edit_time
        self.properties = properties


class AcsChatThreadWithUserDeletedEventData(AcsChatThreadEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.ChatThreadWithUserDeleted event.

    :param recipient_communication_identifier: The communication identifier of the target user.
    :type recipient_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param transaction_id: The transaction id will be used as co-relation vector.
    :type transaction_id: str
    :param thread_id: The chat thread id.
    :type thread_id: str
    :param create_time: The original creation time of the thread.
    :type create_time: ~datetime.datetime
    :param version: The version of the thread.
    :type version: long
    :param deleted_by_communication_identifier: The communication identifier of the user who
     deleted the thread.
    :type deleted_by_communication_identifier:
     ~event_grid_publisher_client.models.CommunicationIdentifierModel
    :param delete_time: The deletion time of the thread.
    :type delete_time: ~datetime.datetime
    """

    _attribute_map = {
        'recipient_communication_identifier': {'key': 'recipientCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
        'thread_id': {'key': 'threadId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'version': {'key': 'version', 'type': 'long'},
        'deleted_by_communication_identifier': {'key': 'deletedByCommunicationIdentifier', 'type': 'CommunicationIdentifierModel'},
        'delete_time': {'key': 'deleteTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        recipient_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        transaction_id: Optional[str] = None,
        thread_id: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        version: Optional[int] = None,
        deleted_by_communication_identifier: Optional["CommunicationIdentifierModel"] = None,
        delete_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsChatThreadWithUserDeletedEventData, self).__init__(recipient_communication_identifier=recipient_communication_identifier, transaction_id=transaction_id, thread_id=thread_id, create_time=create_time, version=version, **kwargs)
        self.deleted_by_communication_identifier = deleted_by_communication_identifier
        self.delete_time = delete_time


class AcsSmsDeliveryAttemptProperties(msrest.serialization.Model):
    """Schema for details of a delivery attempt.

    :param timestamp: TimeStamp when delivery was attempted.
    :type timestamp: ~datetime.datetime
    :param segments_succeeded: Number of segments that were successfully delivered.
    :type segments_succeeded: int
    :param segments_failed: Number of segments whose delivery failed.
    :type segments_failed: int
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'segments_succeeded': {'key': 'segmentsSucceeded', 'type': 'int'},
        'segments_failed': {'key': 'segmentsFailed', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        segments_succeeded: Optional[int] = None,
        segments_failed: Optional[int] = None,
        **kwargs
    ):
        super(AcsSmsDeliveryAttemptProperties, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.segments_succeeded = segments_succeeded
        self.segments_failed = segments_failed


class AcsSmsEventBaseProperties(msrest.serialization.Model):
    """Schema of common properties of all SMS events.

    :param message_id: The identity of the SMS message.
    :type message_id: str
    :param from_property: The identity of SMS message sender.
    :type from_property: str
    :param to: The identity of SMS message receiver.
    :type to: str
    """

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'from_property': {'key': 'from', 'type': 'str'},
        'to': {'key': 'to', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: Optional[str] = None,
        from_property: Optional[str] = None,
        to: Optional[str] = None,
        **kwargs
    ):
        super(AcsSmsEventBaseProperties, self).__init__(**kwargs)
        self.message_id = message_id
        self.from_property = from_property
        self.to = to


class AcsSmsDeliveryReportReceivedEventData(AcsSmsEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.SMSDeliveryReportReceived event.

    :param message_id: The identity of the SMS message.
    :type message_id: str
    :param from_property: The identity of SMS message sender.
    :type from_property: str
    :param to: The identity of SMS message receiver.
    :type to: str
    :param delivery_status: Status of Delivery.
    :type delivery_status: str
    :param delivery_status_details: Details about Delivery Status.
    :type delivery_status_details: str
    :param delivery_attempts: List of details of delivery attempts made.
    :type delivery_attempts:
     list[~event_grid_publisher_client.models.AcsSmsDeliveryAttemptProperties]
    :param received_timestamp: The time at which the SMS delivery report was received.
    :type received_timestamp: ~datetime.datetime
    """

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'from_property': {'key': 'from', 'type': 'str'},
        'to': {'key': 'to', 'type': 'str'},
        'delivery_status': {'key': 'deliveryStatus', 'type': 'str'},
        'delivery_status_details': {'key': 'deliveryStatusDetails', 'type': 'str'},
        'delivery_attempts': {'key': 'deliveryAttempts', 'type': '[AcsSmsDeliveryAttemptProperties]'},
        'received_timestamp': {'key': 'receivedTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        message_id: Optional[str] = None,
        from_property: Optional[str] = None,
        to: Optional[str] = None,
        delivery_status: Optional[str] = None,
        delivery_status_details: Optional[str] = None,
        delivery_attempts: Optional[List["AcsSmsDeliveryAttemptProperties"]] = None,
        received_timestamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsSmsDeliveryReportReceivedEventData, self).__init__(message_id=message_id, from_property=from_property, to=to, **kwargs)
        self.delivery_status = delivery_status
        self.delivery_status_details = delivery_status_details
        self.delivery_attempts = delivery_attempts
        self.received_timestamp = received_timestamp


class AcsSmsReceivedEventData(AcsSmsEventBaseProperties):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Communication.SMSReceived event.

    :param message_id: The identity of the SMS message.
    :type message_id: str
    :param from_property: The identity of SMS message sender.
    :type from_property: str
    :param to: The identity of SMS message receiver.
    :type to: str
    :param message: The SMS content.
    :type message: str
    :param received_timestamp: The time at which the SMS was received.
    :type received_timestamp: ~datetime.datetime
    """

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'from_property': {'key': 'from', 'type': 'str'},
        'to': {'key': 'to', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'received_timestamp': {'key': 'receivedTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        message_id: Optional[str] = None,
        from_property: Optional[str] = None,
        to: Optional[str] = None,
        message: Optional[str] = None,
        received_timestamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(AcsSmsReceivedEventData, self).__init__(message_id=message_id, from_property=from_property, to=to, **kwargs)
        self.message = message
        self.received_timestamp = received_timestamp


class AppConfigurationKeyValueDeletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.AppConfiguration.KeyValueDeleted event.

    :param key: The key used to identify the key-value that was deleted.
    :type key: str
    :param label: The label, if any, used to identify the key-value that was deleted.
    :type label: str
    :param etag: The etag representing the key-value that was deleted.
    :type etag: str
    :param sync_token: The sync token representing the server state after the event.
    :type sync_token: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sync_token': {'key': 'syncToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        label: Optional[str] = None,
        etag: Optional[str] = None,
        sync_token: Optional[str] = None,
        **kwargs
    ):
        super(AppConfigurationKeyValueDeletedEventData, self).__init__(**kwargs)
        self.key = key
        self.label = label
        self.etag = etag
        self.sync_token = sync_token


class AppConfigurationKeyValueModifiedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.AppConfiguration.KeyValueModified event.

    :param key: The key used to identify the key-value that was modified.
    :type key: str
    :param label: The label, if any, used to identify the key-value that was modified.
    :type label: str
    :param etag: The etag representing the new state of the key-value.
    :type etag: str
    :param sync_token: The sync token representing the server state after the event.
    :type sync_token: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sync_token': {'key': 'syncToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        label: Optional[str] = None,
        etag: Optional[str] = None,
        sync_token: Optional[str] = None,
        **kwargs
    ):
        super(AppConfigurationKeyValueModifiedEventData, self).__init__(**kwargs)
        self.key = key
        self.label = label
        self.etag = etag
        self.sync_token = sync_token


class AppEventTypeDetail(msrest.serialization.Model):
    """Detail of action on the app.

    :param action: Type of action of the operation. Possible values include: "Restarted",
     "Stopped", "ChangedAppSettings", "Started", "Completed", "Failed".
    :type action: str or ~event_grid_publisher_client.models.AppAction
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action: Optional[Union[str, "AppAction"]] = None,
        **kwargs
    ):
        super(AppEventTypeDetail, self).__init__(**kwargs)
        self.action = action


class AppServicePlanEventTypeDetail(msrest.serialization.Model):
    """Detail of action on the app service plan.

    :param stamp_kind: Kind of environment where app service plan is. Possible values include:
     "Public", "AseV1", "AseV2".
    :type stamp_kind: str or ~event_grid_publisher_client.models.StampKind
    :param action: Type of action on the app service plan. Possible values include: "Updated".
    :type action: str or ~event_grid_publisher_client.models.AppServicePlanAction
    :param status: Asynchronous operation status of the operation on the app service plan. Possible
     values include: "Started", "Completed", "Failed".
    :type status: str or ~event_grid_publisher_client.models.AsyncStatus
    """

    _attribute_map = {
        'stamp_kind': {'key': 'stampKind', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        stamp_kind: Optional[Union[str, "StampKind"]] = None,
        action: Optional[Union[str, "AppServicePlanAction"]] = None,
        status: Optional[Union[str, "AsyncStatus"]] = None,
        **kwargs
    ):
        super(AppServicePlanEventTypeDetail, self).__init__(**kwargs)
        self.stamp_kind = stamp_kind
        self.action = action
        self.status = status


class CloudEvent(msrest.serialization.Model):
    """Properties of an event published to an Event Grid topic using the CloudEvent 1.0 Schema.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param id: Required. An identifier for the event. The combination of id and source must be
     unique for each distinct event.
    :type id: str
    :param source: Required. Identifies the context in which an event happened. The combination of
     id and source must be unique for each distinct event.
    :type source: str
    :param data: Event data specific to the event type.
    :type data: object
    :param data_base64: Event data specific to the event type, encoded as a base64 string.
    :type data_base64: bytearray
    :param type: Required. Type of event related to the originating occurrence.
    :type type: str
    :param time: The time (in UTC) the event was generated, in RFC3339 format.
    :type time: ~datetime.datetime
    :param specversion: Required. The version of the CloudEvents specification which the event
     uses.
    :type specversion: str
    :param dataschema: Identifies the schema that data adheres to.
    :type dataschema: str
    :param datacontenttype: Content type of data value.
    :type datacontenttype: str
    :param subject: This describes the subject of the event in the context of the event producer
     (identified by source).
    :type subject: str
    """

    _validation = {
        'id': {'required': True},
        'source': {'required': True},
        'type': {'required': True},
        'specversion': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'id': {'key': 'id', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'data': {'key': 'data', 'type': 'object'},
        'data_base64': {'key': 'data_base64', 'type': 'bytearray'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'specversion': {'key': 'specversion', 'type': 'str'},
        'dataschema': {'key': 'dataschema', 'type': 'str'},
        'datacontenttype': {'key': 'datacontenttype', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        source: str,
        type: str,
        specversion: str,
        additional_properties: Optional[Dict[str, object]] = None,
        data: Optional[object] = None,
        data_base64: Optional[bytearray] = None,
        time: Optional[datetime.datetime] = None,
        dataschema: Optional[str] = None,
        datacontenttype: Optional[str] = None,
        subject: Optional[str] = None,
        **kwargs
    ):
        super(CloudEvent, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.source = source
        self.data = data
        self.data_base64 = data_base64
        self.type = type
        self.time = time
        self.specversion = specversion
        self.dataschema = dataschema
        self.datacontenttype = datacontenttype
        self.subject = subject


class CommunicationIdentifierModel(msrest.serialization.Model):
    """Identifies a participant in Azure Communication services. A participant is, for example, a phone number or an Azure communication user. This model must be interpreted as a union: Apart from rawId, at most one further property may be set.

    :param raw_id: Raw Id of the identifier. Optional in requests, required in responses.
    :type raw_id: str
    :param communication_user: The communication user.
    :type communication_user: ~event_grid_publisher_client.models.CommunicationUserIdentifierModel
    :param phone_number: The phone number.
    :type phone_number: ~event_grid_publisher_client.models.PhoneNumberIdentifierModel
    :param microsoft_teams_user: The Microsoft Teams user.
    :type microsoft_teams_user:
     ~event_grid_publisher_client.models.MicrosoftTeamsUserIdentifierModel
    """

    _attribute_map = {
        'raw_id': {'key': 'rawId', 'type': 'str'},
        'communication_user': {'key': 'communicationUser', 'type': 'CommunicationUserIdentifierModel'},
        'phone_number': {'key': 'phoneNumber', 'type': 'PhoneNumberIdentifierModel'},
        'microsoft_teams_user': {'key': 'microsoftTeamsUser', 'type': 'MicrosoftTeamsUserIdentifierModel'},
    }

    def __init__(
        self,
        *,
        raw_id: Optional[str] = None,
        communication_user: Optional["CommunicationUserIdentifierModel"] = None,
        phone_number: Optional["PhoneNumberIdentifierModel"] = None,
        microsoft_teams_user: Optional["MicrosoftTeamsUserIdentifierModel"] = None,
        **kwargs
    ):
        super(CommunicationIdentifierModel, self).__init__(**kwargs)
        self.raw_id = raw_id
        self.communication_user = communication_user
        self.phone_number = phone_number
        self.microsoft_teams_user = microsoft_teams_user


class CommunicationUserIdentifierModel(msrest.serialization.Model):
    """A user that got created with an Azure Communication Services resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The Id of the communication user.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(CommunicationUserIdentifierModel, self).__init__(**kwargs)
        self.id = id


class ContainerRegistryArtifactEventData(msrest.serialization.Model):
    """The content of the event request message.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~event_grid_publisher_client.models.ContainerRegistryArtifactEventTarget
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'ContainerRegistryArtifactEventTarget'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["ContainerRegistryArtifactEventTarget"] = None,
        **kwargs
    ):
        super(ContainerRegistryArtifactEventData, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.action = action
        self.target = target


class ContainerRegistryArtifactEventTarget(msrest.serialization.Model):
    """The target of the event.

    :param media_type: The MIME type of the artifact.
    :type media_type: str
    :param size: The size in bytes of the artifact.
    :type size: long
    :param digest: The digest of the artifact.
    :type digest: str
    :param repository: The repository name of the artifact.
    :type repository: str
    :param tag: The tag of the artifact.
    :type tag: str
    :param name: The name of the artifact.
    :type name: str
    :param version: The version of the artifact.
    :type version: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(ContainerRegistryArtifactEventTarget, self).__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.repository = repository
        self.tag = tag
        self.name = name
        self.version = version


class ContainerRegistryChartDeletedEventData(ContainerRegistryArtifactEventData):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ContainerRegistry.ChartDeleted event.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~event_grid_publisher_client.models.ContainerRegistryArtifactEventTarget
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'ContainerRegistryArtifactEventTarget'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["ContainerRegistryArtifactEventTarget"] = None,
        **kwargs
    ):
        super(ContainerRegistryChartDeletedEventData, self).__init__(id=id, timestamp=timestamp, action=action, target=target, **kwargs)


class ContainerRegistryChartPushedEventData(ContainerRegistryArtifactEventData):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ContainerRegistry.ChartPushed event.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~event_grid_publisher_client.models.ContainerRegistryArtifactEventTarget
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'ContainerRegistryArtifactEventTarget'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["ContainerRegistryArtifactEventTarget"] = None,
        **kwargs
    ):
        super(ContainerRegistryChartPushedEventData, self).__init__(id=id, timestamp=timestamp, action=action, target=target, **kwargs)


class ContainerRegistryEventActor(msrest.serialization.Model):
    """The agent that initiated the event. For most situations, this could be from the authorization context of the request.

    :param name: The subject or username associated with the request context that generated the
     event.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ContainerRegistryEventActor, self).__init__(**kwargs)
        self.name = name


class ContainerRegistryEventData(msrest.serialization.Model):
    """The content of the event request message.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~event_grid_publisher_client.models.ContainerRegistryEventTarget
    :param request: The request that generated the event.
    :type request: ~event_grid_publisher_client.models.ContainerRegistryEventRequest
    :param actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :type actor: ~event_grid_publisher_client.models.ContainerRegistryEventActor
    :param source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :type source: ~event_grid_publisher_client.models.ContainerRegistryEventSource
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'ContainerRegistryEventTarget'},
        'request': {'key': 'request', 'type': 'ContainerRegistryEventRequest'},
        'actor': {'key': 'actor', 'type': 'ContainerRegistryEventActor'},
        'source': {'key': 'source', 'type': 'ContainerRegistryEventSource'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["ContainerRegistryEventTarget"] = None,
        request: Optional["ContainerRegistryEventRequest"] = None,
        actor: Optional["ContainerRegistryEventActor"] = None,
        source: Optional["ContainerRegistryEventSource"] = None,
        **kwargs
    ):
        super(ContainerRegistryEventData, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.action = action
        self.target = target
        self.request = request
        self.actor = actor
        self.source = source


class ContainerRegistryEventRequest(msrest.serialization.Model):
    """The request that generated the event.

    :param id: The ID of the request that initiated the event.
    :type id: str
    :param addr: The IP or hostname and possibly port of the client connection that initiated the
     event. This is the RemoteAddr from the standard http request.
    :type addr: str
    :param host: The externally accessible hostname of the registry instance, as specified by the
     http host header on incoming requests.
    :type host: str
    :param method: The request method that generated the event.
    :type method: str
    :param useragent: The user agent header of the request.
    :type useragent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'addr': {'key': 'addr', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'useragent': {'key': 'useragent', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        addr: Optional[str] = None,
        host: Optional[str] = None,
        method: Optional[str] = None,
        useragent: Optional[str] = None,
        **kwargs
    ):
        super(ContainerRegistryEventRequest, self).__init__(**kwargs)
        self.id = id
        self.addr = addr
        self.host = host
        self.method = method
        self.useragent = useragent


class ContainerRegistryEventSource(msrest.serialization.Model):
    """The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.

    :param addr: The IP or hostname and the port of the registry node that generated the event.
     Generally, this will be resolved by os.Hostname() along with the running port.
    :type addr: str
    :param instance_id: The running instance of an application. Changes after each restart.
    :type instance_id: str
    """

    _attribute_map = {
        'addr': {'key': 'addr', 'type': 'str'},
        'instance_id': {'key': 'instanceID', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        addr: Optional[str] = None,
        instance_id: Optional[str] = None,
        **kwargs
    ):
        super(ContainerRegistryEventSource, self).__init__(**kwargs)
        self.addr = addr
        self.instance_id = instance_id


class ContainerRegistryEventTarget(msrest.serialization.Model):
    """The target of the event.

    :param media_type: The MIME type of the referenced object.
    :type media_type: str
    :param size: The number of bytes of the content. Same as Length field.
    :type size: long
    :param digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :type digest: str
    :param length: The number of bytes of the content. Same as Size field.
    :type length: long
    :param repository: The repository name.
    :type repository: str
    :param url: The direct URL to the content.
    :type url: str
    :param tag: The tag name.
    :type tag: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'length': {'key': 'length', 'type': 'long'},
        'repository': {'key': 'repository', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        length: Optional[int] = None,
        repository: Optional[str] = None,
        url: Optional[str] = None,
        tag: Optional[str] = None,
        **kwargs
    ):
        super(ContainerRegistryEventTarget, self).__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.length = length
        self.repository = repository
        self.url = url
        self.tag = tag


class ContainerRegistryImageDeletedEventData(ContainerRegistryEventData):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ContainerRegistry.ImageDeleted event.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~event_grid_publisher_client.models.ContainerRegistryEventTarget
    :param request: The request that generated the event.
    :type request: ~event_grid_publisher_client.models.ContainerRegistryEventRequest
    :param actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :type actor: ~event_grid_publisher_client.models.ContainerRegistryEventActor
    :param source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :type source: ~event_grid_publisher_client.models.ContainerRegistryEventSource
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'ContainerRegistryEventTarget'},
        'request': {'key': 'request', 'type': 'ContainerRegistryEventRequest'},
        'actor': {'key': 'actor', 'type': 'ContainerRegistryEventActor'},
        'source': {'key': 'source', 'type': 'ContainerRegistryEventSource'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["ContainerRegistryEventTarget"] = None,
        request: Optional["ContainerRegistryEventRequest"] = None,
        actor: Optional["ContainerRegistryEventActor"] = None,
        source: Optional["ContainerRegistryEventSource"] = None,
        **kwargs
    ):
        super(ContainerRegistryImageDeletedEventData, self).__init__(id=id, timestamp=timestamp, action=action, target=target, request=request, actor=actor, source=source, **kwargs)


class ContainerRegistryImagePushedEventData(ContainerRegistryEventData):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ContainerRegistry.ImagePushed event.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~event_grid_publisher_client.models.ContainerRegistryEventTarget
    :param request: The request that generated the event.
    :type request: ~event_grid_publisher_client.models.ContainerRegistryEventRequest
    :param actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :type actor: ~event_grid_publisher_client.models.ContainerRegistryEventActor
    :param source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :type source: ~event_grid_publisher_client.models.ContainerRegistryEventSource
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'ContainerRegistryEventTarget'},
        'request': {'key': 'request', 'type': 'ContainerRegistryEventRequest'},
        'actor': {'key': 'actor', 'type': 'ContainerRegistryEventActor'},
        'source': {'key': 'source', 'type': 'ContainerRegistryEventSource'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["ContainerRegistryEventTarget"] = None,
        request: Optional["ContainerRegistryEventRequest"] = None,
        actor: Optional["ContainerRegistryEventActor"] = None,
        source: Optional["ContainerRegistryEventSource"] = None,
        **kwargs
    ):
        super(ContainerRegistryImagePushedEventData, self).__init__(id=id, timestamp=timestamp, action=action, target=target, request=request, actor=actor, source=source, **kwargs)


class DeviceConnectionStateEventInfo(msrest.serialization.Model):
    """Information about the device connection state event.

    :param sequence_number: Sequence number is string representation of a hexadecimal number.
     string compare can be used to identify the larger number because both in ASCII and HEX numbers
     come after alphabets. If you are converting the string to hex, then the number is a 256 bit
     number.
    :type sequence_number: str
    """

    _attribute_map = {
        'sequence_number': {'key': 'sequenceNumber', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sequence_number: Optional[str] = None,
        **kwargs
    ):
        super(DeviceConnectionStateEventInfo, self).__init__(**kwargs)
        self.sequence_number = sequence_number


class DeviceConnectionStateEventProperties(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a device connection state event (DeviceConnected, DeviceDisconnected).

    :param device_id: The unique identifier of the device. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type device_id: str
    :param module_id: The unique identifier of the module. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type module_id: str
    :param hub_name: Name of the IoT Hub where the device was created or deleted.
    :type hub_name: str
    :param device_connection_state_event_info: Information about the device connection state event.
    :type device_connection_state_event_info:
     ~event_grid_publisher_client.models.DeviceConnectionStateEventInfo
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'module_id': {'key': 'moduleId', 'type': 'str'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'device_connection_state_event_info': {'key': 'deviceConnectionStateEventInfo', 'type': 'DeviceConnectionStateEventInfo'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        module_id: Optional[str] = None,
        hub_name: Optional[str] = None,
        device_connection_state_event_info: Optional["DeviceConnectionStateEventInfo"] = None,
        **kwargs
    ):
        super(DeviceConnectionStateEventProperties, self).__init__(**kwargs)
        self.device_id = device_id
        self.module_id = module_id
        self.hub_name = hub_name
        self.device_connection_state_event_info = device_connection_state_event_info


class DeviceLifeCycleEventProperties(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a device life cycle event (DeviceCreated, DeviceDeleted).

    :param device_id: The unique identifier of the device. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type device_id: str
    :param hub_name: Name of the IoT Hub where the device was created or deleted.
    :type hub_name: str
    :param twin: Information about the device twin, which is the cloud representation of
     application device metadata.
    :type twin: ~event_grid_publisher_client.models.DeviceTwinInfo
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'twin': {'key': 'twin', 'type': 'DeviceTwinInfo'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        hub_name: Optional[str] = None,
        twin: Optional["DeviceTwinInfo"] = None,
        **kwargs
    ):
        super(DeviceLifeCycleEventProperties, self).__init__(**kwargs)
        self.device_id = device_id
        self.hub_name = hub_name
        self.twin = twin


class DeviceTelemetryEventProperties(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a device telemetry event (DeviceTelemetry).

    :param body: The content of the message from the device.
    :type body: object
    :param properties: Application properties are user-defined strings that can be added to the
     message. These fields are optional.
    :type properties: dict[str, str]
    :param system_properties: System properties help identify contents and source of the messages.
    :type system_properties: dict[str, str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'object'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'system_properties': {'key': 'systemProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        body: Optional[object] = None,
        properties: Optional[Dict[str, str]] = None,
        system_properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(DeviceTelemetryEventProperties, self).__init__(**kwargs)
        self.body = body
        self.properties = properties
        self.system_properties = system_properties


class DeviceTwinInfo(msrest.serialization.Model):
    """Information about the device twin, which is the cloud representation of application device metadata.

    :param authentication_type: Authentication type used for this device: either SAS, SelfSigned,
     or CertificateAuthority.
    :type authentication_type: str
    :param cloud_to_device_message_count: Count of cloud to device messages sent to this device.
    :type cloud_to_device_message_count: float
    :param connection_state: Whether the device is connected or disconnected.
    :type connection_state: str
    :param device_id: The unique identifier of the device twin.
    :type device_id: str
    :param etag: A piece of information that describes the content of the device twin. Each etag is
     guaranteed to be unique per device twin.
    :type etag: str
    :param last_activity_time: The ISO8601 timestamp of the last activity.
    :type last_activity_time: str
    :param properties: Properties JSON element.
    :type properties: ~event_grid_publisher_client.models.DeviceTwinInfoProperties
    :param status: Whether the device twin is enabled or disabled.
    :type status: str
    :param status_update_time: The ISO8601 timestamp of the last device twin status update.
    :type status_update_time: str
    :param version: An integer that is incremented by one each time the device twin is updated.
    :type version: float
    :param x509_thumbprint: The thumbprint is a unique value for the x509 certificate, commonly
     used to find a particular certificate in a certificate store. The thumbprint is dynamically
     generated using the SHA1 algorithm, and does not physically exist in the certificate.
    :type x509_thumbprint: ~event_grid_publisher_client.models.DeviceTwinInfoX509Thumbprint
    """

    _attribute_map = {
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'cloud_to_device_message_count': {'key': 'cloudToDeviceMessageCount', 'type': 'float'},
        'connection_state': {'key': 'connectionState', 'type': 'str'},
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'last_activity_time': {'key': 'lastActivityTime', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeviceTwinInfoProperties'},
        'status': {'key': 'status', 'type': 'str'},
        'status_update_time': {'key': 'statusUpdateTime', 'type': 'str'},
        'version': {'key': 'version', 'type': 'float'},
        'x509_thumbprint': {'key': 'x509Thumbprint', 'type': 'DeviceTwinInfoX509Thumbprint'},
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[str] = None,
        cloud_to_device_message_count: Optional[float] = None,
        connection_state: Optional[str] = None,
        device_id: Optional[str] = None,
        etag: Optional[str] = None,
        last_activity_time: Optional[str] = None,
        properties: Optional["DeviceTwinInfoProperties"] = None,
        status: Optional[str] = None,
        status_update_time: Optional[str] = None,
        version: Optional[float] = None,
        x509_thumbprint: Optional["DeviceTwinInfoX509Thumbprint"] = None,
        **kwargs
    ):
        super(DeviceTwinInfo, self).__init__(**kwargs)
        self.authentication_type = authentication_type
        self.cloud_to_device_message_count = cloud_to_device_message_count
        self.connection_state = connection_state
        self.device_id = device_id
        self.etag = etag
        self.last_activity_time = last_activity_time
        self.properties = properties
        self.status = status
        self.status_update_time = status_update_time
        self.version = version
        self.x509_thumbprint = x509_thumbprint


class DeviceTwinInfoProperties(msrest.serialization.Model):
    """Properties JSON element.

    :param desired: A portion of the properties that can be written only by the application back-
     end, and read by the device.
    :type desired: ~event_grid_publisher_client.models.DeviceTwinProperties
    :param reported: A portion of the properties that can be written only by the device, and read
     by the application back-end.
    :type reported: ~event_grid_publisher_client.models.DeviceTwinProperties
    """

    _attribute_map = {
        'desired': {'key': 'desired', 'type': 'DeviceTwinProperties'},
        'reported': {'key': 'reported', 'type': 'DeviceTwinProperties'},
    }

    def __init__(
        self,
        *,
        desired: Optional["DeviceTwinProperties"] = None,
        reported: Optional["DeviceTwinProperties"] = None,
        **kwargs
    ):
        super(DeviceTwinInfoProperties, self).__init__(**kwargs)
        self.desired = desired
        self.reported = reported


class DeviceTwinInfoX509Thumbprint(msrest.serialization.Model):
    """The thumbprint is a unique value for the x509 certificate, commonly used to find a particular certificate in a certificate store. The thumbprint is dynamically generated using the SHA1 algorithm, and does not physically exist in the certificate.

    :param primary_thumbprint: Primary thumbprint for the x509 certificate.
    :type primary_thumbprint: str
    :param secondary_thumbprint: Secondary thumbprint for the x509 certificate.
    :type secondary_thumbprint: str
    """

    _attribute_map = {
        'primary_thumbprint': {'key': 'primaryThumbprint', 'type': 'str'},
        'secondary_thumbprint': {'key': 'secondaryThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_thumbprint: Optional[str] = None,
        secondary_thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(DeviceTwinInfoX509Thumbprint, self).__init__(**kwargs)
        self.primary_thumbprint = primary_thumbprint
        self.secondary_thumbprint = secondary_thumbprint


class DeviceTwinMetadata(msrest.serialization.Model):
    """Metadata information for the properties JSON document.

    :param last_updated: The ISO8601 timestamp of the last time the properties were updated.
    :type last_updated: str
    """

    _attribute_map = {
        'last_updated': {'key': 'lastUpdated', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_updated: Optional[str] = None,
        **kwargs
    ):
        super(DeviceTwinMetadata, self).__init__(**kwargs)
        self.last_updated = last_updated


class DeviceTwinProperties(msrest.serialization.Model):
    """A portion of the properties that can be written only by the application back-end, and read by the device.

    :param metadata: Metadata information for the properties JSON document.
    :type metadata: ~event_grid_publisher_client.models.DeviceTwinMetadata
    :param version: Version of device twin properties.
    :type version: float
    """

    _attribute_map = {
        'metadata': {'key': 'metadata', 'type': 'DeviceTwinMetadata'},
        'version': {'key': 'version', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        metadata: Optional["DeviceTwinMetadata"] = None,
        version: Optional[float] = None,
        **kwargs
    ):
        super(DeviceTwinProperties, self).__init__(**kwargs)
        self.metadata = metadata
        self.version = version


class EventGridEvent(msrest.serialization.Model):
    """Properties of an event published to an Event Grid topic using the EventGrid Schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. An unique identifier for the event.
    :type id: str
    :param topic: The resource path of the event source.
    :type topic: str
    :param subject: Required. A resource path relative to the topic path.
    :type subject: str
    :param data: Required. Event data specific to the event type.
    :type data: object
    :param event_type: Required. The type of the event that occurred.
    :type event_type: str
    :param event_time: Required. The time (in UTC) the event was generated.
    :type event_time: ~datetime.datetime
    :ivar metadata_version: The schema version of the event metadata.
    :vartype metadata_version: str
    :param data_version: Required. The schema version of the data object.
    :type data_version: str
    """

    _validation = {
        'id': {'required': True},
        'subject': {'required': True},
        'data': {'required': True},
        'event_type': {'required': True},
        'event_time': {'required': True},
        'metadata_version': {'readonly': True},
        'data_version': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'topic': {'key': 'topic', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'data': {'key': 'data', 'type': 'object'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'event_time': {'key': 'eventTime', 'type': 'iso-8601'},
        'metadata_version': {'key': 'metadataVersion', 'type': 'str'},
        'data_version': {'key': 'dataVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        subject: str,
        data: object,
        event_type: str,
        event_time: datetime.datetime,
        data_version: str,
        topic: Optional[str] = None,
        **kwargs
    ):
        super(EventGridEvent, self).__init__(**kwargs)
        self.id = id
        self.topic = topic
        self.subject = subject
        self.data = data
        self.event_type = event_type
        self.event_time = event_time
        self.metadata_version = None
        self.data_version = data_version


class EventHubCaptureFileCreatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.EventHub.CaptureFileCreated event.

    :param fileurl: The path to the capture file.
    :type fileurl: str
    :param file_type: The file type of the capture file.
    :type file_type: str
    :param partition_id: The shard ID.
    :type partition_id: str
    :param size_in_bytes: The file size.
    :type size_in_bytes: int
    :param event_count: The number of events in the file.
    :type event_count: int
    :param first_sequence_number: The smallest sequence number from the queue.
    :type first_sequence_number: int
    :param last_sequence_number: The last sequence number from the queue.
    :type last_sequence_number: int
    :param first_enqueue_time: The first time from the queue.
    :type first_enqueue_time: ~datetime.datetime
    :param last_enqueue_time: The last time from the queue.
    :type last_enqueue_time: ~datetime.datetime
    """

    _attribute_map = {
        'fileurl': {'key': 'fileurl', 'type': 'str'},
        'file_type': {'key': 'fileType', 'type': 'str'},
        'partition_id': {'key': 'partitionId', 'type': 'str'},
        'size_in_bytes': {'key': 'sizeInBytes', 'type': 'int'},
        'event_count': {'key': 'eventCount', 'type': 'int'},
        'first_sequence_number': {'key': 'firstSequenceNumber', 'type': 'int'},
        'last_sequence_number': {'key': 'lastSequenceNumber', 'type': 'int'},
        'first_enqueue_time': {'key': 'firstEnqueueTime', 'type': 'iso-8601'},
        'last_enqueue_time': {'key': 'lastEnqueueTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        fileurl: Optional[str] = None,
        file_type: Optional[str] = None,
        partition_id: Optional[str] = None,
        size_in_bytes: Optional[int] = None,
        event_count: Optional[int] = None,
        first_sequence_number: Optional[int] = None,
        last_sequence_number: Optional[int] = None,
        first_enqueue_time: Optional[datetime.datetime] = None,
        last_enqueue_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(EventHubCaptureFileCreatedEventData, self).__init__(**kwargs)
        self.fileurl = fileurl
        self.file_type = file_type
        self.partition_id = partition_id
        self.size_in_bytes = size_in_bytes
        self.event_count = event_count
        self.first_sequence_number = first_sequence_number
        self.last_sequence_number = last_sequence_number
        self.first_enqueue_time = first_enqueue_time
        self.last_enqueue_time = last_enqueue_time


class IotHubDeviceConnectedEventData(DeviceConnectionStateEventProperties):
    """Event data for Microsoft.Devices.DeviceConnected event.

    :param device_id: The unique identifier of the device. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type device_id: str
    :param module_id: The unique identifier of the module. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type module_id: str
    :param hub_name: Name of the IoT Hub where the device was created or deleted.
    :type hub_name: str
    :param device_connection_state_event_info: Information about the device connection state event.
    :type device_connection_state_event_info:
     ~event_grid_publisher_client.models.DeviceConnectionStateEventInfo
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'module_id': {'key': 'moduleId', 'type': 'str'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'device_connection_state_event_info': {'key': 'deviceConnectionStateEventInfo', 'type': 'DeviceConnectionStateEventInfo'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        module_id: Optional[str] = None,
        hub_name: Optional[str] = None,
        device_connection_state_event_info: Optional["DeviceConnectionStateEventInfo"] = None,
        **kwargs
    ):
        super(IotHubDeviceConnectedEventData, self).__init__(device_id=device_id, module_id=module_id, hub_name=hub_name, device_connection_state_event_info=device_connection_state_event_info, **kwargs)


class IotHubDeviceCreatedEventData(DeviceLifeCycleEventProperties):
    """Event data for Microsoft.Devices.DeviceCreated event.

    :param device_id: The unique identifier of the device. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type device_id: str
    :param hub_name: Name of the IoT Hub where the device was created or deleted.
    :type hub_name: str
    :param twin: Information about the device twin, which is the cloud representation of
     application device metadata.
    :type twin: ~event_grid_publisher_client.models.DeviceTwinInfo
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'twin': {'key': 'twin', 'type': 'DeviceTwinInfo'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        hub_name: Optional[str] = None,
        twin: Optional["DeviceTwinInfo"] = None,
        **kwargs
    ):
        super(IotHubDeviceCreatedEventData, self).__init__(device_id=device_id, hub_name=hub_name, twin=twin, **kwargs)


class IotHubDeviceDeletedEventData(DeviceLifeCycleEventProperties):
    """Event data for Microsoft.Devices.DeviceDeleted event.

    :param device_id: The unique identifier of the device. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type device_id: str
    :param hub_name: Name of the IoT Hub where the device was created or deleted.
    :type hub_name: str
    :param twin: Information about the device twin, which is the cloud representation of
     application device metadata.
    :type twin: ~event_grid_publisher_client.models.DeviceTwinInfo
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'twin': {'key': 'twin', 'type': 'DeviceTwinInfo'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        hub_name: Optional[str] = None,
        twin: Optional["DeviceTwinInfo"] = None,
        **kwargs
    ):
        super(IotHubDeviceDeletedEventData, self).__init__(device_id=device_id, hub_name=hub_name, twin=twin, **kwargs)


class IotHubDeviceDisconnectedEventData(DeviceConnectionStateEventProperties):
    """Event data for Microsoft.Devices.DeviceDisconnected event.

    :param device_id: The unique identifier of the device. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type device_id: str
    :param module_id: The unique identifier of the module. This case-sensitive string can be up to
     128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following
     special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
    :type module_id: str
    :param hub_name: Name of the IoT Hub where the device was created or deleted.
    :type hub_name: str
    :param device_connection_state_event_info: Information about the device connection state event.
    :type device_connection_state_event_info:
     ~event_grid_publisher_client.models.DeviceConnectionStateEventInfo
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'module_id': {'key': 'moduleId', 'type': 'str'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'device_connection_state_event_info': {'key': 'deviceConnectionStateEventInfo', 'type': 'DeviceConnectionStateEventInfo'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        module_id: Optional[str] = None,
        hub_name: Optional[str] = None,
        device_connection_state_event_info: Optional["DeviceConnectionStateEventInfo"] = None,
        **kwargs
    ):
        super(IotHubDeviceDisconnectedEventData, self).__init__(device_id=device_id, module_id=module_id, hub_name=hub_name, device_connection_state_event_info=device_connection_state_event_info, **kwargs)


class IotHubDeviceTelemetryEventData(DeviceTelemetryEventProperties):
    """Event data for Microsoft.Devices.DeviceTelemetry event.

    :param body: The content of the message from the device.
    :type body: object
    :param properties: Application properties are user-defined strings that can be added to the
     message. These fields are optional.
    :type properties: dict[str, str]
    :param system_properties: System properties help identify contents and source of the messages.
    :type system_properties: dict[str, str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'object'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'system_properties': {'key': 'systemProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        body: Optional[object] = None,
        properties: Optional[Dict[str, str]] = None,
        system_properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(IotHubDeviceTelemetryEventData, self).__init__(body=body, properties=properties, system_properties=system_properties, **kwargs)


class KeyVaultAccessPolicyChangedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an VaultAccessPolicyChanged event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultAccessPolicyChangedEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultCertificateExpiredEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an CertificateExpired event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultCertificateExpiredEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultCertificateNearExpiryEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an CertificateNearExpiry event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultCertificateNearExpiryEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultCertificateNewVersionCreatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an CertificateNewVersionCreated event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultCertificateNewVersionCreatedEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultKeyExpiredEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an KeyExpired event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultKeyExpiredEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultKeyNearExpiryEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an KeyNearExpiry event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultKeyNearExpiryEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultKeyNewVersionCreatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an KeyNewVersionCreated event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultKeyNewVersionCreatedEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultSecretExpiredEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an SecretExpired event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultSecretExpiredEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultSecretNearExpiryEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an SecretNearExpiry event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultSecretNearExpiryEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class KeyVaultSecretNewVersionCreatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an SecretNewVersionCreated event.

    :param id: The id of the object that triggered this event.
    :type id: str
    :param vault_name: Key vault name of the object that triggered this event.
    :type vault_name: str
    :param object_type: The type of the object that triggered this event.
    :type object_type: str
    :param object_name: The name of the object that triggered this event.
    :type object_name: str
    :param version: The version of the object that triggered this event.
    :type version: str
    :param nbf: Not before date of the object that triggered this event.
    :type nbf: float
    :param exp: The expiration date of the object that triggered this event.
    :type exp: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        vault_name: Optional[str] = None,
        object_type: Optional[str] = None,
        object_name: Optional[str] = None,
        version: Optional[str] = None,
        nbf: Optional[float] = None,
        exp: Optional[float] = None,
        **kwargs
    ):
        super(KeyVaultSecretNewVersionCreatedEventData, self).__init__(**kwargs)
        self.id = id
        self.vault_name = vault_name
        self.object_type = object_type
        self.object_name = object_name
        self.version = version
        self.nbf = nbf
        self.exp = exp


class MachineLearningServicesDatasetDriftDetectedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.MachineLearningServices.DatasetDriftDetected event.

    :param data_drift_id: The ID of the data drift monitor that triggered the event.
    :type data_drift_id: str
    :param data_drift_name: The name of the data drift monitor that triggered the event.
    :type data_drift_name: str
    :param run_id: The ID of the Run that detected data drift.
    :type run_id: str
    :param base_dataset_id: The ID of the base Dataset used to detect drift.
    :type base_dataset_id: str
    :param target_dataset_id: The ID of the target Dataset used to detect drift.
    :type target_dataset_id: str
    :param drift_coefficient: The coefficient result that triggered the event.
    :type drift_coefficient: float
    :param start_time: The start time of the target dataset time series that resulted in drift
     detection.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the target dataset time series that resulted in drift
     detection.
    :type end_time: ~datetime.datetime
    """

    _attribute_map = {
        'data_drift_id': {'key': 'dataDriftId', 'type': 'str'},
        'data_drift_name': {'key': 'dataDriftName', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'base_dataset_id': {'key': 'baseDatasetId', 'type': 'str'},
        'target_dataset_id': {'key': 'targetDatasetId', 'type': 'str'},
        'drift_coefficient': {'key': 'driftCoefficient', 'type': 'float'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        data_drift_id: Optional[str] = None,
        data_drift_name: Optional[str] = None,
        run_id: Optional[str] = None,
        base_dataset_id: Optional[str] = None,
        target_dataset_id: Optional[str] = None,
        drift_coefficient: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(MachineLearningServicesDatasetDriftDetectedEventData, self).__init__(**kwargs)
        self.data_drift_id = data_drift_id
        self.data_drift_name = data_drift_name
        self.run_id = run_id
        self.base_dataset_id = base_dataset_id
        self.target_dataset_id = target_dataset_id
        self.drift_coefficient = drift_coefficient
        self.start_time = start_time
        self.end_time = end_time


class MachineLearningServicesModelDeployedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.MachineLearningServices.ModelDeployed event.

    :param service_name: The name of the deployed service.
    :type service_name: str
    :param service_compute_type: The compute type (e.g. ACI, AKS) of the deployed service.
    :type service_compute_type: str
    :param model_ids: A common separated list of model IDs. The IDs of the models deployed in the
     service.
    :type model_ids: str
    :param service_tags: The tags of the deployed service.
    :type service_tags: object
    :param service_properties: The properties of the deployed service.
    :type service_properties: object
    """

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'service_compute_type': {'key': 'serviceComputeType', 'type': 'str'},
        'model_ids': {'key': 'modelIds', 'type': 'str'},
        'service_tags': {'key': 'serviceTags', 'type': 'object'},
        'service_properties': {'key': 'serviceProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        service_name: Optional[str] = None,
        service_compute_type: Optional[str] = None,
        model_ids: Optional[str] = None,
        service_tags: Optional[object] = None,
        service_properties: Optional[object] = None,
        **kwargs
    ):
        super(MachineLearningServicesModelDeployedEventData, self).__init__(**kwargs)
        self.service_name = service_name
        self.service_compute_type = service_compute_type
        self.model_ids = model_ids
        self.service_tags = service_tags
        self.service_properties = service_properties


class MachineLearningServicesModelRegisteredEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.MachineLearningServices.ModelRegistered event.

    :param model_name: The name of the model that was registered.
    :type model_name: str
    :param model_version: The version of the model that was registered.
    :type model_version: str
    :param model_tags: The tags of the model that was registered.
    :type model_tags: object
    :param model_properties: The properties of the model that was registered.
    :type model_properties: object
    """

    _attribute_map = {
        'model_name': {'key': 'modelName', 'type': 'str'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'model_tags': {'key': 'modelTags', 'type': 'object'},
        'model_properties': {'key': 'modelProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        model_name: Optional[str] = None,
        model_version: Optional[str] = None,
        model_tags: Optional[object] = None,
        model_properties: Optional[object] = None,
        **kwargs
    ):
        super(MachineLearningServicesModelRegisteredEventData, self).__init__(**kwargs)
        self.model_name = model_name
        self.model_version = model_version
        self.model_tags = model_tags
        self.model_properties = model_properties


class MachineLearningServicesRunCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.MachineLearningServices.RunCompleted event.

    :param experiment_id: The ID of the experiment that the run belongs to.
    :type experiment_id: str
    :param experiment_name: The name of the experiment that the run belongs to.
    :type experiment_name: str
    :param run_id: The ID of the Run that was completed.
    :type run_id: str
    :param run_type: The Run Type of the completed Run.
    :type run_type: str
    :param run_tags: The tags of the completed Run.
    :type run_tags: object
    :param run_properties: The properties of the completed Run.
    :type run_properties: object
    """

    _attribute_map = {
        'experiment_id': {'key': 'experimentId', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'run_type': {'key': 'runType', 'type': 'str'},
        'run_tags': {'key': 'runTags', 'type': 'object'},
        'run_properties': {'key': 'runProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        experiment_id: Optional[str] = None,
        experiment_name: Optional[str] = None,
        run_id: Optional[str] = None,
        run_type: Optional[str] = None,
        run_tags: Optional[object] = None,
        run_properties: Optional[object] = None,
        **kwargs
    ):
        super(MachineLearningServicesRunCompletedEventData, self).__init__(**kwargs)
        self.experiment_id = experiment_id
        self.experiment_name = experiment_name
        self.run_id = run_id
        self.run_type = run_type
        self.run_tags = run_tags
        self.run_properties = run_properties


class MachineLearningServicesRunStatusChangedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.MachineLearningServices.RunStatusChanged event.

    :param experiment_id: The ID of the experiment that the Machine Learning Run belongs to.
    :type experiment_id: str
    :param experiment_name: The name of the experiment that the Machine Learning Run belongs to.
    :type experiment_name: str
    :param run_id: The ID of the Machine Learning Run.
    :type run_id: str
    :param run_type: The Run Type of the Machine Learning Run.
    :type run_type: str
    :param run_tags: The tags of the Machine Learning Run.
    :type run_tags: object
    :param run_properties: The properties of the Machine Learning Run.
    :type run_properties: object
    :param run_status: The status of the Machine Learning Run.
    :type run_status: str
    """

    _attribute_map = {
        'experiment_id': {'key': 'experimentId', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'run_type': {'key': 'runType', 'type': 'str'},
        'run_tags': {'key': 'runTags', 'type': 'object'},
        'run_properties': {'key': 'runProperties', 'type': 'object'},
        'run_status': {'key': 'runStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        experiment_id: Optional[str] = None,
        experiment_name: Optional[str] = None,
        run_id: Optional[str] = None,
        run_type: Optional[str] = None,
        run_tags: Optional[object] = None,
        run_properties: Optional[object] = None,
        run_status: Optional[str] = None,
        **kwargs
    ):
        super(MachineLearningServicesRunStatusChangedEventData, self).__init__(**kwargs)
        self.experiment_id = experiment_id
        self.experiment_name = experiment_name
        self.run_id = run_id
        self.run_type = run_type
        self.run_tags = run_tags
        self.run_properties = run_properties
        self.run_status = run_status


class MapsGeofenceEventProperties(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Geofence event (GeofenceEntered, GeofenceExited, GeofenceResult).

    :param expired_geofence_geometry_id: Lists of the geometry ID of the geofence which is expired
     relative to the user time in the request.
    :type expired_geofence_geometry_id: list[str]
    :param geometries: Lists the fence geometries that either fully contain the coordinate position
     or have an overlap with the searchBuffer around the fence.
    :type geometries: list[~event_grid_publisher_client.models.MapsGeofenceGeometry]
    :param invalid_period_geofence_geometry_id: Lists of the geometry ID of the geofence which is
     in invalid period relative to the user time in the request.
    :type invalid_period_geofence_geometry_id: list[str]
    :param is_event_published: True if at least one event is published to the Azure Maps event
     subscriber, false if no event is published to the Azure Maps event subscriber.
    :type is_event_published: bool
    """

    _attribute_map = {
        'expired_geofence_geometry_id': {'key': 'expiredGeofenceGeometryId', 'type': '[str]'},
        'geometries': {'key': 'geometries', 'type': '[MapsGeofenceGeometry]'},
        'invalid_period_geofence_geometry_id': {'key': 'invalidPeriodGeofenceGeometryId', 'type': '[str]'},
        'is_event_published': {'key': 'isEventPublished', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        expired_geofence_geometry_id: Optional[List[str]] = None,
        geometries: Optional[List["MapsGeofenceGeometry"]] = None,
        invalid_period_geofence_geometry_id: Optional[List[str]] = None,
        is_event_published: Optional[bool] = None,
        **kwargs
    ):
        super(MapsGeofenceEventProperties, self).__init__(**kwargs)
        self.expired_geofence_geometry_id = expired_geofence_geometry_id
        self.geometries = geometries
        self.invalid_period_geofence_geometry_id = invalid_period_geofence_geometry_id
        self.is_event_published = is_event_published


class MapsGeofenceEnteredEventData(MapsGeofenceEventProperties):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Maps.GeofenceEntered event.

    :param expired_geofence_geometry_id: Lists of the geometry ID of the geofence which is expired
     relative to the user time in the request.
    :type expired_geofence_geometry_id: list[str]
    :param geometries: Lists the fence geometries that either fully contain the coordinate position
     or have an overlap with the searchBuffer around the fence.
    :type geometries: list[~event_grid_publisher_client.models.MapsGeofenceGeometry]
    :param invalid_period_geofence_geometry_id: Lists of the geometry ID of the geofence which is
     in invalid period relative to the user time in the request.
    :type invalid_period_geofence_geometry_id: list[str]
    :param is_event_published: True if at least one event is published to the Azure Maps event
     subscriber, false if no event is published to the Azure Maps event subscriber.
    :type is_event_published: bool
    """

    _attribute_map = {
        'expired_geofence_geometry_id': {'key': 'expiredGeofenceGeometryId', 'type': '[str]'},
        'geometries': {'key': 'geometries', 'type': '[MapsGeofenceGeometry]'},
        'invalid_period_geofence_geometry_id': {'key': 'invalidPeriodGeofenceGeometryId', 'type': '[str]'},
        'is_event_published': {'key': 'isEventPublished', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        expired_geofence_geometry_id: Optional[List[str]] = None,
        geometries: Optional[List["MapsGeofenceGeometry"]] = None,
        invalid_period_geofence_geometry_id: Optional[List[str]] = None,
        is_event_published: Optional[bool] = None,
        **kwargs
    ):
        super(MapsGeofenceEnteredEventData, self).__init__(expired_geofence_geometry_id=expired_geofence_geometry_id, geometries=geometries, invalid_period_geofence_geometry_id=invalid_period_geofence_geometry_id, is_event_published=is_event_published, **kwargs)


class MapsGeofenceExitedEventData(MapsGeofenceEventProperties):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Maps.GeofenceExited event.

    :param expired_geofence_geometry_id: Lists of the geometry ID of the geofence which is expired
     relative to the user time in the request.
    :type expired_geofence_geometry_id: list[str]
    :param geometries: Lists the fence geometries that either fully contain the coordinate position
     or have an overlap with the searchBuffer around the fence.
    :type geometries: list[~event_grid_publisher_client.models.MapsGeofenceGeometry]
    :param invalid_period_geofence_geometry_id: Lists of the geometry ID of the geofence which is
     in invalid period relative to the user time in the request.
    :type invalid_period_geofence_geometry_id: list[str]
    :param is_event_published: True if at least one event is published to the Azure Maps event
     subscriber, false if no event is published to the Azure Maps event subscriber.
    :type is_event_published: bool
    """

    _attribute_map = {
        'expired_geofence_geometry_id': {'key': 'expiredGeofenceGeometryId', 'type': '[str]'},
        'geometries': {'key': 'geometries', 'type': '[MapsGeofenceGeometry]'},
        'invalid_period_geofence_geometry_id': {'key': 'invalidPeriodGeofenceGeometryId', 'type': '[str]'},
        'is_event_published': {'key': 'isEventPublished', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        expired_geofence_geometry_id: Optional[List[str]] = None,
        geometries: Optional[List["MapsGeofenceGeometry"]] = None,
        invalid_period_geofence_geometry_id: Optional[List[str]] = None,
        is_event_published: Optional[bool] = None,
        **kwargs
    ):
        super(MapsGeofenceExitedEventData, self).__init__(expired_geofence_geometry_id=expired_geofence_geometry_id, geometries=geometries, invalid_period_geofence_geometry_id=invalid_period_geofence_geometry_id, is_event_published=is_event_published, **kwargs)


class MapsGeofenceGeometry(msrest.serialization.Model):
    """The geofence geometry.

    :param device_id: ID of the device.
    :type device_id: str
    :param distance: Distance from the coordinate to the closest border of the geofence. Positive
     means the coordinate is outside of the geofence. If the coordinate is outside of the geofence,
     but more than the value of searchBuffer away from the closest geofence border, then the value
     is 999. Negative means the coordinate is inside of the geofence. If the coordinate is inside
     the polygon, but more than the value of searchBuffer away from the closest geofencing
     border,then the value is -999. A value of 999 means that there is great confidence the
     coordinate is well outside the geofence. A value of -999 means that there is great confidence
     the coordinate is well within the geofence.
    :type distance: float
    :param geometry_id: The unique ID for the geofence geometry.
    :type geometry_id: str
    :param nearest_lat: Latitude of the nearest point of the geometry.
    :type nearest_lat: float
    :param nearest_lon: Longitude of the nearest point of the geometry.
    :type nearest_lon: float
    :param ud_id: The unique id returned from user upload service when uploading a geofence. Will
     not be included in geofencing post API.
    :type ud_id: str
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'distance': {'key': 'distance', 'type': 'float'},
        'geometry_id': {'key': 'geometryId', 'type': 'str'},
        'nearest_lat': {'key': 'nearestLat', 'type': 'float'},
        'nearest_lon': {'key': 'nearestLon', 'type': 'float'},
        'ud_id': {'key': 'udId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        distance: Optional[float] = None,
        geometry_id: Optional[str] = None,
        nearest_lat: Optional[float] = None,
        nearest_lon: Optional[float] = None,
        ud_id: Optional[str] = None,
        **kwargs
    ):
        super(MapsGeofenceGeometry, self).__init__(**kwargs)
        self.device_id = device_id
        self.distance = distance
        self.geometry_id = geometry_id
        self.nearest_lat = nearest_lat
        self.nearest_lon = nearest_lon
        self.ud_id = ud_id


class MapsGeofenceResultEventData(MapsGeofenceEventProperties):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Maps.GeofenceResult event.

    :param expired_geofence_geometry_id: Lists of the geometry ID of the geofence which is expired
     relative to the user time in the request.
    :type expired_geofence_geometry_id: list[str]
    :param geometries: Lists the fence geometries that either fully contain the coordinate position
     or have an overlap with the searchBuffer around the fence.
    :type geometries: list[~event_grid_publisher_client.models.MapsGeofenceGeometry]
    :param invalid_period_geofence_geometry_id: Lists of the geometry ID of the geofence which is
     in invalid period relative to the user time in the request.
    :type invalid_period_geofence_geometry_id: list[str]
    :param is_event_published: True if at least one event is published to the Azure Maps event
     subscriber, false if no event is published to the Azure Maps event subscriber.
    :type is_event_published: bool
    """

    _attribute_map = {
        'expired_geofence_geometry_id': {'key': 'expiredGeofenceGeometryId', 'type': '[str]'},
        'geometries': {'key': 'geometries', 'type': '[MapsGeofenceGeometry]'},
        'invalid_period_geofence_geometry_id': {'key': 'invalidPeriodGeofenceGeometryId', 'type': '[str]'},
        'is_event_published': {'key': 'isEventPublished', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        expired_geofence_geometry_id: Optional[List[str]] = None,
        geometries: Optional[List["MapsGeofenceGeometry"]] = None,
        invalid_period_geofence_geometry_id: Optional[List[str]] = None,
        is_event_published: Optional[bool] = None,
        **kwargs
    ):
        super(MapsGeofenceResultEventData, self).__init__(expired_geofence_geometry_id=expired_geofence_geometry_id, geometries=geometries, invalid_period_geofence_geometry_id=invalid_period_geofence_geometry_id, is_event_published=is_event_published, **kwargs)


class MediaJobStateChangeEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Media.JobStateChange event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :ivar state: The new state of the Job. Possible values include: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype state: str or ~event_grid_publisher_client.models.MediaJobState
    :param correlation_data: Gets the Job correlation data.
    :type correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'correlation_data': {'key': 'correlationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobStateChangeEventData, self).__init__(**kwargs)
        self.previous_state = None
        self.state = None
        self.correlation_data = correlation_data


class MediaJobCanceledEventData(MediaJobStateChangeEventData):
    """Job canceled event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :ivar state: The new state of the Job. Possible values include: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype state: str or ~event_grid_publisher_client.models.MediaJobState
    :param correlation_data: Gets the Job correlation data.
    :type correlation_data: dict[str, str]
    :param outputs: Gets the Job outputs.
    :type outputs: list[~event_grid_publisher_client.models.MediaJobOutput]
    """

    _validation = {
        'previous_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'correlation_data': {'key': 'correlationData', 'type': '{str}'},
        'outputs': {'key': 'outputs', 'type': '[MediaJobOutput]'},
    }

    def __init__(
        self,
        *,
        correlation_data: Optional[Dict[str, str]] = None,
        outputs: Optional[List["MediaJobOutput"]] = None,
        **kwargs
    ):
        super(MediaJobCanceledEventData, self).__init__(correlation_data=correlation_data, **kwargs)
        self.outputs = outputs


class MediaJobCancelingEventData(MediaJobStateChangeEventData):
    """Job canceling event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :ivar state: The new state of the Job. Possible values include: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype state: str or ~event_grid_publisher_client.models.MediaJobState
    :param correlation_data: Gets the Job correlation data.
    :type correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'correlation_data': {'key': 'correlationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobCancelingEventData, self).__init__(correlation_data=correlation_data, **kwargs)


class MediaJobError(msrest.serialization.Model):
    """Details of JobOutput errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code describing the error. Possible values include: "ServiceError",
     "ServiceTransientError", "DownloadNotAccessible", "DownloadTransientError",
     "UploadNotAccessible", "UploadTransientError", "ConfigurationUnsupported", "ContentMalformed",
     "ContentUnsupported".
    :vartype code: str or ~event_grid_publisher_client.models.MediaJobErrorCode
    :ivar message: A human-readable language-dependent representation of the error.
    :vartype message: str
    :ivar category: Helps with categorization of errors. Possible values include: "Service",
     "Download", "Upload", "Configuration", "Content".
    :vartype category: str or ~event_grid_publisher_client.models.MediaJobErrorCategory
    :ivar retry: Indicates that it may be possible to retry the Job. If retry is unsuccessful,
     please contact Azure support via Azure Portal. Possible values include: "DoNotRetry",
     "MayRetry".
    :vartype retry: str or ~event_grid_publisher_client.models.MediaJobRetry
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~event_grid_publisher_client.models.MediaJobErrorDetail]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'category': {'readonly': True},
        'retry': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'retry': {'key': 'retry', 'type': 'str'},
        'details': {'key': 'details', 'type': '[MediaJobErrorDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaJobError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.category = None
        self.retry = None
        self.details = None


class MediaJobErrorDetail(msrest.serialization.Model):
    """Details of JobOutput errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code describing the error detail.
    :vartype code: str
    :ivar message: A human-readable representation of the error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaJobErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None


class MediaJobErroredEventData(MediaJobStateChangeEventData):
    """Job error state event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :ivar state: The new state of the Job. Possible values include: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype state: str or ~event_grid_publisher_client.models.MediaJobState
    :param correlation_data: Gets the Job correlation data.
    :type correlation_data: dict[str, str]
    :param outputs: Gets the Job outputs.
    :type outputs: list[~event_grid_publisher_client.models.MediaJobOutput]
    """

    _validation = {
        'previous_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'correlation_data': {'key': 'correlationData', 'type': '{str}'},
        'outputs': {'key': 'outputs', 'type': '[MediaJobOutput]'},
    }

    def __init__(
        self,
        *,
        correlation_data: Optional[Dict[str, str]] = None,
        outputs: Optional[List["MediaJobOutput"]] = None,
        **kwargs
    ):
        super(MediaJobErroredEventData, self).__init__(correlation_data=correlation_data, **kwargs)
        self.outputs = outputs


class MediaJobFinishedEventData(MediaJobStateChangeEventData):
    """Job finished event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :ivar state: The new state of the Job. Possible values include: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype state: str or ~event_grid_publisher_client.models.MediaJobState
    :param correlation_data: Gets the Job correlation data.
    :type correlation_data: dict[str, str]
    :param outputs: Gets the Job outputs.
    :type outputs: list[~event_grid_publisher_client.models.MediaJobOutput]
    """

    _validation = {
        'previous_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'correlation_data': {'key': 'correlationData', 'type': '{str}'},
        'outputs': {'key': 'outputs', 'type': '[MediaJobOutput]'},
    }

    def __init__(
        self,
        *,
        correlation_data: Optional[Dict[str, str]] = None,
        outputs: Optional[List["MediaJobOutput"]] = None,
        **kwargs
    ):
        super(MediaJobFinishedEventData, self).__init__(correlation_data=correlation_data, **kwargs)
        self.outputs = outputs


class MediaJobOutput(msrest.serialization.Model):
    """The event data for a Job output.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaJobOutputAsset.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: The discriminator for derived types.Constant filled by server.
    :type odata_type: str
    :param error: Gets the Job output error.
    :type error: ~event_grid_publisher_client.models.MediaJobError
    :param label: Gets the Job output label.
    :type label: str
    :param progress: Required. Gets the Job output progress.
    :type progress: long
    :param state: Required. Gets the Job output state. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :type state: str or ~event_grid_publisher_client.models.MediaJobState
    """

    _validation = {
        'progress': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'error': {'key': 'error', 'type': 'MediaJobError'},
        'label': {'key': 'label', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'long'},
        'state': {'key': 'state', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Media.JobOutputAsset': 'MediaJobOutputAsset'}
    }

    def __init__(
        self,
        *,
        progress: int,
        state: Union[str, "MediaJobState"],
        error: Optional["MediaJobError"] = None,
        label: Optional[str] = None,
        **kwargs
    ):
        super(MediaJobOutput, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.error = error
        self.label = label
        self.progress = progress
        self.state = state


class MediaJobOutputAsset(MediaJobOutput):
    """The event data for a Job output asset.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: The discriminator for derived types.Constant filled by server.
    :type odata_type: str
    :param error: Gets the Job output error.
    :type error: ~event_grid_publisher_client.models.MediaJobError
    :param label: Gets the Job output label.
    :type label: str
    :param progress: Required. Gets the Job output progress.
    :type progress: long
    :param state: Required. Gets the Job output state. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :type state: str or ~event_grid_publisher_client.models.MediaJobState
    :param asset_name: Gets the Job output asset name.
    :type asset_name: str
    """

    _validation = {
        'progress': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'error': {'key': 'error', 'type': 'MediaJobError'},
        'label': {'key': 'label', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'long'},
        'state': {'key': 'state', 'type': 'str'},
        'asset_name': {'key': 'assetName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        progress: int,
        state: Union[str, "MediaJobState"],
        error: Optional["MediaJobError"] = None,
        label: Optional[str] = None,
        asset_name: Optional[str] = None,
        **kwargs
    ):
        super(MediaJobOutputAsset, self).__init__(error=error, label=label, progress=progress, state=state, **kwargs)
        self.odata_type = '#Microsoft.Media.JobOutputAsset'  # type: str
        self.asset_name = asset_name


class MediaJobOutputStateChangeEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Media.JobOutputStateChange event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :param output: Gets the output.
    :type output: ~event_grid_publisher_client.models.MediaJobOutput
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'output': {'key': 'output', 'type': 'MediaJobOutput'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        output: Optional["MediaJobOutput"] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputStateChangeEventData, self).__init__(**kwargs)
        self.previous_state = None
        self.output = output
        self.job_correlation_data = job_correlation_data


class MediaJobOutputCanceledEventData(MediaJobOutputStateChangeEventData):
    """Job output canceled event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :param output: Gets the output.
    :type output: ~event_grid_publisher_client.models.MediaJobOutput
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'output': {'key': 'output', 'type': 'MediaJobOutput'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        output: Optional["MediaJobOutput"] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputCanceledEventData, self).__init__(output=output, job_correlation_data=job_correlation_data, **kwargs)


class MediaJobOutputCancelingEventData(MediaJobOutputStateChangeEventData):
    """Job output canceling event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :param output: Gets the output.
    :type output: ~event_grid_publisher_client.models.MediaJobOutput
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'output': {'key': 'output', 'type': 'MediaJobOutput'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        output: Optional["MediaJobOutput"] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputCancelingEventData, self).__init__(output=output, job_correlation_data=job_correlation_data, **kwargs)


class MediaJobOutputErroredEventData(MediaJobOutputStateChangeEventData):
    """Job output error event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :param output: Gets the output.
    :type output: ~event_grid_publisher_client.models.MediaJobOutput
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'output': {'key': 'output', 'type': 'MediaJobOutput'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        output: Optional["MediaJobOutput"] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputErroredEventData, self).__init__(output=output, job_correlation_data=job_correlation_data, **kwargs)


class MediaJobOutputFinishedEventData(MediaJobOutputStateChangeEventData):
    """Job output finished event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :param output: Gets the output.
    :type output: ~event_grid_publisher_client.models.MediaJobOutput
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'output': {'key': 'output', 'type': 'MediaJobOutput'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        output: Optional["MediaJobOutput"] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputFinishedEventData, self).__init__(output=output, job_correlation_data=job_correlation_data, **kwargs)


class MediaJobOutputProcessingEventData(MediaJobOutputStateChangeEventData):
    """Job output processing event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :param output: Gets the output.
    :type output: ~event_grid_publisher_client.models.MediaJobOutput
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'output': {'key': 'output', 'type': 'MediaJobOutput'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        output: Optional["MediaJobOutput"] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputProcessingEventData, self).__init__(output=output, job_correlation_data=job_correlation_data, **kwargs)


class MediaJobOutputProgressEventData(msrest.serialization.Model):
    """Job Output Progress Event Data.

    :param label: Gets the Job output label.
    :type label: str
    :param progress: Gets the Job output progress.
    :type progress: long
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'long'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        progress: Optional[int] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputProgressEventData, self).__init__(**kwargs)
        self.label = label
        self.progress = progress
        self.job_correlation_data = job_correlation_data


class MediaJobOutputScheduledEventData(MediaJobOutputStateChangeEventData):
    """Job output scheduled event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :param output: Gets the output.
    :type output: ~event_grid_publisher_client.models.MediaJobOutput
    :param job_correlation_data: Gets the Job correlation data.
    :type job_correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'output': {'key': 'output', 'type': 'MediaJobOutput'},
        'job_correlation_data': {'key': 'jobCorrelationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        output: Optional["MediaJobOutput"] = None,
        job_correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobOutputScheduledEventData, self).__init__(output=output, job_correlation_data=job_correlation_data, **kwargs)


class MediaJobProcessingEventData(MediaJobStateChangeEventData):
    """Job processing event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :ivar state: The new state of the Job. Possible values include: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype state: str or ~event_grid_publisher_client.models.MediaJobState
    :param correlation_data: Gets the Job correlation data.
    :type correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'correlation_data': {'key': 'correlationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobProcessingEventData, self).__init__(correlation_data=correlation_data, **kwargs)


class MediaJobScheduledEventData(MediaJobStateChangeEventData):
    """Job scheduled event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar previous_state: The previous state of the Job. Possible values include: "Canceled",
     "Canceling", "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype previous_state: str or ~event_grid_publisher_client.models.MediaJobState
    :ivar state: The new state of the Job. Possible values include: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", "Scheduled".
    :vartype state: str or ~event_grid_publisher_client.models.MediaJobState
    :param correlation_data: Gets the Job correlation data.
    :type correlation_data: dict[str, str]
    """

    _validation = {
        'previous_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'previous_state': {'key': 'previousState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'correlation_data': {'key': 'correlationData', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MediaJobScheduledEventData, self).__init__(correlation_data=correlation_data, **kwargs)


class MediaLiveEventConnectionRejectedEventData(msrest.serialization.Model):
    """Encoder connection rejected event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ingest_url: Gets the ingest URL provided by the live event.
    :vartype ingest_url: str
    :ivar stream_id: Gets the stream Id.
    :vartype stream_id: str
    :ivar encoder_ip: Gets the remote IP.
    :vartype encoder_ip: str
    :ivar encoder_port: Gets the remote port.
    :vartype encoder_port: str
    :ivar result_code: Gets the result code.
    :vartype result_code: str
    """

    _validation = {
        'ingest_url': {'readonly': True},
        'stream_id': {'readonly': True},
        'encoder_ip': {'readonly': True},
        'encoder_port': {'readonly': True},
        'result_code': {'readonly': True},
    }

    _attribute_map = {
        'ingest_url': {'key': 'ingestUrl', 'type': 'str'},
        'stream_id': {'key': 'streamId', 'type': 'str'},
        'encoder_ip': {'key': 'encoderIp', 'type': 'str'},
        'encoder_port': {'key': 'encoderPort', 'type': 'str'},
        'result_code': {'key': 'resultCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventConnectionRejectedEventData, self).__init__(**kwargs)
        self.ingest_url = None
        self.stream_id = None
        self.encoder_ip = None
        self.encoder_port = None
        self.result_code = None


class MediaLiveEventEncoderConnectedEventData(msrest.serialization.Model):
    """Encoder connect event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ingest_url: Gets the ingest URL provided by the live event.
    :vartype ingest_url: str
    :ivar stream_id: Gets the stream Id.
    :vartype stream_id: str
    :ivar encoder_ip: Gets the remote IP.
    :vartype encoder_ip: str
    :ivar encoder_port: Gets the remote port.
    :vartype encoder_port: str
    """

    _validation = {
        'ingest_url': {'readonly': True},
        'stream_id': {'readonly': True},
        'encoder_ip': {'readonly': True},
        'encoder_port': {'readonly': True},
    }

    _attribute_map = {
        'ingest_url': {'key': 'ingestUrl', 'type': 'str'},
        'stream_id': {'key': 'streamId', 'type': 'str'},
        'encoder_ip': {'key': 'encoderIp', 'type': 'str'},
        'encoder_port': {'key': 'encoderPort', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventEncoderConnectedEventData, self).__init__(**kwargs)
        self.ingest_url = None
        self.stream_id = None
        self.encoder_ip = None
        self.encoder_port = None


class MediaLiveEventEncoderDisconnectedEventData(msrest.serialization.Model):
    """Encoder disconnected event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ingest_url: Gets the ingest URL provided by the live event.
    :vartype ingest_url: str
    :ivar stream_id: Gets the stream Id.
    :vartype stream_id: str
    :ivar encoder_ip: Gets the remote IP.
    :vartype encoder_ip: str
    :ivar encoder_port: Gets the remote port.
    :vartype encoder_port: str
    :ivar result_code: Gets the result code.
    :vartype result_code: str
    """

    _validation = {
        'ingest_url': {'readonly': True},
        'stream_id': {'readonly': True},
        'encoder_ip': {'readonly': True},
        'encoder_port': {'readonly': True},
        'result_code': {'readonly': True},
    }

    _attribute_map = {
        'ingest_url': {'key': 'ingestUrl', 'type': 'str'},
        'stream_id': {'key': 'streamId', 'type': 'str'},
        'encoder_ip': {'key': 'encoderIp', 'type': 'str'},
        'encoder_port': {'key': 'encoderPort', 'type': 'str'},
        'result_code': {'key': 'resultCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventEncoderDisconnectedEventData, self).__init__(**kwargs)
        self.ingest_url = None
        self.stream_id = None
        self.encoder_ip = None
        self.encoder_port = None
        self.result_code = None


class MediaLiveEventIncomingDataChunkDroppedEventData(msrest.serialization.Model):
    """Ingest fragment dropped event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Gets the timestamp of the data chunk dropped.
    :vartype timestamp: str
    :ivar track_type: Gets the type of the track (Audio / Video).
    :vartype track_type: str
    :ivar bitrate: Gets the bitrate of the track.
    :vartype bitrate: long
    :ivar timescale: Gets the timescale of the Timestamp.
    :vartype timescale: str
    :ivar result_code: Gets the result code for fragment drop operation.
    :vartype result_code: str
    :ivar track_name: Gets the name of the track for which fragment is dropped.
    :vartype track_name: str
    """

    _validation = {
        'timestamp': {'readonly': True},
        'track_type': {'readonly': True},
        'bitrate': {'readonly': True},
        'timescale': {'readonly': True},
        'result_code': {'readonly': True},
        'track_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'str'},
        'track_type': {'key': 'trackType', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'long'},
        'timescale': {'key': 'timescale', 'type': 'str'},
        'result_code': {'key': 'resultCode', 'type': 'str'},
        'track_name': {'key': 'trackName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventIncomingDataChunkDroppedEventData, self).__init__(**kwargs)
        self.timestamp = None
        self.track_type = None
        self.bitrate = None
        self.timescale = None
        self.result_code = None
        self.track_name = None


class MediaLiveEventIncomingStreamReceivedEventData(msrest.serialization.Model):
    """Encoder connect event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ingest_url: Gets the ingest URL provided by the live event.
    :vartype ingest_url: str
    :ivar track_type: Gets the type of the track (Audio / Video).
    :vartype track_type: str
    :ivar track_name: Gets the track name.
    :vartype track_name: str
    :ivar bitrate: Gets the bitrate of the track.
    :vartype bitrate: long
    :ivar encoder_ip: Gets the remote IP.
    :vartype encoder_ip: str
    :ivar encoder_port: Gets the remote port.
    :vartype encoder_port: str
    :ivar timestamp: Gets the first timestamp of the data chunk received.
    :vartype timestamp: str
    :ivar duration: Gets the duration of the first data chunk.
    :vartype duration: str
    :ivar timescale: Gets the timescale in which timestamp is represented.
    :vartype timescale: str
    """

    _validation = {
        'ingest_url': {'readonly': True},
        'track_type': {'readonly': True},
        'track_name': {'readonly': True},
        'bitrate': {'readonly': True},
        'encoder_ip': {'readonly': True},
        'encoder_port': {'readonly': True},
        'timestamp': {'readonly': True},
        'duration': {'readonly': True},
        'timescale': {'readonly': True},
    }

    _attribute_map = {
        'ingest_url': {'key': 'ingestUrl', 'type': 'str'},
        'track_type': {'key': 'trackType', 'type': 'str'},
        'track_name': {'key': 'trackName', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'long'},
        'encoder_ip': {'key': 'encoderIp', 'type': 'str'},
        'encoder_port': {'key': 'encoderPort', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'str'},
        'timescale': {'key': 'timescale', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventIncomingStreamReceivedEventData, self).__init__(**kwargs)
        self.ingest_url = None
        self.track_type = None
        self.track_name = None
        self.bitrate = None
        self.encoder_ip = None
        self.encoder_port = None
        self.timestamp = None
        self.duration = None
        self.timescale = None


class MediaLiveEventIncomingStreamsOutOfSyncEventData(msrest.serialization.Model):
    """Incoming streams out of sync event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min_last_timestamp: Gets the minimum last timestamp received.
    :vartype min_last_timestamp: str
    :ivar type_of_stream_with_min_last_timestamp: Gets the type of stream with minimum last
     timestamp.
    :vartype type_of_stream_with_min_last_timestamp: str
    :ivar max_last_timestamp: Gets the maximum timestamp among all the tracks (audio or video).
    :vartype max_last_timestamp: str
    :ivar type_of_stream_with_max_last_timestamp: Gets the type of stream with maximum last
     timestamp.
    :vartype type_of_stream_with_max_last_timestamp: str
    :ivar timescale_of_min_last_timestamp: Gets the timescale in which "MinLastTimestamp" is
     represented.
    :vartype timescale_of_min_last_timestamp: str
    :ivar timescale_of_max_last_timestamp: Gets the timescale in which "MaxLastTimestamp" is
     represented.
    :vartype timescale_of_max_last_timestamp: str
    """

    _validation = {
        'min_last_timestamp': {'readonly': True},
        'type_of_stream_with_min_last_timestamp': {'readonly': True},
        'max_last_timestamp': {'readonly': True},
        'type_of_stream_with_max_last_timestamp': {'readonly': True},
        'timescale_of_min_last_timestamp': {'readonly': True},
        'timescale_of_max_last_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'min_last_timestamp': {'key': 'minLastTimestamp', 'type': 'str'},
        'type_of_stream_with_min_last_timestamp': {'key': 'typeOfStreamWithMinLastTimestamp', 'type': 'str'},
        'max_last_timestamp': {'key': 'maxLastTimestamp', 'type': 'str'},
        'type_of_stream_with_max_last_timestamp': {'key': 'typeOfStreamWithMaxLastTimestamp', 'type': 'str'},
        'timescale_of_min_last_timestamp': {'key': 'timescaleOfMinLastTimestamp', 'type': 'str'},
        'timescale_of_max_last_timestamp': {'key': 'timescaleOfMaxLastTimestamp', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventIncomingStreamsOutOfSyncEventData, self).__init__(**kwargs)
        self.min_last_timestamp = None
        self.type_of_stream_with_min_last_timestamp = None
        self.max_last_timestamp = None
        self.type_of_stream_with_max_last_timestamp = None
        self.timescale_of_min_last_timestamp = None
        self.timescale_of_max_last_timestamp = None


class MediaLiveEventIncomingVideoStreamsOutOfSyncEventData(msrest.serialization.Model):
    """Incoming video stream out of synch event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar first_timestamp: Gets the first timestamp received for one of the quality levels.
    :vartype first_timestamp: str
    :ivar first_duration: Gets the duration of the data chunk with first timestamp.
    :vartype first_duration: str
    :ivar second_timestamp: Gets the timestamp received for some other quality levels.
    :vartype second_timestamp: str
    :ivar second_duration: Gets the duration of the data chunk with second timestamp.
    :vartype second_duration: str
    :ivar timescale: Gets the timescale in which both the timestamps and durations are represented.
    :vartype timescale: str
    """

    _validation = {
        'first_timestamp': {'readonly': True},
        'first_duration': {'readonly': True},
        'second_timestamp': {'readonly': True},
        'second_duration': {'readonly': True},
        'timescale': {'readonly': True},
    }

    _attribute_map = {
        'first_timestamp': {'key': 'firstTimestamp', 'type': 'str'},
        'first_duration': {'key': 'firstDuration', 'type': 'str'},
        'second_timestamp': {'key': 'secondTimestamp', 'type': 'str'},
        'second_duration': {'key': 'secondDuration', 'type': 'str'},
        'timescale': {'key': 'timescale', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventIncomingVideoStreamsOutOfSyncEventData, self).__init__(**kwargs)
        self.first_timestamp = None
        self.first_duration = None
        self.second_timestamp = None
        self.second_duration = None
        self.timescale = None


class MediaLiveEventIngestHeartbeatEventData(msrest.serialization.Model):
    """Ingest fragment dropped event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar track_type: Gets the type of the track (Audio / Video).
    :vartype track_type: str
    :ivar track_name: Gets the track name.
    :vartype track_name: str
    :ivar bitrate: Gets the bitrate of the track.
    :vartype bitrate: long
    :ivar incoming_bitrate: Gets the incoming bitrate.
    :vartype incoming_bitrate: long
    :ivar last_timestamp: Gets the last timestamp.
    :vartype last_timestamp: str
    :ivar timescale: Gets the timescale of the last timestamp.
    :vartype timescale: str
    :ivar overlap_count: Gets the fragment Overlap count.
    :vartype overlap_count: long
    :ivar discontinuity_count: Gets the fragment Discontinuity count.
    :vartype discontinuity_count: long
    :ivar nonincreasing_count: Gets Non increasing count.
    :vartype nonincreasing_count: long
    :ivar unexpected_bitrate: Gets a value indicating whether unexpected bitrate is present or not.
    :vartype unexpected_bitrate: bool
    :ivar state: Gets the state of the live event.
    :vartype state: str
    :ivar healthy: Gets a value indicating whether preview is healthy or not.
    :vartype healthy: bool
    """

    _validation = {
        'track_type': {'readonly': True},
        'track_name': {'readonly': True},
        'bitrate': {'readonly': True},
        'incoming_bitrate': {'readonly': True},
        'last_timestamp': {'readonly': True},
        'timescale': {'readonly': True},
        'overlap_count': {'readonly': True},
        'discontinuity_count': {'readonly': True},
        'nonincreasing_count': {'readonly': True},
        'unexpected_bitrate': {'readonly': True},
        'state': {'readonly': True},
        'healthy': {'readonly': True},
    }

    _attribute_map = {
        'track_type': {'key': 'trackType', 'type': 'str'},
        'track_name': {'key': 'trackName', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'long'},
        'incoming_bitrate': {'key': 'incomingBitrate', 'type': 'long'},
        'last_timestamp': {'key': 'lastTimestamp', 'type': 'str'},
        'timescale': {'key': 'timescale', 'type': 'str'},
        'overlap_count': {'key': 'overlapCount', 'type': 'long'},
        'discontinuity_count': {'key': 'discontinuityCount', 'type': 'long'},
        'nonincreasing_count': {'key': 'nonincreasingCount', 'type': 'long'},
        'unexpected_bitrate': {'key': 'unexpectedBitrate', 'type': 'bool'},
        'state': {'key': 'state', 'type': 'str'},
        'healthy': {'key': 'healthy', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventIngestHeartbeatEventData, self).__init__(**kwargs)
        self.track_type = None
        self.track_name = None
        self.bitrate = None
        self.incoming_bitrate = None
        self.last_timestamp = None
        self.timescale = None
        self.overlap_count = None
        self.discontinuity_count = None
        self.nonincreasing_count = None
        self.unexpected_bitrate = None
        self.state = None
        self.healthy = None


class MediaLiveEventTrackDiscontinuityDetectedEventData(msrest.serialization.Model):
    """Ingest track discontinuity detected event data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar track_type: Gets the type of the track (Audio / Video).
    :vartype track_type: str
    :ivar track_name: Gets the track name.
    :vartype track_name: str
    :ivar bitrate: Gets the bitrate.
    :vartype bitrate: long
    :ivar previous_timestamp: Gets the timestamp of the previous fragment.
    :vartype previous_timestamp: str
    :ivar new_timestamp: Gets the timestamp of the current fragment.
    :vartype new_timestamp: str
    :ivar timescale: Gets the timescale in which both timestamps and discontinuity gap are
     represented.
    :vartype timescale: str
    :ivar discontinuity_gap: Gets the discontinuity gap between PreviousTimestamp and NewTimestamp.
    :vartype discontinuity_gap: str
    """

    _validation = {
        'track_type': {'readonly': True},
        'track_name': {'readonly': True},
        'bitrate': {'readonly': True},
        'previous_timestamp': {'readonly': True},
        'new_timestamp': {'readonly': True},
        'timescale': {'readonly': True},
        'discontinuity_gap': {'readonly': True},
    }

    _attribute_map = {
        'track_type': {'key': 'trackType', 'type': 'str'},
        'track_name': {'key': 'trackName', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'long'},
        'previous_timestamp': {'key': 'previousTimestamp', 'type': 'str'},
        'new_timestamp': {'key': 'newTimestamp', 'type': 'str'},
        'timescale': {'key': 'timescale', 'type': 'str'},
        'discontinuity_gap': {'key': 'discontinuityGap', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaLiveEventTrackDiscontinuityDetectedEventData, self).__init__(**kwargs)
        self.track_type = None
        self.track_name = None
        self.bitrate = None
        self.previous_timestamp = None
        self.new_timestamp = None
        self.timescale = None
        self.discontinuity_gap = None


class MicrosoftTeamsUserIdentifierModel(msrest.serialization.Model):
    """A Microsoft Teams user.

    All required parameters must be populated in order to send to Azure.

    :param user_id: Required. The Id of the Microsoft Teams user. If not anonymous, this is the AAD
     object Id of the user.
    :type user_id: str
    :param is_anonymous: True if the Microsoft Teams user is anonymous. By default false if
     missing.
    :type is_anonymous: bool
    :param cloud: The cloud that the Microsoft Teams user belongs to. By default 'public' if
     missing. Possible values include: "public", "dod", "gcch".
    :type cloud: str or ~event_grid_publisher_client.models.CommunicationCloudEnvironmentModel
    """

    _validation = {
        'user_id': {'required': True},
    }

    _attribute_map = {
        'user_id': {'key': 'userId', 'type': 'str'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'cloud': {'key': 'cloud', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_id: str,
        is_anonymous: Optional[bool] = None,
        cloud: Optional[Union[str, "CommunicationCloudEnvironmentModel"]] = None,
        **kwargs
    ):
        super(MicrosoftTeamsUserIdentifierModel, self).__init__(**kwargs)
        self.user_id = user_id
        self.is_anonymous = is_anonymous
        self.cloud = cloud


class PhoneNumberIdentifierModel(msrest.serialization.Model):
    """A phone number.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The phone number in E.164 format.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(PhoneNumberIdentifierModel, self).__init__(**kwargs)
        self.value = value


class RedisExportRDBCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Cache.ExportRDBCompleted event.

    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param name: The name of this event.
    :type name: str
    :param status: The status of this event. Failed or  succeeded.
    :type status: str
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RedisExportRDBCompletedEventData, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.name = name
        self.status = status


class RedisImportRDBCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Cache.ImportRDBCompleted event.

    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param name: The name of this event.
    :type name: str
    :param status: The status of this event. Failed or  succeeded.
    :type status: str
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RedisImportRDBCompletedEventData, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.name = name
        self.status = status


class RedisPatchingCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Cache.PatchingCompleted event.

    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param name: The name of this event.
    :type name: str
    :param status: The status of this event. Failed or  succeeded.
    :type status: str
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RedisPatchingCompletedEventData, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.name = name
        self.status = status


class RedisScalingCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Cache.ScalingCompleted event.

    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param name: The name of this event.
    :type name: str
    :param status: The status of this event. Failed or  succeeded.
    :type status: str
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RedisScalingCompletedEventData, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.name = name
        self.status = status


class ResourceActionCancelData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Resources.ResourceActionCancel event. This is raised when a resource action operation is canceled.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceActionCancelData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceActionFailureData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceActionFailure event. This is raised when a resource action operation fails.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceActionFailureData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceActionSuccessData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceActionSuccess event. This is raised when a resource action operation succeeds.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceActionSuccessData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceDeleteCancelData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Resources.ResourceDeleteCancel event. This is raised when a resource delete operation is canceled.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceDeleteCancelData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceDeleteFailureData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceDeleteFailure event. This is raised when a resource delete operation fails.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceDeleteFailureData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceDeleteSuccessData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceDeleteSuccess event. This is raised when a resource delete operation succeeds.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceDeleteSuccessData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceWriteCancelData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceWriteCancel event. This is raised when a resource create or update operation is canceled.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceWriteCancelData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceWriteFailureData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceWriteFailure event. This is raised when a resource create or update operation fails.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceWriteFailureData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ResourceWriteSuccessData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.Resources.ResourceWriteSuccess event. This is raised when a resource create or update operation succeeds.

    :param tenant_id: The tenant ID of the resource.
    :type tenant_id: str
    :param subscription_id: The subscription ID of the resource.
    :type subscription_id: str
    :param resource_group: The resource group of the resource.
    :type resource_group: str
    :param resource_provider: The resource provider performing the operation.
    :type resource_provider: str
    :param resource_uri: The URI of the resource in the operation.
    :type resource_uri: str
    :param operation_name: The operation that was performed.
    :type operation_name: str
    :param status: The status of the operation.
    :type status: str
    :param authorization: The requested authorization for the operation.
    :type authorization: str
    :param claims: The properties of the claims.
    :type claims: str
    :param correlation_id: An operation ID used for troubleshooting.
    :type correlation_id: str
    :param http_request: The details of the operation.
    :type http_request: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_provider': {'key': 'resourceProvider', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'authorization': {'key': 'authorization', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'http_request': {'key': 'httpRequest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_provider: Optional[str] = None,
        resource_uri: Optional[str] = None,
        operation_name: Optional[str] = None,
        status: Optional[str] = None,
        authorization: Optional[str] = None,
        claims: Optional[str] = None,
        correlation_id: Optional[str] = None,
        http_request: Optional[str] = None,
        **kwargs
    ):
        super(ResourceWriteSuccessData, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.resource_provider = resource_provider
        self.resource_uri = resource_uri
        self.operation_name = operation_name
        self.status = status
        self.authorization = authorization
        self.claims = claims
        self.correlation_id = correlation_id
        self.http_request = http_request


class ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ServiceBus.ActiveMessagesAvailablePeriodicNotifications event.

    :param namespace_name: The namespace name of the Microsoft.ServiceBus resource.
    :type namespace_name: str
    :param request_uri: The endpoint of the Microsoft.ServiceBus resource.
    :type request_uri: str
    :param entity_type: The entity type of the Microsoft.ServiceBus resource. Could be one of
     'queue' or 'subscriber'.
    :type entity_type: str
    :param queue_name: The name of the Microsoft.ServiceBus queue. If the entity type is of type
     'subscriber', then this value will be null.
    :type queue_name: str
    :param topic_name: The name of the Microsoft.ServiceBus topic. If the entity type is of type
     'queue', then this value will be null.
    :type topic_name: str
    :param subscription_name: The name of the Microsoft.ServiceBus topic's subscription. If the
     entity type is of type 'queue', then this value will be null.
    :type subscription_name: str
    """

    _attribute_map = {
        'namespace_name': {'key': 'namespaceName', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'topic_name': {'key': 'topicName', 'type': 'str'},
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        namespace_name: Optional[str] = None,
        request_uri: Optional[str] = None,
        entity_type: Optional[str] = None,
        queue_name: Optional[str] = None,
        topic_name: Optional[str] = None,
        subscription_name: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData, self).__init__(**kwargs)
        self.namespace_name = namespace_name
        self.request_uri = request_uri
        self.entity_type = entity_type
        self.queue_name = queue_name
        self.topic_name = topic_name
        self.subscription_name = subscription_name


class ServiceBusActiveMessagesAvailableWithNoListenersEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ServiceBus.ActiveMessagesAvailableWithNoListeners event.

    :param namespace_name: The namespace name of the Microsoft.ServiceBus resource.
    :type namespace_name: str
    :param request_uri: The endpoint of the Microsoft.ServiceBus resource.
    :type request_uri: str
    :param entity_type: The entity type of the Microsoft.ServiceBus resource. Could be one of
     'queue' or 'subscriber'.
    :type entity_type: str
    :param queue_name: The name of the Microsoft.ServiceBus queue. If the entity type is of type
     'subscriber', then this value will be null.
    :type queue_name: str
    :param topic_name: The name of the Microsoft.ServiceBus topic. If the entity type is of type
     'queue', then this value will be null.
    :type topic_name: str
    :param subscription_name: The name of the Microsoft.ServiceBus topic's subscription. If the
     entity type is of type 'queue', then this value will be null.
    :type subscription_name: str
    """

    _attribute_map = {
        'namespace_name': {'key': 'namespaceName', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'topic_name': {'key': 'topicName', 'type': 'str'},
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        namespace_name: Optional[str] = None,
        request_uri: Optional[str] = None,
        entity_type: Optional[str] = None,
        queue_name: Optional[str] = None,
        topic_name: Optional[str] = None,
        subscription_name: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusActiveMessagesAvailableWithNoListenersEventData, self).__init__(**kwargs)
        self.namespace_name = namespace_name
        self.request_uri = request_uri
        self.entity_type = entity_type
        self.queue_name = queue_name
        self.topic_name = topic_name
        self.subscription_name = subscription_name


class ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ServiceBus.DeadletterMessagesAvailablePeriodicNotifications event.

    :param namespace_name: The namespace name of the Microsoft.ServiceBus resource.
    :type namespace_name: str
    :param request_uri: The endpoint of the Microsoft.ServiceBus resource.
    :type request_uri: str
    :param entity_type: The entity type of the Microsoft.ServiceBus resource. Could be one of
     'queue' or 'subscriber'.
    :type entity_type: str
    :param queue_name: The name of the Microsoft.ServiceBus queue. If the entity type is of type
     'subscriber', then this value will be null.
    :type queue_name: str
    :param topic_name: The name of the Microsoft.ServiceBus topic. If the entity type is of type
     'queue', then this value will be null.
    :type topic_name: str
    :param subscription_name: The name of the Microsoft.ServiceBus topic's subscription. If the
     entity type is of type 'queue', then this value will be null.
    :type subscription_name: str
    """

    _attribute_map = {
        'namespace_name': {'key': 'namespaceName', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'topic_name': {'key': 'topicName', 'type': 'str'},
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        namespace_name: Optional[str] = None,
        request_uri: Optional[str] = None,
        entity_type: Optional[str] = None,
        queue_name: Optional[str] = None,
        topic_name: Optional[str] = None,
        subscription_name: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData, self).__init__(**kwargs)
        self.namespace_name = namespace_name
        self.request_uri = request_uri
        self.entity_type = entity_type
        self.queue_name = queue_name
        self.topic_name = topic_name
        self.subscription_name = subscription_name


class ServiceBusDeadletterMessagesAvailableWithNoListenersEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.ServiceBus.DeadletterMessagesAvailableWithNoListenersEvent event.

    :param namespace_name: The namespace name of the Microsoft.ServiceBus resource.
    :type namespace_name: str
    :param request_uri: The endpoint of the Microsoft.ServiceBus resource.
    :type request_uri: str
    :param entity_type: The entity type of the Microsoft.ServiceBus resource. Could be one of
     'queue' or 'subscriber'.
    :type entity_type: str
    :param queue_name: The name of the Microsoft.ServiceBus queue. If the entity type is of type
     'subscriber', then this value will be null.
    :type queue_name: str
    :param topic_name: The name of the Microsoft.ServiceBus topic. If the entity type is of type
     'queue', then this value will be null.
    :type topic_name: str
    :param subscription_name: The name of the Microsoft.ServiceBus topic's subscription. If the
     entity type is of type 'queue', then this value will be null.
    :type subscription_name: str
    """

    _attribute_map = {
        'namespace_name': {'key': 'namespaceName', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'topic_name': {'key': 'topicName', 'type': 'str'},
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        namespace_name: Optional[str] = None,
        request_uri: Optional[str] = None,
        entity_type: Optional[str] = None,
        queue_name: Optional[str] = None,
        topic_name: Optional[str] = None,
        subscription_name: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusDeadletterMessagesAvailableWithNoListenersEventData, self).__init__(**kwargs)
        self.namespace_name = namespace_name
        self.request_uri = request_uri
        self.entity_type = entity_type
        self.queue_name = queue_name
        self.topic_name = topic_name
        self.subscription_name = subscription_name


class SignalRServiceClientConnectionConnectedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.SignalRService.ClientConnectionConnected event.

    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param hub_name: The hub of connected client connection.
    :type hub_name: str
    :param connection_id: The connection Id of connected client connection.
    :type connection_id: str
    :param user_id: The user Id of connected client connection.
    :type user_id: str
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'connection_id': {'key': 'connectionId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        hub_name: Optional[str] = None,
        connection_id: Optional[str] = None,
        user_id: Optional[str] = None,
        **kwargs
    ):
        super(SignalRServiceClientConnectionConnectedEventData, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.hub_name = hub_name
        self.connection_id = connection_id
        self.user_id = user_id


class SignalRServiceClientConnectionDisconnectedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.SignalRService.ClientConnectionDisconnected event.

    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param hub_name: The hub of connected client connection.
    :type hub_name: str
    :param connection_id: The connection Id of connected client connection.
    :type connection_id: str
    :param user_id: The user Id of connected client connection.
    :type user_id: str
    :param error_message: The message of error that cause the client connection disconnected.
    :type error_message: str
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'connection_id': {'key': 'connectionId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        hub_name: Optional[str] = None,
        connection_id: Optional[str] = None,
        user_id: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        super(SignalRServiceClientConnectionDisconnectedEventData, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.hub_name = hub_name
        self.connection_id = connection_id
        self.user_id = user_id
        self.error_message = error_message


class StorageBlobCreatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Storage.BlobCreated event.

    :param api: The name of the API/operation that triggered this event.
    :type api: str
    :param client_request_id: A request id provided by the client of the storage API operation that
     triggered this event.
    :type client_request_id: str
    :param request_id: The request id generated by the Storage service for the storage API
     operation that triggered this event.
    :type request_id: str
    :param e_tag: The etag of the blob at the time this event was triggered.
    :type e_tag: str
    :param content_type: The content type of the blob. This is the same as what would be returned
     in the Content-Type header from the blob.
    :type content_type: str
    :param content_length: The size of the blob in bytes. This is the same as what would be
     returned in the Content-Length header from the blob.
    :type content_length: long
    :param content_offset: The offset of the blob in bytes.
    :type content_offset: long
    :param blob_type: The type of blob.
    :type blob_type: str
    :param url: The path to the blob.
    :type url: str
    :param sequencer: An opaque string value representing the logical sequence of events for any
     particular blob name. Users can use standard string comparison to understand the relative
     sequence of two events on the same blob name.
    :type sequencer: str
    :param identity: The identity of the requester that triggered this event.
    :type identity: str
    :param storage_diagnostics: For service use only. Diagnostic data occasionally included by the
     Azure Storage service. This property should be ignored by event consumers.
    :type storage_diagnostics: object
    """

    _attribute_map = {
        'api': {'key': 'api', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_length': {'key': 'contentLength', 'type': 'long'},
        'content_offset': {'key': 'contentOffset', 'type': 'long'},
        'blob_type': {'key': 'blobType', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'sequencer': {'key': 'sequencer', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'storage_diagnostics': {'key': 'storageDiagnostics', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        api: Optional[str] = None,
        client_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        e_tag: Optional[str] = None,
        content_type: Optional[str] = None,
        content_length: Optional[int] = None,
        content_offset: Optional[int] = None,
        blob_type: Optional[str] = None,
        url: Optional[str] = None,
        sequencer: Optional[str] = None,
        identity: Optional[str] = None,
        storage_diagnostics: Optional[object] = None,
        **kwargs
    ):
        super(StorageBlobCreatedEventData, self).__init__(**kwargs)
        self.api = api
        self.client_request_id = client_request_id
        self.request_id = request_id
        self.e_tag = e_tag
        self.content_type = content_type
        self.content_length = content_length
        self.content_offset = content_offset
        self.blob_type = blob_type
        self.url = url
        self.sequencer = sequencer
        self.identity = identity
        self.storage_diagnostics = storage_diagnostics


class StorageBlobDeletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Storage.BlobDeleted event.

    :param api: The name of the API/operation that triggered this event.
    :type api: str
    :param client_request_id: A request id provided by the client of the storage API operation that
     triggered this event.
    :type client_request_id: str
    :param request_id: The request id generated by the Storage service for the storage API
     operation that triggered this event.
    :type request_id: str
    :param content_type: The content type of the blob. This is the same as what would be returned
     in the Content-Type header from the blob.
    :type content_type: str
    :param blob_type: The type of blob.
    :type blob_type: str
    :param url: The path to the blob.
    :type url: str
    :param sequencer: An opaque string value representing the logical sequence of events for any
     particular blob name. Users can use standard string comparison to understand the relative
     sequence of two events on the same blob name.
    :type sequencer: str
    :param identity: The identity of the requester that triggered this event.
    :type identity: str
    :param storage_diagnostics: For service use only. Diagnostic data occasionally included by the
     Azure Storage service. This property should be ignored by event consumers.
    :type storage_diagnostics: object
    """

    _attribute_map = {
        'api': {'key': 'api', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'blob_type': {'key': 'blobType', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'sequencer': {'key': 'sequencer', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'storage_diagnostics': {'key': 'storageDiagnostics', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        api: Optional[str] = None,
        client_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        content_type: Optional[str] = None,
        blob_type: Optional[str] = None,
        url: Optional[str] = None,
        sequencer: Optional[str] = None,
        identity: Optional[str] = None,
        storage_diagnostics: Optional[object] = None,
        **kwargs
    ):
        super(StorageBlobDeletedEventData, self).__init__(**kwargs)
        self.api = api
        self.client_request_id = client_request_id
        self.request_id = request_id
        self.content_type = content_type
        self.blob_type = blob_type
        self.url = url
        self.sequencer = sequencer
        self.identity = identity
        self.storage_diagnostics = storage_diagnostics


class StorageBlobRenamedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Storage.BlobRenamed event.

    :param api: The name of the API/operation that triggered this event.
    :type api: str
    :param client_request_id: A request id provided by the client of the storage API operation that
     triggered this event.
    :type client_request_id: str
    :param request_id: The request id generated by the storage service for the storage API
     operation that triggered this event.
    :type request_id: str
    :param source_url: The path to the blob that was renamed.
    :type source_url: str
    :param destination_url: The new path to the blob after the rename operation.
    :type destination_url: str
    :param sequencer: An opaque string value representing the logical sequence of events for any
     particular blob name. Users can use standard string comparison to understand the relative
     sequence of two events on the same blob name.
    :type sequencer: str
    :param identity: The identity of the requester that triggered this event.
    :type identity: str
    :param storage_diagnostics: For service use only. Diagnostic data occasionally included by the
     Azure Storage service. This property should be ignored by event consumers.
    :type storage_diagnostics: object
    """

    _attribute_map = {
        'api': {'key': 'api', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'source_url': {'key': 'sourceUrl', 'type': 'str'},
        'destination_url': {'key': 'destinationUrl', 'type': 'str'},
        'sequencer': {'key': 'sequencer', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'storage_diagnostics': {'key': 'storageDiagnostics', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        api: Optional[str] = None,
        client_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        source_url: Optional[str] = None,
        destination_url: Optional[str] = None,
        sequencer: Optional[str] = None,
        identity: Optional[str] = None,
        storage_diagnostics: Optional[object] = None,
        **kwargs
    ):
        super(StorageBlobRenamedEventData, self).__init__(**kwargs)
        self.api = api
        self.client_request_id = client_request_id
        self.request_id = request_id
        self.source_url = source_url
        self.destination_url = destination_url
        self.sequencer = sequencer
        self.identity = identity
        self.storage_diagnostics = storage_diagnostics


class StorageDirectoryCreatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Storage.DirectoryCreated event.

    :param api: The name of the API/operation that triggered this event.
    :type api: str
    :param client_request_id: A request id provided by the client of the storage API operation that
     triggered this event.
    :type client_request_id: str
    :param request_id: The request id generated by the storage service for the storage API
     operation that triggered this event.
    :type request_id: str
    :param e_tag: The etag of the directory at the time this event was triggered.
    :type e_tag: str
    :param url: The path to the directory.
    :type url: str
    :param sequencer: An opaque string value representing the logical sequence of events for any
     particular directory name. Users can use standard string comparison to understand the relative
     sequence of two events on the same directory name.
    :type sequencer: str
    :param identity: The identity of the requester that triggered this event.
    :type identity: str
    :param storage_diagnostics: For service use only. Diagnostic data occasionally included by the
     Azure Storage service. This property should be ignored by event consumers.
    :type storage_diagnostics: object
    """

    _attribute_map = {
        'api': {'key': 'api', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'sequencer': {'key': 'sequencer', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'storage_diagnostics': {'key': 'storageDiagnostics', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        api: Optional[str] = None,
        client_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        e_tag: Optional[str] = None,
        url: Optional[str] = None,
        sequencer: Optional[str] = None,
        identity: Optional[str] = None,
        storage_diagnostics: Optional[object] = None,
        **kwargs
    ):
        super(StorageDirectoryCreatedEventData, self).__init__(**kwargs)
        self.api = api
        self.client_request_id = client_request_id
        self.request_id = request_id
        self.e_tag = e_tag
        self.url = url
        self.sequencer = sequencer
        self.identity = identity
        self.storage_diagnostics = storage_diagnostics


class StorageDirectoryDeletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Storage.DirectoryDeleted event.

    :param api: The name of the API/operation that triggered this event.
    :type api: str
    :param client_request_id: A request id provided by the client of the storage API operation that
     triggered this event.
    :type client_request_id: str
    :param request_id: The request id generated by the storage service for the storage API
     operation that triggered this event.
    :type request_id: str
    :param url: The path to the deleted directory.
    :type url: str
    :param recursive: Is this event for a recursive delete operation.
    :type recursive: bool
    :param sequencer: An opaque string value representing the logical sequence of events for any
     particular directory name. Users can use standard string comparison to understand the relative
     sequence of two events on the same directory name.
    :type sequencer: str
    :param identity: The identity of the requester that triggered this event.
    :type identity: str
    :param storage_diagnostics: For service use only. Diagnostic data occasionally included by the
     Azure Storage service. This property should be ignored by event consumers.
    :type storage_diagnostics: object
    """

    _attribute_map = {
        'api': {'key': 'api', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'recursive': {'key': 'recursive', 'type': 'bool'},
        'sequencer': {'key': 'sequencer', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'storage_diagnostics': {'key': 'storageDiagnostics', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        api: Optional[str] = None,
        client_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        url: Optional[str] = None,
        recursive: Optional[bool] = None,
        sequencer: Optional[str] = None,
        identity: Optional[str] = None,
        storage_diagnostics: Optional[object] = None,
        **kwargs
    ):
        super(StorageDirectoryDeletedEventData, self).__init__(**kwargs)
        self.api = api
        self.client_request_id = client_request_id
        self.request_id = request_id
        self.url = url
        self.recursive = recursive
        self.sequencer = sequencer
        self.identity = identity
        self.storage_diagnostics = storage_diagnostics


class StorageDirectoryRenamedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Storage.DirectoryRenamed event.

    :param api: The name of the API/operation that triggered this event.
    :type api: str
    :param client_request_id: A request id provided by the client of the storage API operation that
     triggered this event.
    :type client_request_id: str
    :param request_id: The request id generated by the storage service for the storage API
     operation that triggered this event.
    :type request_id: str
    :param source_url: The path to the directory that was renamed.
    :type source_url: str
    :param destination_url: The new path to the directory after the rename operation.
    :type destination_url: str
    :param sequencer: An opaque string value representing the logical sequence of events for any
     particular directory name. Users can use standard string comparison to understand the relative
     sequence of two events on the same directory name.
    :type sequencer: str
    :param identity: The identity of the requester that triggered this event.
    :type identity: str
    :param storage_diagnostics: For service use only. Diagnostic data occasionally included by the
     Azure Storage service. This property should be ignored by event consumers.
    :type storage_diagnostics: object
    """

    _attribute_map = {
        'api': {'key': 'api', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'source_url': {'key': 'sourceUrl', 'type': 'str'},
        'destination_url': {'key': 'destinationUrl', 'type': 'str'},
        'sequencer': {'key': 'sequencer', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'storage_diagnostics': {'key': 'storageDiagnostics', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        api: Optional[str] = None,
        client_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        source_url: Optional[str] = None,
        destination_url: Optional[str] = None,
        sequencer: Optional[str] = None,
        identity: Optional[str] = None,
        storage_diagnostics: Optional[object] = None,
        **kwargs
    ):
        super(StorageDirectoryRenamedEventData, self).__init__(**kwargs)
        self.api = api
        self.client_request_id = client_request_id
        self.request_id = request_id
        self.source_url = source_url
        self.destination_url = destination_url
        self.sequencer = sequencer
        self.identity = identity
        self.storage_diagnostics = storage_diagnostics


class StorageLifecyclePolicyActionSummaryDetail(msrest.serialization.Model):
    """Execution statistics of a specific policy action in a Blob Management cycle.

    :param total_objects_count: Total number of objects to be acted on by this action.
    :type total_objects_count: long
    :param success_count: Number of success operations of this action.
    :type success_count: long
    :param error_list: Error messages of this action if any.
    :type error_list: str
    """

    _attribute_map = {
        'total_objects_count': {'key': 'totalObjectsCount', 'type': 'long'},
        'success_count': {'key': 'successCount', 'type': 'long'},
        'error_list': {'key': 'errorList', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        total_objects_count: Optional[int] = None,
        success_count: Optional[int] = None,
        error_list: Optional[str] = None,
        **kwargs
    ):
        super(StorageLifecyclePolicyActionSummaryDetail, self).__init__(**kwargs)
        self.total_objects_count = total_objects_count
        self.success_count = success_count
        self.error_list = error_list


class StorageLifecyclePolicyCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Storage.LifecyclePolicyCompleted event.

    :param schedule_time: The time the policy task was scheduled.
    :type schedule_time: str
    :param delete_summary: Execution statistics of a specific policy action in a Blob Management
     cycle.
    :type delete_summary:
     ~event_grid_publisher_client.models.StorageLifecyclePolicyActionSummaryDetail
    :param tier_to_cool_summary: Execution statistics of a specific policy action in a Blob
     Management cycle.
    :type tier_to_cool_summary:
     ~event_grid_publisher_client.models.StorageLifecyclePolicyActionSummaryDetail
    :param tier_to_archive_summary: Execution statistics of a specific policy action in a Blob
     Management cycle.
    :type tier_to_archive_summary:
     ~event_grid_publisher_client.models.StorageLifecyclePolicyActionSummaryDetail
    """

    _attribute_map = {
        'schedule_time': {'key': 'scheduleTime', 'type': 'str'},
        'delete_summary': {'key': 'deleteSummary', 'type': 'StorageLifecyclePolicyActionSummaryDetail'},
        'tier_to_cool_summary': {'key': 'tierToCoolSummary', 'type': 'StorageLifecyclePolicyActionSummaryDetail'},
        'tier_to_archive_summary': {'key': 'tierToArchiveSummary', 'type': 'StorageLifecyclePolicyActionSummaryDetail'},
    }

    def __init__(
        self,
        *,
        schedule_time: Optional[str] = None,
        delete_summary: Optional["StorageLifecyclePolicyActionSummaryDetail"] = None,
        tier_to_cool_summary: Optional["StorageLifecyclePolicyActionSummaryDetail"] = None,
        tier_to_archive_summary: Optional["StorageLifecyclePolicyActionSummaryDetail"] = None,
        **kwargs
    ):
        super(StorageLifecyclePolicyCompletedEventData, self).__init__(**kwargs)
        self.schedule_time = schedule_time
        self.delete_summary = delete_summary
        self.tier_to_cool_summary = tier_to_cool_summary
        self.tier_to_archive_summary = tier_to_archive_summary


class SubscriptionDeletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.EventGrid.SubscriptionDeletedEvent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar event_subscription_id: The Azure resource ID of the deleted event subscription.
    :vartype event_subscription_id: str
    """

    _validation = {
        'event_subscription_id': {'readonly': True},
    }

    _attribute_map = {
        'event_subscription_id': {'key': 'eventSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionDeletedEventData, self).__init__(**kwargs)
        self.event_subscription_id = None


class SubscriptionValidationEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for a Microsoft.EventGrid.SubscriptionValidationEvent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_code: The validation code sent by Azure Event Grid to validate an event
     subscription. To complete the validation handshake, the subscriber must either respond with
     this validation code as part of the validation response, or perform a GET request on the
     validationUrl (available starting version 2018-05-01-preview).
    :vartype validation_code: str
    :ivar validation_url: The validation URL sent by Azure Event Grid (available starting version
     2018-05-01-preview). To complete the validation handshake, the subscriber must either respond
     with the validationCode as part of the validation response, or perform a GET request on the
     validationUrl (available starting version 2018-05-01-preview).
    :vartype validation_url: str
    """

    _validation = {
        'validation_code': {'readonly': True},
        'validation_url': {'readonly': True},
    }

    _attribute_map = {
        'validation_code': {'key': 'validationCode', 'type': 'str'},
        'validation_url': {'key': 'validationUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionValidationEventData, self).__init__(**kwargs)
        self.validation_code = None
        self.validation_url = None


class SubscriptionValidationResponse(msrest.serialization.Model):
    """To complete an event subscription validation handshake, a subscriber can use either the validationCode or the validationUrl received in a SubscriptionValidationEvent. When the validationCode is used, the SubscriptionValidationResponse can be used to build the response.

    :param validation_response: The validation response sent by the subscriber to Azure Event Grid
     to complete the validation of an event subscription.
    :type validation_response: str
    """

    _attribute_map = {
        'validation_response': {'key': 'validationResponse', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validation_response: Optional[str] = None,
        **kwargs
    ):
        super(SubscriptionValidationResponse, self).__init__(**kwargs)
        self.validation_response = validation_response


class WebAppServicePlanUpdatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.AppServicePlanUpdated event.

    :param app_service_plan_event_type_detail: Detail of action on the app service plan.
    :type app_service_plan_event_type_detail:
     ~event_grid_publisher_client.models.AppServicePlanEventTypeDetail
    :param sku: sku of app service plan.
    :type sku: ~event_grid_publisher_client.models.WebAppServicePlanUpdatedEventDataSku
    :param name: name of the app service plan that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the app
     service plan API operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     app service plan API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the app service plan API
     operation that triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_service_plan_event_type_detail': {'key': 'appServicePlanEventTypeDetail', 'type': 'AppServicePlanEventTypeDetail'},
        'sku': {'key': 'sku', 'type': 'WebAppServicePlanUpdatedEventDataSku'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_service_plan_event_type_detail: Optional["AppServicePlanEventTypeDetail"] = None,
        sku: Optional["WebAppServicePlanUpdatedEventDataSku"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebAppServicePlanUpdatedEventData, self).__init__(**kwargs)
        self.app_service_plan_event_type_detail = app_service_plan_event_type_detail
        self.sku = sku
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebAppServicePlanUpdatedEventDataSku(msrest.serialization.Model):
    """sku of app service plan.

    :param name: name of app service plan sku.
    :type name: str
    :param tier: tier of app service plan sku.
    :type tier: str
    :param size: size of app service plan sku.
    :type size: str
    :param family: family of app service plan sku.
    :type family: str
    :param capacity: capacity of app service plan sku.
    :type capacity: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'Tier', 'type': 'str'},
        'size': {'key': 'Size', 'type': 'str'},
        'family': {'key': 'Family', 'type': 'str'},
        'capacity': {'key': 'Capacity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[str] = None,
        **kwargs
    ):
        super(WebAppServicePlanUpdatedEventDataSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class WebAppUpdatedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.AppUpdated event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebAppUpdatedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebBackupOperationCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.BackupOperationCompleted event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebBackupOperationCompletedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebBackupOperationFailedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.BackupOperationFailed event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebBackupOperationFailedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebBackupOperationStartedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.BackupOperationStarted event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebBackupOperationStartedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebRestoreOperationCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.RestoreOperationCompleted event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebRestoreOperationCompletedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebRestoreOperationFailedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.RestoreOperationFailed event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebRestoreOperationFailedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebRestoreOperationStartedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.RestoreOperationStarted event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebRestoreOperationStartedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebSlotSwapCompletedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.SlotSwapCompleted event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebSlotSwapCompletedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebSlotSwapFailedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.SlotSwapFailed event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebSlotSwapFailedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebSlotSwapStartedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.SlotSwapStarted event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebSlotSwapStartedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebSlotSwapWithPreviewCancelledEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.SlotSwapWithPreviewCancelled event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebSlotSwapWithPreviewCancelledEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb


class WebSlotSwapWithPreviewStartedEventData(msrest.serialization.Model):
    """Schema of the Data property of an EventGridEvent for an Microsoft.Web.SlotSwapWithPreviewStarted event.

    :param app_event_type_detail: Detail of action on the app.
    :type app_event_type_detail: ~event_grid_publisher_client.models.AppEventTypeDetail
    :param name: name of the web site that had this event.
    :type name: str
    :param client_request_id: The client request id generated by the app service for the site API
     operation that triggered this event.
    :type client_request_id: str
    :param correlation_request_id: The correlation request id generated by the app service for the
     site API operation that triggered this event.
    :type correlation_request_id: str
    :param request_id: The request id generated by the app service for the site API operation that
     triggered this event.
    :type request_id: str
    :param address: HTTP request URL of this operation.
    :type address: str
    :param verb: HTTP verb of this operation.
    :type verb: str
    """

    _attribute_map = {
        'app_event_type_detail': {'key': 'appEventTypeDetail', 'type': 'AppEventTypeDetail'},
        'name': {'key': 'name', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'correlation_request_id': {'key': 'correlationRequestId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'verb': {'key': 'verb', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_event_type_detail: Optional["AppEventTypeDetail"] = None,
        name: Optional[str] = None,
        client_request_id: Optional[str] = None,
        correlation_request_id: Optional[str] = None,
        request_id: Optional[str] = None,
        address: Optional[str] = None,
        verb: Optional[str] = None,
        **kwargs
    ):
        super(WebSlotSwapWithPreviewStartedEventData, self).__init__(**kwargs)
        self.app_event_type_detail = app_event_type_detail
        self.name = name
        self.client_request_id = client_request_id
        self.correlation_request_id = correlation_request_id
        self.request_id = request_id
        self.address = address
        self.verb = verb
