# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .partition_scheme_description import PartitionSchemeDescription


class UniformInt64RangePartitionSchemeDescription(PartitionSchemeDescription):
    """Describes a partitioning scheme where an integer range is allocated evenly
    across a number of partitions.

    :param PartitionScheme: Polymorphic Discriminator
    :type PartitionScheme: str
    :param count: The number of partitions.
    :type count: int
    :param low_key: String indicating the lower bound of the partition key
     range that
     should be split between the partition ‘Count’
    :type low_key: str
    :param high_key: String indicating the upper bound of the partition key
     range that
     should be split between the partition ‘Count’
    :type high_key: str
    """ 

    _validation = {
        'PartitionScheme': {'required': True},
        'count': {'required': True},
        'low_key': {'required': True},
        'high_key': {'required': True},
    }

    _attribute_map = {
        'PartitionScheme': {'key': 'PartitionScheme', 'type': 'str'},
        'count': {'key': 'Count', 'type': 'int'},
        'low_key': {'key': 'LowKey', 'type': 'str'},
        'high_key': {'key': 'HighKey', 'type': 'str'},
    }

    def __init__(self, count, low_key, high_key):
        super(UniformInt64RangePartitionSchemeDescription, self).__init__()
        self.count = count
        self.low_key = low_key
        self.high_key = high_key
        self.PartitionScheme = 'UniformInt64Range'
