# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .safety_check import SafetyCheck


class PartitionSafetyCheck(SafetyCheck):
    """Represents a safety check for the service partition being performed by
    service fabric before continuing with operations.

    :param Kind: Polymorphic Discriminator
    :type Kind: str
    :param partition_id:
    :type partition_id: str
    """ 

    _validation = {
        'Kind': {'required': True},
    }

    _attribute_map = {
        'Kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    _subtype_map = {
        'Kind': {'EnsureAvailability': 'EnsureAvailabilitySafetyCheck', 'EnsurePartitionQuorum': 'EnsurePartitionQurumSafetyCheck', 'WaitForInbuildReplica': 'WaitForInbuildReplicaSafetyCheck', 'WaitForPrimaryPlacement': 'WaitForPrimaryPlacementSafetyCheck', 'WaitForPrimarySwap': 'WaitForPrimarySwapSafetyCheck', 'WaitForReconfiguration': 'WaitForReconfigurationSafetyCheck'}
    }

    def __init__(self, partition_id=None):
        super(PartitionSafetyCheck, self).__init__()
        self.partition_id = partition_id
        self.Kind = 'PartitionSafetyCheck'
