# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ManualScaleSettings(Model):
    """Manual scale settings for the cluster.

    :param target_node_count: The desired number of compute nodes in the
     cluster. Default is 0. If autoScaleSettings are not specified, then the
     cluster starts with this target. Default value: 0 .
    :type target_node_count: int
    :param node_deallocation_option: Determines what to do with a compute node
     and its running task(s) if the cluster size is decreasing. The default
     value is requeue. Possible values include: 'requeue', 'terminate',
     'waitforjobcompletion', 'unknown'. Default value: "requeue" .
    :type node_deallocation_option: str or :class:`DeallocationOption
     <azure.mgmt.batchai.models.DeallocationOption>`
    """

    _validation = {
        'target_node_count': {'required': True},
    }

    _attribute_map = {
        'target_node_count': {'key': 'targetNodeCount', 'type': 'int'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'DeallocationOption'},
    }

    def __init__(self, target_node_count=0, node_deallocation_option="requeue"):
        self.target_node_count = target_node_count
        self.node_deallocation_option = node_deallocation_option
