/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.brunel.data.Data;

public class MapInt {
    private final Map<Object, Integer> map = new HashMap<Object, Integer>();
    private int totalCount;
    private int maxCount;

    public int get(Object o) {
        Integer v = this.map.get(o);
        return v == null ? 0 : v;
    }

    public int[] getCounts(Object[] vals) {
        int[] result = new int[vals.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(vals[i]);
        }
        return result;
    }

    public Object[] getIndexedKeys() {
        Object[] results = new Object[this.size()];
        Iterator<Object> i$ = this.map.keySet().iterator();
        while (i$.hasNext()) {
            Object o;
            results[this.map.get((Object)o).intValue()] = o = i$.next();
        }
        return results;
    }

    public void increment(Object o) {
        if (o != null) {
            int v = this.get(o) + 1;
            this.map.put(o, v);
            ++this.totalCount;
            this.maxCount = Math.max(this.maxCount, v);
        }
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public Object mode() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object s : this.map.keySet()) {
            if (this.map.get(s) != this.maxCount) continue;
            list.add(s);
        }
        Object[] array = list.toArray(new Object[list.size()]);
        Data.sort(array);
        return array[(int)Math.floor((array.length - 1) / 2)];
    }

    public MapInt index(Object[] keys) {
        for (Object o : keys) {
            if (this.map.containsKey(o)) continue;
            this.map.put(o, this.map.size());
        }
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public Object[] sortedKeys() {
        Set<Object> s = this.map.keySet();
        Object[] array = s.toArray(new Object[s.size()]);
        Data.sort(array);
        return array;
    }
}

