/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.auto;

import java.util.ArrayList;
import java.util.Date;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.stats.DateStats;
import org.brunel.data.util.DateUnit;

public class NumericScale {
    private static final double HALF_LOG = 3.0;
    public final Double[] divisions;
    public final double max;
    public final double min;
    public final String type;
    public final boolean granular;

    public static NumericScale makeDateScale(Field f, boolean nice, double[] padFraction, int desiredTickCount) {
        double b;
        double a = f.min();
        if (a == (b = f.max().doubleValue())) {
            DateUnit unit = (DateUnit)((Object)f.property("dateUnit"));
            a = Data.asNumeric(DateUnit.increment(Data.asDate(a), unit, -1));
            b = Data.asNumeric(DateUnit.increment(Data.asDate(b), unit, 1));
        } else {
            a -= padFraction[0] * (b - a);
            b += padFraction[1] * (b - a);
        }
        double desiredDaysGap = (b - a) / (double)(desiredTickCount - 1);
        DateUnit unit = DateStats.getUnit(desiredDaysGap * 4.0);
        int multiple = NumericScale.bestDateMultiple(unit, desiredDaysGap);
        Date x = DateUnit.floor(Data.asDate(a), unit, multiple);
        if (nice) {
            a = Data.asNumeric(x);
        }
        ArrayList<Double> d = new ArrayList<Double>();
        while (true) {
            double v;
            if ((v = Data.asNumeric(x).doubleValue()) >= b) {
                if (!nice && v != b) break;
                b = v;
                d.add(v);
                break;
            }
            if (v >= a) {
                d.add(v);
            }
            x = DateUnit.increment(x, unit, multiple);
        }
        if (nice) {
            b = Data.asNumeric(x);
        }
        Double[] data = d.toArray(new Double[d.size()]);
        return new NumericScale("date", a, b, data, false);
    }

    private static int bestDateMultiple(DateUnit unit, double desiredDaysGap) {
        double target = desiredDaysGap / unit.approxDaysPerUnit;
        int multiple = 1;
        for (int i = 2; i <= unit.base / 2; ++i) {
            if (unit.base % i != 0 || i == 4 || i == 6 && unit.base == 60 || !(Math.abs(target - (double)i) <= Math.abs(target - (double)multiple))) continue;
            multiple = i;
        }
        return multiple;
    }

    public static NumericScale makeLinearScale(Field f, boolean nice, double includeZeroTolerance, double[] padFraction, int desiredTickCount, boolean forBinning) {
        double[] choices;
        if (f.valid() == 0) {
            return new NumericScale("linear", 0.0, 1.0, new Double[]{0.0, 1.0}, false);
        }
        double a0 = f.min();
        double b0 = f.max();
        double padA = padFraction[0] * (b0 - a0);
        double padB = padFraction[1] * (b0 - a0);
        double a = a0 - padA;
        double b = b0 + padB;
        if (a > 0.0 && a / b <= includeZeroTolerance) {
            a = 0.0;
        }
        if (b < 0.0 && b / a <= includeZeroTolerance) {
            b = 0.0;
        }
        if (a == 0.0) {
            if (b0 <= 1.0001 && b > 1.0) {
                b = 1.0;
            }
            if (b0 < 100.001 && b > 100.0) {
                b = 100.0;
            }
        }
        if (a + 1.0E-9 > b) {
            b = Math.max(0.0, 2.0 * a);
            if ((a = Math.min(0.0, 2.0 * a)) == 0.0 && b == 0.0) {
                a = 0.0;
                b = 1.0;
            }
        }
        double desiredDivCount = Math.max(desiredTickCount - 1, 1);
        String transform = f.strProperty("transform");
        double granularity = f.numProperty("granularity");
        double granularDivs = (b - a) / granularity;
        if ((forBinning || f.preferCategorical()) && granularDivs > desiredDivCount / 2.0 && granularDivs < desiredDivCount * 2.0) {
            Double[] data = NumericScale.makeGranularDivisions(a, b, granularity, nice);
            return new NumericScale(transform, a, b, data, true);
        }
        double rawDelta = (b - a) / desiredDivCount;
        double deltaLog10 = Math.floor(Math.log(rawDelta) / Math.log(10.0));
        double delta = Math.pow(10.0, deltaLog10);
        double bestDiff = 1.0E9;
        for (double d : choices = new double[]{delta, delta * 10.0, delta / 10.0, delta * 5.0, delta / 2.0, delta * 2.0, delta / 5.0}) {
            double low = d * Math.ceil(a / d);
            double high = d * Math.floor(b / d);
            double dCount = Math.round((high - low) / d) + 1L;
            if (nice && a < low) {
                dCount += 1.0;
            }
            if (nice && b > high) {
                dCount += 1.0;
            }
            double diff = Math.abs(dCount - (double)desiredTickCount);
            if (dCount > (double)desiredTickCount) {
                diff -= 0.001;
            }
            if (!(diff < bestDiff)) continue;
            bestDiff = diff;
            delta = d;
        }
        double x = delta * Math.floor(a / delta);
        if (nice) {
            a = x;
            b = delta * Math.ceil(b / delta);
        }
        if (x < a - 1.0E-6) {
            x += delta;
        }
        ArrayList<Double> d = new ArrayList<Double>();
        while (x < b + 1.0E-6) {
            d.add(x);
            x += delta;
        }
        Double[] data = d.toArray(new Double[d.size()]);
        return new NumericScale(transform, a, b, data, false);
    }

    private static Double[] makeGranularDivisions(double min, double max, double granularity, boolean nice) {
        ArrayList<Double> div = new ArrayList<Double>();
        if (!nice) {
            min += granularity;
            max -= granularity;
        }
        for (double at = min - granularity / 2.0; at < max + granularity; at += granularity) {
            div.add(at);
        }
        return div.toArray(new Double[div.size()]);
    }

    public static NumericScale makeLogScale(Field f, boolean nice, double[] padFraction, double includeZeroTolerance, int desiredTickCount) {
        double n;
        double a = Math.log(f.min()) / Math.log(10.0);
        double b = Math.log(f.max()) / Math.log(10.0);
        double pad = Math.max(padFraction[0], padFraction[1]);
        a -= pad * (b - a);
        b += pad * (b - a);
        if (includeZeroTolerance > 0.5 && a == 0.0) {
            a = -0.5;
        }
        if (a > 0.0 && a / b <= includeZeroTolerance) {
            a = 0.0;
        }
        if (nice) {
            a = Math.floor(a);
            b = Math.ceil(b);
        }
        boolean add5 = (n = b - a + 1.0) < (double)desiredTickCount * 0.666;
        double factor = n > (double)desiredTickCount * 1.66 ? 100.0 : 10.0;
        ArrayList<Double> d = new ArrayList<Double>();
        double low = Math.pow(10.0, a);
        double high = Math.pow(10.0, b);
        if (add5 && high / 2.0 > f.max()) {
            high /= 2.0;
        }
        double tolerantHigh = high * 1.001;
        for (double x = Math.pow(10.0, Math.ceil(a)); x < tolerantHigh; x *= factor) {
            d.add(x);
            if (!add5 || !(x * 3.0 < tolerantHigh)) continue;
            d.add(x * 3.0);
        }
        Double[] data = d.toArray(new Double[d.size()]);
        return new NumericScale("log", low, high, data, false);
    }

    private NumericScale(String type, double min, double max, Double[] divs, boolean granular) {
        this.type = type;
        this.min = min;
        this.max = max;
        this.divisions = divs;
        this.granular = granular;
    }
}

