/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Bubble
extends D3Diagram {
    public Bubble(VisSingle vis, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define bubble (hierarchy) data structures");
        this.makeHierarchicalTree();
        this.out.add("var pack = d3.pack().size([geom.inner_width, geom.inner_height])").endStatement();
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.spaceFillingCircle, "point", "pack(tree).descendants()");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('class', function(d) { return (d.children ? 'element L' + d.depth : 'leaf element " + this.element.name() + "') })").addChained("attr('cx', function(d) { return scale_x(d.x) })").addChained("attr('cy', function(d) { return scale_y(d.y) })").addChained("attr('r', function(d) { return scale_x(d.r) - scale_x(0) })");
        this.addAestheticsAndTooltips(details);
    }

    @Override
    public String getRowKey() {
        return "d.data.key == null ? data._key(d.data.row) : d.data.key";
    }
}

