/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.d3.AxisDetails;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.SVGGroupUtility;
import org.brunel.build.d3.ScalePurpose;
import org.brunel.build.info.ChartCoordinates;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.color.ColorMapping;
import org.brunel.color.Palette;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.auto.Auto;
import org.brunel.data.auto.NumericScale;
import org.brunel.data.stats.DateStats;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.DateUnit;
import org.brunel.data.util.Range;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3ScaleBuilder {
    private static final double MIN_SIZE_FACTOR = 0.001;
    final VisTypes.Coordinates coords;
    private final Field colorLegendField;
    private final AxisDetails hAxis;
    private final AxisDetails vAxis;
    private final double[] marginTLBR;
    private final ChartStructure structure;
    private final VisSingle[] elements;
    private final ScriptWriter out;

    public D3ScaleBuilder(ChartStructure structure, double chartWidth, double chartHeight, ScriptWriter out) {
        this.structure = structure;
        this.elements = structure.elements;
        this.out = out;
        this.coords = this.makeCombinedCoords();
        AxisSpec[] axes = this.makeCombinedAxes();
        this.colorLegendField = this.getColorLegendField();
        ChartCoordinates coords = structure.coordinates;
        AxisDetails xAxis = axes[0] != null ? new AxisDetails("x", coords.allXFields, coords.xCategorical, axes[0].name, axes[0].ticks, axes[0].grid) : new AxisDetails("x", new Field[0], coords.xCategorical, null, 9999, false);
        AxisDetails yAxis = axes[1] != null ? new AxisDetails("y", coords.allYFields, coords.yCategorical, axes[1].name, axes[1].ticks, axes[1].grid) : new AxisDetails("y", new Field[0], coords.yCategorical, null, 9999, false);
        if (this.coords == VisTypes.Coordinates.transposed) {
            this.hAxis = yAxis;
            this.vAxis = xAxis;
        } else {
            this.hAxis = xAxis;
            this.vAxis = yAxis;
        }
        this.hAxis.setTextDetails(structure, true);
        this.vAxis.setTextDetails(structure, false);
        int legendWidth = this.legendWidth();
        this.vAxis.layoutVertically(chartHeight - (double)this.hAxis.estimatedSimpleSizeWhenHorizontal());
        this.hAxis.layoutHorizontally(chartWidth - (double)this.vAxis.size - (double)legendWidth, this.elementsFillHorizontal(ScalePurpose.x));
        int marginTop = this.vAxis.topGutter;
        int marginLeft = Math.max(this.vAxis.size, this.hAxis.leftGutter);
        int marginBottom = Math.max(this.hAxis.size, this.vAxis.bottomGutter);
        int marginRight = Math.max(this.hAxis.rightGutter, legendWidth);
        this.marginTLBR = new double[]{marginTop, marginLeft, marginBottom, marginRight};
    }

    public boolean needsLegends() {
        return this.colorLegendField != null;
    }

    public void setAdditionalHAxisOffset(double v) {
        this.hAxis.setAdditionalHAxisOffset(v);
    }

    private VisTypes.Coordinates makeCombinedCoords() {
        if (this.structure.diagram == VisTypes.Diagram.chord || this.structure.diagram == VisTypes.Diagram.cloud) {
            return VisTypes.Coordinates.polar;
        }
        VisTypes.Coordinates result = this.elements[0].coords;
        for (VisSingle e : this.elements) {
            if (e.coords.compareTo(result) <= 0) continue;
            result = e.coords;
        }
        return result;
    }

    private AxisSpec[] makeCombinedAxes() {
        AxisSpec x = null;
        AxisSpec y = null;
        boolean auto = true;
        for (VisSingle e : this.elements) {
            if (e.tDiagram != null || e.fAxes.containsKey((Object)VisTypes.Axes.none)) {
                return new AxisSpec[2];
            }
            for (Map.Entry<VisTypes.Axes, Param[]> p : e.fAxes.entrySet()) {
                auto = false;
                VisTypes.Axes key = p.getKey();
                Param[] value = p.getValue();
                if (key == VisTypes.Axes.x) {
                    x = (x == null ? AxisSpec.DEFAULT : x).merge(value);
                    continue;
                }
                if (key != VisTypes.Axes.y) continue;
                y = (y == null ? AxisSpec.DEFAULT : y).merge(value);
            }
        }
        if (auto) {
            if (this.coords == VisTypes.Coordinates.polar || this.structure.diagram != null || this.structure.nested()) {
                return new AxisSpec[2];
            }
            return new AxisSpec[]{AxisSpec.DEFAULT, AxisSpec.DEFAULT};
        }
        return new AxisSpec[]{x, y};
    }

    private Field getColorLegendField() {
        Field result = null;
        for (VisSingle vis : this.elements) {
            boolean auto;
            boolean bl = auto = vis.tLegends == VisTypes.Legends.auto;
            if (auto && this.structure.nested() || vis.fColor.isEmpty() || vis.tLegends == VisTypes.Legends.none) continue;
            Field f = this.fieldById(this.getColor(vis).asField(), vis);
            if (auto && f.name.equals("#selection")) continue;
            if (result == null) {
                result = f;
                continue;
            }
            if (this.same(result, f)) continue;
            return null;
        }
        return result;
    }

    private int legendWidth() {
        if (!this.needsLegends()) {
            return 0;
        }
        AxisDetails legendAxis = new AxisDetails("color", new Field[]{this.colorLegendField}, this.colorLegendField.preferCategorical(), null, 9999, false);
        legendAxis.setTextDetails(this.structure, false);
        int spaceNeededForTicks = 32 + legendAxis.maxCategoryWidth();
        int spaceNeededForTitle = this.colorLegendField.label.length() * 7;
        return 6 + Math.max(spaceNeededForTicks, spaceNeededForTitle);
    }

    private boolean elementsFillHorizontal(ScalePurpose purpose) {
        for (VisSingle e : this.elements) {
            if (e.tElement != VisTypes.Element.line && e.tElement != VisTypes.Element.area) {
                return false;
            }
            if (purpose != ScalePurpose.x || e.fX.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private Field fieldById(String fieldName, VisSingle vis) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] != vis) continue;
            Field field = this.structure.elementStructure[i].data.field(fieldName);
            if (field == null) {
                throw new IllegalStateException("Unknown field " + fieldName);
            }
            return field;
        }
        throw new IllegalStateException("Passed in a vis that was not part of the system defined in the constructor");
    }

    private Param getColor(VisSingle vis) {
        return vis.fColor.isEmpty() ? null : vis.fColor.get(0);
    }

    private boolean same(Field a, Field b) {
        return a.name.equals(b.name) && a.preferCategorical() == b.preferCategorical();
    }

    public boolean allNumeric(Field[] fields) {
        for (Field f : fields) {
            if (f.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public Double getGranularitySuitableForSizing(Field[] ff) {
        Double r = null;
        for (Field f : ff) {
            Double g;
            if (f.isDate() || (g = f.numProperty("granularity")) == null || !(g / (f.max() - f.min()) > 0.02) || r != null && !(g < r)) continue;
            r = g;
        }
        return r;
    }

    public double[] marginsTLBR() {
        return this.marginTLBR;
    }

    public boolean needsAxes() {
        return this.hAxis.exists() || this.vAxis.exists();
    }

    public void writeAestheticScales(ElementStructure structure) {
        Field field;
        VisSingle vis = structure.vis;
        boolean dataInside = structure.hasComplexDataStructure();
        Param color = this.getColor(vis);
        Param[] size = this.getSize(vis);
        Param opacity = this.getOpacity(vis);
        if (color == null && opacity == null && size.length == 0) {
            return;
        }
        this.out.onNewLine().comment("Aesthetic Functions");
        if (color != null) {
            this.addColorScale(color, vis);
            field = this.fieldById(color, vis);
            this.out.onNewLine().add("var color = function(d) { return scale_color(" + D3Util.writeCall(field, dataInside) + ") }").endStatement();
        }
        if (opacity != null) {
            this.addOpacityScale(opacity, vis);
            field = this.fieldById(opacity, vis);
            this.out.onNewLine().add("var opacity = function(d) { return scale_opacity(" + D3Util.writeCall(field, dataInside) + ") }").endStatement();
        }
        if (size.length == 1) {
            String defaultTransform = vis.tElement == VisTypes.Element.point || vis.tElement == VisTypes.Element.text ? "sqrt" : "linear";
            this.addSizeScale("size", size[0], vis, defaultTransform);
            Field field2 = this.fieldById(size[0], vis);
            this.out.onNewLine().add("var size = function(d) { return scale_size(" + D3Util.writeCall(field2, dataInside) + ") }").endStatement();
        } else if (size.length > 1) {
            this.addSizeScale("width", size[0], vis, "linear");
            this.addSizeScale("height", size[1], vis, "linear");
            Field widthField = this.fieldById(size[0], vis);
            this.out.onNewLine().add("var width = function(d) { return scale_width(" + D3Util.writeCall(widthField, dataInside) + ") }").endStatement();
            Field heightField = this.fieldById(size[1], vis);
            this.out.onNewLine().add("var height = function(d) { return scale_height(" + D3Util.writeCall(heightField, dataInside) + ") }").endStatement();
        }
    }

    public void writeAxes() {
        SVGGroupUtility groupUtil;
        if (!this.hAxis.exists() && !this.vAxis.exists()) {
            return;
        }
        if (this.hAxis.exists()) {
            groupUtil = new SVGGroupUtility(this.structure, "x_axis", this.out);
            this.out.onNewLine().add("axes.append('g').attr('class', 'x axis')").addChained("attr('transform','translate(0,' + geom.inner_rawHeight + ')')");
            groupUtil.addClipPathReference("haxis");
            groupUtil.addAccessibleTitle("Horizontal Axis");
            this.out.endStatement();
            groupUtil.defineHorizontalAxisClipPath();
            this.hAxis.writeTitle("axes.select('g.axis.x')", this.out);
        }
        if (this.vAxis.exists()) {
            groupUtil = new SVGGroupUtility(this.structure, "y_axis", this.out);
            this.out.onNewLine().add("axes.append('g').attr('class', 'y axis')");
            groupUtil.addClipPathReference("vaxis");
            groupUtil.addAccessibleTitle("Vertical Axis");
            this.out.endStatement();
            groupUtil.defineVerticalAxisClipPath();
            this.vAxis.writeTitle("axes.select('g.axis.y')", this.out);
        }
        this.out.onNewLine().ln();
        this.defineAxis("var axis_bottom = d3.axisBottom", this.hAxis, true);
        this.defineAxis("var axis_left = d3.axisLeft", this.vAxis, false);
        this.defineAxesBuild();
    }

    private void defineAxis(String basicDefinition, AxisDetails axis, boolean horizontal) {
        if (axis.exists()) {
            int padding = horizontal ? axis.tickPadding.top : axis.tickPadding.right;
            this.out.add(basicDefinition).add("(" + axis.scale + ").tickSizeInner(" + axis.markSize + ").tickPadding(" + padding + ").tickSizeOuter(0)");
            if (axis.isLog()) {
                this.out.addChained("ticks(7, ',.3g')");
            } else if (axis.tickCount != null) {
                this.out.addChained("ticks(").add(axis.tickCount).add(")");
            } else if (axis == this.hAxis) {
                this.out.addChained("ticks(Math.min(10, Math.round(geom.inner_width / " + 1.5 * (double)axis.maxCategoryWidth() + ")))");
            }
            if (axis.inMillions()) {
                this.out.addChained("tickFormat(  function(x) { return BrunelData.Data.format(x/1e6) + 'M' })");
            }
            this.out.endStatement();
        }
    }

    private void defineAxesBuild() {
        this.out.onNewLine().ln().add("function buildAxes(time) {").indentMore();
        if (this.hAxis.exists()) {
            if (this.hAxis.categorical) {
                this.out.onNewLine().add("axis_bottom.tickValues(BrunelD3.filterTicks(" + this.hAxis.scale + "))");
            }
            this.out.onNewLine().add("var axis_x = axes.select('g.axis.x');");
            this.out.onNewLine().add("BrunelD3.transition(axis_x, time).call(axis_bottom.scale(" + this.hAxis.scale + "))");
            if (this.hAxis.rotatedTicks) {
                this.addRotateTicks();
            }
            this.out.endStatement();
        }
        if (this.vAxis.exists()) {
            if (this.vAxis.categorical) {
                this.out.onNewLine().add("axis_left.tickValues(BrunelD3.filterTicks(" + this.vAxis.scale + "))");
            }
            this.out.onNewLine().add("var axis_y = axes.select('g.axis.y');");
            this.out.onNewLine().add("BrunelD3.transition(axis_y, time).call(axis_left.scale(" + this.vAxis.scale + "))");
            if (this.vAxis.rotatedTicks) {
                this.addRotateTicks();
            }
            this.out.endStatement();
        }
        if (this.hAxis.hasGrid) {
            if (this.hAxis.isX()) {
                this.addGrid("scale_x", "geom.inner_height", true);
            } else {
                this.addGrid("scale_y", "geom.inner_width", true);
            }
        }
        if (this.vAxis.hasGrid) {
            if (this.vAxis.isX()) {
                this.addGrid("scale_x", "geom.inner_height", false);
            } else {
                this.addGrid("scale_y", "geom.inner_width", false);
            }
        }
        this.out.indentLess().add("}").ln();
    }

    private void addGrid(String scaleName, String extent, boolean isX) {
        this.out.onNewLine().add("BrunelD3.makeGrid(gridGroup, " + scaleName + ", " + extent + ", " + isX + " )").endStatement();
    }

    private void addRotateTicks() {
        this.out.add(".selectAll('.tick text')").addChained("attr('transform', function() {").indentMore().indentMore().onNewLine().onNewLine().add("var v = this.getComputedTextLength() / Math.sqrt(2)/2;").onNewLine().add("return 'translate(-' + (v+6) + ',' + v + ') rotate(-45)'").indentLess().indentLess().onNewLine().add("})");
    }

    public void writeCoordinateScales() {
        ChartCoordinates coordinates = this.structure.coordinates;
        this.writePositionScale(ScalePurpose.x, coordinates.allXFields, this.getXRange(), this.elementsFillHorizontal(ScalePurpose.x), coordinates.xReversed);
        this.writePositionScale(ScalePurpose.inner, coordinates.allXClusterFields, "[-0.5, 0.5]", this.elementsFillHorizontal(ScalePurpose.inner), coordinates.xReversed);
        this.writePositionScale(ScalePurpose.y, coordinates.allYFields, this.getYRange(), false, coordinates.yReversed);
        this.writeScaleExtras();
    }

    protected void writeScaleExtras() {
        this.out.onNewLine().add("var base_scales = [scale_x, scale_y];").at(50).comment("Untransformed original scales");
        this.writeAspect();
    }

    public void writeDiagramScales() {
        this.out.onNewLine().add("var scale_x = d3.scaleLinear(), scale_y = d3.scaleLinear()").endStatement();
        this.writeScaleExtras();
    }

    private void writeAspect() {
        boolean anyCategorial;
        Double aspect = this.getAspect();
        boolean bl = anyCategorial = this.structure.coordinates.xCategorical || this.structure.coordinates.yCategorical;
        if (aspect != null && !anyCategorial) {
            this.out.onNewLine().add("BrunelD3.setAspect(scale_x, scale_y, " + aspect + ")");
            this.out.endStatement();
        }
    }

    private void writePositionScale(ScalePurpose purpose, Field[] fields, String range, boolean fillToEdge, boolean reverse) {
        int categories = this.defineScaleWithDomain(purpose.name(), fields, purpose, 2, "linear", null, reverse);
        this.out.addChained("range(" + range + ")");
        if (categories > 0 && fillToEdge) {
            this.out.add(".padding(0)");
        }
        this.out.endStatement();
    }

    private String getXRange() {
        if (this.structure.coordinates.isPolar()) {
            return "[0, geom.inner_radius]";
        }
        if (this.structure.coordinates.isTransposed()) {
            return "[geom.inner_width, 0]";
        }
        return "[0, geom.inner_width]";
    }

    private String getYRange() {
        if (this.structure.coordinates.isPolar()) {
            return "[0, Math.PI*2]";
        }
        if (this.structure.coordinates.isTransposed()) {
            return "[0, geom.inner_height]";
        }
        return "[geom.inner_height, 0]";
    }

    private Double getAspect() {
        for (VisSingle e : this.elements) {
            for (Param p : e.fCoords) {
                if (!p.asString().equals("aspect")) continue;
                Param m = p.firstModifier();
                if (m.asString().equals("square")) {
                    return 1.0;
                }
                return m.asDouble();
            }
        }
        return null;
    }

    private int defineScaleWithDomain(String name, Field[] fields, ScalePurpose purpose, int numericDomainDivs, String defaultTransform, Object[] partitionPoints, boolean reverse) {
        Double[] extent;
        this.out.onNewLine().add("var", "scale_" + name, "= ");
        if (fields.length == 0) {
            return this.makeEmptyZeroOneScale();
        }
        if (ModelUtil.combinationIsCategorical(fields, purpose.isCoord)) {
            return this.makeCategoricalScale(fields, purpose, reverse);
        }
        double includeZero = this.getIncludeZeroFraction(fields, purpose);
        if (purpose == ScalePurpose.size) {
            includeZero = 1.0;
        }
        Field field = fields[0];
        Field scaleField = fields.length == 1 ? field : this.combineNumericFields(fields);
        ChartCoordinates coordinates = this.structure.coordinates;
        if (name.equals("x")) {
            if (scaleField == field) {
                scaleField = field.rename(field.name, field.label);
            }
            scaleField.set("transform", (Object)coordinates.xTransform);
        }
        if (name.equals("y")) {
            if (scaleField == field) {
                scaleField = field.rename(field.name, field.label);
            }
            scaleField.set("transform", (Object)coordinates.yTransform);
        }
        boolean nice = (name.equals("x") || name.equals("y")) && this.coords != VisTypes.Coordinates.polar;
        double[] padding = this.getNumericPaddingFraction(purpose, this.coords);
        if (scaleField.isBinned() || purpose == ScalePurpose.x && this.elementsFillHorizontal(ScalePurpose.x)) {
            nice = false;
            padding = new double[]{0.0, 0.0};
            includeZero = 0.0;
        }
        NumericScale detail = Auto.makeNumericScale((Field)scaleField, (boolean)nice, (double[])padding, (double)includeZero, (int)9, (boolean)false);
        double min = detail.min;
        double max = detail.max;
        Double[] doubleArray = extent = name.equals("x") ? coordinates.xExtent : coordinates.yExtent;
        if (extent != null && extent[0] != null) {
            min = extent[0];
        }
        if (extent != null && extent[1] != null) {
            max = extent[1];
        }
        Object[] divs = new Object[numericDomainDivs];
        if (field.isDate()) {
            DateFormat dateFormat = (DateFormat)field.property("dateFormat");
            D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
            for (int i = 0; i < divs.length; ++i) {
                Object v = partitionPoints == null ? Double.valueOf(min + (max - min) * (double)i / (double)(numericDomainDivs - 1)) : partitionPoints[i];
                divs[i] = dateBuilder.make(Data.asDate((Object)v), dateFormat, true);
            }
            this.out.add("d3.scaleTime()");
        } else {
            String transform = null;
            if (name.equals("x")) {
                transform = coordinates.xTransform;
            }
            if (name.equals("y")) {
                transform = coordinates.yTransform;
            }
            if (purpose == ScalePurpose.size) {
                transform = defaultTransform;
            }
            transform = this.makeD3ScaleName(defaultTransform, scaleField, transform);
            max += (max - min) * 1.0E-7;
            this.out.add("d3." + transform + "()");
            for (int i = 0; i < divs.length; ++i) {
                divs[i] = partitionPoints == null ? Double.valueOf(min + (max - min) * (double)i / (double)(numericDomainDivs - 1)) : partitionPoints[i];
            }
        }
        if (reverse) {
            List<Object> l = Arrays.asList(divs);
            Collections.reverse(l);
            divs = l.toArray();
        }
        this.out.addChained("domain([").add(Data.join((Object[])divs)).add("])");
        return -1;
    }

    private int makeCategoricalScale(Field[] fields, ScalePurpose purpose, boolean reverse) {
        List<Object> list = this.getCategories(fields);
        if (reverse) {
            Collections.reverse(list);
        }
        this.out.add(purpose.isCoord ? "d3.scalePoint().padding(0.5)" : "d3.scaleOrdinal()").addChained("domain([");
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (i > 0) {
                this.out.add(", ");
            }
            if (o instanceof Number) {
                this.out.add(Data.format((Object)o, (boolean)false));
                continue;
            }
            this.out.add(Data.quote((String)o.toString()));
        }
        this.out.add("])");
        return list.size();
    }

    private int makeEmptyZeroOneScale() {
        this.out.add("d3.scaleLinear().domain([0,1])");
        return -1;
    }

    private String makeD3ScaleName(String defaultTransform, Field scaleField, String transform) {
        if (transform == null) {
            transform = (String)scaleField.property("transform");
            if (transform == null) {
                transform = "linear";
            }
            if (transform.equals("linear")) {
                transform = defaultTransform;
            }
        }
        if (transform.equals("root") || transform.equals("sqrt")) {
            return "scaleSqrt";
        }
        if (transform.equals("log")) {
            return "scaleLog";
        }
        if (transform.equals("linear")) {
            return "scaleLinear";
        }
        throw new IllegalStateException("Unknown scale type: " + transform);
    }

    public List<Object> getCategories(Field[] ff) {
        LinkedHashSet all = new LinkedHashSet();
        for (Field f : ff) {
            if (!f.preferCategorical()) continue;
            Collections.addAll(all, f.categories());
        }
        return new ArrayList<Object>(all);
    }

    private double getIncludeZeroFraction(Field[] fields, ScalePurpose purpose) {
        if (purpose == ScalePurpose.x) {
            return 0.1;
        }
        if (purpose == ScalePurpose.size) {
            return 0.98;
        }
        if (purpose == ScalePurpose.color) {
            return 0.2;
        }
        for (Field f : fields) {
            if (!f.name.equals("#count") && !"sum".equals(f.strProperty("summary"))) continue;
            return 1.0;
        }
        int nBarArea = 0;
        for (VisSingle e : this.elements) {
            if (e.tElement != VisTypes.Element.bar && e.tElement != VisTypes.Element.area || e.fRange != null) continue;
            ++nBarArea;
        }
        if (nBarArea == this.elements.length) {
            return 1.0;
        }
        if (nBarArea > 0) {
            return 0.8;
        }
        return 0.2;
    }

    private Field combineNumericFields(Field[] ff) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (Field f : ff) {
            for (int i = 0; i < f.rowCount(); ++i) {
                Object value = f.value(i);
                if (value instanceof Range) {
                    data.add(Data.asNumeric((Object)((Range)value).low));
                    data.add(Data.asNumeric((Object)((Range)value).high));
                    continue;
                }
                data.add(Data.asNumeric((Object)value));
            }
        }
        Field combined = Fields.makeColumnField((String)"combined", null, (Object[])data.toArray(new Object[data.size()]));
        combined.set("numeric", (Object)true);
        return combined;
    }

    private double[] getNumericPaddingFraction(ScalePurpose purpose, VisTypes.Coordinates coords) {
        double[] padding = new double[]{0.0, 0.0};
        if (purpose == ScalePurpose.color || purpose == ScalePurpose.size) {
            return padding;
        }
        if (coords == VisTypes.Coordinates.polar) {
            return padding;
        }
        for (VisSingle e : this.elements) {
            boolean noBottomYPadding;
            boolean bl = noBottomYPadding = e.tElement == VisTypes.Element.bar || e.tElement == VisTypes.Element.area || e.tElement == VisTypes.Element.line;
            if (e.tElement == VisTypes.Element.text) {
                padding[0] = Math.max(padding[0], 0.1);
                padding[1] = Math.max(padding[1], 0.1);
                continue;
            }
            if (purpose == ScalePurpose.y && noBottomYPadding) {
                padding[1] = Math.max(padding[1], 0.02);
                continue;
            }
            padding[0] = Math.max(padding[0], 0.02);
            padding[1] = Math.max(padding[1], 0.02);
        }
        return padding;
    }

    public void writeLegends(VisSingle vis) {
        String title;
        String legendTicks;
        DateFormat dateFormat = null;
        if (vis.fColor.isEmpty() || this.colorLegendField == null) {
            return;
        }
        if (!vis.fColor.get(0).asField().equals(this.colorLegendField.name)) {
            return;
        }
        if (this.colorLegendField.preferCategorical()) {
            legendTicks = "scale_color.domain()";
            if (this.colorLegendField.isBinned() && this.colorLegendField.isNumeric()) {
                legendTicks = legendTicks + ".reverse()";
            }
        } else {
            NumericScale details = Auto.makeNumericScale((Field)this.colorLegendField, (boolean)true, (double[])new double[]{0.0, 0.0}, (double)0.25, (int)7, (boolean)false);
            Object[] divisions = details.divisions;
            if (details.granular) {
                Double[] newDiv = new Double[divisions.length - 1];
                for (int i = 0; i < newDiv.length; ++i) {
                    newDiv[i] = (divisions[i] + (Double)divisions[i + 1]) / 2.0;
                }
                divisions = newDiv;
            }
            for (int i = 0; i < divisions.length / 2; ++i) {
                Double t = divisions[divisions.length - 1 - i];
                divisions[divisions.length - 1 - i] = divisions[i];
                divisions[i] = t;
            }
            if (this.colorLegendField.isDate()) {
                DateUnit dateUnit = DateStats.getUnit((double)Math.abs(divisions[divisions.length - 1] - (Double)divisions[0]));
                dateFormat = DateStats.getFormat((DateUnit)dateUnit, (double)Math.abs((Double)divisions[1] - (Double)divisions[0]));
                D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
                Object[] divs = new String[divisions.length];
                for (int i = 0; i < divs.length; ++i) {
                    divs[i] = dateBuilder.make(Data.asDate((Object)divisions[i]), dateFormat, true);
                }
                legendTicks = "[" + Data.join((Object[])divs) + "]";
            } else {
                legendTicks = "[" + Data.join((Object[])divisions) + "]";
            }
        }
        if ((title = this.colorLegendField.label) == null) {
            title = this.colorLegendField.name;
        }
        this.out.add("BrunelD3.addLegend(legends, " + this.out.quote(title) + ", scale_color, " + legendTicks);
        if (dateFormat != null) {
            this.out.add(", BrunelData.util_DateFormat." + dateFormat.name());
        }
        this.out.add(")").endStatement();
    }

    private void addColorScale(Param p, VisSingle vis) {
        boolean largeElement;
        Field f = this.fieldById(p, vis);
        boolean bl = largeElement = vis.tElement == VisTypes.Element.area || vis.tElement == VisTypes.Element.bar || vis.tElement == VisTypes.Element.polygon;
        if (vis.tDiagram == VisTypes.Diagram.map || vis.tDiagram == VisTypes.Diagram.treemap) {
            largeElement = true;
        }
        if (vis.tElement == VisTypes.Element.path && !vis.fSize.isEmpty()) {
            largeElement = true;
        }
        ColorMapping palette = Palette.makeColorMapping(f, p.modifiers(), largeElement);
        int categories = this.defineScaleWithDomain("color", new Field[]{f}, ScalePurpose.color, palette.values.length, "linear", palette.values, false);
        if (categories <= 0) {
            this.out.addChained("interpolate(d3.interpolateHcl)");
        }
        this.out.addChained("range([ ").addQuoted(palette.colors).add("])").endStatement();
    }

    private void addOpacityScale(Param p, VisSingle vis) {
        double min = p.hasModifiers() ? p.firstModifier().asDouble() : 0.2;
        Field f = this.fieldById(p, vis);
        this.defineScaleWithDomain("opacity", new Field[]{f}, ScalePurpose.color, 2, "linear", null, false);
        if (f.preferCategorical()) {
            int length = f.categories().length;
            double[] sizes = new double[length];
            if (length == 1) {
                sizes[0] = min;
            } else {
                for (int i = 0; i < length; ++i) {
                    sizes[i] = min + (1.0 - min) * (double)i / (double)(length - 1);
                }
            }
            this.out.addChained("range(" + Arrays.toString(sizes) + ")");
        } else {
            this.out.addChained("range([" + min + ", 1])");
        }
        this.out.endStatement();
    }

    private void addSizeScale(String name, Param p, VisSingle vis, String defaultTransform) {
        Object[] sizes = p.modifiers().length > 0 ? this.getSizes(p.modifiers()[0].asList()) : new Object[]{0.001, 1.0};
        Field f = this.fieldById(p, vis);
        Object[] divisions = f.isNumeric() ? null : f.categories();
        this.defineScaleWithDomain(name, new Field[]{f}, ScalePurpose.size, sizes.length, defaultTransform, divisions, false);
        this.out.addChained("range([ ").add(Data.join((Object[])sizes)).add("])").endStatement();
    }

    private Field fieldById(Param p, VisSingle vis) {
        return this.fieldById(p.asField(), vis);
    }

    private Param getOpacity(VisSingle vis) {
        return vis.fOpacity.isEmpty() ? null : vis.fOpacity.get(0);
    }

    private Param[] getSize(VisSingle vis) {
        List<Param> fSize = vis.fSize;
        return fSize.toArray(new Param[fSize.size()]);
    }

    private Object[] getSizes(List<Param> params) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (Param p : params) {
            Double d;
            String s = p.asString();
            if (s.endsWith("%")) {
                s = s.substring(0, s.length() - 1);
            }
            if ((d = Data.asNumeric((Object)s)) == null) continue;
            result.add(d / 100.0);
        }
        if (result.isEmpty()) {
            return new Object[]{0.001, 1.0};
        }
        if (result.size() == 1) {
            result.add(0, 0.001);
        }
        return result.toArray(new Object[result.size()]);
    }

    private static final class AxisSpec {
        static final AxisSpec DEFAULT = new AxisSpec();
        final int ticks;
        final String name;
        final boolean grid;
        final boolean reverse;

        private AxisSpec() {
            this.ticks = 9999;
            this.name = null;
            this.grid = false;
            this.reverse = false;
        }

        public AxisSpec(int ticks, String name, boolean grid, boolean reverse) {
            this.ticks = ticks;
            this.name = name;
            this.grid = grid;
            this.reverse = reverse;
        }

        public AxisSpec merge(Param[] params) {
            AxisSpec result = this;
            for (Param p : params) {
                if (p.type() == Param.Type.number) {
                    int newTicks = Math.min((int)p.asDouble(), result.ticks);
                    result = new AxisSpec(newTicks, result.name, result.grid, result.reverse);
                    continue;
                }
                if (p.type() == Param.Type.string) {
                    String newTitle = p.asString();
                    result = new AxisSpec(result.ticks, newTitle, result.grid, result.reverse);
                    continue;
                }
                if (p.type() != Param.Type.option) continue;
                if ("grid".equals(p.asString())) {
                    result = new AxisSpec(result.ticks, result.name, true, result.reverse);
                    continue;
                }
                if (!"reverse".equals(p.asString())) continue;
                result = new AxisSpec(result.ticks, result.name, result.grid, true);
            }
            return result;
        }
    }
}

