/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3Util;
import org.brunel.build.data.DataTransformParameters;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.summary.FieldRowComparison;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.Range;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3DataBuilder {
    private final VisSingle vis;
    private final ScriptWriter out;
    private final Dataset data;
    private final int datasetIndex;

    public static void writeTables(VisItem main, ScriptWriter out, BuilderOptions options) {
        if (options.includeData == BuilderOptions.DataMethod.none) {
            return;
        }
        if (options.includeData == BuilderOptions.DataMethod.minimal) {
            throw new UnsupportedOperationException("Cannot make minimal data yet");
        }
        out.titleComment("Data Tables");
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setGroupingUsed(false);
        ((NumberFormat)format).setMinimumFractionDigits(0);
        ((NumberFormat)format).setMaximumFractionDigits(8);
        Dataset[] datasets = main.getDataSets();
        for (int d = 0; d < datasets.length; ++d) {
            String name;
            int i;
            Field[] fields;
            Dataset data = datasets[d];
            if (options.includeData == BuilderOptions.DataMethod.columns) {
                LinkedHashSet<Field> fieldsAsSet = new LinkedHashSet<Field>();
                D3DataBuilder.addUsedFields(main, data, fieldsAsSet);
                fields = fieldsAsSet.toArray(new Field[fieldsAsSet.size()]);
            } else {
                fields = data.fields;
            }
            if (fields.length == 0) {
                fields = new Field[]{Fields.makeConstantField((String)"_dummy_", (String)"Dummy", (Object)1.0, (int)data.rowCount())};
            }
            out.onNewLine().add("var", String.format(options.dataName, d + 1), "= {").indentMore();
            out.onNewLine().add(" names: [");
            for (i = 0; i < fields.length; ++i) {
                if (fields[i].isSynthetic()) continue;
                name = fields[i].name;
                if (i > 0) {
                    out.add(", ");
                }
                out.add("'").add(name).add("'");
            }
            out.add("], ");
            out.onNewLine().add(" options: [");
            for (i = 0; i < fields.length; ++i) {
                if (fields[i].isSynthetic()) continue;
                name = fields[i].isDate() ? "date" : (fields[i].isProperty("list") ? "list" : (fields[i].isNumeric() ? "numeric" : "string"));
                if (i > 0) {
                    out.add(", ");
                }
                out.add("'").add(name).add("'");
            }
            out.add("], ");
            out.onNewLine().add(" rows: [");
            for (int r = 0; r < data.rowCount(); ++r) {
                if (r > 0) {
                    out.add(",");
                }
                String rowText = D3DataBuilder.makeRowText(fields, r, format);
                if (out.currentColumn() + rowText.length() > 99) {
                    out.onNewLine();
                } else if (r > 0) {
                    out.add(" ");
                }
                out.add(rowText);
            }
            out.add("]");
            out.indentLess().onNewLine().add("}").endStatement();
        }
    }

    private static void addUsedFields(VisItem item, Dataset data, Collection<Field> fields) {
        if (item.children() == null) {
            VisSingle vis = (VisSingle)item;
            if (vis.getDataset() != data) {
                return;
            }
            for (String f : vis.usedFields(true)) {
                Field field;
                if (f.startsWith("#") || (field = data.field(f, true)) == null) continue;
                fields.add(field);
            }
        } else {
            for (VisItem i : item.children()) {
                D3DataBuilder.addUsedFields(i, data, fields);
            }
        }
    }

    private static String makeRowText(Field[] fields, int r, NumberFormat format) {
        StringBuilder row = new StringBuilder();
        D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
        row.append("[");
        for (int i = 0; i < fields.length; ++i) {
            Object value;
            Field field = fields[i];
            if (field.name.startsWith("#")) continue;
            if (i > 0) {
                row.append(", ");
            }
            if ((value = field.value(r)) == null) {
                row.append("null");
                continue;
            }
            if (value instanceof Range) {
                row.append(Data.quote((String)value.toString()));
                continue;
            }
            if (field.isDate()) {
                Date date = Data.asDate((Object)value);
                if (date == null) {
                    row.append("null");
                    continue;
                }
                row.append(dateBuilder.make(date, (DateFormat)field.property("dateFormat"), false));
                continue;
            }
            if (field.isNumeric()) {
                Double d = Data.asNumeric((Object)value);
                if (d == null) {
                    row.append("null");
                    continue;
                }
                row.append(format.format(d));
                continue;
            }
            row.append(Data.quote((String)value.toString()));
        }
        row.append("]");
        return row.toString();
    }

    public D3DataBuilder(VisSingle vis, ScriptWriter out, Dataset data, int index) {
        this.vis = vis;
        this.out = out;
        this.data = data;
        this.datasetIndex = index;
    }

    public void writeDataManipulation(Map<String, Integer> requiredFields) {
        this.out.onNewLine().ln().add("function makeData() {").ln().indentMore();
        if (this.vis.tGuides.isEmpty()) {
            this.writeDataTransforms();
            this.writeHookup(requiredFields);
        }
        this.out.indentLess().onNewLine().add("}").ln();
    }

    private void writeDataTransforms() {
        DataTransformParameters params = (DataTransformParameters)this.data.property("parameters");
        D3Util.addTiming("Data Start", this.out);
        this.out.add("original = datasets[" + this.datasetIndex + "]").endStatement();
        this.out.add("if (filterRows) original = original.retainRows(filterRows)").endStatement();
        this.out.add("processed = pre(original,", this.datasetIndex, ")");
        this.out.mark();
        this.writeTransform("addConstants", params.constantsCommand);
        Param param = D3Interaction.getInteractionParam(this.vis, VisTypes.Interaction.filter);
        if (param != null) {
            if ("unselected".equals(param.asString())) {
                this.writeTransform("filter", "#selection is \u2717");
            } else {
                this.writeTransform("filter", "#selection is \u2713");
            }
        }
        this.writeTransform("each", params.eachCommand);
        this.writeTransform("transform", params.transformCommand);
        this.writeTransform("summarize", params.summaryCommand);
        this.writeTransform("filter", params.filterCommand);
        if (!params.seriesCommand.isEmpty()) {
            if (params.summaryCommand.isEmpty()) {
                this.writeTransform("reduce", params.usedCommand);
            }
            this.writeTransform("series", params.seriesCommand);
        }
        this.writeTransform("sort", params.sortCommand);
        this.writeTransform("stack", params.stackCommand);
        if (this.vis.tDiagram == VisTypes.Diagram.network && this.vis.fY.size() > 1) {
            String command = "#values=#values";
            for (String s : this.vis.aestheticFields()) {
                if (s.equals("#values")) continue;
                command = command + ";" + s + "=" + s;
            }
            this.writeTransform("summarize", command);
        }
        this.writeTransform("sortRows", params.sortRowsCommand);
        this.out.endStatement();
        this.out.add("processed = post(processed,", this.datasetIndex, ")").endStatement();
        D3Util.addTiming("Data End", this.out);
    }

    private void writeHookup(Map<String, Integer> fieldsToIndex) {
        String fieldID;
        int fieldIndex;
        String[] fields = new String[fieldsToIndex.size()];
        for (Map.Entry<String, Integer> e : fieldsToIndex.entrySet()) {
            fields[e.getValue().intValue()] = e.getKey();
        }
        this.out.onNewLine().add("var ");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                this.out.onNewLine();
            } else {
                this.out.indentMore();
            }
            this.out.add("f" + i, "= processed.field(" + this.out.quote(fields[i]) + ")");
            if (i == fields.length - 1) {
                this.out.endStatement();
                continue;
            }
            this.out.add(",");
        }
        this.out.indentLess();
        this.out.add("var keyFunc = ");
        this.defineKeyFieldFunction(this.makeKeyFields(), false, fieldsToIndex);
        this.out.endStatement();
        this.out.add("data = {").ln().indentMore();
        for (fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
            fieldID = D3Util.canonicalFieldName(fields[fieldIndex]);
            this.out.add(fieldID, ":").at(24).add("function(d) { return f" + fieldIndex + ".value(d.row) },").ln();
        }
        for (fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
            fieldID = D3Util.canonicalFieldName(fields[fieldIndex]);
            this.out.add(fieldID + "_f", ":").at(24).add("function(d) { return f" + fieldIndex + ".valueFormatted(d.row) },").ln();
        }
        this.out.add("_split:").at(24);
        this.defineKeyFieldFunction(this.makeSplitFields(), true, fieldsToIndex);
        this.out.add(",").ln();
        this.out.add("_key:").at(24).add("keyFunc").add(",").ln();
        this.out.add("_rows:").at(24).add("BrunelD3.makeRowsWithKeys(keyFunc, processed.rowCount())");
        if (this.vis.fKeys.size() == 1 && this.vis.fX.size() == 1 && this.vis.fY.size() == 1) {
            this.out.add(",").ln();
            String id = "f" + fieldsToIndex.get(this.vis.fKeys.get(0).asField());
            String x = "f" + fieldsToIndex.get(this.vis.fX.get(0).asField());
            String y = "f" + fieldsToIndex.get(this.vis.fY.get(0).asField());
            this.out.add("_idToPoint:").at(24).add("BrunelD3.locate(" + id, ", ", x, ",", y, ", processed.rowCount())");
        }
        this.out.onNewLine().indentLess().add("}").endStatement();
    }

    private void writeTransform(String name, String command) {
        if (!command.isEmpty()) {
            this.out.addChained(name, "(" + this.out.quote(command) + ")");
        }
    }

    private void defineKeyFieldFunction(List<String> fields, boolean actsOnRowObject, Map<String, Integer> usedFields) {
        this.out.add("function(d) { return ");
        if (fields.isEmpty()) {
            this.out.add("'ALL'");
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                String s = fields.get(i);
                if (i > 0) {
                    this.out.add("+ '|' + ");
                }
                this.out.add("f" + usedFields.get(s));
                this.out.add(actsOnRowObject ? ".value(d.row)" : ".value(d)");
            }
        }
        this.out.add(" }");
    }

    public List<String> makeKeyFields() {
        if (!this.vis.fKeys.isEmpty()) {
            return this.asFields(this.vis.fKeys);
        }
        if (this.vis.tDiagram != null) {
            return this.makeKeyFieldForDiagram(this.vis.tDiagram);
        }
        if (this.vis.tElement.producesSingleShape) {
            List<String> list = this.makeSplitFields();
            this.removeSynthetic(list);
            return list;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.vis.fY.size() > 1) {
            result.add("#values");
            this.addIfCategorical(result, this.vis.fX);
        } else {
            this.addIfCategorical(result, this.vis.positionFields());
        }
        this.addIfCategorical(result, this.vis.aestheticFields());
        this.removeSynthetic(result);
        if (!this.suitableForKey(result)) {
            result.clear();
            result.add("#row");
            if (this.vis.fY.size() > 1) {
                result.add("#series");
            }
            for (Map.Entry<Param, String> e : this.vis.fTransform.entrySet()) {
                if (!e.getValue().equals("each")) continue;
                result.add(e.getKey().asField());
            }
        }
        return new ArrayList<String>(result);
    }

    private void removeSynthetic(Collection<String> result) {
        result.remove("#selection");
        result.remove("#row");
        result.remove("#count");
    }

    private List<String> makeKeyFieldForDiagram(VisTypes.Diagram diagram) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (diagram == VisTypes.Diagram.network && this.vis.fY.size() > 1) {
            return Collections.singletonList("#values");
        }
        Collections.addAll(result, this.vis.positionFields());
        if (diagram != VisTypes.Diagram.map) {
            this.addIfCategorical(result, this.vis.aestheticFields());
        }
        if (this.suitableForKey(result)) {
            ArrayList<String> list = new ArrayList<String>(result);
            if (result.contains("#selection")) {
                list.remove("#selection");
                if (!this.suitableForKey(list)) {
                    list.add("#selection");
                }
            }
            return list;
        }
        return Collections.singletonList("#row");
    }

    private void addIfCategorical(Collection<String> result, String ... fieldNames) {
        for (String f : fieldNames) {
            Field field = this.data.field(f, true);
            if (!field.preferCategorical() && !field.isDate() || field.isProperty("calculated")) continue;
            result.add(f);
        }
    }

    private void addIfCategorical(Collection<String> result, Collection<Param> fieldNames) {
        for (Param p : fieldNames) {
            String f = p.asField(this.data);
            Field field = this.data.field(f);
            if (!field.preferCategorical() && !field.isDate() || field.isProperty("calculated")) continue;
            result.add(f);
        }
    }

    private List<String> makeSplitFields() {
        ArrayList<String> splitters = new ArrayList<String>();
        for (Param p : this.vis.fSplits) {
            splitters.add(p.asField());
        }
        for (Param p : this.vis.fColor) {
            splitters.add(p.asField());
        }
        for (Param p : this.vis.fOpacity) {
            splitters.add(p.asField());
        }
        if (this.vis.tElement != VisTypes.Element.line && this.vis.tElement != VisTypes.Element.path) {
            for (Param p : this.vis.fSize) {
                splitters.add(p.asField());
            }
        }
        return splitters;
    }

    private List<String> asFields(List<Param> items) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Param p : items) {
            fields.add(p.asField());
        }
        return fields;
    }

    private boolean suitableForKey(Collection<String> result) {
        if (result.isEmpty()) {
            return false;
        }
        Field[] fields = new Field[result.size()];
        int index = 0;
        for (String s : result) {
            fields[index++] = this.data.field(s);
        }
        FieldRowComparison rowComparison = new FieldRowComparison(fields, null, false);
        int[] order = rowComparison.makeSortedOrder();
        for (int i = 1; i < order.length; ++i) {
            if (rowComparison.compare(Integer.valueOf(order[i]), Integer.valueOf(order[i - 1])) != 0) continue;
            return false;
        }
        return true;
    }
}

