/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.AbstractBuilder;
import org.brunel.build.controls.Controls;
import org.brunel.build.d3.D3DataBuilder;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.d3.GuideBuilder;
import org.brunel.build.d3.SVGGroupUtility;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.d3.titles.ChartTitleBuilder;
import org.brunel.build.data.DataTransformParameters;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.Accessibility;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3Builder
extends AbstractBuilder {
    private static final String COPYRIGHT_COMMENTS = "\t<!--\n\t\tD3 Copyright \u00a9 2012, Michael Bostock\n\t\tjQuery Copyright \u00a9 2010 by The jQuery Project\n\t\tsumoselect Copyright \u00a9 2014 Hemant Negi\n \t-->\n";
    private ScriptWriter out;
    public int visWidth;
    public int visHeight;
    private D3ScaleBuilder scalesBuilder;
    private D3Interaction interaction;
    private D3ElementBuilder[] elementBuilders;
    private boolean hasMultipleCharts;

    public static D3Builder make() {
        return D3Builder.make(new BuilderOptions());
    }

    public static D3Builder make(BuilderOptions options) {
        return new D3Builder(options);
    }

    private D3Builder(BuilderOptions options) {
        super(options);
    }

    @Override
    public String getVisualization() {
        return this.out.content();
    }

    @Override
    public String makeImports() {
        String pattern = "\t<script src=\"%s\" charset=\"utf-8\"></script>\n";
        String base = COPYRIGHT_COMMENTS + String.format(pattern, BuilderOptions.fullLocation(this.options.locD3)) + String.format(pattern, BuilderOptions.fullLocation(this.options.locTopoJson));
        if (this.getControls().isNeeded()) {
            base = base + String.format(pattern, "http://code.jquery.com/jquery-1.10.2.js") + String.format(pattern, "http://code.jquery.com/ui/1.11.4/jquery-ui.js");
        }
        if (this.options.locJavaScript.startsWith("file")) {
            base = base + String.format(pattern, this.options.locJavaScript + "/BrunelData.js") + String.format(pattern, this.options.locJavaScript + "/BrunelD3.js");
            if (this.getControls().isNeeded()) {
                base = base + String.format(pattern, this.options.locJavaScript + "/BrunelEventHandlers.js") + String.format(pattern, this.options.locJavaScript + "/BrunelJQueryControlFactory.js") + String.format(pattern, this.options.locJavaScript + "/sumoselect/jquery.sumoselect.min.js");
            }
        } else {
            base = base + String.format(pattern, this.options.locJavaScript + "/brunel." + this.options.version + ".min.js");
            if (this.getControls().isNeeded()) {
                base = base + String.format(pattern, this.options.locJavaScript + "/brunel.controls." + this.options.version + ".min.js");
            }
        }
        return base;
    }

    @Override
    protected void defineChart(ChartStructure structure, double[] location) {
        double[] chartMargins = new double[]{location[0] / 100.0, location[1] / 100.0, location[2] / 100.0, location[3] / 100.0};
        this.createBuilders(structure, chartMargins);
        this.out.titleComment("Define chart #" + structure.chartID(), "in the visualization");
        this.out.add("charts[" + structure.chartIndex + "] = function(parentNode, filterRows) {").ln();
        this.out.indentMore();
        double[] margins = this.scalesBuilder.marginsTLBR();
        ChartTitleBuilder title = new ChartTitleBuilder(structure, "header");
        ChartTitleBuilder sub = new ChartTitleBuilder(structure, "footer");
        margins[0] = margins[0] + title.verticalSpace();
        margins[2] = margins[2] + sub.verticalSpace();
        this.scalesBuilder.setAdditionalHAxisOffset(sub.verticalSpace());
        this.out.add("var geom = BrunelD3.geometry(parentNode || vis.node(),", chartMargins, ",", margins, "),").indentMore().onNewLine().add("elements = [];").at(50).comment("Array of elements in this chart").indentLess();
        if (this.forceSquare(structure.elements)) {
            this.out.add("geom.makeSquare()").endStatement();
        }
        if (this.scalesBuilder.coords == VisTypes.Coordinates.transposed) {
            this.out.add("geom.transpose()").endStatement();
        }
        this.out.titleComment("Define groups for the chart parts");
        this.writeMainGroups(structure);
        for (D3ElementBuilder builder : this.elementBuilders) {
            builder.writePerChartDefinitions();
        }
        title.writeContent("chart", this.out);
        sub.writeContent("chart", this.out);
        if (structure.diagram == null) {
            this.out.titleComment("Scales");
            this.scalesBuilder.writeCoordinateScales();
            if (this.scalesBuilder.needsAxes()) {
                this.out.titleComment("Axes");
                this.scalesBuilder.writeAxes();
            }
        } else {
            this.scalesBuilder.writeDiagramScales();
        }
        this.interaction.addZoomFunctionality();
    }

    private boolean forceSquare(VisSingle[] elements) {
        for (VisSingle e : elements) {
            for (Param p : e.fCoords) {
                if (!p.asString().equals("square")) continue;
                return true;
            }
        }
        return false;
    }

    private void createBuilders(ChartStructure structure, double[] chartMargins) {
        double chartWidth = (double)this.visWidth - chartMargins[1] - chartMargins[3];
        double chartHeight = (double)this.visHeight - chartMargins[0] - chartMargins[2];
        this.scalesBuilder = new D3ScaleBuilder(structure, chartWidth, chartHeight, this.out);
        this.interaction = new D3Interaction(structure, this.scalesBuilder, this.out);
        ElementStructure[] structures = structure.elementStructure;
        this.elementBuilders = new D3ElementBuilder[structures.length];
        for (int i = 0; i < structures.length; ++i) {
            this.elementBuilders[i] = structures[i].vis.tGuides.isEmpty() ? new D3ElementBuilder(structures[i], this.out, this.scalesBuilder, this.interaction) : new GuideBuilder(structures[i], this.out, this.scalesBuilder, this.interaction);
        }
    }

    @Override
    protected void defineElement(ElementStructure structure) {
        D3ElementBuilder elementBuilder = this.elementBuilders[structure.index];
        this.out.titleComment("Define element #" + structure.elementID());
        this.out.add("elements[" + structure.index + "] = function() {").indentMore();
        this.out.onNewLine().add("var original, processed,").at(40).comment("data sets passed in and then transformed").indentMore().onNewLine().add("element, data,").at(40).comment("Brunel element information and brunel data").onNewLine().add("selection, merged;").at(40).comment("D3 selection and merged selection").indentLess();
        this.addElementGroups(elementBuilder, structure);
        int datasetIndex = structure.getBaseDatasetIndex();
        VisSingle vis = structure.vis;
        D3DataBuilder dataBuilder = new D3DataBuilder(vis, this.out, structure.data, datasetIndex);
        dataBuilder.writeDataManipulation(this.createResultFields(vis));
        this.scalesBuilder.writeAestheticScales(structure);
        this.scalesBuilder.writeLegends(vis);
        elementBuilder.preBuildDefinitions();
        this.out.titleComment("Build element from data");
        this.out.add("function build(transitionMillis) {").ln().indentMore();
        elementBuilder.generate(structure.index);
        this.interaction.addHandlers(vis.tInteraction);
        Integer index = structure.chart.innerChartIndex;
        if (index != null) {
            String id = ChartStructure.makeChartID(index);
            this.out.onNewLine().comment("Build the faceted charts within this chart's selection");
            this.out.add("vis.select('g.chart" + id + "').selectAll('*').remove()").endStatement().add("BrunelD3.facet(charts[" + index + "], element, transitionMillis)").endStatement();
        }
        this.out.indentLess().onNewLine().add("}").ln().ln();
        this.addElementExports(vis, dataBuilder, structure);
        this.out.indentLess().onNewLine().add("}()").endStatement().ln();
    }

    @Override
    protected void defineVisSystem(VisItem main, int width, int height) {
        this.visWidth = width;
        this.visHeight = height;
        this.out = new ScriptWriter(this.options);
        this.hasMultipleCharts = main.children() != null && main.children().length > 1;
        this.out.add("function ", this.options.className, "(visId) {").ln().indentMore();
        this.out.add("\"use strict\";").comment("Strict Mode");
        this.out.add("var datasets = [],").at(50).comment("Array of datasets for the original data");
        this.out.add("    pre = function(d, i) { return d },").at(50).comment("Default pre-process does nothing");
        this.out.add("    post = function(d, i) { return d },").at(50).comment("Default post-process does nothing");
        this.out.add("    transitionTime = 200,").at(50).comment("Transition time for animations");
        this.out.add("    charts = [],").at(50).comment("The charts in the system");
        this.out.add("    hasData = function(d) {return d && (d.row != null || hasData(d.data))},").at(50).comment("Filters to data items");
        this.out.add("    vis = d3.select('#' + visId).attr('class', 'brunel');").at(60).comment("the SVG container");
    }

    @Override
    protected void endChart(ChartStructure structure) {
        int i;
        int i$;
        int len$;
        Object[] arr$;
        this.out.onNewLine().add("function build(time, noData) {").indentMore();
        this.out.onNewLine().add("var first = elements[0].data() == null").endStatement();
        this.out.add("if (first) time = 0;").comment("No transition for first call");
        if (this.scalesBuilder.needsAxes()) {
            this.out.onNewLine().add("buildAxes(time)").endStatement();
        }
        if (structure.geo != null && structure.geo.withGraticule) {
            this.out.onNewLine().add("buildAxes(time)").endStatement();
        }
        Integer[] order = structure.elementBuildOrder();
        this.out.onNewLine().add("if ((first || time > -1) && !noData)");
        if (order.length > 1) {
            this.out.add("{").indentMore();
            arr$ = order;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                i = arr$[i$];
                this.out.onNewLine().add("elements[" + i + "].makeData();");
            }
            this.out.indentLess().onNewLine().add("}").ln();
        } else {
            this.out.add("elements[0].makeData()").endStatement();
        }
        arr$ = order;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            this.out.onNewLine().add("elements[" + i + "].build(time);");
        }
        for (D3ElementBuilder builder : this.elementBuilders) {
            builder.writeBuildCommands();
        }
        this.out.indentLess().onNewLine().add("}").ln();
        this.out.ln().comment("Expose the following components of the chart");
        this.out.add("return {").indentMore().onNewLine().add("elements : elements,").onNewLine().add("interior : interior,");
        if (structure.diagram == null) {
            this.out.onNewLine().add("scales: {x:scale_x, y:scale_y},");
        }
        this.interaction.defineChartZoomFunction();
        this.out.onNewLine().add("build : build").indentLess().onNewLine().add("}").endStatement();
        if (this.nesting.containsKey(structure.chartIndex)) {
            this.out.add("}");
        } else {
            this.out.add("}()");
        }
        this.out.indentLess().endStatement().ln();
    }

    @Override
    protected void endVisSystem(VisItem main) {
        this.out.add("function setData(rowData, i) { datasets[i||0] = BrunelD3.makeData(rowData) }").ln();
        if (this.nesting.isEmpty()) {
            this.out.add("function updateAll(time) { charts.forEach(function(x) {x.build(time || 0)}) }").ln();
        } else {
            this.out.add("function updateAll(time) {").indentMore().ln().add("var t = time || 20").endStatement().add("charts[0].build(0)").endStatement().indentLess().add("}").ln();
        }
        this.out.add("function buildAll() {").ln().indentMore().add("for (var i=0;i<arguments.length;i++) setData(arguments[i], i)").endStatement().add("updateAll(transitionTime)").endStatement();
        this.out.indentLess().add("}").ln().ln();
        this.out.add("return {").indentMore().ln().add("dataPreProcess:").at(24).add("function(f) { if (f) pre = f; return pre },").ln().add("dataPostProcess:").at(24).add("function(f) { if (f) post = f; return post },").ln().add("data:").at(24).add("function(d,i) { if (d) setData(d,i); return datasets[i||0] },").ln().add("visId:").at(24).add("visId,").ln().add("build:").at(24).add("buildAll,").ln().add("rebuild:").at(24).add("updateAll,").ln().add("charts:").at(24).add("charts").ln().indentLess().add("}").ln();
        this.out.indentLess().onNewLine().add("}").ln();
        D3DataBuilder.writeTables(main, this.out, this.options);
        if (this.options.generateBuildCode) {
            this.out.titleComment("Call Code to Build the system");
            this.out.add("var v = new", this.options.className, "(" + this.out.quote(this.options.visIdentifier) + ")").endStatement();
            this.controls.writeEventHandler(this.out, "v");
            int length = main.getDataSets().length;
            int enterAnimateTime = this.enterAnimate(main, length);
            if (enterAnimateTime > 0) {
                this.out.add("BrunelD3.animateBuild(v,", String.format(this.options.dataName, 1), ",", enterAnimateTime, ")").endStatement();
            } else {
                this.out.add("v.build(");
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        this.out.add(", ");
                    }
                    this.out.add(String.format(this.options.dataName, i + 1));
                }
                this.out.add(")").endStatement();
            }
        }
        this.controls.writeControls(this.out, "v");
    }

    private int enterAnimate(VisItem main, int dataSetCount) {
        if (dataSetCount != 1) {
            return -1;
        }
        if (main.children() != null) {
            for (VisItem child : main.children()) {
                int v = this.enterAnimate(child, dataSetCount);
                if (v < 0) continue;
                return v;
            }
        }
        List<Param> effects = main.getSingle().getSingle().fEffects;
        for (Param p : effects) {
            if (p.type() != Param.Type.option || !p.asString().equals("enter")) continue;
            if (p.hasModifiers()) {
                try {
                    return (int)p.modifiers()[0].asDouble();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 700;
        }
        return -1;
    }

    private void addElementGroups(D3ElementBuilder builder, ElementStructure structure) {
        String elementTransform = this.makeElementTransform(this.scalesBuilder.coords);
        this.out.add("var elementGroup = interior.append('g').attr('class', 'element" + structure.elementID() + "')");
        Accessibility.addElementInformation(structure, this.out);
        if (elementTransform != null) {
            this.out.addChained(elementTransform);
        }
        if (builder.needsDiagramExtras()) {
            this.out.continueOnNextLine(",").add("diagramExtras = elementGroup.append('g').attr('class', 'extras')");
        }
        this.out.continueOnNextLine(",").add("main = elementGroup.append('g').attr('class', 'main')");
        if (builder.needsDiagramLabels()) {
            this.out.continueOnNextLine(",").add("diagramLabels = BrunelD3.undoTransform(elementGroup.append('g').attr('class', 'diagram labels').attr('aria-hidden', 'true'), elementGroup)");
        }
        this.out.continueOnNextLine(",").add("labels = BrunelD3.undoTransform(elementGroup.append('g').attr('class', 'labels').attr('aria-hidden', 'true'), elementGroup)").endStatement();
    }

    private Map<String, Integer> createResultFields(VisSingle vis) {
        LinkedHashSet<String> needed = new LinkedHashSet<String>();
        if (vis.fY.size() > 1) {
            if (vis.stacked) {
                needed.add("#values$lower");
                needed.add("#values$upper");
            }
            needed.add("#series");
            needed.add("#values");
            for (Param p : vis.fX) {
                needed.add(p.asField());
            }
            Collections.addAll(needed, vis.nonPositionFields());
        } else {
            if (vis.stacked) {
                String y = vis.fY.get(0).asField();
                needed.add(y + "$lower");
                needed.add(y + "$upper");
            }
            Collections.addAll(needed, vis.usedFields(true));
        }
        needed.add("#row");
        needed.add("#selection");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String s : needed) {
            result.put(s, result.size());
        }
        return result;
    }

    private void addElementExports(VisSingle vis, D3DataBuilder dataBuilder, ElementStructure structure) {
        this.out.add("return {").indentMore();
        this.out.onNewLine().add("data:").at(24).add("function() { return processed },");
        this.out.onNewLine().add("original:").at(24).add("function() { return original },");
        this.out.onNewLine().add("internal:").at(24).add("function() { return data },");
        this.out.onNewLine().add("selection:").at(24).add("function() { return merged },");
        this.out.onNewLine().add("makeData:").at(24).add("makeData,");
        this.out.onNewLine().add("build:").at(24).add("build,");
        this.out.onNewLine().add("chart:").at(24).add("function() { return charts[" + structure.chart.chartIndex + "] },");
        this.out.onNewLine().add("group:").at(24).add("function() { return elementGroup },");
        this.out.onNewLine().add("fields: {").indentMore();
        this.out.mark();
        this.writeFieldName("x", vis.fX);
        if (vis.fRange != null) {
            this.writeFieldName("y", Arrays.asList(vis.fRange));
        } else {
            this.writeFieldName("y", vis.fY);
        }
        List<String> keys = dataBuilder.makeKeyFields();
        if (!keys.isEmpty()) {
            this.writeFieldName("key", keys);
        }
        this.writeFieldName("color", vis.fColor);
        this.writeFieldName("size", vis.fSize);
        this.writeFieldName("opacity", vis.fOpacity);
        this.out.onNewLine().indentLess().add("}");
        this.out.indentLess().onNewLine().add("}").endStatement();
    }

    private String makeElementTransform(VisTypes.Coordinates coords) {
        if (coords == VisTypes.Coordinates.transposed) {
            return "attr('transform','matrix(0,1,1,0,0,0)')";
        }
        if (coords == VisTypes.Coordinates.polar) {
            return this.makeTranslateTransform("geom.inner_width/2", "geom.inner_height/2");
        }
        return null;
    }

    private void writeFieldName(String name, List fieldNames) {
        if (fieldNames.isEmpty()) {
            return;
        }
        if (this.out.changedSinceMark()) {
            this.out.add(",");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Object p : fieldNames) {
            if (p instanceof Param) {
                names.add(((Param)p).asField());
                continue;
            }
            names.add(p.toString());
        }
        this.out.onNewLine().add(name, ":").at(24).add("[").addQuotedCollection(names).add("]");
    }

    private void writeMainGroups(ChartStructure structure) {
        SVGGroupUtility groupUtil = new SVGGroupUtility(structure, "chart" + structure.chartID(), this.out);
        if (structure.nested()) {
            this.out.onNewLine().comment("Nesting -- create an outer chart and place groups inside for each facet");
            this.out.add("var outer = vis.select('g." + groupUtil.className + "')").endStatement();
            this.out.add("if (outer.empty()) outer = ", groupUtil.createChart()).endStatement();
            this.out.add("var chart = outer.append('g').attr('class', 'facet')");
        } else {
            this.out.add("var chart = ", groupUtil.createChart());
        }
        if (this.hasMultipleCharts) {
            groupUtil.addAccessibleChartInfo();
        }
        this.out.addChained(this.makeTranslateTransform("geom.chart_left", "geom.chart_top")).endStatement();
        this.interaction.addOverlayForZoom();
        this.out.add("chart.append('rect').attr('class', 'background')").add(".attr('width', geom.chart_right-geom.chart_left).attr('height', geom.chart_bottom-geom.chart_top)").endStatement();
        String axesTransform = this.makeTranslateTransform("geom.inner_left", "geom.inner_top");
        this.out.add("var interior = chart.append('g').attr('class', 'interior')").addChained(axesTransform);
        if (!structure.nested()) {
            groupUtil.addClipPathReference("inner");
        }
        this.out.endStatement();
        this.out.add("interior.append('rect').attr('class', 'inner')").add(".attr('width', geom.inner_width).attr('height', geom.inner_height)").endStatement();
        this.out.add("var gridGroup = interior.append('g').attr('class', 'grid')").endStatement();
        if (this.scalesBuilder.needsAxes()) {
            this.out.add("var axes = chart.append('g').attr('class', 'axis')").addChained(axesTransform).endStatement();
        }
        if (this.scalesBuilder.needsLegends()) {
            this.out.add("var legends = chart.append('g').attr('class', 'legend')").addChained(this.makeTranslateTransform("(geom.chart_right-geom.chart_left - 3)", "0"));
            groupUtil.addAccessibleTitle("Legend");
            this.out.endStatement();
        }
        if (!structure.nested()) {
            groupUtil.defineInnerClipPath();
        }
    }

    private String makeTranslateTransform(String dx, String dy) {
        return "attr('transform','translate(' + " + dx + " + ',' + " + dy + " + ')')";
    }

    public Controls getControls() {
        return this.controls;
    }

    public String makeStyleSheets() {
        String pattern = "\t<link rel=\"stylesheet\" type=\"text/css\" href=\"%s\" charset=\"utf-8\"/>\n";
        String base = this.options.locJavaScript.startsWith("file") ? String.format(pattern, this.options.locJavaScript + "/Brunel.css") : String.format(pattern, this.options.locJavaScript + "/brunel." + this.options.version + ".css");
        if (this.getControls().isNeeded()) {
            base = base + String.format(pattern, "http://code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css") + String.format(pattern, this.options.locJavaScript + "/sumoselect.css");
        }
        return base;
    }

    @Override
    public DataTransformParameters modifyParameters(DataTransformParameters params, VisSingle vis) {
        String stackCommand = "";
        String sortRows = params.sortRowsCommand;
        if (vis.stacked) {
            if (vis.fY.size() > 1) {
                stackCommand = "#values";
            } else if (vis.fY.size() == 1) {
                stackCommand = vis.fY.get(0).asField();
            }
            stackCommand = stackCommand + "; " + Data.join(vis.fX) + "; " + Data.join((Object[])vis.aestheticFields()) + "; " + vis.tElement.producesSingleShape;
        } else if (vis.tElement == VisTypes.Element.line || vis.tElement == VisTypes.Element.area) {
            String x = vis.fX.get(0).asField() + ":ascending";
            sortRows = sortRows.isEmpty() ? x : sortRows + "; " + x;
        }
        return new DataTransformParameters(params.constantsCommand, params.filterCommand, params.eachCommand, params.transformCommand, params.summaryCommand, stackCommand, params.sortCommand, sortRows, params.seriesCommand, params.usedCommand);
    }
}

