/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.controls;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.build.controls.FilterControl;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

public class Controls {
    public final List<FilterControl> filters;
    private final transient BuilderOptions options;
    private final transient Gson gson = new Gson();

    public Controls(BuilderOptions options) {
        this.options = options;
        this.filters = new ArrayList<FilterControl>();
    }

    public void buildControls(VisSingle vis, Dataset data) {
        for (Param f : vis.fFilter) {
            this.filters.add(FilterControl.makeForFilterField(data, f.asField(data), f.firstModifier()));
        }
        FilterControl animationControl = FilterControl.makeForAnimation(data, vis.fAnimate);
        if (animationControl != null) {
            this.filters.add(animationControl);
        }
    }

    public boolean isNeeded() {
        return !this.filters.isEmpty();
    }

    public void writeControls(ScriptWriter out, String visInstance) {
        if (this.options.controlsIdentifier != null) {
            this.writeControls(this.options.controlsIdentifier, "BrunelJQueryControlFactory", out, visInstance);
        }
    }

    public void writeControls(String controlId, String uiFactoryClass, ScriptWriter out, String visInstance) {
        if (!this.needsControls()) {
            return;
        }
        out.titleComment("Create and wire controls");
        out.add("$(function() {").ln().indentMore();
        this.createFilters(controlId, uiFactoryClass, out, visInstance);
        out.indentLess().ln();
        out.add("})").endStatement();
    }

    public void writeEventHandler(ScriptWriter out, String visInstance) {
        if (!this.needsControls()) {
            return;
        }
        String filterDefaults = this.gson.toJson((JsonElement)FilterControl.buildFilterDefaults(this.filters));
        out.add("var eventHandler = BrunelEventHandlers(", visInstance, ")").endStatement();
        out.add("eventHandler.make_filter_handler(", filterDefaults, ")").endStatement();
    }

    private boolean needsControls() {
        return !this.filters.isEmpty();
    }

    private void createFilters(String controlId, String uiFactoryClass, ScriptWriter out, String visInstance) {
        for (FilterControl filter : this.filters) {
            String fieldId = filter.id;
            String label = filter.label;
            Object[] categories = filter.categories;
            Double low = filter.lowValue;
            Double high = filter.highValue;
            Object[] selectedCategories = filter.selectedCategories;
            Double animateSpeed = filter.animateSpeed;
            Double animateFrames = filter.animateFrames;
            boolean animate = filter.animate;
            if (categories == null) {
                out.add("$(", out.quote("#" + controlId), ").append(", uiFactoryClass, ".make_range_slider(", out.quote(this.options.visIdentifier), ",", out.quote(fieldId), ",", out.quote(label), ",", low, ",", high, ",", visInstance, ".data().field(", out.quote(fieldId), "),", animate, ",", animateFrames, ",", animateSpeed, "))").endStatement();
                continue;
            }
            out.add("$(", out.quote("#" + controlId), ").append(", uiFactoryClass, ".make_category_filter(", out.quote(this.options.visIdentifier), ",", out.quote(fieldId), ",", out.quote(label), ",", this.gson.toJson((Object)categories), ",", this.gson.toJson((Object)selectedCategories), "))").endStatement();
        }
    }
}

