# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._storage_management_client_enums import *


class AccountSasParameters(msrest.serialization.Model):
    """The parameters to list SAS credentials of a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar services: Required. The signed services accessible with the account SAS. Possible values
     include: Blob (b), Queue (q), Table (t), File (f). Possible values include: "b", "q", "t", "f".
    :vartype services: str or ~azure.mgmt.storage.v2019_04_01.models.Services
    :ivar resource_types: Required. The signed resource types that are accessible with the account
     SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs;
     Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     Possible values include: "s", "c", "o".
    :vartype resource_types: str or ~azure.mgmt.storage.v2019_04_01.models.SignedResourceTypes
    :ivar permissions: Required. The signed permissions for the account SAS. Possible values
     include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process
     (p). Possible values include: "r", "d", "w", "l", "a", "c", "u", "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2019_04_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Possible
     values include: "https,http", "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2019_04_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: Required. The time at which the shared access signature
     becomes invalid.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    """

    _validation = {
        'services': {'required': True},
        'resource_types': {'required': True},
        'permissions': {'required': True},
        'shared_access_expiry_time': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'signedServices', 'type': 'str'},
        'resource_types': {'key': 'signedResourceTypes', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'str'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        services: Union[str, "Services"],
        resource_types: Union[str, "SignedResourceTypes"],
        permissions: Union[str, "Permissions"],
        shared_access_expiry_time: datetime.datetime,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        key_to_sign: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword services: Required. The signed services accessible with the account SAS. Possible
         values include: Blob (b), Queue (q), Table (t), File (f). Possible values include: "b", "q",
         "t", "f".
        :paramtype services: str or ~azure.mgmt.storage.v2019_04_01.models.Services
        :keyword resource_types: Required. The signed resource types that are accessible with the
         account SAS. Service (s): Access to service-level APIs; Container (c): Access to
         container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table
         entities, and files. Possible values include: "s", "c", "o".
        :paramtype resource_types: str or ~azure.mgmt.storage.v2019_04_01.models.SignedResourceTypes
        :keyword permissions: Required. The signed permissions for the account SAS. Possible values
         include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process
         (p). Possible values include: "r", "d", "w", "l", "a", "c", "u", "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2019_04_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Possible
         values include: "https,http", "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2019_04_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: Required. The time at which the shared access signature
         becomes invalid.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        """
        super(AccountSasParameters, self).__init__(**kwargs)
        self.services = services
        self.resource_types = resource_types
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.key_to_sign = key_to_sign


class ActiveDirectoryProperties(msrest.serialization.Model):
    """Settings properties for Active Directory (AD).

    All required parameters must be populated in order to send to Azure.

    :ivar domain_name: Required. Specifies the primary domain that the AD DNS server is
     authoritative for.
    :vartype domain_name: str
    :ivar net_bios_domain_name: Required. Specifies the NetBIOS domain name.
    :vartype net_bios_domain_name: str
    :ivar forest_name: Required. Specifies the Active Directory forest to get.
    :vartype forest_name: str
    :ivar domain_guid: Required. Specifies the domain GUID.
    :vartype domain_guid: str
    :ivar domain_sid: Required. Specifies the security identifier (SID).
    :vartype domain_sid: str
    :ivar azure_storage_sid: Required. Specifies the security identifier (SID) for Azure Storage.
    :vartype azure_storage_sid: str
    """

    _validation = {
        'domain_name': {'required': True},
        'net_bios_domain_name': {'required': True},
        'forest_name': {'required': True},
        'domain_guid': {'required': True},
        'domain_sid': {'required': True},
        'azure_storage_sid': {'required': True},
    }

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'net_bios_domain_name': {'key': 'netBiosDomainName', 'type': 'str'},
        'forest_name': {'key': 'forestName', 'type': 'str'},
        'domain_guid': {'key': 'domainGuid', 'type': 'str'},
        'domain_sid': {'key': 'domainSid', 'type': 'str'},
        'azure_storage_sid': {'key': 'azureStorageSid', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        net_bios_domain_name: str,
        forest_name: str,
        domain_guid: str,
        domain_sid: str,
        azure_storage_sid: str,
        **kwargs
    ):
        """
        :keyword domain_name: Required. Specifies the primary domain that the AD DNS server is
         authoritative for.
        :paramtype domain_name: str
        :keyword net_bios_domain_name: Required. Specifies the NetBIOS domain name.
        :paramtype net_bios_domain_name: str
        :keyword forest_name: Required. Specifies the Active Directory forest to get.
        :paramtype forest_name: str
        :keyword domain_guid: Required. Specifies the domain GUID.
        :paramtype domain_guid: str
        :keyword domain_sid: Required. Specifies the security identifier (SID).
        :paramtype domain_sid: str
        :keyword azure_storage_sid: Required. Specifies the security identifier (SID) for Azure
         Storage.
        :paramtype azure_storage_sid: str
        """
        super(ActiveDirectoryProperties, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.net_bios_domain_name = net_bios_domain_name
        self.forest_name = forest_name
        self.domain_guid = domain_guid
        self.domain_sid = domain_sid
        self.azure_storage_sid = azure_storage_sid


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class AzureFilesIdentityBasedAuthentication(msrest.serialization.Model):
    """Settings for Azure Files identity based authentication.

    All required parameters must be populated in order to send to Azure.

    :ivar directory_service_options: Required. Indicates the directory service used. Possible
     values include: "None", "AADDS", "AD".
    :vartype directory_service_options: str or
     ~azure.mgmt.storage.v2019_04_01.models.DirectoryServiceOptions
    :ivar active_directory_properties: Required if choose AD.
    :vartype active_directory_properties:
     ~azure.mgmt.storage.v2019_04_01.models.ActiveDirectoryProperties
    """

    _validation = {
        'directory_service_options': {'required': True},
    }

    _attribute_map = {
        'directory_service_options': {'key': 'directoryServiceOptions', 'type': 'str'},
        'active_directory_properties': {'key': 'activeDirectoryProperties', 'type': 'ActiveDirectoryProperties'},
    }

    def __init__(
        self,
        *,
        directory_service_options: Union[str, "DirectoryServiceOptions"],
        active_directory_properties: Optional["ActiveDirectoryProperties"] = None,
        **kwargs
    ):
        """
        :keyword directory_service_options: Required. Indicates the directory service used. Possible
         values include: "None", "AADDS", "AD".
        :paramtype directory_service_options: str or
         ~azure.mgmt.storage.v2019_04_01.models.DirectoryServiceOptions
        :keyword active_directory_properties: Required if choose AD.
        :paramtype active_directory_properties:
         ~azure.mgmt.storage.v2019_04_01.models.ActiveDirectoryProperties
        """
        super(AzureFilesIdentityBasedAuthentication, self).__init__(**kwargs)
        self.directory_service_options = directory_service_options
        self.active_directory_properties = active_directory_properties


class BlobContainer(AzureEntityResource):
    """Properties of the blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Possible values include: "Container", "Blob", "None".
    :vartype public_access: str or ~azure.mgmt.storage.v2019_04_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Possible values include: "Locked",
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Possible values include: "Available",
     "Leased", "Expired", "Breaking", "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Possible values include: "Infinite", "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseDuration
    :ivar metadata: A name-value pair to associate with the container as metadata.
    :vartype metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2019_04_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'immutability_policy': {'readonly': True},
        'legal_hold': {'readonly': True},
        'has_legal_hold': {'readonly': True},
        'has_immutability_policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_access': {'key': 'properties.publicAccess', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'immutability_policy': {'key': 'properties.immutabilityPolicy', 'type': 'ImmutabilityPolicyProperties'},
        'legal_hold': {'key': 'properties.legalHold', 'type': 'LegalHoldProperties'},
        'has_legal_hold': {'key': 'properties.hasLegalHold', 'type': 'bool'},
        'has_immutability_policy': {'key': 'properties.hasImmutabilityPolicy', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        public_access: Optional[Union[str, "PublicAccess"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword public_access: Specifies whether data in the container may be accessed publicly and
         the level of access. Possible values include: "Container", "Blob", "None".
        :paramtype public_access: str or ~azure.mgmt.storage.v2019_04_01.models.PublicAccess
        :keyword metadata: A name-value pair to associate with the container as metadata.
        :paramtype metadata: dict[str, str]
        """
        super(BlobContainer, self).__init__(**kwargs)
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None


class BlobServiceItems(msrest.serialization.Model):
    """BlobServiceItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blob services returned.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.BlobServiceProperties]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BlobServiceProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BlobServiceItems, self).__init__(**kwargs)
        self.value = None


class BlobServiceProperties(Resource):
    """The properties of a storage account’s Blob service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar cors: Specifies CORS rules for the Blob service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Blob service.
    :vartype cors: ~azure.mgmt.storage.v2019_04_01.models.CorsRules
    :ivar default_service_version: DefaultServiceVersion indicates the default version to use for
     requests to the Blob service if an incoming request’s version is not specified. Possible values
     include version 2008-10-27 and all more recent versions.
    :vartype default_service_version: str
    :ivar delete_retention_policy: The blob service properties for soft delete.
    :vartype delete_retention_policy: ~azure.mgmt.storage.v2019_04_01.models.DeleteRetentionPolicy
    :ivar automatic_snapshot_policy_enabled: Automatic Snapshot is enabled if set to true.
    :vartype automatic_snapshot_policy_enabled: bool
    :ivar change_feed: The blob service properties for change feed events.
    :vartype change_feed: ~azure.mgmt.storage.v2019_04_01.models.ChangeFeed
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
        'default_service_version': {'key': 'properties.defaultServiceVersion', 'type': 'str'},
        'delete_retention_policy': {'key': 'properties.deleteRetentionPolicy', 'type': 'DeleteRetentionPolicy'},
        'automatic_snapshot_policy_enabled': {'key': 'properties.automaticSnapshotPolicyEnabled', 'type': 'bool'},
        'change_feed': {'key': 'properties.changeFeed', 'type': 'ChangeFeed'},
    }

    def __init__(
        self,
        *,
        cors: Optional["CorsRules"] = None,
        default_service_version: Optional[str] = None,
        delete_retention_policy: Optional["DeleteRetentionPolicy"] = None,
        automatic_snapshot_policy_enabled: Optional[bool] = None,
        change_feed: Optional["ChangeFeed"] = None,
        **kwargs
    ):
        """
        :keyword cors: Specifies CORS rules for the Blob service. You can include up to five CorsRule
         elements in the request. If no CorsRule elements are included in the request body, all CORS
         rules will be deleted, and CORS will be disabled for the Blob service.
        :paramtype cors: ~azure.mgmt.storage.v2019_04_01.models.CorsRules
        :keyword default_service_version: DefaultServiceVersion indicates the default version to use
         for requests to the Blob service if an incoming request’s version is not specified. Possible
         values include version 2008-10-27 and all more recent versions.
        :paramtype default_service_version: str
        :keyword delete_retention_policy: The blob service properties for soft delete.
        :paramtype delete_retention_policy:
         ~azure.mgmt.storage.v2019_04_01.models.DeleteRetentionPolicy
        :keyword automatic_snapshot_policy_enabled: Automatic Snapshot is enabled if set to true.
        :paramtype automatic_snapshot_policy_enabled: bool
        :keyword change_feed: The blob service properties for change feed events.
        :paramtype change_feed: ~azure.mgmt.storage.v2019_04_01.models.ChangeFeed
        """
        super(BlobServiceProperties, self).__init__(**kwargs)
        self.cors = cors
        self.default_service_version = default_service_version
        self.delete_retention_policy = delete_retention_policy
        self.automatic_snapshot_policy_enabled = automatic_snapshot_policy_enabled
        self.change_feed = change_feed


class ChangeFeed(msrest.serialization.Model):
    """The blob service properties for change feed events.

    :ivar enabled: Indicates whether change feed event logging is enabled for the Blob service.
    :vartype enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Indicates whether change feed event logging is enabled for the Blob service.
        :paramtype enabled: bool
        """
        super(ChangeFeed, self).__init__(**kwargs)
        self.enabled = enabled


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a storage account name could not be used. The Reason element
     is only returned if NameAvailable is false. Possible values include: "AccountNameInvalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.storage.v2019_04_01.models.Reason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Storage service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.storage.v2019_04_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.storage.v2019_04_01.models.CloudErrorBody]
        """
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CorsRule(msrest.serialization.Model):
    """Specifies a CORS rule for the Blob service.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: Required. Required if CorsRule element is present. A list of origin
     domains that will be allowed via CORS, or "*" to allow all domains.
    :vartype allowed_origins: list[str]
    :ivar allowed_methods: Required. Required if CorsRule element is present. A list of HTTP
     methods that are allowed to be executed by the origin.
    :vartype allowed_methods: list[str or
     ~azure.mgmt.storage.v2019_04_01.models.CorsRuleAllowedMethodsItem]
    :ivar max_age_in_seconds: Required. Required if CorsRule element is present. The number of
     seconds that the client/browser should cache a preflight response.
    :vartype max_age_in_seconds: int
    :ivar exposed_headers: Required. Required if CorsRule element is present. A list of response
     headers to expose to CORS clients.
    :vartype exposed_headers: list[str]
    :ivar allowed_headers: Required. Required if CorsRule element is present. A list of headers
     allowed to be part of the cross-origin request.
    :vartype allowed_headers: list[str]
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'max_age_in_seconds': {'required': True},
        'exposed_headers': {'required': True},
        'allowed_headers': {'required': True},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'allowed_methods': {'key': 'allowedMethods', 'type': '[str]'},
        'max_age_in_seconds': {'key': 'maxAgeInSeconds', 'type': 'int'},
        'exposed_headers': {'key': 'exposedHeaders', 'type': '[str]'},
        'allowed_headers': {'key': 'allowedHeaders', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        allowed_origins: List[str],
        allowed_methods: List[Union[str, "CorsRuleAllowedMethodsItem"]],
        max_age_in_seconds: int,
        exposed_headers: List[str],
        allowed_headers: List[str],
        **kwargs
    ):
        """
        :keyword allowed_origins: Required. Required if CorsRule element is present. A list of origin
         domains that will be allowed via CORS, or "*" to allow all domains.
        :paramtype allowed_origins: list[str]
        :keyword allowed_methods: Required. Required if CorsRule element is present. A list of HTTP
         methods that are allowed to be executed by the origin.
        :paramtype allowed_methods: list[str or
         ~azure.mgmt.storage.v2019_04_01.models.CorsRuleAllowedMethodsItem]
        :keyword max_age_in_seconds: Required. Required if CorsRule element is present. The number of
         seconds that the client/browser should cache a preflight response.
        :paramtype max_age_in_seconds: int
        :keyword exposed_headers: Required. Required if CorsRule element is present. A list of response
         headers to expose to CORS clients.
        :paramtype exposed_headers: list[str]
        :keyword allowed_headers: Required. Required if CorsRule element is present. A list of headers
         allowed to be part of the cross-origin request.
        :paramtype allowed_headers: list[str]
        """
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.max_age_in_seconds = max_age_in_seconds
        self.exposed_headers = exposed_headers
        self.allowed_headers = allowed_headers


class CorsRules(msrest.serialization.Model):
    """Sets the CORS rules. You can include up to five CorsRule elements in the request.

    :ivar cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the
     request.
    :vartype cors_rules: list[~azure.mgmt.storage.v2019_04_01.models.CorsRule]
    """

    _attribute_map = {
        'cors_rules': {'key': 'corsRules', 'type': '[CorsRule]'},
    }

    def __init__(
        self,
        *,
        cors_rules: Optional[List["CorsRule"]] = None,
        **kwargs
    ):
        """
        :keyword cors_rules: The List of CORS rules. You can include up to five CorsRule elements in
         the request.
        :paramtype cors_rules: list[~azure.mgmt.storage.v2019_04_01.models.CorsRule]
        """
        super(CorsRules, self).__init__(**kwargs)
        self.cors_rules = cors_rules


class CustomDomain(msrest.serialization.Model):
    """The custom domain assigned to this storage account. This can be set via Update.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Gets or sets the custom domain name assigned to the storage account. Name
     is the CNAME source.
    :vartype name: str
    :ivar use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
     value is false. This should only be set on updates.
    :vartype use_sub_domain_name: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'use_sub_domain_name': {'key': 'useSubDomainName', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        use_sub_domain_name: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Gets or sets the custom domain name assigned to the storage account.
         Name is the CNAME source.
        :paramtype name: str
        :keyword use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
         value is false. This should only be set on updates.
        :paramtype use_sub_domain_name: bool
        """
        super(CustomDomain, self).__init__(**kwargs)
        self.name = name
        self.use_sub_domain_name = use_sub_domain_name


class DateAfterCreation(msrest.serialization.Model):
    """Object to define the number of days after creation.

    All required parameters must be populated in order to send to Azure.

    :ivar days_after_creation_greater_than: Required. Value indicating the age in days after
     creation.
    :vartype days_after_creation_greater_than: float
    """

    _validation = {
        'days_after_creation_greater_than': {'required': True, 'minimum': 0, 'multiple': 1},
    }

    _attribute_map = {
        'days_after_creation_greater_than': {'key': 'daysAfterCreationGreaterThan', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        days_after_creation_greater_than: float,
        **kwargs
    ):
        """
        :keyword days_after_creation_greater_than: Required. Value indicating the age in days after
         creation.
        :paramtype days_after_creation_greater_than: float
        """
        super(DateAfterCreation, self).__init__(**kwargs)
        self.days_after_creation_greater_than = days_after_creation_greater_than


class DateAfterModification(msrest.serialization.Model):
    """Object to define the number of days after last modification.

    All required parameters must be populated in order to send to Azure.

    :ivar days_after_modification_greater_than: Required. Value indicating the age in days after
     last modification.
    :vartype days_after_modification_greater_than: float
    """

    _validation = {
        'days_after_modification_greater_than': {'required': True, 'minimum': 0, 'multiple': 1},
    }

    _attribute_map = {
        'days_after_modification_greater_than': {'key': 'daysAfterModificationGreaterThan', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        days_after_modification_greater_than: float,
        **kwargs
    ):
        """
        :keyword days_after_modification_greater_than: Required. Value indicating the age in days after
         last modification.
        :paramtype days_after_modification_greater_than: float
        """
        super(DateAfterModification, self).__init__(**kwargs)
        self.days_after_modification_greater_than = days_after_modification_greater_than


class DeleteRetentionPolicy(msrest.serialization.Model):
    """The blob service properties for soft delete.

    :ivar enabled: Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that the deleted blob should be retained. The minimum
     specified value can be 1 and the maximum value can be 365.
    :vartype days: int
    """

    _validation = {
        'days': {'maximum': 365, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        days: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword enabled: Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that the deleted blob should be retained. The
         minimum specified value can be 1 and the maximum value can be 365.
        :paramtype days: int
        """
        super(DeleteRetentionPolicy, self).__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class Dimension(msrest.serialization.Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :ivar name: Display name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Display name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        """
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class Encryption(msrest.serialization.Model):
    """The encryption settings on the storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar services: List of services which support encryption.
    :vartype services: ~azure.mgmt.storage.v2019_04_01.models.EncryptionServices
    :ivar key_source: Required. The encryption keySource (provider). Possible values
     (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include:
     "Microsoft.Storage", "Microsoft.Keyvault". Default value: "Microsoft.Storage".
    :vartype key_source: str or ~azure.mgmt.storage.v2019_04_01.models.KeySource
    :ivar key_vault_properties: Properties provided by key vault.
    :vartype key_vault_properties: ~azure.mgmt.storage.v2019_04_01.models.KeyVaultProperties
    """

    _validation = {
        'key_source': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'services', 'type': 'EncryptionServices'},
        'key_source': {'key': 'keySource', 'type': 'str'},
        'key_vault_properties': {'key': 'keyvaultproperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(
        self,
        *,
        key_source: Union[str, "KeySource"] = "Microsoft.Storage",
        services: Optional["EncryptionServices"] = None,
        key_vault_properties: Optional["KeyVaultProperties"] = None,
        **kwargs
    ):
        """
        :keyword services: List of services which support encryption.
        :paramtype services: ~azure.mgmt.storage.v2019_04_01.models.EncryptionServices
        :keyword key_source: Required. The encryption keySource (provider). Possible values
         (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include:
         "Microsoft.Storage", "Microsoft.Keyvault". Default value: "Microsoft.Storage".
        :paramtype key_source: str or ~azure.mgmt.storage.v2019_04_01.models.KeySource
        :keyword key_vault_properties: Properties provided by key vault.
        :paramtype key_vault_properties: ~azure.mgmt.storage.v2019_04_01.models.KeyVaultProperties
        """
        super(Encryption, self).__init__(**kwargs)
        self.services = services
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties


class EncryptionService(msrest.serialization.Model):
    """A service that allows server-side encryption to be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: A boolean indicating whether or not the service encrypts the data as it is
     stored.
    :vartype enabled: bool
    :ivar last_enabled_time: Gets a rough estimate of the date/time when the encryption was last
     enabled by the user. Only returned when encryption is enabled. There might be some unencrypted
     blobs which were written after this time, as it is just a rough estimate.
    :vartype last_enabled_time: ~datetime.datetime
    """

    _validation = {
        'last_enabled_time': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_enabled_time': {'key': 'lastEnabledTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: A boolean indicating whether or not the service encrypts the data as it is
         stored.
        :paramtype enabled: bool
        """
        super(EncryptionService, self).__init__(**kwargs)
        self.enabled = enabled
        self.last_enabled_time = None


class EncryptionServices(msrest.serialization.Model):
    """A list of services that support encryption.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: The encryption function of the blob storage service.
    :vartype blob: ~azure.mgmt.storage.v2019_04_01.models.EncryptionService
    :ivar file: The encryption function of the file storage service.
    :vartype file: ~azure.mgmt.storage.v2019_04_01.models.EncryptionService
    :ivar table: The encryption function of the table storage service.
    :vartype table: ~azure.mgmt.storage.v2019_04_01.models.EncryptionService
    :ivar queue: The encryption function of the queue storage service.
    :vartype queue: ~azure.mgmt.storage.v2019_04_01.models.EncryptionService
    """

    _validation = {
        'table': {'readonly': True},
        'queue': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'EncryptionService'},
        'file': {'key': 'file', 'type': 'EncryptionService'},
        'table': {'key': 'table', 'type': 'EncryptionService'},
        'queue': {'key': 'queue', 'type': 'EncryptionService'},
    }

    def __init__(
        self,
        *,
        blob: Optional["EncryptionService"] = None,
        file: Optional["EncryptionService"] = None,
        **kwargs
    ):
        """
        :keyword blob: The encryption function of the blob storage service.
        :paramtype blob: ~azure.mgmt.storage.v2019_04_01.models.EncryptionService
        :keyword file: The encryption function of the file storage service.
        :paramtype file: ~azure.mgmt.storage.v2019_04_01.models.EncryptionService
        """
        super(EncryptionServices, self).__init__(**kwargs)
        self.blob = blob
        self.file = file
        self.table = None
        self.queue = None


class Endpoints(msrest.serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        'blob': {'readonly': True},
        'queue': {'readonly': True},
        'table': {'readonly': True},
        'file': {'readonly': True},
        'web': {'readonly': True},
        'dfs': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'queue': {'key': 'queue', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'web': {'key': 'web', 'type': 'str'},
        'dfs': {'key': 'dfs', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Endpoints, self).__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None


class FileServiceItems(msrest.serialization.Model):
    """FileServiceItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of file services returned.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.FileServiceProperties]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FileServiceProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FileServiceItems, self).__init__(**kwargs)
        self.value = None


class FileServiceProperties(Resource):
    """The properties of File services in storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar cors: Specifies CORS rules for the File service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the File service.
    :vartype cors: ~azure.mgmt.storage.v2019_04_01.models.CorsRules
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
    }

    def __init__(
        self,
        *,
        cors: Optional["CorsRules"] = None,
        **kwargs
    ):
        """
        :keyword cors: Specifies CORS rules for the File service. You can include up to five CorsRule
         elements in the request. If no CorsRule elements are included in the request body, all CORS
         rules will be deleted, and CORS will be disabled for the File service.
        :paramtype cors: ~azure.mgmt.storage.v2019_04_01.models.CorsRules
        """
        super(FileServiceProperties, self).__init__(**kwargs)
        self.cors = cors


class FileShare(AzureEntityResource):
    """Properties of the file share, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar metadata: A name-value pair to associate with the share as metadata.
    :vartype metadata: dict[str, str]
    :ivar share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
     less than or equal to 5TB (5120).
    :vartype share_quota: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'share_quota': {'maximum': 5120, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'share_quota': {'key': 'properties.shareQuota', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        share_quota: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword metadata: A name-value pair to associate with the share as metadata.
        :paramtype metadata: dict[str, str]
        :keyword share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
         less than or equal to 5TB (5120).
        :paramtype share_quota: int
        """
        super(FileShare, self).__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = metadata
        self.share_quota = share_quota


class FileShareItem(AzureEntityResource):
    """The file share properties be listed out.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar metadata: A name-value pair to associate with the share as metadata.
    :vartype metadata: dict[str, str]
    :ivar share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
     less than or equal to 5TB (5120).
    :vartype share_quota: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'share_quota': {'maximum': 5120, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'share_quota': {'key': 'properties.shareQuota', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        share_quota: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword metadata: A name-value pair to associate with the share as metadata.
        :paramtype metadata: dict[str, str]
        :keyword share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
         less than or equal to 5TB (5120).
        :paramtype share_quota: int
        """
        super(FileShareItem, self).__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = metadata
        self.share_quota = share_quota


class FileShareItems(msrest.serialization.Model):
    """Response schema. Contains list of shares returned, and if paging is requested or required, a URL to next page of shares.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of file shares returned.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.FileShareItem]
    :ivar next_link: Request URL that can be used to query next page of shares. Returned when total
     number of requested shares exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FileShareItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FileShareItems, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GeoReplicationStats(msrest.serialization.Model):
    """Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the secondary location. Possible values are: - Live: Indicates that
     the secondary location is active and operational. - Bootstrap: Indicates initial
     synchronization from the primary location to the secondary location is in progress.This
     typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary
     location is temporarily unavailable. Possible values include: "Live", "Bootstrap",
     "Unavailable".
    :vartype status: str or ~azure.mgmt.storage.v2019_04_01.models.GeoReplicationStatus
    :ivar last_sync_time: All primary writes preceding this UTC date/time value are guaranteed to
     be available for read operations. Primary writes following this point in time may or may not be
     available for reads. Element may be default value if value of LastSyncTime is not available,
     this can happen if secondary is offline or we are in bootstrap.
    :vartype last_sync_time: ~datetime.datetime
    :ivar can_failover: A boolean flag which indicates whether or not account failover is supported
     for the account.
    :vartype can_failover: bool
    """

    _validation = {
        'status': {'readonly': True},
        'last_sync_time': {'readonly': True},
        'can_failover': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'last_sync_time': {'key': 'lastSyncTime', 'type': 'iso-8601'},
        'can_failover': {'key': 'canFailover', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GeoReplicationStats, self).__init__(**kwargs)
        self.status = None
        self.last_sync_time = None
        self.can_failover = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Has constant value: "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class ImmutabilityPolicy(AzureEntityResource):
    """The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar immutability_period_since_creation_in_days: Required. The immutability period for the
     blobs in the container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Possible values include: "Locked", "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicyState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'immutability_period_since_creation_in_days': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'immutability_period_since_creation_in_days': {'key': 'properties.immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        immutability_period_since_creation_in_days: int,
        **kwargs
    ):
        """
        :keyword immutability_period_since_creation_in_days: Required. The immutability period for the
         blobs in the container since the policy creation, in days.
        :paramtype immutability_period_since_creation_in_days: int
        """
        super(ImmutabilityPolicy, self).__init__(**kwargs)
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None


class ImmutabilityPolicyProperties(msrest.serialization.Model):
    """The properties of an ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar etag: ImmutabilityPolicy Etag.
    :vartype etag: str
    :ivar update_history: The ImmutabilityPolicy update history of the blob container.
    :vartype update_history: list[~azure.mgmt.storage.v2019_04_01.models.UpdateHistoryProperty]
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Possible values include: "Locked", "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicyState
    """

    _validation = {
        'etag': {'readonly': True},
        'update_history': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
        'update_history': {'key': 'updateHistory', 'type': '[UpdateHistoryProperty]'},
        'immutability_period_since_creation_in_days': {'key': 'properties.immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        immutability_period_since_creation_in_days: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword immutability_period_since_creation_in_days: The immutability period for the blobs in
         the container since the policy creation, in days.
        :paramtype immutability_period_since_creation_in_days: int
        """
        super(ImmutabilityPolicyProperties, self).__init__(**kwargs)
        self.etag = None
        self.update_history = None
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None


class IPRule(msrest.serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
     address is allowed.
    :vartype ip_address_or_range: str
    :ivar action: The action of IP ACL rule. The only acceptable values to pass in are None and
     "Allow". The default value is None.
    :vartype action: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address_or_range: str,
        action: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
         address is allowed.
        :paramtype ip_address_or_range: str
        :keyword action: The action of IP ACL rule. The only acceptable values to pass in are None and
         "Allow". The default value is None.
        :paramtype action: str
        """
        super(IPRule, self).__init__(**kwargs)
        self.ip_address_or_range = ip_address_or_range
        self.action = action


class KeyVaultProperties(msrest.serialization.Model):
    """Properties of key vault.

    :ivar key_name: The name of KeyVault key.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of KeyVault.
    :vartype key_vault_uri: str
    """

    _attribute_map = {
        'key_name': {'key': 'keyname', 'type': 'str'},
        'key_version': {'key': 'keyversion', 'type': 'str'},
        'key_vault_uri': {'key': 'keyvaulturi', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: The name of KeyVault key.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key.
        :paramtype key_version: str
        :keyword key_vault_uri: The Uri of KeyVault.
        :paramtype key_vault_uri: str
        """
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri


class LeaseContainerRequest(msrest.serialization.Model):
    """Lease Container request schema.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Required. Specifies the lease action. Can be one of the available actions.
     Possible values include: "Acquire", "Renew", "Change", "Release", "Break".
    :vartype action: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseContainerRequestAction
    :ivar lease_id: Identifies the lease. Can be specified in any valid GUID string format.
    :vartype lease_id: str
    :ivar break_period: Optional. For a break action, proposed duration the lease should continue
     before it is broken, in seconds, between 0 and 60.
    :vartype break_period: int
    :ivar lease_duration: Required for acquire. Specifies the duration of the lease, in seconds, or
     negative one (-1) for a lease that never expires.
    :vartype lease_duration: int
    :ivar proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
     GUID string format.
    :vartype proposed_lease_id: str
    """

    _validation = {
        'action': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'break_period': {'key': 'breakPeriod', 'type': 'int'},
        'lease_duration': {'key': 'leaseDuration', 'type': 'int'},
        'proposed_lease_id': {'key': 'proposedLeaseId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action: Union[str, "LeaseContainerRequestAction"],
        lease_id: Optional[str] = None,
        break_period: Optional[int] = None,
        lease_duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action: Required. Specifies the lease action. Can be one of the available actions.
         Possible values include: "Acquire", "Renew", "Change", "Release", "Break".
        :paramtype action: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseContainerRequestAction
        :keyword lease_id: Identifies the lease. Can be specified in any valid GUID string format.
        :paramtype lease_id: str
        :keyword break_period: Optional. For a break action, proposed duration the lease should
         continue before it is broken, in seconds, between 0 and 60.
        :paramtype break_period: int
        :keyword lease_duration: Required for acquire. Specifies the duration of the lease, in seconds,
         or negative one (-1) for a lease that never expires.
        :paramtype lease_duration: int
        :keyword proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
         GUID string format.
        :paramtype proposed_lease_id: str
        """
        super(LeaseContainerRequest, self).__init__(**kwargs)
        self.action = action
        self.lease_id = lease_id
        self.break_period = break_period
        self.lease_duration = lease_duration
        self.proposed_lease_id = proposed_lease_id


class LeaseContainerResponse(msrest.serialization.Model):
    """Lease Container response schema.

    :ivar lease_id: Returned unique lease ID that must be included with any request to delete the
     container, or to renew, change, or release the lease.
    :vartype lease_id: str
    :ivar lease_time_seconds: Approximate time remaining in the lease period, in seconds.
    :vartype lease_time_seconds: str
    """

    _attribute_map = {
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'lease_time_seconds': {'key': 'leaseTimeSeconds', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lease_id: Optional[str] = None,
        lease_time_seconds: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword lease_id: Returned unique lease ID that must be included with any request to delete
         the container, or to renew, change, or release the lease.
        :paramtype lease_id: str
        :keyword lease_time_seconds: Approximate time remaining in the lease period, in seconds.
        :paramtype lease_time_seconds: str
        """
        super(LeaseContainerResponse, self).__init__(**kwargs)
        self.lease_id = lease_id
        self.lease_time_seconds = lease_time_seconds


class LegalHold(msrest.serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar tags: Required. A set of tags. Each tag should be 3 to 23 alphanumeric characters and is
     normalized to lower case at SRP.
    :vartype tags: list[str]
    """

    _validation = {
        'has_legal_hold': {'readonly': True},
        'tags': {'required': True},
    }

    _attribute_map = {
        'has_legal_hold': {'key': 'hasLegalHold', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tags: List[str],
        **kwargs
    ):
        """
        :keyword tags: Required. A set of tags. Each tag should be 3 to 23 alphanumeric characters and
         is normalized to lower case at SRP.
        :paramtype tags: list[str]
        """
        super(LegalHold, self).__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags


class LegalHoldProperties(msrest.serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar tags: A set of tags. The list of LegalHold tags of a blob container.
    :vartype tags: list[~azure.mgmt.storage.v2019_04_01.models.TagProperty]
    """

    _validation = {
        'has_legal_hold': {'readonly': True},
    }

    _attribute_map = {
        'has_legal_hold': {'key': 'hasLegalHold', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '[TagProperty]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[List["TagProperty"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The list of LegalHold tags of a blob container.
        :paramtype tags: list[~azure.mgmt.storage.v2019_04_01.models.TagProperty]
        """
        super(LegalHoldProperties, self).__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags


class ListAccountSasResponse(msrest.serialization.Model):
    """The List SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_sas_token: List SAS credentials of storage account.
    :vartype account_sas_token: str
    """

    _validation = {
        'account_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'account_sas_token': {'key': 'accountSasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListAccountSasResponse, self).__init__(**kwargs)
        self.account_sas_token = None


class ListContainerItem(AzureEntityResource):
    """The blob container properties be listed out.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Possible values include: "Container", "Blob", "None".
    :vartype public_access: str or ~azure.mgmt.storage.v2019_04_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Possible values include: "Locked",
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Possible values include: "Available",
     "Leased", "Expired", "Breaking", "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Possible values include: "Infinite", "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2019_04_01.models.LeaseDuration
    :ivar metadata: A name-value pair to associate with the container as metadata.
    :vartype metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2019_04_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'immutability_policy': {'readonly': True},
        'legal_hold': {'readonly': True},
        'has_legal_hold': {'readonly': True},
        'has_immutability_policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_access': {'key': 'properties.publicAccess', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'immutability_policy': {'key': 'properties.immutabilityPolicy', 'type': 'ImmutabilityPolicyProperties'},
        'legal_hold': {'key': 'properties.legalHold', 'type': 'LegalHoldProperties'},
        'has_legal_hold': {'key': 'properties.hasLegalHold', 'type': 'bool'},
        'has_immutability_policy': {'key': 'properties.hasImmutabilityPolicy', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        public_access: Optional[Union[str, "PublicAccess"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword public_access: Specifies whether data in the container may be accessed publicly and
         the level of access. Possible values include: "Container", "Blob", "None".
        :paramtype public_access: str or ~azure.mgmt.storage.v2019_04_01.models.PublicAccess
        :keyword metadata: A name-value pair to associate with the container as metadata.
        :paramtype metadata: dict[str, str]
        """
        super(ListContainerItem, self).__init__(**kwargs)
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None


class ListContainerItems(msrest.serialization.Model):
    """Response schema. Contains list of blobs returned, and if paging is requested or required, a URL to next page of containers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blobs containers returned.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.ListContainerItem]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ListContainerItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListContainerItems, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListServiceSasResponse(msrest.serialization.Model):
    """The List service SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_sas_token: List service SAS credentials of specific resource.
    :vartype service_sas_token: str
    """

    _validation = {
        'service_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'service_sas_token': {'key': 'serviceSasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListServiceSasResponse, self).__init__(**kwargs)
        self.service_sas_token = None


class ManagementPolicy(Resource):
    """The Get Storage Account ManagementPolicies operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar last_modified_time: Returns the date and time the ManagementPolicies was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar policy: The Storage Account ManagementPolicy, in JSON format. See more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :vartype policy: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicySchema
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'policy': {'key': 'properties.policy', 'type': 'ManagementPolicySchema'},
    }

    def __init__(
        self,
        *,
        policy: Optional["ManagementPolicySchema"] = None,
        **kwargs
    ):
        """
        :keyword policy: The Storage Account ManagementPolicy, in JSON format. See more details in:
         https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :paramtype policy: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicySchema
        """
        super(ManagementPolicy, self).__init__(**kwargs)
        self.last_modified_time = None
        self.policy = policy


class ManagementPolicyAction(msrest.serialization.Model):
    """Actions are applied to the filtered blobs when the execution condition is met.

    :ivar base_blob: The management policy action for base blob.
    :vartype base_blob: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyBaseBlob
    :ivar snapshot: The management policy action for snapshot.
    :vartype snapshot: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicySnapShot
    """

    _attribute_map = {
        'base_blob': {'key': 'baseBlob', 'type': 'ManagementPolicyBaseBlob'},
        'snapshot': {'key': 'snapshot', 'type': 'ManagementPolicySnapShot'},
    }

    def __init__(
        self,
        *,
        base_blob: Optional["ManagementPolicyBaseBlob"] = None,
        snapshot: Optional["ManagementPolicySnapShot"] = None,
        **kwargs
    ):
        """
        :keyword base_blob: The management policy action for base blob.
        :paramtype base_blob: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyBaseBlob
        :keyword snapshot: The management policy action for snapshot.
        :paramtype snapshot: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicySnapShot
        """
        super(ManagementPolicyAction, self).__init__(**kwargs)
        self.base_blob = base_blob
        self.snapshot = snapshot


class ManagementPolicyBaseBlob(msrest.serialization.Model):
    """Management policy action for base blob.

    :ivar tier_to_cool: The function to tier blobs to cool storage. Support blobs currently at Hot
     tier.
    :vartype tier_to_cool: ~azure.mgmt.storage.v2019_04_01.models.DateAfterModification
    :ivar tier_to_archive: The function to tier blobs to archive storage. Support blobs currently
     at Hot or Cool tier.
    :vartype tier_to_archive: ~azure.mgmt.storage.v2019_04_01.models.DateAfterModification
    :ivar delete: The function to delete the blob.
    :vartype delete: ~azure.mgmt.storage.v2019_04_01.models.DateAfterModification
    """

    _attribute_map = {
        'tier_to_cool': {'key': 'tierToCool', 'type': 'DateAfterModification'},
        'tier_to_archive': {'key': 'tierToArchive', 'type': 'DateAfterModification'},
        'delete': {'key': 'delete', 'type': 'DateAfterModification'},
    }

    def __init__(
        self,
        *,
        tier_to_cool: Optional["DateAfterModification"] = None,
        tier_to_archive: Optional["DateAfterModification"] = None,
        delete: Optional["DateAfterModification"] = None,
        **kwargs
    ):
        """
        :keyword tier_to_cool: The function to tier blobs to cool storage. Support blobs currently at
         Hot tier.
        :paramtype tier_to_cool: ~azure.mgmt.storage.v2019_04_01.models.DateAfterModification
        :keyword tier_to_archive: The function to tier blobs to archive storage. Support blobs
         currently at Hot or Cool tier.
        :paramtype tier_to_archive: ~azure.mgmt.storage.v2019_04_01.models.DateAfterModification
        :keyword delete: The function to delete the blob.
        :paramtype delete: ~azure.mgmt.storage.v2019_04_01.models.DateAfterModification
        """
        super(ManagementPolicyBaseBlob, self).__init__(**kwargs)
        self.tier_to_cool = tier_to_cool
        self.tier_to_archive = tier_to_archive
        self.delete = delete


class ManagementPolicyDefinition(msrest.serialization.Model):
    """An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.

    All required parameters must be populated in order to send to Azure.

    :ivar actions: Required. An object that defines the action set.
    :vartype actions: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyAction
    :ivar filters: An object that defines the filter set.
    :vartype filters: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyFilter
    """

    _validation = {
        'actions': {'required': True},
    }

    _attribute_map = {
        'actions': {'key': 'actions', 'type': 'ManagementPolicyAction'},
        'filters': {'key': 'filters', 'type': 'ManagementPolicyFilter'},
    }

    def __init__(
        self,
        *,
        actions: "ManagementPolicyAction",
        filters: Optional["ManagementPolicyFilter"] = None,
        **kwargs
    ):
        """
        :keyword actions: Required. An object that defines the action set.
        :paramtype actions: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyAction
        :keyword filters: An object that defines the filter set.
        :paramtype filters: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyFilter
        """
        super(ManagementPolicyDefinition, self).__init__(**kwargs)
        self.actions = actions
        self.filters = filters


class ManagementPolicyFilter(msrest.serialization.Model):
    """Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters.

    All required parameters must be populated in order to send to Azure.

    :ivar prefix_match: An array of strings for prefixes to be match.
    :vartype prefix_match: list[str]
    :ivar blob_types: Required. An array of predefined enum values. Only blockBlob is supported.
    :vartype blob_types: list[str]
    """

    _validation = {
        'blob_types': {'required': True},
    }

    _attribute_map = {
        'prefix_match': {'key': 'prefixMatch', 'type': '[str]'},
        'blob_types': {'key': 'blobTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        blob_types: List[str],
        prefix_match: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword prefix_match: An array of strings for prefixes to be match.
        :paramtype prefix_match: list[str]
        :keyword blob_types: Required. An array of predefined enum values. Only blockBlob is supported.
        :paramtype blob_types: list[str]
        """
        super(ManagementPolicyFilter, self).__init__(**kwargs)
        self.prefix_match = prefix_match
        self.blob_types = blob_types


class ManagementPolicyRule(msrest.serialization.Model):
    """An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Rule is enabled if set to true.
    :vartype enabled: bool
    :ivar name: Required. A rule name can contain any combination of alpha numeric characters. Rule
     name is case-sensitive. It must be unique within a policy.
    :vartype name: str
    :ivar type: Required. The valid value is Lifecycle. Possible values include: "Lifecycle".
    :vartype type: str or ~azure.mgmt.storage.v2019_04_01.models.RuleType
    :ivar definition: Required. An object that defines the Lifecycle rule.
    :vartype definition: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyDefinition
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'definition': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'definition': {'key': 'definition', 'type': 'ManagementPolicyDefinition'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "RuleType"],
        definition: "ManagementPolicyDefinition",
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Rule is enabled if set to true.
        :paramtype enabled: bool
        :keyword name: Required. A rule name can contain any combination of alpha numeric characters.
         Rule name is case-sensitive. It must be unique within a policy.
        :paramtype name: str
        :keyword type: Required. The valid value is Lifecycle. Possible values include: "Lifecycle".
        :paramtype type: str or ~azure.mgmt.storage.v2019_04_01.models.RuleType
        :keyword definition: Required. An object that defines the Lifecycle rule.
        :paramtype definition: ~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyDefinition
        """
        super(ManagementPolicyRule, self).__init__(**kwargs)
        self.enabled = enabled
        self.name = name
        self.type = type
        self.definition = definition


class ManagementPolicySchema(msrest.serialization.Model):
    """The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.

    All required parameters must be populated in order to send to Azure.

    :ivar rules: Required. The Storage Account ManagementPolicies Rules. See more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :vartype rules: list[~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyRule]
    """

    _validation = {
        'rules': {'required': True},
    }

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ManagementPolicyRule]'},
    }

    def __init__(
        self,
        *,
        rules: List["ManagementPolicyRule"],
        **kwargs
    ):
        """
        :keyword rules: Required. The Storage Account ManagementPolicies Rules. See more details in:
         https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :paramtype rules: list[~azure.mgmt.storage.v2019_04_01.models.ManagementPolicyRule]
        """
        super(ManagementPolicySchema, self).__init__(**kwargs)
        self.rules = rules


class ManagementPolicySnapShot(msrest.serialization.Model):
    """Management policy action for snapshot.

    :ivar delete: The function to delete the blob snapshot.
    :vartype delete: ~azure.mgmt.storage.v2019_04_01.models.DateAfterCreation
    """

    _attribute_map = {
        'delete': {'key': 'delete', 'type': 'DateAfterCreation'},
    }

    def __init__(
        self,
        *,
        delete: Optional["DateAfterCreation"] = None,
        **kwargs
    ):
        """
        :keyword delete: The function to delete the blob snapshot.
        :paramtype delete: ~azure.mgmt.storage.v2019_04_01.models.DateAfterCreation
        """
        super(ManagementPolicySnapShot, self).__init__(**kwargs)
        self.delete = delete


class MetricSpecification(msrest.serialization.Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: Unit could be Bytes or Count.
    :vartype unit: str
    :ivar dimensions: Dimensions of blobs, including blob type and access tier.
    :vartype dimensions: list[~azure.mgmt.storage.v2019_04_01.models.Dimension]
    :ivar aggregation_type: Aggregation type could be Average.
    :vartype aggregation_type: str
    :ivar fill_gap_with_zero: The property to decide fill gap with zero or not.
    :vartype fill_gap_with_zero: bool
    :ivar category: The category this metric specification belong to, could be Capacity.
    :vartype category: str
    :ivar resource_id_dimension_name_override: Account Resource Id.
    :vartype resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        dimensions: Optional[List["Dimension"]] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: Unit could be Bytes or Count.
        :paramtype unit: str
        :keyword dimensions: Dimensions of blobs, including blob type and access tier.
        :paramtype dimensions: list[~azure.mgmt.storage.v2019_04_01.models.Dimension]
        :keyword aggregation_type: Aggregation type could be Average.
        :paramtype aggregation_type: str
        :keyword fill_gap_with_zero: The property to decide fill gap with zero or not.
        :paramtype fill_gap_with_zero: bool
        :keyword category: The category this metric specification belong to, could be Capacity.
        :paramtype category: str
        :keyword resource_id_dimension_name_override: Account Resource Id.
        :paramtype resource_id_dimension_name_override: str
        """
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.dimensions = dimensions
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class NetworkRuleSet(msrest.serialization.Model):
    """Network rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible
     values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"),
     or None to bypass none of those traffics. Possible values include: "None", "Logging",
     "Metrics", "AzureServices". Default value: "AzureServices".
    :vartype bypass: str or ~azure.mgmt.storage.v2019_04_01.models.Bypass
    :ivar virtual_network_rules: Sets the virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.storage.v2019_04_01.models.VirtualNetworkRule]
    :ivar ip_rules: Sets the IP ACL rules.
    :vartype ip_rules: list[~azure.mgmt.storage.v2019_04_01.models.IPRule]
    :ivar default_action: Required. Specifies the default action of allow or deny when no other
     rules match. Possible values include: "Allow", "Deny". Default value: "Allow".
    :vartype default_action: str or ~azure.mgmt.storage.v2019_04_01.models.DefaultAction
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        default_action: Union[str, "DefaultAction"] = "Allow",
        bypass: Optional[Union[str, "Bypass"]] = "AzureServices",
        virtual_network_rules: Optional[List["VirtualNetworkRule"]] = None,
        ip_rules: Optional[List["IPRule"]] = None,
        **kwargs
    ):
        """
        :keyword bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices.
         Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging,
         Metrics"), or None to bypass none of those traffics. Possible values include: "None",
         "Logging", "Metrics", "AzureServices". Default value: "AzureServices".
        :paramtype bypass: str or ~azure.mgmt.storage.v2019_04_01.models.Bypass
        :keyword virtual_network_rules: Sets the virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.storage.v2019_04_01.models.VirtualNetworkRule]
        :keyword ip_rules: Sets the IP ACL rules.
        :paramtype ip_rules: list[~azure.mgmt.storage.v2019_04_01.models.IPRule]
        :keyword default_action: Required. Specifies the default action of allow or deny when no other
         rules match. Possible values include: "Allow", "Deny". Default value: "Allow".
        :paramtype default_action: str or ~azure.mgmt.storage.v2019_04_01.models.DefaultAction
        """
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.bypass = bypass
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.default_action = default_action


class Operation(msrest.serialization.Model):
    """Storage REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.storage.v2019_04_01.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.storage.v2019_04_01.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.storage.v2019_04_01.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.storage.v2019_04_01.models.ServiceSpecification
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Storage.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft Storage.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.storage.v2019_04_01.models.Operation]
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class Restriction(msrest.serialization.Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. As of now only possible value for this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar reason_code: The reason for the restriction. As of now this can be "QuotaId" or
     "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
     subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
     capacity at DC. Possible values include: "QuotaId", "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.storage.v2019_04_01.models.ReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason_code: Optional[Union[str, "ReasonCode"]] = None,
        **kwargs
    ):
        """
        :keyword reason_code: The reason for the restriction. As of now this can be "QuotaId" or
         "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
         subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
         capacity at DC. Possible values include: "QuotaId", "NotAvailableForSubscription".
        :paramtype reason_code: str or ~azure.mgmt.storage.v2019_04_01.models.ReasonCode
        """
        super(Restriction, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = reason_code


class ServiceSasParameters(msrest.serialization.Model):
    """The parameters to list service SAS credentials of a specific resource.

    All required parameters must be populated in order to send to Azure.

    :ivar canonicalized_resource: Required. The canonical path to the signed resource.
    :vartype canonicalized_resource: str
    :ivar resource: The signed services accessible with the service SAS. Possible values include:
     Blob (b), Container (c), File (f), Share (s). Possible values include: "b", "c", "f", "s".
    :vartype resource: str or ~azure.mgmt.storage.v2019_04_01.models.SignedResource
    :ivar permissions: The signed permissions for the service SAS. Possible values include: Read
     (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible
     values include: "r", "d", "w", "l", "a", "c", "u", "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2019_04_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Possible
     values include: "https,http", "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2019_04_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: The time at which the shared access signature becomes invalid.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar identifier: A unique value up to 64 characters in length that correlates to an access
     policy specified for the container, queue, or table.
    :vartype identifier: str
    :ivar partition_key_start: The start of partition key.
    :vartype partition_key_start: str
    :ivar partition_key_end: The end of partition key.
    :vartype partition_key_end: str
    :ivar row_key_start: The start of row key.
    :vartype row_key_start: str
    :ivar row_key_end: The end of row key.
    :vartype row_key_end: str
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    :ivar cache_control: The response header override for cache control.
    :vartype cache_control: str
    :ivar content_disposition: The response header override for content disposition.
    :vartype content_disposition: str
    :ivar content_encoding: The response header override for content encoding.
    :vartype content_encoding: str
    :ivar content_language: The response header override for content language.
    :vartype content_language: str
    :ivar content_type: The response header override for content type.
    :vartype content_type: str
    """

    _validation = {
        'canonicalized_resource': {'required': True},
        'identifier': {'max_length': 64, 'min_length': 0},
    }

    _attribute_map = {
        'canonicalized_resource': {'key': 'canonicalizedResource', 'type': 'str'},
        'resource': {'key': 'signedResource', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'str'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'identifier': {'key': 'signedIdentifier', 'type': 'str'},
        'partition_key_start': {'key': 'startPk', 'type': 'str'},
        'partition_key_end': {'key': 'endPk', 'type': 'str'},
        'row_key_start': {'key': 'startRk', 'type': 'str'},
        'row_key_end': {'key': 'endRk', 'type': 'str'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
        'cache_control': {'key': 'rscc', 'type': 'str'},
        'content_disposition': {'key': 'rscd', 'type': 'str'},
        'content_encoding': {'key': 'rsce', 'type': 'str'},
        'content_language': {'key': 'rscl', 'type': 'str'},
        'content_type': {'key': 'rsct', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        canonicalized_resource: str,
        resource: Optional[Union[str, "SignedResource"]] = None,
        permissions: Optional[Union[str, "Permissions"]] = None,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        shared_access_expiry_time: Optional[datetime.datetime] = None,
        identifier: Optional[str] = None,
        partition_key_start: Optional[str] = None,
        partition_key_end: Optional[str] = None,
        row_key_start: Optional[str] = None,
        row_key_end: Optional[str] = None,
        key_to_sign: Optional[str] = None,
        cache_control: Optional[str] = None,
        content_disposition: Optional[str] = None,
        content_encoding: Optional[str] = None,
        content_language: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword canonicalized_resource: Required. The canonical path to the signed resource.
        :paramtype canonicalized_resource: str
        :keyword resource: The signed services accessible with the service SAS. Possible values
         include: Blob (b), Container (c), File (f), Share (s). Possible values include: "b", "c", "f",
         "s".
        :paramtype resource: str or ~azure.mgmt.storage.v2019_04_01.models.SignedResource
        :keyword permissions: The signed permissions for the service SAS. Possible values include: Read
         (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible
         values include: "r", "d", "w", "l", "a", "c", "u", "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2019_04_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Possible
         values include: "https,http", "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2019_04_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: The time at which the shared access signature becomes
         invalid.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword identifier: A unique value up to 64 characters in length that correlates to an access
         policy specified for the container, queue, or table.
        :paramtype identifier: str
        :keyword partition_key_start: The start of partition key.
        :paramtype partition_key_start: str
        :keyword partition_key_end: The end of partition key.
        :paramtype partition_key_end: str
        :keyword row_key_start: The start of row key.
        :paramtype row_key_start: str
        :keyword row_key_end: The end of row key.
        :paramtype row_key_end: str
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        :keyword cache_control: The response header override for cache control.
        :paramtype cache_control: str
        :keyword content_disposition: The response header override for content disposition.
        :paramtype content_disposition: str
        :keyword content_encoding: The response header override for content encoding.
        :paramtype content_encoding: str
        :keyword content_language: The response header override for content language.
        :paramtype content_language: str
        :keyword content_type: The response header override for content type.
        :paramtype content_type: str
        """
        super(ServiceSasParameters, self).__init__(**kwargs)
        self.canonicalized_resource = canonicalized_resource
        self.resource = resource
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.identifier = identifier
        self.partition_key_start = partition_key_start
        self.partition_key_end = partition_key_end
        self.row_key_start = row_key_start
        self.row_key_end = row_key_end
        self.key_to_sign = key_to_sign
        self.cache_control = cache_control
        self.content_disposition = content_disposition
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_type = content_type


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include metric specifications.

    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications:
     list[~azure.mgmt.storage.v2019_04_01.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.storage.v2019_04_01.models.MetricSpecification]
        """
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Sku(msrest.serialization.Model):
    """The SKU of the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Gets or sets the SKU name. Required for account creation; optional for
     update. Note that in older versions, SKU name was called accountType. Possible values include:
     "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
     "Standard_GZRS", "Standard_RAGZRS".
    :vartype name: str or ~azure.mgmt.storage.v2019_04_01.models.SkuName
    :ivar tier: Gets the SKU tier. This is based on the SKU name. Possible values include:
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.storage.v2019_04_01.models.SkuTier
    :ivar resource_type: The type of the resource, usually it is 'storageAccounts'.
    :vartype resource_type: str
    :ivar kind: Indicates the type of storage account. Possible values include: "Storage",
     "StorageV2", "BlobStorage", "FileStorage", "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2019_04_01.models.Kind
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar capabilities: The capability information in the specified SKU, including file encryption,
     network ACLs, change notification, etc.
    :vartype capabilities: list[~azure.mgmt.storage.v2019_04_01.models.SKUCapability]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.storage.v2019_04_01.models.Restriction]
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
        'resource_type': {'readonly': True},
        'kind': {'readonly': True},
        'locations': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[SKUCapability]'},
        'restrictions': {'key': 'restrictions', 'type': '[Restriction]'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        restrictions: Optional[List["Restriction"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Gets or sets the SKU name. Required for account creation; optional for
         update. Note that in older versions, SKU name was called accountType. Possible values include:
         "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
         "Standard_GZRS", "Standard_RAGZRS".
        :paramtype name: str or ~azure.mgmt.storage.v2019_04_01.models.SkuName
        :keyword restrictions: The restrictions because of which SKU cannot be used. This is empty if
         there are no restrictions.
        :paramtype restrictions: list[~azure.mgmt.storage.v2019_04_01.models.Restriction]
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = None
        self.resource_type = None
        self.kind = None
        self.locations = None
        self.capabilities = None
        self.restrictions = restrictions


class SKUCapability(msrest.serialization.Model):
    """The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of capability, The capability information in the specified SKU, including
     file encryption, network ACLs, change notification, etc.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability. Possibly 'true' or 'false'.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SKUCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageAccount(TrackedResource):
    """The storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar sku: Gets the SKU.
    :vartype sku: ~azure.mgmt.storage.v2019_04_01.models.Sku
    :ivar kind: Gets the Kind. Possible values include: "Storage", "StorageV2", "BlobStorage",
     "FileStorage", "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2019_04_01.models.Kind
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2019_04_01.models.Identity
    :ivar provisioning_state: Gets the status of the storage account at the time the operation was
     called. Possible values include: "Creating", "ResolvingDNS", "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.storage.v2019_04_01.models.ProvisioningState
    :ivar primary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob
     endpoint.
    :vartype primary_endpoints: ~azure.mgmt.storage.v2019_04_01.models.Endpoints
    :ivar primary_location: Gets the location of the primary data center for the storage account.
    :vartype primary_location: str
    :ivar status_of_primary: Gets the status indicating whether the primary location of the storage
     account is available or unavailable. Possible values include: "available", "unavailable".
    :vartype status_of_primary: str or ~azure.mgmt.storage.v2019_04_01.models.AccountStatus
    :ivar last_geo_failover_time: Gets the timestamp of the most recent instance of a failover to
     the secondary location. Only the most recent timestamp is retained. This element is not
     returned if there has never been a failover instance. Only available if the accountType is
     Standard_GRS or Standard_RAGRS.
    :vartype last_geo_failover_time: ~datetime.datetime
    :ivar secondary_location: Gets the location of the geo-replicated secondary for the storage
     account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
    :vartype secondary_location: str
    :ivar status_of_secondary: Gets the status indicating whether the secondary location of the
     storage account is available or unavailable. Only available if the SKU name is Standard_GRS or
     Standard_RAGRS. Possible values include: "available", "unavailable".
    :vartype status_of_secondary: str or ~azure.mgmt.storage.v2019_04_01.models.AccountStatus
    :ivar creation_time: Gets the creation date and time of the storage account in UTC.
    :vartype creation_time: ~datetime.datetime
    :ivar custom_domain: Gets the custom domain the user assigned to this storage account.
    :vartype custom_domain: ~azure.mgmt.storage.v2019_04_01.models.CustomDomain
    :ivar secondary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object from the secondary location of the storage account. Only available if
     the SKU name is Standard_RAGRS.
    :vartype secondary_endpoints: ~azure.mgmt.storage.v2019_04_01.models.Endpoints
    :ivar encryption: Gets the encryption settings on the account. If unspecified, the account is
     unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2019_04_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Possible values include: "Hot", "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2019_04_01.models.AccessTier
    :ivar azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :vartype azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2019_04_01.models.AzureFilesIdentityBasedAuthentication
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2019_04_01.models.NetworkRuleSet
    :ivar is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :vartype is_hns_enabled: bool
    :ivar geo_replication_stats: Geo Replication Stats.
    :vartype geo_replication_stats: ~azure.mgmt.storage.v2019_04_01.models.GeoReplicationStats
    :ivar failover_in_progress: If the failover is in progress, the value will be true, otherwise,
     it will be null.
    :vartype failover_in_progress: bool
    :ivar large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Possible values include: "Disabled", "Enabled".
    :vartype large_file_shares_state: str or
     ~azure.mgmt.storage.v2019_04_01.models.LargeFileSharesState
    :ivar allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :vartype allow_blob_public_access: bool
    :ivar minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Possible values include: "TLS1_0",
     "TLS1_1", "TLS1_2".
    :vartype minimum_tls_version: str or ~azure.mgmt.storage.v2019_04_01.models.MinimumTlsVersion
    :ivar allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :vartype allow_shared_key_access: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'readonly': True},
        'kind': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'primary_endpoints': {'readonly': True},
        'primary_location': {'readonly': True},
        'status_of_primary': {'readonly': True},
        'last_geo_failover_time': {'readonly': True},
        'secondary_location': {'readonly': True},
        'status_of_secondary': {'readonly': True},
        'creation_time': {'readonly': True},
        'custom_domain': {'readonly': True},
        'secondary_endpoints': {'readonly': True},
        'encryption': {'readonly': True},
        'access_tier': {'readonly': True},
        'network_rule_set': {'readonly': True},
        'geo_replication_stats': {'readonly': True},
        'failover_in_progress': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'primary_endpoints': {'key': 'properties.primaryEndpoints', 'type': 'Endpoints'},
        'primary_location': {'key': 'properties.primaryLocation', 'type': 'str'},
        'status_of_primary': {'key': 'properties.statusOfPrimary', 'type': 'str'},
        'last_geo_failover_time': {'key': 'properties.lastGeoFailoverTime', 'type': 'iso-8601'},
        'secondary_location': {'key': 'properties.secondaryLocation', 'type': 'str'},
        'status_of_secondary': {'key': 'properties.statusOfSecondary', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'secondary_endpoints': {'key': 'properties.secondaryEndpoints', 'type': 'Endpoints'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'is_hns_enabled': {'key': 'properties.isHnsEnabled', 'type': 'bool'},
        'geo_replication_stats': {'key': 'properties.geoReplicationStats', 'type': 'GeoReplicationStats'},
        'failover_in_progress': {'key': 'properties.failoverInProgress', 'type': 'bool'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'allow_blob_public_access': {'key': 'properties.allowBlobPublicAccess', 'type': 'bool'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'allow_shared_key_access': {'key': 'properties.allowSharedKeyAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        azure_files_identity_based_authentication: Optional["AzureFilesIdentityBasedAuthentication"] = None,
        enable_https_traffic_only: Optional[bool] = None,
        is_hns_enabled: Optional[bool] = None,
        large_file_shares_state: Optional[Union[str, "LargeFileSharesState"]] = None,
        allow_blob_public_access: Optional[bool] = None,
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        allow_shared_key_access: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2019_04_01.models.Identity
        :keyword azure_files_identity_based_authentication: Provides the identity based authentication
         settings for Azure Files.
        :paramtype azure_files_identity_based_authentication:
         ~azure.mgmt.storage.v2019_04_01.models.AzureFilesIdentityBasedAuthentication
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
        :paramtype is_hns_enabled: bool
        :keyword large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
         disabled once it is enabled. Possible values include: "Disabled", "Enabled".
        :paramtype large_file_shares_state: str or
         ~azure.mgmt.storage.v2019_04_01.models.LargeFileSharesState
        :keyword allow_blob_public_access: Allow or disallow public access to all blobs or containers
         in the storage account. The default interpretation is true for this property.
        :paramtype allow_blob_public_access: bool
        :keyword minimum_tls_version: Set the minimum TLS version to be permitted on requests to
         storage. The default interpretation is TLS 1.0 for this property. Possible values include:
         "TLS1_0", "TLS1_1", "TLS1_2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.storage.v2019_04_01.models.MinimumTlsVersion
        :keyword allow_shared_key_access: Indicates whether the storage account permits requests to be
         authorized with the account access key via Shared Key. If false, then all requests, including
         shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
         default value is null, which is equivalent to true.
        :paramtype allow_shared_key_access: bool
        """
        super(StorageAccount, self).__init__(tags=tags, location=location, **kwargs)
        self.sku = None
        self.kind = None
        self.identity = identity
        self.provisioning_state = None
        self.primary_endpoints = None
        self.primary_location = None
        self.status_of_primary = None
        self.last_geo_failover_time = None
        self.secondary_location = None
        self.status_of_secondary = None
        self.creation_time = None
        self.custom_domain = None
        self.secondary_endpoints = None
        self.encryption = None
        self.access_tier = None
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = None
        self.is_hns_enabled = is_hns_enabled
        self.geo_replication_stats = None
        self.failover_in_progress = None
        self.large_file_shares_state = large_file_shares_state
        self.allow_blob_public_access = allow_blob_public_access
        self.minimum_tls_version = minimum_tls_version
        self.allow_shared_key_access = allow_shared_key_access


class StorageAccountCheckNameAvailabilityParameters(msrest.serialization.Model):
    """The parameters used to check the availability of the storage account name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The storage account name.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.Storage/storageAccounts. Has constant value:
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Storage/storageAccounts"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. The storage account name.
        :paramtype name: str
        """
        super(StorageAccountCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class StorageAccountCreateParameters(msrest.serialization.Model):
    """The parameters used when creating a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar sku: Required. Required. Gets or sets the SKU name.
    :vartype sku: ~azure.mgmt.storage.v2019_04_01.models.Sku
    :ivar kind: Required. Required. Indicates the type of storage account. Possible values include:
     "Storage", "StorageV2", "BlobStorage", "FileStorage", "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2019_04_01.models.Kind
    :ivar location: Required. Required. Gets or sets the location of the resource. This will be one
     of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia,
     etc.). The geo region of a resource cannot be changed once it is created, but if an identical
     geo region is specified on update, the request will succeed.
    :vartype location: str
    :ivar tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used for viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no
     greater than 128 characters and a value with a length no greater than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2019_04_01.models.Identity
    :ivar custom_domain: User domain assigned to the storage account. Name is the CNAME source.
     Only one custom domain is supported per storage account at this time. To clear the existing
     custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2019_04_01.models.CustomDomain
    :ivar encryption: Not applicable. Azure Storage encryption is enabled for all storage accounts
     and cannot be disabled.
    :vartype encryption: ~azure.mgmt.storage.v2019_04_01.models.Encryption
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2019_04_01.models.NetworkRuleSet
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Possible values include: "Hot", "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2019_04_01.models.AccessTier
    :ivar azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :vartype azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2019_04_01.models.AzureFilesIdentityBasedAuthentication
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
     The default value is true since API version 2019-04-01.
    :vartype enable_https_traffic_only: bool
    :ivar is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :vartype is_hns_enabled: bool
    :ivar large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Possible values include: "Disabled", "Enabled".
    :vartype large_file_shares_state: str or
     ~azure.mgmt.storage.v2019_04_01.models.LargeFileSharesState
    :ivar allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :vartype allow_blob_public_access: bool
    :ivar minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Possible values include: "TLS1_0",
     "TLS1_1", "TLS1_2".
    :vartype minimum_tls_version: str or ~azure.mgmt.storage.v2019_04_01.models.MinimumTlsVersion
    :ivar allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :vartype allow_shared_key_access: bool
    """

    _validation = {
        'sku': {'required': True},
        'kind': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'is_hns_enabled': {'key': 'properties.isHnsEnabled', 'type': 'bool'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'allow_blob_public_access': {'key': 'properties.allowBlobPublicAccess', 'type': 'bool'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'allow_shared_key_access': {'key': 'properties.allowSharedKeyAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sku: "Sku",
        kind: Union[str, "Kind"],
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        custom_domain: Optional["CustomDomain"] = None,
        encryption: Optional["Encryption"] = None,
        network_rule_set: Optional["NetworkRuleSet"] = None,
        access_tier: Optional[Union[str, "AccessTier"]] = None,
        azure_files_identity_based_authentication: Optional["AzureFilesIdentityBasedAuthentication"] = None,
        enable_https_traffic_only: Optional[bool] = None,
        is_hns_enabled: Optional[bool] = None,
        large_file_shares_state: Optional[Union[str, "LargeFileSharesState"]] = None,
        allow_blob_public_access: Optional[bool] = None,
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        allow_shared_key_access: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword sku: Required. Required. Gets or sets the SKU name.
        :paramtype sku: ~azure.mgmt.storage.v2019_04_01.models.Sku
        :keyword kind: Required. Required. Indicates the type of storage account. Possible values
         include: "Storage", "StorageV2", "BlobStorage", "FileStorage", "BlockBlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2019_04_01.models.Kind
        :keyword location: Required. Required. Gets or sets the location of the resource. This will be
         one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia,
         etc.). The geo region of a resource cannot be changed once it is created, but if an identical
         geo region is specified on update, the request will succeed.
        :paramtype location: str
        :keyword tags: A set of tags. Gets or sets a list of key value pairs that describe the
         resource. These tags can be used for viewing and grouping this resource (across resource
         groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a
         length no greater than 128 characters and a value with a length no greater than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2019_04_01.models.Identity
        :keyword custom_domain: User domain assigned to the storage account. Name is the CNAME source.
         Only one custom domain is supported per storage account at this time. To clear the existing
         custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2019_04_01.models.CustomDomain
        :keyword encryption: Not applicable. Azure Storage encryption is enabled for all storage
         accounts and cannot be disabled.
        :paramtype encryption: ~azure.mgmt.storage.v2019_04_01.models.Encryption
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2019_04_01.models.NetworkRuleSet
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         used for billing. Possible values include: "Hot", "Cool".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2019_04_01.models.AccessTier
        :keyword azure_files_identity_based_authentication: Provides the identity based authentication
         settings for Azure Files.
        :paramtype azure_files_identity_based_authentication:
         ~azure.mgmt.storage.v2019_04_01.models.AzureFilesIdentityBasedAuthentication
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true. The default value is true since API version 2019-04-01.
        :paramtype enable_https_traffic_only: bool
        :keyword is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
        :paramtype is_hns_enabled: bool
        :keyword large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
         disabled once it is enabled. Possible values include: "Disabled", "Enabled".
        :paramtype large_file_shares_state: str or
         ~azure.mgmt.storage.v2019_04_01.models.LargeFileSharesState
        :keyword allow_blob_public_access: Allow or disallow public access to all blobs or containers
         in the storage account. The default interpretation is true for this property.
        :paramtype allow_blob_public_access: bool
        :keyword minimum_tls_version: Set the minimum TLS version to be permitted on requests to
         storage. The default interpretation is TLS 1.0 for this property. Possible values include:
         "TLS1_0", "TLS1_1", "TLS1_2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.storage.v2019_04_01.models.MinimumTlsVersion
        :keyword allow_shared_key_access: Indicates whether the storage account permits requests to be
         authorized with the account access key via Shared Key. If false, then all requests, including
         shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
         default value is null, which is equivalent to true.
        :paramtype allow_shared_key_access: bool
        """
        super(StorageAccountCreateParameters, self).__init__(**kwargs)
        self.sku = sku
        self.kind = kind
        self.location = location
        self.tags = tags
        self.identity = identity
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.network_rule_set = network_rule_set
        self.access_tier = access_tier
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.is_hns_enabled = is_hns_enabled
        self.large_file_shares_state = large_file_shares_state
        self.allow_blob_public_access = allow_blob_public_access
        self.minimum_tls_version = minimum_tls_version
        self.allow_shared_key_access = allow_shared_key_access


class StorageAccountKey(msrest.serialization.Model):
    """An access key for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: Name of the key.
    :vartype key_name: str
    :ivar value: Base 64-encoded value of the key.
    :vartype value: str
    :ivar permissions: Permissions for the key -- read-only or full permissions. Possible values
     include: "Read", "Full".
    :vartype permissions: str or ~azure.mgmt.storage.v2019_04_01.models.KeyPermission
    """

    _validation = {
        'key_name': {'readonly': True},
        'value': {'readonly': True},
        'permissions': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageAccountKey, self).__init__(**kwargs)
        self.key_name = None
        self.value = None
        self.permissions = None


class StorageAccountListKeysResult(msrest.serialization.Model):
    """The response from the ListKeys operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar keys: Gets the list of storage account keys and their properties for the specified
     storage account.
    :vartype keys: list[~azure.mgmt.storage.v2019_04_01.models.StorageAccountKey]
    """

    _validation = {
        'keys': {'readonly': True},
    }

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[StorageAccountKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageAccountListKeysResult, self).__init__(**kwargs)
        self.keys = None


class StorageAccountListResult(msrest.serialization.Model):
    """The response from the List Storage Accounts operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of storage accounts and their properties.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.StorageAccount]
    :ivar next_link: Request URL that can be used to query next page of storage accounts. Returned
     when total number of requested storage accounts exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageAccountListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageAccountRegenerateKeyParameters(msrest.serialization.Model):
    """The parameters used to regenerate the storage account key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: Required. The name of storage keys that want to be regenerated, possible values
     are key1, key2, kerb1, kerb2.
    :vartype key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        **kwargs
    ):
        """
        :keyword key_name: Required. The name of storage keys that want to be regenerated, possible
         values are key1, key2, kerb1, kerb2.
        :paramtype key_name: str
        """
        super(StorageAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = key_name


class StorageAccountUpdateParameters(msrest.serialization.Model):
    """The parameters that can be provided when updating the storage account properties.

    :ivar sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to Standard_ZRS,
     Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any other value.
    :vartype sku: ~azure.mgmt.storage.v2019_04_01.models.Sku
    :ivar tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used in viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in
     length than 128 characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2019_04_01.models.Identity
    :ivar kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
     supported by server. Possible values include: "Storage", "StorageV2", "BlobStorage",
     "FileStorage", "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2019_04_01.models.Kind
    :ivar custom_domain: Custom domain assigned to the storage account by the user. Name is the
     CNAME source. Only one custom domain is supported per storage account at this time. To clear
     the existing custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2019_04_01.models.CustomDomain
    :ivar encryption: Provides the encryption settings on the account. The default setting is
     unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2019_04_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Possible values include: "Hot", "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2019_04_01.models.AccessTier
    :ivar azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :vartype azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2019_04_01.models.AzureFilesIdentityBasedAuthentication
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2019_04_01.models.NetworkRuleSet
    :ivar large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Possible values include: "Disabled", "Enabled".
    :vartype large_file_shares_state: str or
     ~azure.mgmt.storage.v2019_04_01.models.LargeFileSharesState
    :ivar allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :vartype allow_blob_public_access: bool
    :ivar minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Possible values include: "TLS1_0",
     "TLS1_1", "TLS1_2".
    :vartype minimum_tls_version: str or ~azure.mgmt.storage.v2019_04_01.models.MinimumTlsVersion
    :ivar allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :vartype allow_shared_key_access: bool
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'allow_blob_public_access': {'key': 'properties.allowBlobPublicAccess', 'type': 'bool'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'allow_shared_key_access': {'key': 'properties.allowSharedKeyAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        custom_domain: Optional["CustomDomain"] = None,
        encryption: Optional["Encryption"] = None,
        access_tier: Optional[Union[str, "AccessTier"]] = None,
        azure_files_identity_based_authentication: Optional["AzureFilesIdentityBasedAuthentication"] = None,
        enable_https_traffic_only: Optional[bool] = None,
        network_rule_set: Optional["NetworkRuleSet"] = None,
        large_file_shares_state: Optional[Union[str, "LargeFileSharesState"]] = None,
        allow_blob_public_access: Optional[bool] = None,
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        allow_shared_key_access: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to
         Standard_ZRS, Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any
         other value.
        :paramtype sku: ~azure.mgmt.storage.v2019_04_01.models.Sku
        :keyword tags: A set of tags. Gets or sets a list of key value pairs that describe the
         resource. These tags can be used in viewing and grouping this resource (across resource
         groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no
         greater in length than 128 characters and a value no greater in length than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2019_04_01.models.Identity
        :keyword kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
         supported by server. Possible values include: "Storage", "StorageV2", "BlobStorage",
         "FileStorage", "BlockBlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2019_04_01.models.Kind
        :keyword custom_domain: Custom domain assigned to the storage account by the user. Name is the
         CNAME source. Only one custom domain is supported per storage account at this time. To clear
         the existing custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2019_04_01.models.CustomDomain
        :keyword encryption: Provides the encryption settings on the account. The default setting is
         unencrypted.
        :paramtype encryption: ~azure.mgmt.storage.v2019_04_01.models.Encryption
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         used for billing. Possible values include: "Hot", "Cool".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2019_04_01.models.AccessTier
        :keyword azure_files_identity_based_authentication: Provides the identity based authentication
         settings for Azure Files.
        :paramtype azure_files_identity_based_authentication:
         ~azure.mgmt.storage.v2019_04_01.models.AzureFilesIdentityBasedAuthentication
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2019_04_01.models.NetworkRuleSet
        :keyword large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
         disabled once it is enabled. Possible values include: "Disabled", "Enabled".
        :paramtype large_file_shares_state: str or
         ~azure.mgmt.storage.v2019_04_01.models.LargeFileSharesState
        :keyword allow_blob_public_access: Allow or disallow public access to all blobs or containers
         in the storage account. The default interpretation is true for this property.
        :paramtype allow_blob_public_access: bool
        :keyword minimum_tls_version: Set the minimum TLS version to be permitted on requests to
         storage. The default interpretation is TLS 1.0 for this property. Possible values include:
         "TLS1_0", "TLS1_1", "TLS1_2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.storage.v2019_04_01.models.MinimumTlsVersion
        :keyword allow_shared_key_access: Indicates whether the storage account permits requests to be
         authorized with the account access key via Shared Key. If false, then all requests, including
         shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
         default value is null, which is equivalent to true.
        :paramtype allow_shared_key_access: bool
        """
        super(StorageAccountUpdateParameters, self).__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.identity = identity
        self.kind = kind
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.access_tier = access_tier
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = network_rule_set
        self.large_file_shares_state = large_file_shares_state
        self.allow_blob_public_access = allow_blob_public_access
        self.minimum_tls_version = minimum_tls_version
        self.allow_shared_key_access = allow_shared_key_access


class StorageSkuListResult(msrest.serialization.Model):
    """The response from the List Storage SKUs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Get the list result of storage SKUs and their properties.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.Sku]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Sku]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageSkuListResult, self).__init__(**kwargs)
        self.value = None


class TagProperty(msrest.serialization.Model):
    """A tag of the LegalHold of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tag: The tag value.
    :vartype tag: str
    :ivar timestamp: Returns the date and time the tag was added.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who added the tag.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who added the tag.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who added the tag.
    :vartype upn: str
    """

    _validation = {
        'tag': {'readonly': True},
        'timestamp': {'readonly': True},
        'object_identifier': {'readonly': True},
        'tenant_id': {'readonly': True},
        'upn': {'readonly': True},
    }

    _attribute_map = {
        'tag': {'key': 'tag', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'object_identifier': {'key': 'objectIdentifier', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TagProperty, self).__init__(**kwargs)
        self.tag = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class UpdateHistoryProperty(msrest.serialization.Model):
    """An update history of the ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar update: The ImmutabilityPolicy update type of a blob container, possible values include:
     put, lock and extend. Possible values include: "put", "lock", "extend".
    :vartype update: str or ~azure.mgmt.storage.v2019_04_01.models.ImmutabilityPolicyUpdateType
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar timestamp: Returns the date and time the ImmutabilityPolicy was updated.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who updated the ImmutabilityPolicy.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who updated the
     ImmutabilityPolicy.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
    :vartype upn: str
    """

    _validation = {
        'update': {'readonly': True},
        'immutability_period_since_creation_in_days': {'readonly': True},
        'timestamp': {'readonly': True},
        'object_identifier': {'readonly': True},
        'tenant_id': {'readonly': True},
        'upn': {'readonly': True},
    }

    _attribute_map = {
        'update': {'key': 'update', 'type': 'str'},
        'immutability_period_since_creation_in_days': {'key': 'immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'object_identifier': {'key': 'objectIdentifier', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UpdateHistoryProperty, self).__init__(**kwargs)
        self.update = None
        self.immutability_period_since_creation_in_days = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class Usage(msrest.serialization.Model):
    """Describes Storage Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: Gets the unit of measurement. Possible values include: "Count", "Bytes", "Seconds",
     "Percent", "CountsPerSecond", "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.storage.v2019_04_01.models.UsageUnit
    :ivar current_value: Gets the current count of the allocated resources in the subscription.
    :vartype current_value: int
    :ivar limit: Gets the maximum count of the resources that can be allocated in the subscription.
    :vartype limit: int
    :ivar name: Gets the name of the type of usage.
    :vartype name: ~azure.mgmt.storage.v2019_04_01.models.UsageName
    """

    _validation = {
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Usage, self).__init__(**kwargs)
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageListResult(msrest.serialization.Model):
    """The response from the List Usages operation.

    :ivar value: Gets or sets the list of Storage Resource Usages.
    :vartype value: list[~azure.mgmt.storage.v2019_04_01.models.Usage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Usage"]] = None,
        **kwargs
    ):
        """
        :keyword value: Gets or sets the list of Storage Resource Usages.
        :paramtype value: list[~azure.mgmt.storage.v2019_04_01.models.Usage]
        """
        super(UsageListResult, self).__init__(**kwargs)
        self.value = value


class UsageName(msrest.serialization.Model):
    """The usage names that can be used; currently limited to StorageAccount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a string describing the resource name.
    :vartype value: str
    :ivar localized_value: Gets a localized string describing the resource name.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class VirtualNetworkRule(msrest.serialization.Model):
    """Virtual Network rule.

    All required parameters must be populated in order to send to Azure.

    :ivar virtual_network_resource_id: Required. Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :vartype virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. The only acceptable values to pass in are
     None and "Allow". The default value is None.
    :vartype action: str
    :ivar state: Gets the state of virtual network rule. Possible values include: "provisioning",
     "deprovisioning", "succeeded", "failed", "networkSourceDeleted".
    :vartype state: str or ~azure.mgmt.storage.v2019_04_01.models.State
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_resource_id: str,
        action: Optional[str] = None,
        state: Optional[Union[str, "State"]] = None,
        **kwargs
    ):
        """
        :keyword virtual_network_resource_id: Required. Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :paramtype virtual_network_resource_id: str
        :keyword action: The action of virtual network rule. The only acceptable values to pass in are
         None and "Allow". The default value is None.
        :paramtype action: str
        :keyword state: Gets the state of virtual network rule. Possible values include:
         "provisioning", "deprovisioning", "succeeded", "failed", "networkSourceDeleted".
        :paramtype state: str or ~azure.mgmt.storage.v2019_04_01.models.State
        """
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id
        self.action = action
        self.state = state
