# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._storage_management_enums import *


class AccountSasParameters(msrest.serialization.Model):
    """The parameters to list SAS credentials of a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar services: Required. The signed services accessible with the account SAS. Possible values
     include: Blob (b), Queue (q), Table (t), File (f). Possible values include: "b", "q", "t", "f".
    :vartype services: str or ~azure.mgmt.storage.v2017_10_01.models.Services
    :ivar resource_types: Required. The signed resource types that are accessible with the account
     SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs;
     Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     Possible values include: "s", "c", "o".
    :vartype resource_types: str or ~azure.mgmt.storage.v2017_10_01.models.SignedResourceTypes
    :ivar permissions: Required. The signed permissions for the account SAS. Possible values
     include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process
     (p). Possible values include: "r", "d", "w", "l", "a", "c", "u", "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2017_10_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Possible
     values include: "https,http", "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2017_10_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: Required. The time at which the shared access signature
     becomes invalid.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    """

    _validation = {
        'services': {'required': True},
        'resource_types': {'required': True},
        'permissions': {'required': True},
        'shared_access_expiry_time': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'signedServices', 'type': 'str'},
        'resource_types': {'key': 'signedResourceTypes', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'str'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        services: Union[str, "Services"],
        resource_types: Union[str, "SignedResourceTypes"],
        permissions: Union[str, "Permissions"],
        shared_access_expiry_time: datetime.datetime,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        key_to_sign: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword services: Required. The signed services accessible with the account SAS. Possible
         values include: Blob (b), Queue (q), Table (t), File (f). Possible values include: "b", "q",
         "t", "f".
        :paramtype services: str or ~azure.mgmt.storage.v2017_10_01.models.Services
        :keyword resource_types: Required. The signed resource types that are accessible with the
         account SAS. Service (s): Access to service-level APIs; Container (c): Access to
         container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table
         entities, and files. Possible values include: "s", "c", "o".
        :paramtype resource_types: str or ~azure.mgmt.storage.v2017_10_01.models.SignedResourceTypes
        :keyword permissions: Required. The signed permissions for the account SAS. Possible values
         include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process
         (p). Possible values include: "r", "d", "w", "l", "a", "c", "u", "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2017_10_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Possible
         values include: "https,http", "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2017_10_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: Required. The time at which the shared access signature
         becomes invalid.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        """
        super(AccountSasParameters, self).__init__(**kwargs)
        self.services = services
        self.resource_types = resource_types
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.key_to_sign = key_to_sign


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a storage account name could not be used. The Reason element
     is only returned if NameAvailable is false. Possible values include: "AccountNameInvalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.storage.v2017_10_01.models.Reason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CustomDomain(msrest.serialization.Model):
    """The custom domain assigned to this storage account. This can be set via Update.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Gets or sets the custom domain name assigned to the storage account. Name
     is the CNAME source.
    :vartype name: str
    :ivar use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
     value is false. This should only be set on updates.
    :vartype use_sub_domain_name: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'use_sub_domain_name': {'key': 'useSubDomainName', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        use_sub_domain_name: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Gets or sets the custom domain name assigned to the storage account.
         Name is the CNAME source.
        :paramtype name: str
        :keyword use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
         value is false. This should only be set on updates.
        :paramtype use_sub_domain_name: bool
        """
        super(CustomDomain, self).__init__(**kwargs)
        self.name = name
        self.use_sub_domain_name = use_sub_domain_name


class Dimension(msrest.serialization.Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :ivar name: Display name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Display name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        """
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class Encryption(msrest.serialization.Model):
    """The encryption settings on the storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar services: List of services which support encryption.
    :vartype services: ~azure.mgmt.storage.v2017_10_01.models.EncryptionServices
    :ivar key_source: Required. The encryption keySource (provider). Possible values
     (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include:
     "Microsoft.Storage", "Microsoft.Keyvault". Default value: "Microsoft.Storage".
    :vartype key_source: str or ~azure.mgmt.storage.v2017_10_01.models.KeySource
    :ivar key_vault_properties: Properties provided by key vault.
    :vartype key_vault_properties: ~azure.mgmt.storage.v2017_10_01.models.KeyVaultProperties
    """

    _validation = {
        'key_source': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'services', 'type': 'EncryptionServices'},
        'key_source': {'key': 'keySource', 'type': 'str'},
        'key_vault_properties': {'key': 'keyvaultproperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(
        self,
        *,
        key_source: Union[str, "KeySource"] = "Microsoft.Storage",
        services: Optional["EncryptionServices"] = None,
        key_vault_properties: Optional["KeyVaultProperties"] = None,
        **kwargs
    ):
        """
        :keyword services: List of services which support encryption.
        :paramtype services: ~azure.mgmt.storage.v2017_10_01.models.EncryptionServices
        :keyword key_source: Required. The encryption keySource (provider). Possible values
         (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include:
         "Microsoft.Storage", "Microsoft.Keyvault". Default value: "Microsoft.Storage".
        :paramtype key_source: str or ~azure.mgmt.storage.v2017_10_01.models.KeySource
        :keyword key_vault_properties: Properties provided by key vault.
        :paramtype key_vault_properties: ~azure.mgmt.storage.v2017_10_01.models.KeyVaultProperties
        """
        super(Encryption, self).__init__(**kwargs)
        self.services = services
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties


class EncryptionService(msrest.serialization.Model):
    """A service that allows server-side encryption to be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: A boolean indicating whether or not the service encrypts the data as it is
     stored.
    :vartype enabled: bool
    :ivar last_enabled_time: Gets a rough estimate of the date/time when the encryption was last
     enabled by the user. Only returned when encryption is enabled. There might be some unencrypted
     blobs which were written after this time, as it is just a rough estimate.
    :vartype last_enabled_time: ~datetime.datetime
    """

    _validation = {
        'last_enabled_time': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_enabled_time': {'key': 'lastEnabledTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: A boolean indicating whether or not the service encrypts the data as it is
         stored.
        :paramtype enabled: bool
        """
        super(EncryptionService, self).__init__(**kwargs)
        self.enabled = enabled
        self.last_enabled_time = None


class EncryptionServices(msrest.serialization.Model):
    """A list of services that support encryption.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: The encryption function of the blob storage service.
    :vartype blob: ~azure.mgmt.storage.v2017_10_01.models.EncryptionService
    :ivar file: The encryption function of the file storage service.
    :vartype file: ~azure.mgmt.storage.v2017_10_01.models.EncryptionService
    :ivar table: The encryption function of the table storage service.
    :vartype table: ~azure.mgmt.storage.v2017_10_01.models.EncryptionService
    :ivar queue: The encryption function of the queue storage service.
    :vartype queue: ~azure.mgmt.storage.v2017_10_01.models.EncryptionService
    """

    _validation = {
        'table': {'readonly': True},
        'queue': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'EncryptionService'},
        'file': {'key': 'file', 'type': 'EncryptionService'},
        'table': {'key': 'table', 'type': 'EncryptionService'},
        'queue': {'key': 'queue', 'type': 'EncryptionService'},
    }

    def __init__(
        self,
        *,
        blob: Optional["EncryptionService"] = None,
        file: Optional["EncryptionService"] = None,
        **kwargs
    ):
        """
        :keyword blob: The encryption function of the blob storage service.
        :paramtype blob: ~azure.mgmt.storage.v2017_10_01.models.EncryptionService
        :keyword file: The encryption function of the file storage service.
        :paramtype file: ~azure.mgmt.storage.v2017_10_01.models.EncryptionService
        """
        super(EncryptionServices, self).__init__(**kwargs)
        self.blob = blob
        self.file = file
        self.table = None
        self.queue = None


class Endpoints(msrest.serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, queue, or table object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    """

    _validation = {
        'blob': {'readonly': True},
        'queue': {'readonly': True},
        'table': {'readonly': True},
        'file': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'queue': {'key': 'queue', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Endpoints, self).__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Has constant value: "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class IPRule(msrest.serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
     address is allowed.
    :vartype ip_address_or_range: str
    :ivar action: The action of IP ACL rule. The only acceptable values to pass in are None and
     "Allow". The default value is None.
    :vartype action: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address_or_range: str,
        action: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
         address is allowed.
        :paramtype ip_address_or_range: str
        :keyword action: The action of IP ACL rule. The only acceptable values to pass in are None and
         "Allow". The default value is None.
        :paramtype action: str
        """
        super(IPRule, self).__init__(**kwargs)
        self.ip_address_or_range = ip_address_or_range
        self.action = action


class KeyVaultProperties(msrest.serialization.Model):
    """Properties of key vault.

    :ivar key_name: The name of KeyVault key.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of KeyVault.
    :vartype key_vault_uri: str
    """

    _attribute_map = {
        'key_name': {'key': 'keyname', 'type': 'str'},
        'key_version': {'key': 'keyversion', 'type': 'str'},
        'key_vault_uri': {'key': 'keyvaulturi', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: The name of KeyVault key.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key.
        :paramtype key_version: str
        :keyword key_vault_uri: The Uri of KeyVault.
        :paramtype key_vault_uri: str
        """
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri


class ListAccountSasResponse(msrest.serialization.Model):
    """The List SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_sas_token: List SAS credentials of storage account.
    :vartype account_sas_token: str
    """

    _validation = {
        'account_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'account_sas_token': {'key': 'accountSasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListAccountSasResponse, self).__init__(**kwargs)
        self.account_sas_token = None


class ListServiceSasResponse(msrest.serialization.Model):
    """The List service SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_sas_token: List service SAS credentials of specific resource.
    :vartype service_sas_token: str
    """

    _validation = {
        'service_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'service_sas_token': {'key': 'serviceSasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListServiceSasResponse, self).__init__(**kwargs)
        self.service_sas_token = None


class MetricSpecification(msrest.serialization.Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: Unit could be Bytes or Count.
    :vartype unit: str
    :ivar dimensions: Dimensions of blobs, including blob type and access tier.
    :vartype dimensions: list[~azure.mgmt.storage.v2017_10_01.models.Dimension]
    :ivar aggregation_type: Aggregation type could be Average.
    :vartype aggregation_type: str
    :ivar fill_gap_with_zero: The property to decide fill gap with zero or not.
    :vartype fill_gap_with_zero: bool
    :ivar category: The category this metric specification belong to, could be Capacity.
    :vartype category: str
    :ivar resource_id_dimension_name_override: Account Resource Id.
    :vartype resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        dimensions: Optional[List["Dimension"]] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: Unit could be Bytes or Count.
        :paramtype unit: str
        :keyword dimensions: Dimensions of blobs, including blob type and access tier.
        :paramtype dimensions: list[~azure.mgmt.storage.v2017_10_01.models.Dimension]
        :keyword aggregation_type: Aggregation type could be Average.
        :paramtype aggregation_type: str
        :keyword fill_gap_with_zero: The property to decide fill gap with zero or not.
        :paramtype fill_gap_with_zero: bool
        :keyword category: The category this metric specification belong to, could be Capacity.
        :paramtype category: str
        :keyword resource_id_dimension_name_override: Account Resource Id.
        :paramtype resource_id_dimension_name_override: str
        """
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.dimensions = dimensions
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class NetworkRuleSet(msrest.serialization.Model):
    """Network rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible
     values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"),
     or None to bypass none of those traffics. Possible values include: "None", "Logging",
     "Metrics", "AzureServices". Default value: "AzureServices".
    :vartype bypass: str or ~azure.mgmt.storage.v2017_10_01.models.Bypass
    :ivar virtual_network_rules: Sets the virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.storage.v2017_10_01.models.VirtualNetworkRule]
    :ivar ip_rules: Sets the IP ACL rules.
    :vartype ip_rules: list[~azure.mgmt.storage.v2017_10_01.models.IPRule]
    :ivar default_action: Required. Specifies the default action of allow or deny when no other
     rules match. Possible values include: "Allow", "Deny". Default value: "Allow".
    :vartype default_action: str or ~azure.mgmt.storage.v2017_10_01.models.DefaultAction
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        default_action: Union[str, "DefaultAction"] = "Allow",
        bypass: Optional[Union[str, "Bypass"]] = "AzureServices",
        virtual_network_rules: Optional[List["VirtualNetworkRule"]] = None,
        ip_rules: Optional[List["IPRule"]] = None,
        **kwargs
    ):
        """
        :keyword bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices.
         Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging,
         Metrics"), or None to bypass none of those traffics. Possible values include: "None",
         "Logging", "Metrics", "AzureServices". Default value: "AzureServices".
        :paramtype bypass: str or ~azure.mgmt.storage.v2017_10_01.models.Bypass
        :keyword virtual_network_rules: Sets the virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.storage.v2017_10_01.models.VirtualNetworkRule]
        :keyword ip_rules: Sets the IP ACL rules.
        :paramtype ip_rules: list[~azure.mgmt.storage.v2017_10_01.models.IPRule]
        :keyword default_action: Required. Specifies the default action of allow or deny when no other
         rules match. Possible values include: "Allow", "Deny". Default value: "Allow".
        :paramtype default_action: str or ~azure.mgmt.storage.v2017_10_01.models.DefaultAction
        """
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.bypass = bypass
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.default_action = default_action


class Operation(msrest.serialization.Model):
    """Storage REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.storage.v2017_10_01.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.storage.v2017_10_01.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.storage.v2017_10_01.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.storage.v2017_10_01.models.ServiceSpecification
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Storage.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft Storage.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.storage.v2017_10_01.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.storage.v2017_10_01.models.Operation]
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class Resource(msrest.serialization.Model):
    """Describes a storage resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Tags assigned to a resource; can be used for viewing and grouping a
     resource (across resource groups).
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Tags assigned to a resource; can be used for viewing and grouping
         a resource (across resource groups).
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Restriction(msrest.serialization.Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. As of now only possible value for this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar reason_code: The reason for the restriction. As of now this can be "QuotaId" or
     "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
     subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
     capacity at DC. Possible values include: "QuotaId", "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.storage.v2017_10_01.models.ReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason_code: Optional[Union[str, "ReasonCode"]] = None,
        **kwargs
    ):
        """
        :keyword reason_code: The reason for the restriction. As of now this can be "QuotaId" or
         "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
         subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
         capacity at DC. Possible values include: "QuotaId", "NotAvailableForSubscription".
        :paramtype reason_code: str or ~azure.mgmt.storage.v2017_10_01.models.ReasonCode
        """
        super(Restriction, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = reason_code


class ServiceSasParameters(msrest.serialization.Model):
    """The parameters to list service SAS credentials of a specific resource.

    All required parameters must be populated in order to send to Azure.

    :ivar canonicalized_resource: Required. The canonical path to the signed resource.
    :vartype canonicalized_resource: str
    :ivar resource: Required. The signed services accessible with the service SAS. Possible values
     include: Blob (b), Container (c), File (f), Share (s). Possible values include: "b", "c", "f",
     "s".
    :vartype resource: str or ~azure.mgmt.storage.v2017_10_01.models.SignedResource
    :ivar permissions: The signed permissions for the service SAS. Possible values include: Read
     (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible
     values include: "r", "d", "w", "l", "a", "c", "u", "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2017_10_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Possible
     values include: "https,http", "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2017_10_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: The time at which the shared access signature becomes invalid.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar identifier: A unique value up to 64 characters in length that correlates to an access
     policy specified for the container, queue, or table.
    :vartype identifier: str
    :ivar partition_key_start: The start of partition key.
    :vartype partition_key_start: str
    :ivar partition_key_end: The end of partition key.
    :vartype partition_key_end: str
    :ivar row_key_start: The start of row key.
    :vartype row_key_start: str
    :ivar row_key_end: The end of row key.
    :vartype row_key_end: str
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    :ivar cache_control: The response header override for cache control.
    :vartype cache_control: str
    :ivar content_disposition: The response header override for content disposition.
    :vartype content_disposition: str
    :ivar content_encoding: The response header override for content encoding.
    :vartype content_encoding: str
    :ivar content_language: The response header override for content language.
    :vartype content_language: str
    :ivar content_type: The response header override for content type.
    :vartype content_type: str
    """

    _validation = {
        'canonicalized_resource': {'required': True},
        'resource': {'required': True},
        'identifier': {'max_length': 64, 'min_length': 0},
    }

    _attribute_map = {
        'canonicalized_resource': {'key': 'canonicalizedResource', 'type': 'str'},
        'resource': {'key': 'signedResource', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'str'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'identifier': {'key': 'signedIdentifier', 'type': 'str'},
        'partition_key_start': {'key': 'startPk', 'type': 'str'},
        'partition_key_end': {'key': 'endPk', 'type': 'str'},
        'row_key_start': {'key': 'startRk', 'type': 'str'},
        'row_key_end': {'key': 'endRk', 'type': 'str'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
        'cache_control': {'key': 'rscc', 'type': 'str'},
        'content_disposition': {'key': 'rscd', 'type': 'str'},
        'content_encoding': {'key': 'rsce', 'type': 'str'},
        'content_language': {'key': 'rscl', 'type': 'str'},
        'content_type': {'key': 'rsct', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        canonicalized_resource: str,
        resource: Union[str, "SignedResource"],
        permissions: Optional[Union[str, "Permissions"]] = None,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        shared_access_expiry_time: Optional[datetime.datetime] = None,
        identifier: Optional[str] = None,
        partition_key_start: Optional[str] = None,
        partition_key_end: Optional[str] = None,
        row_key_start: Optional[str] = None,
        row_key_end: Optional[str] = None,
        key_to_sign: Optional[str] = None,
        cache_control: Optional[str] = None,
        content_disposition: Optional[str] = None,
        content_encoding: Optional[str] = None,
        content_language: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword canonicalized_resource: Required. The canonical path to the signed resource.
        :paramtype canonicalized_resource: str
        :keyword resource: Required. The signed services accessible with the service SAS. Possible
         values include: Blob (b), Container (c), File (f), Share (s). Possible values include: "b",
         "c", "f", "s".
        :paramtype resource: str or ~azure.mgmt.storage.v2017_10_01.models.SignedResource
        :keyword permissions: The signed permissions for the service SAS. Possible values include: Read
         (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible
         values include: "r", "d", "w", "l", "a", "c", "u", "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2017_10_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Possible
         values include: "https,http", "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2017_10_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: The time at which the shared access signature becomes
         invalid.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword identifier: A unique value up to 64 characters in length that correlates to an access
         policy specified for the container, queue, or table.
        :paramtype identifier: str
        :keyword partition_key_start: The start of partition key.
        :paramtype partition_key_start: str
        :keyword partition_key_end: The end of partition key.
        :paramtype partition_key_end: str
        :keyword row_key_start: The start of row key.
        :paramtype row_key_start: str
        :keyword row_key_end: The end of row key.
        :paramtype row_key_end: str
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        :keyword cache_control: The response header override for cache control.
        :paramtype cache_control: str
        :keyword content_disposition: The response header override for content disposition.
        :paramtype content_disposition: str
        :keyword content_encoding: The response header override for content encoding.
        :paramtype content_encoding: str
        :keyword content_language: The response header override for content language.
        :paramtype content_language: str
        :keyword content_type: The response header override for content type.
        :paramtype content_type: str
        """
        super(ServiceSasParameters, self).__init__(**kwargs)
        self.canonicalized_resource = canonicalized_resource
        self.resource = resource
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.identifier = identifier
        self.partition_key_start = partition_key_start
        self.partition_key_end = partition_key_end
        self.row_key_start = row_key_start
        self.row_key_end = row_key_end
        self.key_to_sign = key_to_sign
        self.cache_control = cache_control
        self.content_disposition = content_disposition
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_type = content_type


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include metric specifications.

    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications:
     list[~azure.mgmt.storage.v2017_10_01.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.storage.v2017_10_01.models.MetricSpecification]
        """
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Sku(msrest.serialization.Model):
    """The SKU of the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Gets or sets the sku name. Required for account creation; optional for
     update. Note that in older versions, sku name was called accountType. Possible values include:
     "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS".
    :vartype name: str or ~azure.mgmt.storage.v2017_10_01.models.SkuName
    :ivar tier: Gets the sku tier. This is based on the SKU name. Possible values include:
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.storage.v2017_10_01.models.SkuTier
    :ivar resource_type: The type of the resource, usually it is 'storageAccounts'.
    :vartype resource_type: str
    :ivar kind: Indicates the type of storage account. Possible values include: "Storage",
     "StorageV2", "BlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2017_10_01.models.Kind
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar capabilities: The capability information in the specified sku, including file encryption,
     network acls, change notification, etc.
    :vartype capabilities: list[~azure.mgmt.storage.v2017_10_01.models.SKUCapability]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.storage.v2017_10_01.models.Restriction]
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
        'resource_type': {'readonly': True},
        'kind': {'readonly': True},
        'locations': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[SKUCapability]'},
        'restrictions': {'key': 'restrictions', 'type': '[Restriction]'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        restrictions: Optional[List["Restriction"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Gets or sets the sku name. Required for account creation; optional for
         update. Note that in older versions, sku name was called accountType. Possible values include:
         "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS".
        :paramtype name: str or ~azure.mgmt.storage.v2017_10_01.models.SkuName
        :keyword restrictions: The restrictions because of which SKU cannot be used. This is empty if
         there are no restrictions.
        :paramtype restrictions: list[~azure.mgmt.storage.v2017_10_01.models.Restriction]
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = None
        self.resource_type = None
        self.kind = None
        self.locations = None
        self.capabilities = None
        self.restrictions = restrictions


class SKUCapability(msrest.serialization.Model):
    """The capability information in the specified sku, including file encryption, network acls, change notification, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of capability, The capability information in the specified sku, including
     file encryption, network acls, change notification, etc.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability. Possibly 'true' or 'false'.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SKUCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None


class StorageAccount(Resource):
    """The storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Tags assigned to a resource; can be used for viewing and grouping a
     resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar sku: Gets the SKU.
    :vartype sku: ~azure.mgmt.storage.v2017_10_01.models.Sku
    :ivar kind: Gets the Kind. Possible values include: "Storage", "StorageV2", "BlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2017_10_01.models.Kind
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2017_10_01.models.Identity
    :ivar provisioning_state: Gets the status of the storage account at the time the operation was
     called. Possible values include: "Creating", "ResolvingDNS", "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.storage.v2017_10_01.models.ProvisioningState
    :ivar primary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob
     endpoint.
    :vartype primary_endpoints: ~azure.mgmt.storage.v2017_10_01.models.Endpoints
    :ivar primary_location: Gets the location of the primary data center for the storage account.
    :vartype primary_location: str
    :ivar status_of_primary: Gets the status indicating whether the primary location of the storage
     account is available or unavailable. Possible values include: "available", "unavailable".
    :vartype status_of_primary: str or ~azure.mgmt.storage.v2017_10_01.models.AccountStatus
    :ivar last_geo_failover_time: Gets the timestamp of the most recent instance of a failover to
     the secondary location. Only the most recent timestamp is retained. This element is not
     returned if there has never been a failover instance. Only available if the accountType is
     Standard_GRS or Standard_RAGRS.
    :vartype last_geo_failover_time: ~datetime.datetime
    :ivar secondary_location: Gets the location of the geo-replicated secondary for the storage
     account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
    :vartype secondary_location: str
    :ivar status_of_secondary: Gets the status indicating whether the secondary location of the
     storage account is available or unavailable. Only available if the SKU name is Standard_GRS or
     Standard_RAGRS. Possible values include: "available", "unavailable".
    :vartype status_of_secondary: str or ~azure.mgmt.storage.v2017_10_01.models.AccountStatus
    :ivar creation_time: Gets the creation date and time of the storage account in UTC.
    :vartype creation_time: ~datetime.datetime
    :ivar custom_domain: Gets the custom domain the user assigned to this storage account.
    :vartype custom_domain: ~azure.mgmt.storage.v2017_10_01.models.CustomDomain
    :ivar secondary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object from the secondary location of the storage account. Only available if
     the SKU name is Standard_RAGRS.
    :vartype secondary_endpoints: ~azure.mgmt.storage.v2017_10_01.models.Endpoints
    :ivar encryption: Gets the encryption settings on the account. If unspecified, the account is
     unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2017_10_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Possible values include: "Hot", "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2017_10_01.models.AccessTier
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2017_10_01.models.NetworkRuleSet
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'readonly': True},
        'kind': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'primary_endpoints': {'readonly': True},
        'primary_location': {'readonly': True},
        'status_of_primary': {'readonly': True},
        'last_geo_failover_time': {'readonly': True},
        'secondary_location': {'readonly': True},
        'status_of_secondary': {'readonly': True},
        'creation_time': {'readonly': True},
        'custom_domain': {'readonly': True},
        'secondary_endpoints': {'readonly': True},
        'encryption': {'readonly': True},
        'access_tier': {'readonly': True},
        'network_rule_set': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'primary_endpoints': {'key': 'properties.primaryEndpoints', 'type': 'Endpoints'},
        'primary_location': {'key': 'properties.primaryLocation', 'type': 'str'},
        'status_of_primary': {'key': 'properties.statusOfPrimary', 'type': 'str'},
        'last_geo_failover_time': {'key': 'properties.lastGeoFailoverTime', 'type': 'iso-8601'},
        'secondary_location': {'key': 'properties.secondaryLocation', 'type': 'str'},
        'status_of_secondary': {'key': 'properties.statusOfSecondary', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'secondary_endpoints': {'key': 'properties.secondaryEndpoints', 'type': 'Endpoints'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        enable_https_traffic_only: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Tags assigned to a resource; can be used for viewing and grouping
         a resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2017_10_01.models.Identity
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        """
        super(StorageAccount, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = None
        self.kind = None
        self.identity = identity
        self.provisioning_state = None
        self.primary_endpoints = None
        self.primary_location = None
        self.status_of_primary = None
        self.last_geo_failover_time = None
        self.secondary_location = None
        self.status_of_secondary = None
        self.creation_time = None
        self.custom_domain = None
        self.secondary_endpoints = None
        self.encryption = None
        self.access_tier = None
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = None


class StorageAccountCheckNameAvailabilityParameters(msrest.serialization.Model):
    """The parameters used to check the availability of the storage account name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The storage account name.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.Storage/storageAccounts. Has constant value:
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Storage/storageAccounts"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. The storage account name.
        :paramtype name: str
        """
        super(StorageAccountCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class StorageAccountCreateParameters(msrest.serialization.Model):
    """The parameters used when creating a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar sku: Required. Required. Gets or sets the sku name.
    :vartype sku: ~azure.mgmt.storage.v2017_10_01.models.Sku
    :ivar kind: Required. Required. Indicates the type of storage account. Possible values include:
     "Storage", "StorageV2", "BlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2017_10_01.models.Kind
    :ivar location: Required. Required. Gets or sets the location of the resource. This will be one
     of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia,
     etc.). The geo region of a resource cannot be changed once it is created, but if an identical
     geo region is specified on update, the request will succeed.
    :vartype location: str
    :ivar tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used for viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no
     greater than 128 characters and a value with a length no greater than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2017_10_01.models.Identity
    :ivar custom_domain: User domain assigned to the storage account. Name is the CNAME source.
     Only one custom domain is supported per storage account at this time. To clear the existing
     custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2017_10_01.models.CustomDomain
    :ivar encryption: Provides the encryption settings on the account. If left unspecified the
     account encryption settings will remain the same. The default setting is unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2017_10_01.models.Encryption
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2017_10_01.models.NetworkRuleSet
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Possible values include: "Hot", "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2017_10_01.models.AccessTier
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    """

    _validation = {
        'sku': {'required': True},
        'kind': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sku: "Sku",
        kind: Union[str, "Kind"],
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        custom_domain: Optional["CustomDomain"] = None,
        encryption: Optional["Encryption"] = None,
        network_rule_set: Optional["NetworkRuleSet"] = None,
        access_tier: Optional[Union[str, "AccessTier"]] = None,
        enable_https_traffic_only: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword sku: Required. Required. Gets or sets the sku name.
        :paramtype sku: ~azure.mgmt.storage.v2017_10_01.models.Sku
        :keyword kind: Required. Required. Indicates the type of storage account. Possible values
         include: "Storage", "StorageV2", "BlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2017_10_01.models.Kind
        :keyword location: Required. Required. Gets or sets the location of the resource. This will be
         one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia,
         etc.). The geo region of a resource cannot be changed once it is created, but if an identical
         geo region is specified on update, the request will succeed.
        :paramtype location: str
        :keyword tags: A set of tags. Gets or sets a list of key value pairs that describe the
         resource. These tags can be used for viewing and grouping this resource (across resource
         groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a
         length no greater than 128 characters and a value with a length no greater than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2017_10_01.models.Identity
        :keyword custom_domain: User domain assigned to the storage account. Name is the CNAME source.
         Only one custom domain is supported per storage account at this time. To clear the existing
         custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2017_10_01.models.CustomDomain
        :keyword encryption: Provides the encryption settings on the account. If left unspecified the
         account encryption settings will remain the same. The default setting is unencrypted.
        :paramtype encryption: ~azure.mgmt.storage.v2017_10_01.models.Encryption
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2017_10_01.models.NetworkRuleSet
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         used for billing. Possible values include: "Hot", "Cool".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2017_10_01.models.AccessTier
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        """
        super(StorageAccountCreateParameters, self).__init__(**kwargs)
        self.sku = sku
        self.kind = kind
        self.location = location
        self.tags = tags
        self.identity = identity
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.network_rule_set = network_rule_set
        self.access_tier = access_tier
        self.enable_https_traffic_only = enable_https_traffic_only


class StorageAccountKey(msrest.serialization.Model):
    """An access key for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: Name of the key.
    :vartype key_name: str
    :ivar value: Base 64-encoded value of the key.
    :vartype value: str
    :ivar permissions: Permissions for the key -- read-only or full permissions. Possible values
     include: "Read", "Full".
    :vartype permissions: str or ~azure.mgmt.storage.v2017_10_01.models.KeyPermission
    """

    _validation = {
        'key_name': {'readonly': True},
        'value': {'readonly': True},
        'permissions': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageAccountKey, self).__init__(**kwargs)
        self.key_name = None
        self.value = None
        self.permissions = None


class StorageAccountListKeysResult(msrest.serialization.Model):
    """The response from the ListKeys operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar keys: Gets the list of storage account keys and their properties for the specified
     storage account.
    :vartype keys: list[~azure.mgmt.storage.v2017_10_01.models.StorageAccountKey]
    """

    _validation = {
        'keys': {'readonly': True},
    }

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[StorageAccountKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageAccountListKeysResult, self).__init__(**kwargs)
        self.keys = None


class StorageAccountListResult(msrest.serialization.Model):
    """The response from the List Storage Accounts operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of storage accounts and their properties.
    :vartype value: list[~azure.mgmt.storage.v2017_10_01.models.StorageAccount]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageAccount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageAccountListResult, self).__init__(**kwargs)
        self.value = None


class StorageAccountRegenerateKeyParameters(msrest.serialization.Model):
    """The parameters used to regenerate the storage account key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: Required. The name of storage keys that want to be regenerated, possible values
     are key1, key2.
    :vartype key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        **kwargs
    ):
        """
        :keyword key_name: Required. The name of storage keys that want to be regenerated, possible
         values are key1, key2.
        :paramtype key_name: str
        """
        super(StorageAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = key_name


class StorageAccountUpdateParameters(msrest.serialization.Model):
    """The parameters that can be provided when updating the storage account properties.

    :ivar sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to Standard_ZRS
     or Premium_LRS, nor can accounts of those sku names be updated to any other value.
    :vartype sku: ~azure.mgmt.storage.v2017_10_01.models.Sku
    :ivar tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used in viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in
     length than 128 characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2017_10_01.models.Identity
    :ivar kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
     supported by server. Possible values include: "Storage", "StorageV2", "BlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2017_10_01.models.Kind
    :ivar custom_domain: Custom domain assigned to the storage account by the user. Name is the
     CNAME source. Only one custom domain is supported per storage account at this time. To clear
     the existing custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2017_10_01.models.CustomDomain
    :ivar encryption: Provides the encryption settings on the account. The default setting is
     unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2017_10_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Possible values include: "Hot", "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2017_10_01.models.AccessTier
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2017_10_01.models.NetworkRuleSet
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        custom_domain: Optional["CustomDomain"] = None,
        encryption: Optional["Encryption"] = None,
        access_tier: Optional[Union[str, "AccessTier"]] = None,
        enable_https_traffic_only: Optional[bool] = False,
        network_rule_set: Optional["NetworkRuleSet"] = None,
        **kwargs
    ):
        """
        :keyword sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to
         Standard_ZRS or Premium_LRS, nor can accounts of those sku names be updated to any other value.
        :paramtype sku: ~azure.mgmt.storage.v2017_10_01.models.Sku
        :keyword tags: A set of tags. Gets or sets a list of key value pairs that describe the
         resource. These tags can be used in viewing and grouping this resource (across resource
         groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no
         greater in length than 128 characters and a value no greater in length than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2017_10_01.models.Identity
        :keyword kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
         supported by server. Possible values include: "Storage", "StorageV2", "BlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2017_10_01.models.Kind
        :keyword custom_domain: Custom domain assigned to the storage account by the user. Name is the
         CNAME source. Only one custom domain is supported per storage account at this time. To clear
         the existing custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2017_10_01.models.CustomDomain
        :keyword encryption: Provides the encryption settings on the account. The default setting is
         unencrypted.
        :paramtype encryption: ~azure.mgmt.storage.v2017_10_01.models.Encryption
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         used for billing. Possible values include: "Hot", "Cool".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2017_10_01.models.AccessTier
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2017_10_01.models.NetworkRuleSet
        """
        super(StorageAccountUpdateParameters, self).__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.identity = identity
        self.kind = kind
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.access_tier = access_tier
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = network_rule_set


class StorageSkuListResult(msrest.serialization.Model):
    """The response from the List Storage SKUs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Get the list result of storage SKUs and their properties.
    :vartype value: list[~azure.mgmt.storage.v2017_10_01.models.Sku]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Sku]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StorageSkuListResult, self).__init__(**kwargs)
        self.value = None


class Usage(msrest.serialization.Model):
    """Describes Storage Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: Gets the unit of measurement. Possible values include: "Count", "Bytes", "Seconds",
     "Percent", "CountsPerSecond", "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.storage.v2017_10_01.models.UsageUnit
    :ivar current_value: Gets the current count of the allocated resources in the subscription.
    :vartype current_value: int
    :ivar limit: Gets the maximum count of the resources that can be allocated in the subscription.
    :vartype limit: int
    :ivar name: Gets the name of the type of usage.
    :vartype name: ~azure.mgmt.storage.v2017_10_01.models.UsageName
    """

    _validation = {
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Usage, self).__init__(**kwargs)
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageListResult(msrest.serialization.Model):
    """The response from the List Usages operation.

    :ivar value: Gets or sets the list of Storage Resource Usages.
    :vartype value: list[~azure.mgmt.storage.v2017_10_01.models.Usage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Usage"]] = None,
        **kwargs
    ):
        """
        :keyword value: Gets or sets the list of Storage Resource Usages.
        :paramtype value: list[~azure.mgmt.storage.v2017_10_01.models.Usage]
        """
        super(UsageListResult, self).__init__(**kwargs)
        self.value = value


class UsageName(msrest.serialization.Model):
    """The usage names that can be used; currently limited to StorageAccount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a string describing the resource name.
    :vartype value: str
    :ivar localized_value: Gets a localized string describing the resource name.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class VirtualNetworkRule(msrest.serialization.Model):
    """Virtual Network rule.

    All required parameters must be populated in order to send to Azure.

    :ivar virtual_network_resource_id: Required. Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :vartype virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. The only acceptable values to pass in are
     None and "Allow". The default value is None.
    :vartype action: str
    :ivar state: Gets the state of virtual network rule. Possible values include: "provisioning",
     "deprovisioning", "succeeded", "failed", "networkSourceDeleted".
    :vartype state: str or ~azure.mgmt.storage.v2017_10_01.models.State
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_resource_id: str,
        action: Optional[str] = None,
        state: Optional[Union[str, "State"]] = None,
        **kwargs
    ):
        """
        :keyword virtual_network_resource_id: Required. Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :paramtype virtual_network_resource_id: str
        :keyword action: The action of virtual network rule. The only acceptable values to pass in are
         None and "Allow". The default value is None.
        :paramtype action: str
        :keyword state: Gets the state of virtual network rule. Possible values include:
         "provisioning", "deprovisioning", "succeeded", "failed", "networkSourceDeleted".
        :paramtype state: str or ~azure.mgmt.storage.v2017_10_01.models.State
        """
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id
        self.action = action
        self.state = state
