# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class TrainingApiConfiguration(Configuration):
    """Configuration for TrainingApi
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param api_key:
    :type api_key: str
    :param str base_url: Service URL
    """

    def __init__(
            self, api_key, base_url=None):

        if api_key is None:
            raise ValueError("Parameter 'api_key' must not be None.")
        if not base_url:
            base_url = 'https://southcentralus.api.cognitive.microsoft.com/customvision/v1.2/Training'

        super(TrainingApiConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-cognitiveservices-vision-customvision/{}'.format(VERSION))

        self.api_key = api_key


class TrainingApi(object):
    """TrainingApi

    :ivar config: Configuration for client.
    :vartype config: TrainingApiConfiguration

    :param api_key:
    :type api_key: str
    :param str base_url: Service URL
    """

    def __init__(
            self, api_key, base_url=None):

        self.config = TrainingApiConfiguration(api_key, base_url)
        self._client = ServiceClient(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1.2'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def get_account_info(
            self, custom_headers=None, raw=False, **operation_config):
        """Get basic information about your account.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Account or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Account
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_account_info.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Account', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_account_info.metadata = {'url': '/account'}

    def get_domains(
            self, custom_headers=None, raw=False, **operation_config):
        """Get a list of the available domains.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.vision.customvision.training.models.Domain]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_domains.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[Domain]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_domains.metadata = {'url': '/domains'}

    def get_domain(
            self, domain_id, custom_headers=None, raw=False, **operation_config):
        """Get information about a specific domain.

        :param domain_id: The id of the domain to get information about
        :type domain_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Domain or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Domain or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_domain.metadata['url']
        path_format_arguments = {
            'domainId': self._serialize.url("domain_id", domain_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Domain', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_domain.metadata = {'url': '/domains/{domainId}'}

    def get_tagged_images(
            self, project_id, iteration_id=None, tag_ids=None, order_by=None, take=50, skip=0, custom_headers=None, raw=False, **operation_config):
        """Get tagged images for a given project iteration.

        This API supports batching and range selection. By default it will only
        return first 50 images matching images.
        Use the {take} and {skip} parameters to control how many images to
        return in a given batch.
        The filtering is on an and/or relationship. For example, if the
        provided tag ids are for the "Dog" and
        "Cat" tags, then only images tagged with Dog and/or Cat will be
        returned.

        :param project_id: The project id
        :type project_id: str
        :param iteration_id: The iteration id. Defaults to workspace
        :type iteration_id: str
        :param tag_ids: An list of tags ids to filter the images. Defaults to
         all tagged images when null. Limited to 20
        :type tag_ids: list[str]
        :param order_by: The ordering. Defaults to newest. Possible values
         include: 'Newest', 'Oldest'
        :type order_by: str
        :param take: Maximum number of images to return. Defaults to 50,
         limited to 256
        :type take: int
        :param skip: Number of images to skip before beginning the image
         batch. Defaults to 0
        :type skip: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.vision.customvision.training.models.Image]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tagged_images.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if iteration_id is not None:
            query_parameters['iterationId'] = self._serialize.query("iteration_id", iteration_id, 'str')
        if tag_ids is not None:
            query_parameters['tagIds'] = self._serialize.query("tag_ids", tag_ids, '[str]', div=',')
        if order_by is not None:
            query_parameters['orderBy'] = self._serialize.query("order_by", order_by, 'str')
        if take is not None:
            query_parameters['take'] = self._serialize.query("take", take, 'int')
        if skip is not None:
            query_parameters['skip'] = self._serialize.query("skip", skip, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[Image]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tagged_images.metadata = {'url': '/projects/{projectId}/images/tagged'}

    def get_untagged_images(
            self, project_id, iteration_id=None, order_by=None, take=50, skip=0, custom_headers=None, raw=False, **operation_config):
        """Get untagged images for a given project iteration.

        This API supports batching and range selection. By default it will only
        return first 50 images matching images.
        Use the {take} and {skip} parameters to control how many images to
        return in a given batch.

        :param project_id: The project id
        :type project_id: str
        :param iteration_id: The iteration id. Defaults to workspace
        :type iteration_id: str
        :param order_by: The ordering. Defaults to newest. Possible values
         include: 'Newest', 'Oldest'
        :type order_by: str
        :param take: Maximum number of images to return. Defaults to 50,
         limited to 256
        :type take: int
        :param skip: Number of images to skip before beginning the image
         batch. Defaults to 0
        :type skip: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.vision.customvision.training.models.Image]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_untagged_images.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if iteration_id is not None:
            query_parameters['iterationId'] = self._serialize.query("iteration_id", iteration_id, 'str')
        if order_by is not None:
            query_parameters['orderBy'] = self._serialize.query("order_by", order_by, 'str')
        if take is not None:
            query_parameters['take'] = self._serialize.query("take", take, 'int')
        if skip is not None:
            query_parameters['skip'] = self._serialize.query("skip", skip, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[Image]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_untagged_images.metadata = {'url': '/projects/{projectId}/images/untagged'}

    def create_images_from_data(
            self, project_id, image_data, tag_ids=None, custom_headers=None, raw=False, **operation_config):
        """Add the provided images to the set of training images.

        This API accepts body content as multipart/form-data and
        application/octet-stream. When using multipart
        multiple image files can be sent at once, with a maximum of 64 files.

        :param project_id: The project id
        :type project_id: str
        :param image_data:
        :type image_data: Generator
        :param tag_ids: The tags ids with which to tag each image. Limited to
         20
        :type tag_ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ImageCreateSummary or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.ImageCreateSummary
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_images_from_data.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if tag_ids is not None:
            query_parameters['tagIds'] = self._serialize.query("tag_ids", tag_ids, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct form data
        form_data_content = {
            'imageData': image_data,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send_formdata(
            request, header_parameters, form_data_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImageCreateSummary', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_images_from_data.metadata = {'url': '/projects/{projectId}/images'}

    def delete_images(
            self, project_id, image_ids, custom_headers=None, raw=False, **operation_config):
        """Delete images from the set of training images.

        :param project_id: The project id
        :type project_id: str
        :param image_ids: Ids of the images to be deleted. Limted to 256
         images per batch
        :type image_ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_images.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['imageIds'] = self._serialize.query("image_ids", image_ids, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_images.metadata = {'url': '/projects/{projectId}/images'}

    def create_images_from_files(
            self, project_id, images=None, tag_ids=None, custom_headers=None, raw=False, **operation_config):
        """Add the provided batch of images to the set of training images.

        :param project_id: The project id
        :type project_id: str
        :param images:
        :type images:
         list[~azure.cognitiveservices.vision.customvision.training.models.ImageFileCreateEntry]
        :param tag_ids:
        :type tag_ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ImageCreateSummary or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.ImageCreateSummary
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        batch = models.ImageFileCreateBatch(images=images, tag_ids=tag_ids)

        # Construct URL
        url = self.create_images_from_files.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(batch, 'ImageFileCreateBatch')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImageCreateSummary', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_images_from_files.metadata = {'url': '/projects/{projectId}/images/files'}

    def create_images_from_urls(
            self, project_id, images=None, tag_ids=None, custom_headers=None, raw=False, **operation_config):
        """Add the provided images urls to the set of training images.

        :param project_id: The project id
        :type project_id: str
        :param images:
        :type images:
         list[~azure.cognitiveservices.vision.customvision.training.models.ImageUrlCreateEntry]
        :param tag_ids:
        :type tag_ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ImageCreateSummary or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.ImageCreateSummary
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        batch = models.ImageUrlCreateBatch(images=images, tag_ids=tag_ids)

        # Construct URL
        url = self.create_images_from_urls.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(batch, 'ImageUrlCreateBatch')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImageCreateSummary', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_images_from_urls.metadata = {'url': '/projects/{projectId}/images/urls'}

    def create_images_from_predictions(
            self, project_id, images=None, tag_ids=None, custom_headers=None, raw=False, **operation_config):
        """Add the specified predicted images to the set of training images.

        :param project_id: The project id
        :type project_id: str
        :param images:
        :type images:
         list[~azure.cognitiveservices.vision.customvision.training.models.ImageIdCreateEntry]
        :param tag_ids:
        :type tag_ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ImageCreateSummary or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.ImageCreateSummary
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        batch = models.ImageIdCreateBatch(images=images, tag_ids=tag_ids)

        # Construct URL
        url = self.create_images_from_predictions.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(batch, 'ImageIdCreateBatch')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImageCreateSummary', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_images_from_predictions.metadata = {'url': '/projects/{projectId}/images/predictions'}

    def post_image_tags(
            self, project_id, tags=None, custom_headers=None, raw=False, **operation_config):
        """Associate a set of images with a set of tags.

        :param project_id: The project id
        :type project_id: str
        :param tags:
        :type tags:
         list[~azure.cognitiveservices.vision.customvision.training.models.ImageTagCreateEntry]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ImageTagCreateSummary or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.ImageTagCreateSummary
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        batch = models.ImageTagCreateBatch(tags=tags)

        # Construct URL
        url = self.post_image_tags.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(batch, 'ImageTagCreateBatch')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImageTagCreateSummary', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    post_image_tags.metadata = {'url': '/projects/{projectId}/images/tags'}

    def delete_image_tags(
            self, project_id, image_ids, tag_ids, custom_headers=None, raw=False, **operation_config):
        """Remove a set of tags from a set of images.

        :param project_id: The project id
        :type project_id: str
        :param image_ids: Image ids. Limited to 64 images
        :type image_ids: list[str]
        :param tag_ids: Tags to be deleted from the specified images. Limted
         to 20 tags
        :type tag_ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_image_tags.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['imageIds'] = self._serialize.query("image_ids", image_ids, '[str]', div=',')
        query_parameters['tagIds'] = self._serialize.query("tag_ids", tag_ids, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_image_tags.metadata = {'url': '/projects/{projectId}/images/tags'}

    def query_prediction_results(
            self, project_id, query, custom_headers=None, raw=False, **operation_config):
        """Get images that were sent to your prediction endpoint.

        :param project_id: The project id
        :type project_id: str
        :param query: Parameters used to query the predictions. Limited to
         combining 2 tags
        :type query:
         ~azure.cognitiveservices.vision.customvision.training.models.PredictionQueryToken
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PredictionQuery or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.PredictionQuery
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.query_prediction_results.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(query, 'PredictionQueryToken')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PredictionQuery', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    query_prediction_results.metadata = {'url': '/projects/{projectId}/predictions/query'}

    def delete_prediction(
            self, project_id, ids, custom_headers=None, raw=False, **operation_config):
        """Delete a set of predicted images and their associated prediction
        results.

        :param project_id: The project id
        :type project_id: str
        :param ids: The prediction ids. Limited to 64
        :type ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_prediction.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['ids'] = self._serialize.query("ids", ids, '[str]', div=',')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_prediction.metadata = {'url': '/projects/{projectId}/predictions'}

    def quick_test_image_url(
            self, project_id, iteration_id=None, url=None, custom_headers=None, raw=False, **operation_config):
        """Quick test an image url.

        :param project_id: The project to evaluate against
        :type project_id: str
        :param iteration_id: Optional. Specifies the id of a particular
         iteration to evaluate against.
         The default iteration for the project will be used when not specified.
        :type iteration_id: str
        :param url:
        :type url: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ImagePredictionResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.ImagePredictionResult
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        image_url = models.ImageUrl(url=url)

        # Construct URL
        url = self.quick_test_image_url.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if iteration_id is not None:
            query_parameters['iterationId'] = self._serialize.query("iteration_id", iteration_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(image_url, 'ImageUrl')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImagePredictionResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    quick_test_image_url.metadata = {'url': '/projects/{projectId}/quicktest/url'}

    def quick_test_image(
            self, project_id, image_data, iteration_id=None, custom_headers=None, raw=False, **operation_config):
        """Quick test an image.

        :param project_id: The project id
        :type project_id: str
        :param image_data:
        :type image_data: Generator
        :param iteration_id: Optional. Specifies the id of a particular
         iteration to evaluate against.
         The default iteration for the project will be used when not specified.
        :type iteration_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ImagePredictionResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.ImagePredictionResult
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.quick_test_image.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if iteration_id is not None:
            query_parameters['iterationId'] = self._serialize.query("iteration_id", iteration_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct form data
        form_data_content = {
            'imageData': image_data,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send_formdata(
            request, header_parameters, form_data_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImagePredictionResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    quick_test_image.metadata = {'url': '/projects/{projectId}/quicktest/image'}

    def get_projects(
            self, custom_headers=None, raw=False, **operation_config):
        """Get your projects.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.vision.customvision.training.models.Project]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_projects.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[Project]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_projects.metadata = {'url': '/projects'}

    def create_project(
            self, name, description=None, domain_id=None, custom_headers=None, raw=False, **operation_config):
        """Create a project.

        :param name: Name of the project
        :type name: str
        :param description: The description of the project
        :type description: str
        :param domain_id: The id of the domain to use for this project.
         Defaults to General
        :type domain_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Project or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Project
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_project.metadata['url']

        # Construct parameters
        query_parameters = {}
        query_parameters['name'] = self._serialize.query("name", name, 'str')
        if description is not None:
            query_parameters['description'] = self._serialize.query("description", description, 'str')
        if domain_id is not None:
            query_parameters['domainId'] = self._serialize.query("domain_id", domain_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Project', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_project.metadata = {'url': '/projects'}

    def get_project(
            self, project_id, custom_headers=None, raw=False, **operation_config):
        """Get a specific project.

        :param project_id: The id of the project to get
        :type project_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Project or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Project
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_project.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Project', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_project.metadata = {'url': '/projects/{projectId}'}

    def delete_project(
            self, project_id, custom_headers=None, raw=False, **operation_config):
        """Delete a specific project.

        :param project_id: The project id
        :type project_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_project.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_project.metadata = {'url': '/projects/{projectId}'}

    def update_project(
            self, project_id, updated_project, custom_headers=None, raw=False, **operation_config):
        """Update a specific project.

        :param project_id: The id of the project to update
        :type project_id: str
        :param updated_project: The updated project model
        :type updated_project:
         ~azure.cognitiveservices.vision.customvision.training.models.Project
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Project or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Project
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_project.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(updated_project, 'Project')

        # Construct and send request
        request = self._client.patch(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Project', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_project.metadata = {'url': '/projects/{projectId}'}

    def train_project(
            self, project_id, custom_headers=None, raw=False, **operation_config):
        """Queues project for training.

        :param project_id: The project id
        :type project_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Iteration or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Iteration
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.train_project.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Iteration', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    train_project.metadata = {'url': '/projects/{projectId}/train'}

    def get_iterations(
            self, project_id, custom_headers=None, raw=False, **operation_config):
        """Get iterations for the project.

        :param project_id: The project id
        :type project_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.vision.customvision.training.models.Iteration]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_iterations.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[Iteration]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_iterations.metadata = {'url': '/projects/{projectId}/iterations'}

    def get_iteration(
            self, project_id, iteration_id, custom_headers=None, raw=False, **operation_config):
        """Get a specific iteration.

        :param project_id: The id of the project the iteration belongs to
        :type project_id: str
        :param iteration_id: The id of the iteration to get
        :type iteration_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Iteration or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Iteration
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_iteration.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'iterationId': self._serialize.url("iteration_id", iteration_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Iteration', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_iteration.metadata = {'url': '/projects/{projectId}/iterations/{iterationId}'}

    def delete_iteration(
            self, project_id, iteration_id, custom_headers=None, raw=False, **operation_config):
        """Delete a specific iteration of a project.

        :param project_id: The project id
        :type project_id: str
        :param iteration_id: The iteration id
        :type iteration_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_iteration.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'iterationId': self._serialize.url("iteration_id", iteration_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_iteration.metadata = {'url': '/projects/{projectId}/iterations/{iterationId}'}

    def update_iteration(
            self, project_id, iteration_id, name=None, is_default=None, custom_headers=None, raw=False, **operation_config):
        """Update a specific iteration.

        :param project_id: Project id
        :type project_id: str
        :param iteration_id: Iteration id
        :type iteration_id: str
        :param name: Gets or sets the name of the iteration
        :type name: str
        :param is_default: Gets or sets a value indicating whether the
         iteration is the default iteration for the project
        :type is_default: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Iteration or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Iteration
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        updated_iteration = models.Iteration(name=name, is_default=is_default)

        # Construct URL
        url = self.update_iteration.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'iterationId': self._serialize.url("iteration_id", iteration_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(updated_iteration, 'Iteration')

        # Construct and send request
        request = self._client.patch(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Iteration', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_iteration.metadata = {'url': '/projects/{projectId}/iterations/{iterationId}'}

    def get_iteration_performance(
            self, project_id, iteration_id, threshold, custom_headers=None, raw=False, **operation_config):
        """Get detailed performance information about a trained iteration.

        :param project_id: The project id
        :type project_id: str
        :param iteration_id: The id of the trained iteration
        :type iteration_id: str
        :param threshold: The 0 to 1 threshold to determine positive
         prediction
        :type threshold: float
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: IterationPerformance or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.IterationPerformance
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_iteration_performance.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'iterationId': self._serialize.url("iteration_id", iteration_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['threshold'] = self._serialize.query("threshold", threshold, 'float')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IterationPerformance', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_iteration_performance.metadata = {'url': '/projects/{projectId}/iterations/{iterationId}/performance'}

    def get_exports(
            self, project_id, iteration_id, custom_headers=None, raw=False, **operation_config):
        """Get the list of exports for a specific iteration.

        :param project_id: The project id
        :type project_id: str
        :param iteration_id: The iteration id
        :type iteration_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.vision.customvision.training.models.Export]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_exports.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'iterationId': self._serialize.url("iteration_id", iteration_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[Export]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_exports.metadata = {'url': '/projects/{projectId}/iterations/{iterationId}/export'}

    def export_iteration(
            self, project_id, iteration_id, platform, custom_headers=None, raw=False, **operation_config):
        """Export a trained iteration.

        :param project_id: The project id
        :type project_id: str
        :param iteration_id: The iteration id
        :type iteration_id: str
        :param platform: The target platform (coreml or tensorflow)
        :type platform: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Export or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Export or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.export_iteration.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'iterationId': self._serialize.url("iteration_id", iteration_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['platform'] = self._serialize.query("platform", platform, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Export', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    export_iteration.metadata = {'url': '/projects/{projectId}/iterations/{iterationId}/export'}

    def get_tags(
            self, project_id, iteration_id=None, custom_headers=None, raw=False, **operation_config):
        """Get the tags for a given project and iteration.

        :param project_id: The project id
        :type project_id: str
        :param iteration_id: The iteration id. Defaults to workspace
        :type iteration_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: TagList or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.TagList
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tags.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if iteration_id is not None:
            query_parameters['iterationId'] = self._serialize.query("iteration_id", iteration_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TagList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tags.metadata = {'url': '/projects/{projectId}/tags'}

    def create_tag(
            self, project_id, name, description=None, custom_headers=None, raw=False, **operation_config):
        """Create a tag for the project.

        :param project_id: The project id
        :type project_id: str
        :param name: The tag name
        :type name: str
        :param description: Optional description for the tag
        :type description: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Tag or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Tag or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_tag.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['name'] = self._serialize.query("name", name, 'str')
        if description is not None:
            query_parameters['description'] = self._serialize.query("description", description, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Tag', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_tag.metadata = {'url': '/projects/{projectId}/tags'}

    def get_tag(
            self, project_id, tag_id, iteration_id=None, custom_headers=None, raw=False, **operation_config):
        """Get information about a specific tag.

        :param project_id: The project this tag belongs to
        :type project_id: str
        :param tag_id: The tag id
        :type tag_id: str
        :param iteration_id: The iteration to retrieve this tag from.
         Optional, defaults to current training set
        :type iteration_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Tag or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Tag or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tag.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'tagId': self._serialize.url("tag_id", tag_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if iteration_id is not None:
            query_parameters['iterationId'] = self._serialize.query("iteration_id", iteration_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Tag', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tag.metadata = {'url': '/projects/{projectId}/tags/{tagId}'}

    def delete_tag(
            self, project_id, tag_id, custom_headers=None, raw=False, **operation_config):
        """Delete a tag from the project.

        :param project_id: The project id
        :type project_id: str
        :param tag_id: Id of the tag to be deleted
        :type tag_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_tag.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'tagId': self._serialize.url("tag_id", tag_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_tag.metadata = {'url': '/projects/{projectId}/tags/{tagId}'}

    def update_tag(
            self, project_id, tag_id, name=None, description=None, custom_headers=None, raw=False, **operation_config):
        """Update a tag.

        :param project_id: The project id
        :type project_id: str
        :param tag_id: The id of the target tag
        :type tag_id: str
        :param name: Gets or sets the name of the tag
        :type name: str
        :param description: Gets or sets the description of the tag
        :type description: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Tag or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.vision.customvision.training.models.Tag or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        updated_tag = models.Tag(name=name, description=description)

        # Construct URL
        url = self.update_tag.metadata['url']
        path_format_arguments = {
            'projectId': self._serialize.url("project_id", project_id, 'str'),
            'tagId': self._serialize.url("tag_id", tag_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Training-Key'] = self._serialize.header("self.config.api_key", self.config.api_key, 'str')

        # Construct body
        body_content = self._serialize.body(updated_tag, 'Tag')

        # Construct and send request
        request = self._client.patch(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Tag', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_tag.metadata = {'url': '/projects/{projectId}/tags/{tagId}'}
