# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TagPerformance(Model):
    """Represents performance data for a particular tag in a trained iteration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar precision: Gets the precision
    :vartype precision: float
    :ivar precision_std_deviation: Gets the standard deviation for the
     precision
    :vartype precision_std_deviation: float
    :ivar recall: Gets the recall
    :vartype recall: float
    :ivar recall_std_deviation: Gets the standard deviation for the recall
    :vartype recall_std_deviation: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'precision': {'readonly': True},
        'precision_std_deviation': {'readonly': True},
        'recall': {'readonly': True},
        'recall_std_deviation': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'precision': {'key': 'Precision', 'type': 'float'},
        'precision_std_deviation': {'key': 'PrecisionStdDeviation', 'type': 'float'},
        'recall': {'key': 'Recall', 'type': 'float'},
        'recall_std_deviation': {'key': 'RecallStdDeviation', 'type': 'float'},
    }

    def __init__(self, **kwargs) -> None:
        super(TagPerformance, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.precision = None
        self.precision_std_deviation = None
        self.recall = None
        self.recall_std_deviation = None
