# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Quota(Model):
    """Represents a quota.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar total: The total allowable amount in the quota
    :vartype total: int
    :ivar used: The amount of quota that has currently been used
    :vartype used: int
    :ivar time_until_reset: Gets the time remaining until the quota resets.
     Null if this quota does not reset.
    :vartype time_until_reset: timedelta
    """

    _validation = {
        'total': {'readonly': True},
        'used': {'readonly': True},
        'time_until_reset': {'readonly': True},
    }

    _attribute_map = {
        'total': {'key': 'Total', 'type': 'int'},
        'used': {'key': 'Used', 'type': 'int'},
        'time_until_reset': {'key': 'TimeUntilReset', 'type': 'duration'},
    }

    def __init__(self, **kwargs) -> None:
        super(Quota, self).__init__(**kwargs)
        self.total = None
        self.used = None
        self.time_until_reset = None
