# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Project(Model):
    """Represents a project.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Gets the project id
    :vartype id: str
    :param name: Gets or sets the name of the project
    :type name: str
    :param description: Gets or sets the description of the project
    :type description: str
    :param settings: Gets or sets the project settings
    :type settings:
     ~azure.cognitiveservices.vision.customvision.training.models.ProjectSettings
    :ivar current_iteration_id: Gets the current iteration id
    :vartype current_iteration_id: str
    :ivar created: Gets the date this project was created
    :vartype created: datetime
    :ivar last_modified: Gets the date this project was last modifed
    :vartype last_modified: datetime
    :ivar thumbnail_uri: Gets the thumbnail url representing the image
    :vartype thumbnail_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'current_iteration_id': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'thumbnail_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'settings': {'key': 'Settings', 'type': 'ProjectSettings'},
        'current_iteration_id': {'key': 'CurrentIterationId', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'last_modified': {'key': 'LastModified', 'type': 'iso-8601'},
        'thumbnail_uri': {'key': 'ThumbnailUri', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, description: str=None, settings=None, **kwargs) -> None:
        super(Project, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.description = description
        self.settings = settings
        self.current_iteration_id = None
        self.created = None
        self.last_modified = None
        self.thumbnail_uri = None
